; 01/31/2011 Created for V10, (esp. DPU 3.2.8).
; 07/27/2011 Check for back_day = -1.
; 07/28/2011 When checking back time, get to nearest 5.

PRO read_319_v10, packet, spacecraft, version
compile_opt strictarrsubs
COMMON share1
COMMON share2
COMMON com_heavy
                                ; check checksum
;IF cycles5_heavy[232] GT -1 THEN stop
;IF timestamp GE '2012-11-02T22:16:47.242' THEN stop
temporary = packet.pkt
host_to_ieee, temporary
load_bytarr, temporary, bytarr
bytarr = [bytarr, packet.dat]
sum = total(bytarr)
IF sum MOD 256 NE 0 THEN BEGIN 
    printf, error_lun, timestamp, ' Error with checksum, apid 319, time'
ENDIF ELSE BEGIN 
    temp_num_summed = intarr(128)
    seq = fix(packet.dat[0])
                                ; check seq
    just_wrote = 0
    IF (seq EQ 0 AND last_seq_319 NE 4 AND last_seq_319 NE -1) OR $
      (seq NE 0 AND last_seq_319 NE -1 AND last_seq_319 NE seq-1) THEN BEGIN 
        printf, error_lun, timestamp, ' Missing 319 packet.', last_seq_319, seq
                                ; NB: if seq 0 is missing, we didn't get the cycle count
        check_seq_heavy, back_cycles
        IF timestamp LT '2013-06-22T00:00:00.000' THEN BEGIN 
            IF ((timestamp EQ '2013-01-19T09:58:29.973') AND (spacecraft EQ 'B')) OR $
              ((timestamp EQ '2013-01-13T19:15:40.586') AND (spacecraft EQ 'A')) OR $
              ((timestamp EQ '2013-06-21T04:08:28.371') AND (spacecraft EQ 'A')) THEN BEGIN 
                write_cycle_heavy_v10, -1, -1, pkt_epoch 
                back_cycles = -1
            ENDIF 
        ENDIF 
        IF back_cycles NE -1 THEN BEGIN             
            IF wrote_319[num_cycles5_heavy-back_cycles] EQ 1 THEN BEGIN
                printf, error_lun, timestamp, ' ', string(apid, format = '(Z)'), ' read_319: processing error'
                suspect_319[num_cycles5_heavy-back_cycles] = 1
            ENDIF 
        ENDIF 
    ENDIF 
    
    IF timestamp EQ '2010-12-05T21:00:32.156' AND spacecraft EQ 'A' THEN write_cycle5_heavy,    -1, -1, pkt_epoch
    IF timestamp EQ '2012-11-02T22:16:47.242' AND spacecraft EQ 'A' THEN write_cycle_heavy_v10, -1, -1, pkt_epoch

    last_seq_319 = seq
    last_epoch_319 = pkt_epoch

    IF seq EQ 0 THEN BEGIN 
        schan_319 = fix(packet.dat[1+1])
        IF dpu_post_327 EQ 0 THEN heavy_on_ten = fix(packet.dat[2-1]) ELSE complete_flags = fix(packet.dat[2-1])
        cycle_319 = fix(packet.dat[3+1])
        IF just_wrote EQ 0 THEN BEGIN 
            IF (num_cycles5_heavy EQ 0) THEN write_cycle_heavy_v10, cycle_319, schan_319, pkt_epoch $
            ELSE IF (cycles5_heavy[num_cycles5_heavy-1] NE cycle_319) THEN write_cycle_heavy_v10, cycle_319, schan_319, pkt_epoch $
                 ELSE check_cycle_heavy_v10, cycle_319, schan_319
        ENDIF 
    ENDIF 
    ; get data from first half of packet
    FOR i = 0, 127 DO BEGIN 
        IF i MOD 2 EQ 1 THEN temp_num_summed[i] = packet.dat[4+i+1] ELSE temp_num_summed[i] = packet.dat[4+i-1]
    ENDFOR
    IF dpu_post_327 EQ 0 THEN BEGIN 
        CASE seq OF
            0: BEGIN ; 31A
                cdf_varput, cdf_id, 'num_summed_sw_z>2_h', temp_num_summed, rec_start = (num_cycles5_heavy-1)
                num_summed = temp_num_summed
            END 
            1: BEGIN ; 31C
                cdf_varput, cdf_id, 'num_summed_sw_z>2_l', temp_num_summed, rec_start = (num_cycles5_heavy-1)
                IF num_cycles5_heavy EQ 0 THEN write_cycle_heavy_v10, -1, -1, pkt_epoch 
                IF wrote_319[num_cycles5_heavy-1] NE 1 THEN BEGIN ; missed seq 0
                    cdf_varput, cdf_id, 'num_summed_sw_z>2_h', temp_num_summed, rec_start = (num_cycles5_heavy-1)
                    wrote_319[num_cycles5_heavy-1] = 1
                    num_summed = temp_num_summed
                ENDIF ELSE IF array_equal(num_summed, temp_num_summed) NE 1 THEN BEGIN ; old 5 cycle data
                    temp_string = ' Apid 319, seq '+string(seq, format = '(I2.2)')+ ' non-matching number of packets summed.'
                    printf, error_lun, timestamp, temp_string
                    suspect_319[num_cycles5_heavy-1] = 1
                ENDIF 
            END 
            2: BEGIN ; 31E
                cdf_varput, cdf_id, 'num_summed_wap_ssd_tcr', temp_num_summed, rec_start = (num_cycles5_heavy-1)
                IF num_cycles5_heavy EQ 0 THEN write_cycle_heavy_v10, -1, -1, pkt_epoch 
                IF wrote_319[num_cycles5_heavy-1] NE 1 THEN BEGIN ; missed seq 0
                    cdf_varput, cdf_id, 'num_summed_sw_z>2_h', temp_num_summed, rec_start = (num_cycles5_heavy-1)
                    cdf_varput, cdf_id, 'num_summed_sw_z>2_l', temp_num_summed, rec_start = (num_cycles5_heavy-1)
                    wrote_319[num_cycles5_heavy-1] = 1
                    num_summed = temp_num_summed
                ENDIF ELSE IF array_equal(num_summed, temp_num_summed) NE 1 THEN BEGIN ; old 5 cycle data
                    temp_string = ' Apid 319, seq '+string(seq, format = '(I2.2)')+ ' non-matching number of packets summed.'
                    printf, error_lun, timestamp, temp_string
                    suspect_319[num_cycles5_heavy-1] = 1
                ENDIF 
            END 
            3: BEGIN ; 320
                IF heavy_on_ten EQ 1 AND num_cycles5_heavy GT 1 THEN $ ; new 10 cycle data
                  cdf_varput, cdf_id, 'num_summed_wap_nossd_dcr', temp_num_summed, rec_start = (num_cycles5_heavy-2)
            END 
            4: BEGIN ; 322
                cdf_varput, cdf_id, 'num_summed_wap_ssd_pri', temp_num_summed, rec_start = (num_cycles5_heavy-1)
                IF num_cycles5_heavy EQ 0 THEN write_cycle_heavy_v10, -1, -1, pkt_epoch 
                IF wrote_319[num_cycles5_heavy-1] NE 1 THEN BEGIN ; missed seq 0
                    cdf_varput, cdf_id, 'num_summed_sw_z>2_h',    temp_num_summed, rec_start = (num_cycles5_heavy-1)
                    cdf_varput, cdf_id, 'num_summed_sw_z>2_l',    temp_num_summed, rec_start = (num_cycles5_heavy-1)
                    cdf_varput, cdf_id, 'num_summed_wap_ssd_tcr', temp_num_summed, rec_start = (num_cycles5_heavy-1)
                    cdf_varput, cdf_id, 'num_summed_wap_ssd_dcr', temp_num_summed, rec_start = (num_cycles5_heavy-1)
                    cdf_varput, cdf_id, 'num_summed_sw_pri',      temp_num_summed, rec_start = (num_cycles5_heavy-1)
                    wrote_319[num_cycles5_heavy-1] = 1
                    num_summed = temp_num_summed
                ENDIF ELSE IF array_equal(num_summed, temp_num_summed) NE 1 THEN BEGIN ; old 5 cycle data
                    temp_string = ' Apid 319, seq '+string(seq, format = '(I2.2)')+ ' non-matching number of packets summed.'
                    printf, error_lun, timestamp, temp_string
                    suspect_319[num_cycles5_heavy-1] = 1
                ENDIF 
            END 
        ENDCASE 
    ENDIF ELSE BEGIN ; DPU post 327
        IF (temp_num_summed[0] MOD 5 EQ 0) THEN temp_num_cycles = temp_num_summed[0] ELSE $ ; get to nearest multiple of 5
          temp_num_cycles = temp_num_summed[0] + (5 - (temp_num_summed[0] MOD 5))
        CASE seq OF
            0: BEGIN ; 31A
                IF ishft(complete_flags, -7) AND '1'x EQ 1 THEN BEGIN ; 31A complete
                    num_summed = temp_num_summed
                    IF ishft(complete_flags, -6) AND '1'x NE 1 THEN $ ; 31B complete
                      printf, error_lun, timestamp, ' read_319_v10: 31A and 31B do not match'
                    old_epoch = pkt_epoch-(60000*(temp_num_cycles-5)) ; NOTE: This will be wrong if 319 not 5 min.
                    find_heavy_start, spacecraft, old_epoch, -1, -1, '319: 31A_B', cycle_index, back_day, version
                    IF back_day EQ 0 THEN BEGIN 
                        cdf_varput, cdf_id, 'num_summed_sw_z>2_h', temp_num_summed, rec_start = cycle_index 
                    ENDIF ELSE IF back_day EQ -1 THEN BEGIN 
                        write_cycle_heavy_v10, cycle_319, schan_319, pkt_epoch
                    ENDIF ELSE $
                      write_old_heavy_v10, old_epoch, spacecraft, cycle_index, $
                                           'sw_z>2_h', version, temp_num_summed = temp_num_summed
                ENDIF 
            END
            1: BEGIN ; 31C
                IF ishft(complete_flags, -5) AND '1'x EQ 1 THEN BEGIN ; 31C complete
                    num_summed = temp_num_summed
                    IF ishft(complete_flags, -4) AND '1'x NE 1 THEN $ ; 31D complete
                      printf, error_lun, timestamp, ' read_319_v10: 31C and 31D do not match'
                    old_epoch = pkt_epoch-(60000*(temp_num_cycles-5)) ; NOTE: This will be wrong if 319 not 5 min.
                    find_heavy_start, spacecraft, old_epoch, -1, -1, '319: 31C_D', cycle_index, back_day, version
                    IF back_day EQ 0 THEN BEGIN 
                        cdf_varput, cdf_id, 'num_summed_sw_z>2_l', temp_num_summed, rec_start = cycle_index 
                    ENDIF ELSE IF back_day EQ -1 THEN BEGIN 
                        write_cycle_heavy_v10, cycle_319, schan_319, pkt_epoch
                    ENDIF ELSE IF back_day EQ 1 THEN BEGIN 
                      write_old_heavy_v10, old_epoch, spacecraft, cycle_index, $
                                           'sw_z>2_l', version, temp_num_summed = temp_num_summed
                  ENDIF ; don't do anything if back_doy = -2
                ENDIF 
            END 
            2: BEGIN ; 31E
                ;IF timestamp EQ '2011-10-13T15:55:25.762' THEN stop
                IF ishft(complete_flags, -3) AND '1'x EQ 1 THEN BEGIN ; 31E complete
                    old_epoch = pkt_epoch-(60000*(temp_num_cycles-5)) ; NOTE: This will be wrong if 319 not 5 min.
                    find_heavy_start, spacecraft, old_epoch, -1, -1, '319: 31E', cycle_index, back_day, version
                    IF back_day EQ 0 THEN BEGIN 
                        cdf_varput, cdf_id, 'num_summed_wap_ssd_tcr', temp_num_summed, rec_start = cycle_index 
                    ENDIF ELSE IF back_day EQ -1 THEN BEGIN 
                        write_cycle_heavy_v10, cycle_319, schan_319, pkt_epoch
                    ENDIF ELSE $
                      write_old_heavy_v10, old_epoch, spacecraft, cycle_index, $
                                           'wap_ssd_tcr', version, temp_num_summed = temp_num_summed
                ENDIF 
            END 
            3: BEGIN ; 320
                IF ishft(complete_flags, -1) AND '1'x EQ 1 THEN BEGIN ; 320 complete
                    old_epoch = pkt_epoch-(60000*(temp_num_cycles-5)) ; NOTE: This will be wrong if 319 not 5 min.
                    find_heavy_start, spacecraft, old_epoch, -1, -1, '319: 320', cycle_index, back_day, version
                    IF back_day EQ 0 THEN BEGIN 
                        cdf_varput, cdf_id, 'num_summed_wap_nossd_dcr', temp_num_summed, rec_start = cycle_index 
                    ENDIF ELSE IF back_day EQ -1 THEN BEGIN 
                        write_cycle_heavy_v10, cycle_319, schan_319, pkt_epoch
                    ENDIF ELSE $
                      write_old_heavy_v10, old_epoch, spacecraft, cycle_index, $
                                           'wap_nossd_dcr', version, temp_num_summed = temp_num_summed
                ENDIF 
            END 
            4: BEGIN ; 322
                old_epoch = pkt_epoch-(60000*(temp_num_cycles-5)) ; NOTE: This will be wrong if 319 not 5 min.
                find_heavy_start, spacecraft, old_epoch, -1, -1, '319: 322', cycle_index, back_day, version
                IF back_day EQ 0 THEN BEGIN 
                    cdf_varput, cdf_id, 'num_summed_wap_ssd_pri', temp_num_summed, rec_start = cycle_index 
                ENDIF ELSE IF back_day EQ -1 THEN BEGIN 
                    write_cycle_heavy_v10, cycle_319, schan_319, pkt_epoch
                ENDIF ELSE $
                  write_old_heavy_v10, old_epoch, spacecraft, cycle_index, $
                                       'wap_ssd_pri', version, temp_num_summed = temp_num_summed
            END
        ENDCASE 
    ENDELSE 
            
    wrote_319[num_cycles5_heavy-1] = 1
    ; get data from second half of packet
    FOR i = 0, 127 DO BEGIN 
        IF i MOD 2 EQ 1 THEN temp_num_summed[i] = packet.dat[4+128+i+1] ELSE temp_num_summed[i] = packet.dat[4+128+i-1]
    ENDFOR
    IF dpu_post_327 EQ 0 THEN BEGIN 
        IF seq NE 3 THEN BEGIN ; sums should match
            IF array_equal(num_summed, temp_num_summed) NE 1 THEN BEGIN ; old 5 cycle data
                temp_string = ' Apid 319, seq '+string(seq, format = '(I2.2)')+ ' non-matching number of packets summed.'
                printf, error_lun, timestamp, temp_string
                suspect_319[num_cycles5_heavy-1] = 1
            ENDIF 
            IF seq EQ 2 THEN cdf_varput, cdf_id, 'num_summed_wap_ssd_dcr',   temp_num_summed, rec_start = (num_cycles5_heavy-1)
            IF seq EQ 4 THEN cdf_varput, cdf_id, 'num_summed_wap_nossd_pri', temp_num_summed, rec_start = (num_cycles5_heavy-1)
        ENDIF ELSE BEGIN ; 321
            IF num_cycles5_heavy EQ 0 THEN write_cycle_heavy_v10, -1, -1, pkt_epoch 
            cdf_varput, cdf_id, 'num_summed_sw_pri',      temp_num_summed, rec_start = (num_cycles5_heavy-1)
            IF wrote_319[num_cycles5_heavy-1] NE 1 THEN BEGIN ; missed seq 0
                cdf_varput, cdf_id, 'num_summed_sw_z>2_h',    temp_num_summed, rec_start = (num_cycles5_heavy-1)
                cdf_varput, cdf_id, 'num_summed_sw_z>2_l',    temp_num_summed, rec_start = (num_cycles5_heavy-1)
                cdf_varput, cdf_id, 'num_summed_wap_ssd_tcr', temp_num_summed, rec_start = (num_cycles5_heavy-1)
                cdf_varput, cdf_id, 'num_summed_wap_ssd_dcr', temp_num_summed, rec_start = (num_cycles5_heavy-1)
                wrote_319[num_cycles5_heavy-1] = 1
                num_summed = temp_num_summed
            ENDIF ELSE IF array_equal(num_summed, temp_num_summed) NE 1 THEN BEGIN ; old 5 cycle data
                temp_string = ' Apid 319, seq '+string(seq, format = '(I2.2)')+ ' non-matching number of packets summed.'
                printf, error_lun, timestamp, temp_string
                suspect_319[num_cycles5_heavy-1] = 1
            ENDIF 
        ENDELSE 
    ENDIF ELSE BEGIN      
        IF (temp_num_summed[0] MOD 5 EQ 0) THEN temp_num_cycles = temp_num_summed[0] ELSE $ ; get to nearest multiple of 5
          temp_num_cycles = temp_num_summed[0] + (5 - (temp_num_summed[0] MOD 5))
        CASE seq OF 
            0: IF (ishft(complete_flags, -6) AND '1'x NE 1) AND $
              (array_equal(num_summed, temp_num_summed) NE 1) THEN printf, error_lun, timestamp, ' read_319_v10: 31B does not match 31A'
            1: IF (ishft(complete_flags, -4) AND '1'x NE 1) AND $
              (array_equal(num_summed, temp_num_summed) NE 1) THEN printf, error_lun, timestamp, ' read_319_v10: 31D does not match 31C'
            2: BEGIN ; 31F
                IF ishft(complete_flags, -2) AND '1'x EQ 1 THEN BEGIN ; 31F complete
                    old_epoch = pkt_epoch-(60000*(temp_num_cycles-5)) ; NOTE: This will be wrong if 319 not 5 min.
                    find_heavy_start, spacecraft, old_epoch, -1, -1, '319: 31F', cycle_index, back_day, version
                    IF back_day EQ 0 THEN BEGIN 
                        cdf_varput, cdf_id, 'num_summed_wap_ssd_dcr', temp_num_summed, rec_start = cycle_index 
                    ENDIF ELSE IF back_day EQ -1 THEN BEGIN 
                        write_cycle_heavy_v10, cycle_319, schan_319, pkt_epoch
                    ENDIF ELSE $
                      write_old_heavy_v10, old_epoch, spacecraft, cycle_index, $
                                           'wap_ssd_dcr', version, temp_num_summed = temp_num_summed
                ENDIF 
            END
            3: BEGIN ; 321
                ;IF timestamp GE '2011-10-19T13:53:15.141' THEN stop
                IF ishft(complete_flags, -0) AND '1'x EQ 1 THEN BEGIN ; 321 complete
                    old_epoch = pkt_epoch-(60000*(temp_num_cycles-5)) ; NOTE: This will be wrong if 319 not 5 min.
                    find_heavy_start, spacecraft, old_epoch, -1, -1, '319: 321', cycle_index, back_day, version
                    IF back_day EQ 0 THEN BEGIN 
                        cdf_varput, cdf_id, 'num_summed_sw_pri', temp_num_summed, rec_start = cycle_index 
                    ENDIF ELSE IF back_day EQ -1 THEN BEGIN 
                        write_cycle_heavy_v10, cycle_319, schan_319, pkt_epoch
                    ENDIF ELSE $
                      write_old_heavy_v10, old_epoch, spacecraft, cycle_index, $
                                           'sw_pri', version, temp_num_summed = temp_num_summed
                ENDIF 
            END
            4: BEGIN ; 323
                old_epoch = pkt_epoch-(60000*(temp_num_cycles-5)) ; NOTE: This will be wrong if 319 not 5 min.
                find_heavy_start, spacecraft, old_epoch, -1, -1, '319: 323', cycle_index, back_day, version
                IF back_day EQ 0 THEN BEGIN
                    cdf_varput, cdf_id, 'num_summed_wap_nossd_pri', temp_num_summed, rec_start = cycle_index 
                ENDIF ELSE IF back_day EQ -1 THEN BEGIN 
                    write_cycle_heavy_v10, cycle_319, schan_319, pkt_epoch
                ENDIF ELSE $
                  write_old_heavy_v10, old_epoch, spacecraft, cycle_index, $
                                       'wap_nossd_pri', version, temp_num_summed = temp_num_summed
            END
        ENDCASE
    ENDELSE 
    IF seq EQ 4 THEN BEGIN
        schan_319 = -1
        cycle_319 = -1
        heavy_on_ten = -1
    ENDIF 
ENDELSE 
;IF cycles5_heavy[232] GT -1 THEN stop
END 
