; 02/15/07 Changed 329 to 319 (bug)
; 09/26/07 Changed format of error messages.
; 05/20/09 Added spacecraft argument
; 06/01/10 Added check for num_cycles5_heavy eq 0 (~line 60)
; 01/07/11 Added check for 12/5/10 for A.
; 01/31/11 Added option for V10 skeleton files.

PRO read_319, packet, spacecraft
compile_opt strictarrsubs
COMMON share1
COMMON share2
COMMON com_heavy
                                ; check checksum
temporary = packet.pkt
host_to_ieee, temporary
load_bytarr, temporary, bytarr
bytarr = [bytarr, packet.dat]
sum = total(bytarr)
IF sum MOD 256 NE 0 THEN BEGIN 
    printf, error_lun, timestamp, ' Error with checksum, apid 319, time'
ENDIF ELSE BEGIN 
    temp_num_summed = intarr(128)
    seq = fix(packet.dat[0])
                                ; check seq
    just_wrote = 0
    IF (seq EQ 0 AND last_seq_319 NE 4 AND last_seq_319 NE -1) OR $
      (seq NE 0 AND last_seq_319 NE -1 AND last_seq_319 NE seq-1) THEN BEGIN 
        printf, error_lun, timestamp, ' Missing 319 packet.', last_seq_319, seq
                                ; NB: if seq 0 is missing, we didn't get the cycle count
        check_seq_heavy, back_cycles
        IF back_cycles NE -1 THEN BEGIN             
            IF wrote_319[num_cycles5_heavy-back_cycles] EQ 1 THEN BEGIN
                printf, error_lun, timestamp, ' ', string(apid, format = '(Z)'), ' read_319: processing error'
                suspect_319[num_cycles5_heavy-back_cycles] = 1
            ENDIF 
        ENDIF 
    ENDIF 
    
    IF timestamp EQ '2010-12-05T21:00:32.156' AND spacecraft EQ 'A' THEN write_cycle5_heavy, -1, -1, pkt_epoch

    last_seq_319 = seq
    last_epoch_319 = pkt_epoch

    IF seq EQ 0 THEN BEGIN 
        schan_319 = fix(packet.dat[1+1])
        heavy_on_ten = fix(packet.dat[2-1])
        cycle_319 = fix(packet.dat[3+1])
        ;IF timestamp GT '2010-12-05T21:00:32.156' THEN stop
        IF just_wrote EQ 0 THEN BEGIN 
            IF (num_cycles5_heavy EQ 0) THEN write_cycle5_heavy, cycle_319, schan_319, pkt_epoch $
            ELSE IF (cycles5_heavy[num_cycles5_heavy-1] NE cycle_319) THEN write_cycle5_heavy, cycle_319, schan_319, pkt_epoch $
                 ELSE check_cycle5_heavy, cycle_319, schan_319
        ENDIF 
    ENDIF 
    ; get data from first half of packet
    FOR i = 0, 127 DO BEGIN 
        IF i MOD 2 EQ 1 THEN temp_num_summed[i] = packet.dat[4+i+1] ELSE temp_num_summed[i] = packet.dat[4+i-1]
    ENDFOR
    IF seq EQ 0 THEN BEGIN ; new 5 cycle data
        num_summed = temp_num_summed
        cdf_varput, cdf_id, 'heavy_ion_num_summed5', temp_num_summed, rec_start = (num_cycles5_heavy-1)
        wrote_319[num_cycles5_heavy-1] = 1
    ENDIF ELSE IF seq EQ 3 THEN BEGIN 
        IF heavy_on_ten EQ 1 AND num_cycles5_heavy GT 1 THEN $ ; new 10 cycle data
          cdf_varput, cdf_id, 'heavy_ion_num_summed10', temp_num_summed, rec_start = (num_cycles5_heavy-2)
    ENDIF ELSE BEGIN 
        IF num_cycles5_heavy EQ 0 THEN write_cycle5_heavy, cycle_319, schan_319, pkt_epoch 
        IF wrote_319[num_cycles5_heavy-1] NE 1 THEN BEGIN  ; missed seq 0
            cdf_varput, cdf_id, 'heavy_ion_num_summed5', temp_num_summed, rec_start = (num_cycles5_heavy-1)
            wrote_319[num_cycles5_heavy-1] = 1
            num_summed = temp_num_summed
        ENDIF ELSE IF array_equal(num_summed, temp_num_summed) NE 1 THEN BEGIN ; old 5 cycle data
            temp_string = ' Apid 319, seq '+string(seq, format = '(I2.2)')+ ' non-matching number of packets summed.'
            printf, error_lun, timestamp, temp_string
            suspect_319[num_cycles5_heavy-1] = 1
        ENDIF 
    ENDELSE  
    wrote_319[num_cycles5_heavy-1] = 1
    ; get data from second half of packet
    FOR i = 0, 127 DO BEGIN 
        IF i MOD 2 EQ 1 THEN temp_num_summed[i] = packet.dat[4+128+i+1] ELSE temp_num_summed[i] = packet.dat[4+128+i-1]
    ENDFOR
    IF seq EQ 3 AND wrote_319[num_cycles5_heavy-1] NE 1 THEN BEGIN  ; missed seq 0
        cdf_varput, cdf_id, 'heavy_ion_num_summed5', temp_num_summed, rec_start = (num_cycles5_heavy-1)
        wrote_319[num_cycles5_heavy-1] = 1
        num_summed = temp_num_summed
    ENDIF ELSE IF array_equal(num_summed, temp_num_summed) NE 1 THEN BEGIN 
        temp_string = ' Apid 319, seq '+string(seq, format = '(I2.2)')+ ' non-matching number of packets summed.'
        printf, error_lun, timestamp, temp_string
        suspect_319[num_cycles5_heavy-1] = 1
    ENDIF         
    IF seq EQ 4 THEN BEGIN
        schan_319 = -1
        cycle_319 = -1
        heavy_on_ten = -1
    ENDIF 
ENDELSE 
END 
