PRO read_318, packet, clcdf_id
compile_opt strictarrsubs
COMMON share1

                                ; check checksum
temporary = packet.pkt
host_to_ieee, temporary
load_bytarr, temporary, bytarr
bytarr = [bytarr, packet.dat]
sum = total(bytarr)
IF sum MOD 256 NE 0 THEN BEGIN 
    timestamp = parse_stereo_pkt(packet, /PKT_DATE, /ccsds) ; /ccsds is for anytim2utc
    printf, error_lun, 'Error with checksum, apid 328, time:', timestamp
ENDIF ELSE BEGIN 
    index = -11
    epoch = anytim2cdf(timestamp)
    device = fix(packet.dat[3+1])
    block = fix(packet.dat[2-1])
    data = lonarr(256)
    FOR i = 2, 129 DO BEGIN ; 256 bytes of data (128 words)
        data[(i*2)-4] = long(packet.dat[(i*2)-1])
        data[(i*2)-4+1] = long(packet.dat[(i*2)+1+1])
    ENDFOR
    cdf_varput, clcdf_id, 'epoch_memory', epoch, rec_start = num_memory_cycles
    cdf_varput, clcdf_id, 'device', device, rec_start = num_memory_cycles
    cdf_varput, clcdf_id, 'block_id_memory', (block), rec_start = num_memory_cycles
    cdf_varput, clcdf_id, 'memory_data', data, rec_start = num_memory_cycles
    num_memory_cycles = num_memory_cycles + 1
ENDELSE 
END 
