; 09/07/2007 Add mode to check_cycle1, changed when read mode
; 09/10/2007 Added temp_mode check
; 09/19/2007 Added last_cycle_mode_317
; 09/26/2007 Changed format of error statement.
; 03/19/2009 Removed write for B on 01/27/2009.
; 09/09/2009 Added checks for A on 08/07/2009.
; 01/26/2010 Added checks for A on 12/20/2009.
; 02/04/2010 Added checks for B on 12/31/2009.
; 03/15/2010 Added checks for B on 02/12/2010.
; 11/08/2010 Added checks for A on 10/08/2010.

PRO incrementApid317
compile_opt strictarrsubs
COMMON com_mon
apid317rate = apid317rate + 1
IF ( (mon_high_mode EQ 1) OR $ ; science mode
     ((apid317rate EQ 6) AND ((mon_high_mode AND 1) OR (mon_high_mode EQ 2))) ) THEN BEGIN 
    apid317rate = 0             
    apid317defl = apid317defl + 1
    IF apid317defl EQ 32 THEN BEGIN 
        apid317defl = 0         
        apid317esa = apid317esa + 1
        IF apid317esa EQ 64 THEN BEGIN 
            apid317esa = 0      
        ENDIF
    ENDIF
ENDIF 
END 


PRO read_317, packet, sat
compile_opt strictarrsubs
COMMON share1
COMMON share2
COMMON com_mon
                                ; check checksum
temporary = packet.pkt
host_to_ieee, temporary
load_bytarr, temporary, bytarr
bytarr = [bytarr, packet.dat]
sum = total(bytarr)
IF sum MOD 256 NE 0 THEN BEGIN 
    printf, error_lun, timestamp, ' Error with checksum, apid 317'
ENDIF ELSE BEGIN 
    seq = fix(packet.dat[0])
    ;IF timestamp GT '2018-03-14T12:59:33.000' THEN stop
                                ; check seq
    mode = mon_high_mode
    IF (seq EQ 0 AND mode EQ 1 AND last_seq_317 NE 7 AND last_seq_317 NE -1) OR $
      (seq EQ 0 AND mode EQ 2 AND last_seq_317 NE 47 AND last_seq_317 NE -1) OR $
      (seq NE 0 AND last_seq_317 NE -1 AND last_seq_317 NE seq-1) THEN BEGIN 
        printf, error_lun, timestamp, ' Missing 317 packet.', last_seq_317, seq
        check_seq1, back_cycles
        IF back_cycles NE -1 THEN BEGIN             
            IF array_equal(mon_high_values, -1) NE 1 THEN BEGIN 
                IF wrote_317[num_cycles1-back_cycles] EQ 1 THEN BEGIN
                    printf, error_lun, timestamp, ' ', string(apid, format = '(Z)'), ' read_317: processing error'
                    suspect_317[num_cycles1-back_cycles] = 1
                ENDIF ELSE BEGIN 
                    suspect_317[num_cycles1-back_cycles] = 1
                    write_317, 0, back_cycles
                ENDELSE 
            ENDIF 
        ENDIF 
        IF timestamp LT '2010-10-30T00:00:00.000' THEN BEGIN 
            IF timestamp EQ '2009-08-07T20:37:29.570' AND sat EQ 'A' THEN suspect_317[num_cycles1  ] = 1
            IF timestamp EQ '2009-08-07T20:50:29.570' AND sat EQ 'A' THEN suspect_317[num_cycles1+1] = 1
            IF timestamp EQ '2009-08-07T20:57:29.570' AND sat EQ 'A' THEN suspect_317[num_cycles1-1] = 1
            IF timestamp EQ '2009-08-07T21:05:29.566' AND sat EQ 'A' THEN suspect_317[num_cycles1-1] = 1
            IF timestamp EQ '2009-08-07T22:57:29.555' AND sat EQ 'A' THEN suspect_317[num_cycles1-1] = 1
            IF timestamp EQ '2010-02-12T08:48:49.184' AND sat EQ 'B' THEN suspect_317[num_cycles1-1] = 1
            IF timestamp EQ '2010-02-12T08:48:49.184' AND sat EQ 'B' THEN suspect_317[num_cycles1  ] = 1
            IF timestamp EQ '2010-10-08T21:06:37.563' AND sat EQ 'A' THEN suspect_317[num_cycles1+1] = 1
            IF timestamp EQ '2010-10-29T23:21:36.141' AND sat EQ 'A' THEN suspect_317[num_cycles1-1] = 1
        ENDIF 
    ENDIF
    IF seq EQ 0 OR mon_high_mode EQ -1 THEN mode = ishft(packet.dat[2-1], -6) ; 1=sci, 2=eng -- has to be down here so check seq 0 with old mode
    schan_317 = fix(packet.dat[1+1])
    last_epoch_317 = pkt_epoch
    last_seq_317 = seq
    IF (timestamp EQ '2009-12-20T22:06:12.211' AND seq EQ 0 AND sat EQ 'A') OR $
      (timestamp EQ '2009-12-20T22:11:12.207' AND seq EQ 6 AND sat EQ 'A') $
      THEN BEGIN 
        write_cycle1, -1, schan_317, pkt_epoch
        suspect_317[num_cycles1-1] = 1
    ENDIF 
    

                                ; get header info
    IF seq LT 6 THEN mon_high_products[seq] = fix(packet.dat[3+1])
    IF seq EQ 6 THEN mon_high_start_esa = fix(packet.dat[3+1])
    IF seq EQ 7 THEN BEGIN 
        cycle_317 = fix(packet.dat[3+1])
        IF mode EQ 1 THEN BEGIN ; science mode
            IF last_cycle_mode_317 EQ 2 THEN temp_mode = 2 ELSE temp_mode = 1 ; catch when changing from eng mode
            IF num_cycles1 EQ 0 THEN write_cycle1, cycle_317, schan_317, last_epoch_317 ELSE $
              IF cycles1[num_cycles1-1] NE cycle_317 THEN write_cycle1, cycle_317, schan_317, last_epoch_317 ELSE $
              check_cycle1, cycle_317, schan_317, temp_mode
        ENDIF ELSE BEGIN        ; if eng mode start new epoch if more than 30 seconds apart
            last_epoch = epochs1[num_cycles1-1]
            epoch = anytim2cdf(timestamp)
            IF abs(last_epoch-epoch) GT 30000 THEN $
              write_cycle1, cycle_317, schan_317, last_epoch_317 ELSE check_cycle1, cycle_317, schan_317, last_cycle_mode_317
        ENDELSE 
        last_cycle_mode_317 = mode
    ENDIF 
    mon_high_mode = mode

                                ; set variables in case first packet
; is not seq 0
    IF first_apid317 EQ 1 THEN BEGIN 
        first_apid317 = 0
        IF mon_high_mode EQ 1 THEN BEGIN ; science mode
            apid317esa = seq * 8
            apid317defl = 0
            apid317rate = 0
        ENDIF ELSE BEGIN        ; eng mode
            apid317esa = (seq/3)*4 + (seq MOD 3) 
            IF (seq MOD 3) EQ 0 THEN BEGIN 
                apid317defl = 0 
                apid317rate = 0 
            ENDIF ELSE IF (seq MOD 3) EQ 1 THEN BEGIN 
                apid317defl = 10
                apid317rate = 4
            ENDIF ELSE BEGIN 
                apid317defl = 21 
                apid317rate = 2 
            ENDELSE 
        ENDELSE 
    ENDIF ELSE IF seq EQ 0 THEN BEGIN ; to be on safe side if data missing
        apid317esa = 0
        apid317rate = 0
        apid317defl = 0
    ENDIF  
                                ; get data
    FOR i = 0, 255 DO BEGIN 
        index = 4+i
        IF index MOD 2 EQ 0 THEN compressed = packet.dat[index-1] ELSE compressed = packet.dat[index+1]
        uncompress8, compressed, uncompressed
        mon_high_values[apid317rate, apid317esa, apid317defl] = uncompressed 
        incrementApid317
    ENDFOR 
    
    IF timestamp EQ '2009-12-31T07:59:55.574' AND sat EQ 'B' AND seq EQ 7 THEN suspect_317[num_cycles1-1] = 1

    IF timestamp LT '2010-02-13T00:00:00' THEN BEGIN 
        IF (timestamp EQ '2009-12-20T22:06:12.211' AND seq EQ 2 AND sat EQ 'A') OR $
          (timestamp EQ '2009-12-20T22:07:12.207' AND seq EQ 6 AND sat EQ 'A') OR $
          (timestamp EQ '2010-02-12T08:45:49.184' AND seq EQ 5 AND sat EQ 'B') OR $
          (timestamp EQ '2010-02-12T08:49:49.184' AND seq EQ 4 AND sat EQ 'B') OR $
          (timestamp EQ '2010-02-12T08:50:49.184' AND seq EQ 2 AND sat EQ 'B') $
          THEN write_317, 0, 1  
    ENDIF 
    IF (mode EQ 1 AND seq EQ 7) OR (mode EQ 2 AND seq EQ 47) THEN BEGIN 
        IF timestamp EQ '2009-01-27T20:50:51.191' AND sat EQ 'B' THEN BEGIN 
            mon_high_values[*, *, *] = -1
            mon_high_mode = -1
            mon_high_start_esa = -1
            apid317rate = 0
            apid317defl = 0
            apid317esa = 0
            cycle_317 = -1
            schan_317 = -1
        ENDIF ELSE write_317, 0, 1
    ENDIF 
ENDELSE 
END 
