; 05/10/07 Added line to check if first packet has seq after 7
; 09/26/2007 Changed format of error statement.
; 09/16/2008 Added check for changing mode in middle of cycle.
; 09/17/2008 Changed suspect_316_5 to suspect5_mon.
; 07/20/2012 Check if num_cycles5_mon gt 0.

PRO read_316, packet
compile_opt strictarrsubs
COMMON share1
COMMON share2
COMMON com_mon
                                ; check checksum
temporary = packet.pkt
host_to_ieee, temporary
load_bytarr, temporary, bytarr
bytarr = [bytarr, packet.dat]
sum = total(bytarr)
IF sum MOD 256 NE 0 THEN BEGIN 
    printf, error_lun, timestamp, ' Error with checksum, apid 316'
ENDIF ELSE BEGIN 
    seq = fix(packet.dat[0])
    esa = seq*4
    temp_norm_mode = ishft(packet.dat[2-1], -6)

                                ; check seq
    IF (seq EQ 0 AND last_seq_316 NE 31 AND last_seq_316 NE -1) OR $
      (seq NE 0 AND last_seq_316 NE -1 AND last_seq_316 NE seq-1) THEN BEGIN 
        printf, error_lun, timestamp, ' Missing 316 packet.', last_seq_316, seq
        IF temp_norm_mode EQ 2 THEN BEGIN 
            check_seq1, back_cycles
            IF back_cycles NE -1 THEN BEGIN             
                IF array_equal(mon_norm_values, -1) NE 1 THEN BEGIN 
                    IF wrote_316_1[num_cycles1-back_cycles] EQ 1 THEN BEGIN
                        printf, error_lun, timestamp, ' ', string(apid, format = '(Z)'), ' read_316: processing error1 '
                        suspect_316_1[num_cycles1-back_cycles] = 1
                    ENDIF ELSE BEGIN 
                        suspect_316_1[num_cycles1-back_cycles] = 1
                        write_316, 0, back_cycles
                    ENDELSE 
                ENDIF 
            ENDIF 
        ENDIF ELSE BEGIN 
            check_seq5_mon, back_cycles
            IF back_cycles NE -1 THEN BEGIN             
                IF array_equal(mon_norm_values, -1) NE 1 THEN BEGIN 
                    IF wrote_316_5[num_cycles5_mon-back_cycles] EQ 1 THEN BEGIN
                        printf, error_lun, timestamp, ' ', string(apid, format = '(Z)'), ' read_316: processing error2 '
                        suspect5_mon[num_cycles5_mon-back_cycles] = 1
                    ENDIF ELSE BEGIN 
                        suspect5_mon[num_cycles5_mon-back_cycles] = 1
                        write_316, 0, back_cycles
                    ENDELSE 
                ENDIF 
            ENDIF ELSE BEGIN
                IF num_cycles5_mon GT 0 THEN BEGIN 
                    diff = abs(pkt_epoch-epochs5_mon[num_cycles5_mon-1])
                    IF diff GT 270000 THEN write_cycle5_mon, -1, -1, pkt_epoch
                ENDIF 
            ENDELSE 
        ENDELSE 
    ENDIF
                                ; get header info
    schan_316 = fix(packet.dat[1+1])
    IF temp_norm_mode NE mon_norm_mode AND seq NE 0 AND last_seq_316 NE -1 THEN BEGIN
        printf, error_lun, timestamp, ' ', string(apid, format = '(Z)'), ' read_316: Mode changed in middle of cycle.'
        suspect_316_1[num_cycles1] = 1
        suspect5_mon[num_cycles5_mon] = 1
    ENDIF
    mon_norm_mode = temp_norm_mode
    ; check if first packet is too late for seq
    IF (seq GT 7 AND last_seq_316 EQ -1) THEN BEGIN
        cycle_316 = (packet.dat[3+1])
        IF mon_norm_mode EQ 2 THEN write_cycle1, cycle_316, schan_316, pkt_epoch ELSE $
          write_cycle5_mon, cycle_316, schan_316, last_epoch_316
    ENDIF 
    last_epoch_316 = pkt_epoch
    last_seq_316 = seq
    first_apid316 = 0

                                ; get header info
    IF seq EQ 7 THEN BEGIN 
        cycle_316 = (packet.dat[3+1])
        ;stop
        ;IF timestamp GT temp_t AND timestamp LT temp_t2 THEN stop
        IF mon_norm_mode EQ 2 THEN BEGIN ; eng mode
            IF num_cycles1 EQ 0 THEN write_cycle1, cycle_316, schan_316, last_epoch_316 $
              ELSE IF cycles1[num_cycles1-1] NE cycle_316 THEN write_cycle1, cycle_316, schan_316, last_epoch_316 $
            ELSE check_cycle1, cycle_316, schan_316
        ENDIF ELSE IF mon_norm_mode EQ 1 THEN BEGIN 
            write_cycle5_mon, cycle_316, schan_316, last_epoch_316
        ENDIF ELSE printf, error_lun, timestamp, " Invalid mode in apid316 at cycle ", cycle_316
    ENDIF 
                                ; get data
    FOR i = 0, 7 DO BEGIN       ; 8 sets of defl per packet (i.e. per esa group)
        defl = i*4
        FOR j = 0, 31 DO BEGIN  ; 32 rates
            index = 4+(i*32)+(31-j) ; read backwards to match TlmPacket
            IF index MOD 2 EQ 0 THEN uncompress8, packet.dat[index-1], value $
            ELSE uncompress8, packet.dat[index+1], value 
            mon_norm_values[j, seq, i] = value 
        ENDFOR
    ENDFOR
    IF seq EQ 31 THEN BEGIN 
        ;IF timestamp GE temp_t THEN stop
        IF mon_norm_mode EQ 2 THEN BEGIN
            diff = abs(pkt_epoch-epochs1[num_cycles1-1])
            IF diff GT 30000 OR wrote_316_1[num_cycles1-1] EQ 1 THEN BEGIN 
                write_cycle1, -1, -1, pkt_epoch
            ENDIF 
            write_316, 0, 1
        ENDIF ELSE BEGIN
            diff = abs(pkt_epoch-epochs5_mon[num_cycles5_mon-1])
            IF diff GT 270000 OR wrote_316_5[num_cycles5_mon-1] EQ 1 THEN BEGIN 
                write_cycle5_mon, -1, -1, pkt_epoch
            ENDIF 
            write_316, 0, 1
        ENDELSE 
    ENDIF 
ENDELSE 
END 
