; 03/19/2007 Added accomodation for new and old DPU software
; 04/09/2007 Moved num_pha_events = 0 
; 09/20/2007 Changed format of error message
; 11/14/2007 When checking for missing data, no longer check if seq 0
;            -- already taken care of above
; 11/15/2007 Check if pha_last_seq eq 17
; 11/16/2007 add write_315 if missing end of cycle
; 01/12/2009 Added check to change cycle number for A on 11/05/2008
; 01/03/2016 Add check if cycle_315 eq -1

PRO read_315, packet, spacecraft
COMMON share1
COMMON share2
COMMON com_pha
compile_opt strictarrsubs
temporary = packet.pkt
host_to_ieee, temporary
load_bytarr, temporary, bytarr
bytarr = [bytarr, packet.dat]
sum = total(bytarr)
IF sum MOD 256 NE 0 THEN printf, error_lun, 'Error with checksum, apid 315, time:', timestamp $
ELSE BEGIN 
    IF (spacecraft EQ 'A' AND timestamp GE '2007-06-26T16:00:00.000') OR $
      (spacecraft EQ 'B' AND timestamp GE '2007-07-02T20:00:00.000') THEN dpu_version = 321 ELSE dpu_version = 317
    
    seq = fix(packet.dat[0])
    ;temp_t = '2012-12-25T05:17:42.430'
    ;temp_t2 = '2007-06-02T15:20:00.000'
    ;IF timestamp GE '2012-12-25T05:17:42.430' THEN stop
                                ;IF timestamp GE temp_t THEN print,
                                ;timestamp, ' ', seq, ' ',
                                ;suspect_315[245]
    IF seq EQ 0 THEN BEGIN 
        IF dpu_version LT 321 THEN BEGIN 
            temp_cycle = fix(packet.dat[14-11+1])-1 ; cycle count was off by one
            IF temp_cycle EQ -1 THEN temp_cycle = 255 
        ENDIF ELSE temp_cycle = fix(packet.dat[14-11+1])
        IF timestamp LT '2020-11-06T00:00:00.000' THEN check_315_write_cycle, timestamp, spacecraft, temp_cycle, pkt_epoch
        ;IF timestamp GE '2012-12-25T05:17:42.430' THEN stop
        IF (num_cycles1 EQ 0) OR (cycle_315 EQ -1) THEN BEGIN 
            write_cycle1, temp_cycle, -1, pkt_epoch
            cycle_315 = temp_cycle
        ENDIF ELSE IF (temp_cycle EQ cycle_315 OR temp_cycle+1 EQ cycle_315) AND $
          timestamp NE '2010-07-13T22:54:39.828' THEN BEGIN            ; remove this part with new dpu 
            temp2_cycle = temp_cycle + 1
            IF temp_cycle EQ cycle_315 THEN BEGIN 
                IF num_cycles1 GT 1 THEN BEGIN 
                    IF cycles1[num_cycles1-2] EQ cycle_315 THEN temp2_cycle = temp_cycle ELSE temp2_cycle = temp_cycle+1
                ENDIF ELSE temp2_cycle = temp_cycle+1
            ENDIF 
            IF temp2_cycle EQ 255 THEN write_cycle1, 0, -1, pkt_epoch ELSE write_cycle1, temp2_cycle, -1, pkt_epoch
            cycle_315 = temp2_cycle
        ENDIF ELSE BEGIN 
            IF cycles1[num_cycles1-1] EQ cycle_315 THEN write_cycle1, temp_cycle, -1, pkt_epoch ELSE check_cycle1, temp_cycle, -1
            cycle_315 = temp_cycle
        ENDELSE 
        IF (pha_last_seq NE -1) AND (pha_last_seq NE 17) THEN BEGIN
            printf, error_lun, timestamp, ' Missing 315 packet1.', pha_last_seq, seq
            IF (timestamp EQ '2012-12-14T15:07:32.258' AND spacecraft EQ 'B') OR $
              (timestamp EQ '2012-12-20T18:43:42.988' AND spacecraft EQ 'A') OR $
              (timestamp EQ '2012-12-25T05:17:42.430' AND spacecraft EQ 'A') OR $
              (timestamp EQ '2012-12-25T05:18:42.430' AND spacecraft EQ 'A') OR $
              (timestamp EQ '2013-01-05T15:13:41.004' AND spacecraft EQ 'A') OR $
              (timestamp EQ '2013-01-07T07:06:40.871' AND spacecraft EQ 'A') OR $
              (timestamp EQ '2013-01-07T15:27:31.094' AND spacecraft EQ 'B') OR $
              (timestamp EQ '2013-01-08T16:45:30.973' AND spacecraft EQ 'B') OR $
              (timestamp EQ '2013-01-11T17:10:30.621' AND spacecraft EQ 'B') OR $
              (timestamp EQ '2013-01-12T19:58:30.504' AND spacecraft EQ 'B') THEN dummy = dummy $
            ELSE BEGIN 
                suspect_315[num_cycles1-1] = 1
                IF (timestamp EQ '2012-12-25T05:18:42.430' AND spacecraft EQ 'A') THEN dummy = dummy $
                  ELSE suspect_315[num_cycles1] = 1            
                FOR i = pha_last_seq+1, 17 DO BEGIN 
                    mask = 0L
                    mask = ishft(mask, i)
                    pha_missing = pha_missing OR mask
                ENDFOR
                FOR i = 0, seq-1 DO BEGIN
                    mask = 0L
                    mask = ishft(mask, i)
                    pha_missing = pha_missing OR mask
                ENDFOR
                write_315, 0
            ENDELSE 
        ENDIF 
    ENDIF 
    IF seq EQ 1 THEN apid315_start_esa = fix(packet.dat[12-11+1])
    IF (seq NE 0 AND pha_last_seq NE -1 AND pha_last_seq NE seq-1) THEN BEGIN 
        pha_missed_packet = 1
        IF pha_last_seq EQ 17 THEN BEGIN 
            write_cycle1, -1, -1, pkt_epoch
            suspect_315[num_cycles1] = 1
            FOR i = 0, seq-1 DO BEGIN
                mask = 0L
                mask = ishft(mask, i)
                pha_missing = pha_missing OR mask
            ENDFOR
            printf, error_lun, timestamp, ' Missing 315 packet2.', pha_last_seq, seq
        ENDIF ELSE IF seq GT pha_last_seq THEN BEGIN
            IF num_cycles1 GT 0 THEN suspect_315[num_cycles1-1] = 1
            FOR i = pha_last_seq+1, seq-1 DO BEGIN 
                mask = 0L
                mask = ishft(mask, i)
                pha_missing = pha_missing OR mask
            ENDFOR 
            printf, error_lun, timestamp, ' Missing 315 packet3.', pha_last_seq, seq
        ENDIF ELSE BEGIN  
            suspect_315[num_cycles1-1] = 1
            suspect_315[num_cycles1] = 1            
            FOR i = pha_last_seq+1, 17 DO BEGIN 
                mask = 0L
                mask = ishft(mask, i)
                pha_missing = pha_missing OR mask
            ENDFOR
            FOR i = 0, seq-1 DO BEGIN
                mask = 0L
                mask = ishft(mask, i)
                pha_missing = pha_missing OR mask
            ENDFOR
            write_cycle1, -1, -1, last_epoch_315
            write_315, 0
            printf, error_lun, timestamp, ' Missing 315 packet4.', pha_last_seq, seq
        ENDELSE 
    ENDIF
    IF seq EQ 0 THEN num_pha_events = 0
    last_epoch_315 = pkt_epoch
    pha_last_seq = seq
    IF seq MOD 3 EQ 0 THEN start_byte = 0 ELSE $
      IF seq MOD 3 EQ 1 THEN start_byte = 4 ELSE start_byte = 2
    current_byte = start_byte
    FOR i = 0, 255 DO BEGIN     ; get data
        IF pha_missed_packet EQ 1 THEN BEGIN ; reset to first full PHA event; drop partial event
            current_byte = 0
            IF seq MOD 3 EQ 0 THEN i = 0 ELSE $
              IF seq MOD 3 EQ 1 THEN i = 2 ELSE i = 4
            pha_missed_packet = 0
        ENDIF
        IF i MOD 2 EQ 0 THEN pha_bytes[current_byte] = packet.dat(i+4-1) ELSE pha_bytes[current_byte] = packet.dat(i+4+1) 
        current_byte = current_byte+1
        IF current_byte EQ 6 THEN BEGIN
            current_byte = 0
            IF array_equal(pha_bytes, 0b) THEN dummy = dummy ELSE BEGIN ; skip all 0 filler events
                bytes3 = bytarr(6)
                FOR j = 0, 5 DO BEGIN
                    bytes3[j] = pha_bytes[5-j]
                ENDFOR 
                pha_events[num_pha_events, 0] = ishft((bytes3[0] AND 'FE'x), -1) ;swpe
                temp1 = ishft(fix(bytes3[0] AND '01'x), 4)
                temp2 = ishft(fix(bytes3[1] AND 'F0'x), -4)
                pha_events[num_pha_events, 1] = temp1 OR temp2 ; swpd
                pha_events[num_pha_events, 2] = ishft(bytes3[1] AND  '0C'x, -2) ;quad
                temp1 = ishft(fix(bytes3[1] AND '03'x), 2)
                temp2 = ishft(fix(bytes3[2] AND 'C0'x), -6)
                pha_events[num_pha_events, 3] = temp1 OR temp2 ; ssd
                temp1 = ishft(fix(bytes3[2] AND '3F'x), 4)
                temp2 = ishft(fix(bytes3[3] AND 'F0'x), -4)
                pha_events[num_pha_events, 4] = temp1 OR temp2 ; ssde
                temp1 = ishft(fix(bytes3[3] AND '0F'x), 6)
                temp2 = ishft(fix(bytes3[4] AND 'FC'x), -2)
                pha_events[num_pha_events, 5] = temp1 OR temp2 ;tof
                temp1 = ishft(fix(bytes3[4] AND '03'x), 4)
                temp2 = ishft(fix(bytes3[5] AND 'F0'x), -4)
                pha_events[num_pha_events, 6] = temp1 OR temp2 ;pos
                pha_events[num_pha_events, 7] = ishft(bytes3[5] AND '0C'x, -2) ; sec
                pha_events[num_pha_events, 8] = bytes3[5] AND '03'x ; pri
                num_pha_events = num_pha_events + 1
            ENDELSE 
        ENDIF 
    ENDFOR 

    ;IF seq EQ 1 AND timestamp EQ '2009-12-20T22:10:12.207' AND spacecraft EQ 'A' THEN write_315, 0

    IF seq EQ 17 THEN BEGIN
        write_315, 0
    ENDIF 

ENDELSE 

END 
