; 02/08/07 Added -3 option to check_limits
; 02/13/07 Added logic for dacm/dacr_defl_1/2_course/fine/dfine for sweeping or not
; 01/28/11 Added part for DPU post 327.
; 06/18/11 Fixed problem with DPU post 327.
; 09/04/14 Add check of values for first packet of day.
; 12/08/14 Change check to all packets of day

PRO check_limits_read_313, value, index
compile_opt strictarrsubs
COMMON share1
COMMON com_hk
low_limit = dighk_low_limits[index]
CASE low_limit OF 
    -3: IF value NE dighk_old_values[index-33] THEN BEGIN
        temp_string = timestamp+": DACM and DACR don't match for: "+dighk_products[index]+" "+dighk_products[index-33]+" DACM="+$
                          string(dighk_old_values[index-33], format = '(Z4.2)')+" DACR="+string(value, format = '(Z4.2)')
        printf, hkerror_lun, temp_string
        printf, status_lun, temp_string
    ENDIF 
    -2: IF value NE dighk_old_values[index] THEN BEGIN
        IF first_dighk EQ 0 THEN BEGIN 
            temp_string = timestamp+": Change in dighk: "+dighk_products[index]+" from "+$
                          string(dighk_old_values[index], format = '(Z4.2)')+" to "+string(value, format = '(Z4.2)')
            printf, hkerror_lun, temp_string
            printf, status_lun, temp_string
        ENDIF 
    ENDIF 
    -1: BREAK 
    ELSE: BEGIN 
        IF value LT low_limit THEN BEGIN 
            temp_string = timestamp+": Value below low limit: "+dighk_products[index]+". Limit="+$
                          string(dighk_low_limits[index], format = '(Z2.2)')+". Value="+string(value, format = '(Z2.2)')
            printf, hkerror_lun, temp_string
        ENDIF ELSE BEGIN 
            high_limit = dighk_high_limits[index]
            IF value GT high_limit THEN BEGIN 
                temp_string = timestamp+": Value above high limit: "+dighk_products[index]+". Limit="+$
                              string(dighk_high_limits[index], format = '(Z2.2)')+". Value="+string(value, format = '(Z2.2)')
                printf, hkerror_lun, temp_string
            ENDIF 
        ENDELSE 
    END 
ENDCASE 
dighk_old_values[index] = value
END 

PRO read_313, packet, hkcdf_id, sat, have_313
compile_opt strictarrsubs
COMMON share1
COMMON com_hk
                                ; check checksum
temporary = packet.pkt
host_to_ieee, temporary
load_bytarr, temporary, bytarr
bytarr = [bytarr, packet.dat]
sum = total(bytarr)
IF sum MOD 256 NE 0 THEN BEGIN 
    timestamp = parse_stereo_pkt(packet, /PKT_DATE, /ccsds) ; /ccsds is for anytim2utc
    printf, hkerror_lun, 'Error with checksum, apid 313, time:', timestamp
ENDIF ELSE BEGIN 
    epoch = anytim2cdf(timestamp)
    cdf_varput, hkcdf_id, 'epoch_digital', epoch, rec_start = num_digital_cycles
    IF (abs(epoch-old_dighk_epoch) GT 1800000) THEN BEGIN 
        old_timestamp = cdf2utc(old_dighk_epoch, /ccsds)
        temp_string = timestamp+"  More than 30 minutes between apids313: "+old_timestamp
        printf, hkerror_lun, temp_string
    ENDIF 
    old_dighk_epoch = epoch
    index = 4-15
    FOR i = 0, 2 DO BEGIN ; sw_version - cmd_exec_cnt
        value2 = long(packet.dat[index+13+(i*2)-1])
        value1 = ishft(long(packet.dat[index+13+(i*2)+1+1]), 8)
        value = value1 OR value2
        check_limits_read_313, value, i
        IF i EQ 0 THEN BEGIN 
            IF value LE '327'x THEN dpu_post_327 = 0 ELSE dpu_post_327 = 1
        ENDIF 
        cdf_varput, hkcdf_id, dighk_products[i], value, rec_start = num_digital_cycles
        dighk_values[i, dighk_val_i] = value
    ENDFOR 
    ; cmd_total_err_cnt - ic_ctl_reg
    value = long((packet.dat[index+19-1])) AND 'F'x
    check_limits_read_313, value, 3
    cdf_varput, hkcdf_id, dighk_products[3], value, rec_start = num_digital_cycles
    dighk_values[3, dighk_val_i] = value
    value = ishft(long((packet.dat[index+19-1])), -4)
    check_limits_read_313, value, 4
    cdf_varput, hkcdf_id, dighk_products[4], value, rec_start = num_digital_cycles
    dighk_values[4, dighk_val_i] = value
    value = long((packet.dat[index+20+1])) AND 'F'x
    check_limits_read_313, value, 5
    cdf_varput, hkcdf_id, dighk_products[5], value, rec_start = num_digital_cycles
    dighk_values[5, dighk_val_i] = value
    value = ishft(long((packet.dat[index+20+1])), -4)
    check_limits_read_313, value, 6
    cdf_varput, hkcdf_id, dighk_products[6], value, rec_start = num_digital_cycles
    dighk_values[6, dighk_val_i] = value
    value2 = long(packet.dat[index+21-1])  
    value1 = ishft(long(packet.dat[index+22+1]), 8)
    value = value1 OR value2
    check_limits_read_313, value, 7
    cdf_varput, hkcdf_id, dighk_products[7], value, rec_start = num_digital_cycles
    dighk_values[7, dighk_val_i] = value
    value2 = long(packet.dat[index+23-1])  
    value1 = ishft(long(packet.dat[index+24+1]), 8)
    value = value1 OR value2
    check_limits_read_313, value, 8
    cdf_varput, hkcdf_id, dighk_products[8], value, rec_start = num_digital_cycles
    dighk_values[8, dighk_val_i] = value
    FOR i = 0, 32 DO BEGIN ; lbc_reset_ctl - lbe_ssd_over_lo
        temp_index = index+25+i
        IF temp_index MOD 2 EQ 0 THEN temp_index = temp_index-1 ELSE temp_index = temp_index+1
        value = long(packet.dat[temp_index])
        check_limits_read_313, value, i+9
        cdf_varput, hkcdf_id, dighk_products[i+9], value, rec_start = num_digital_cycles
        dighk_values[i+9, dighk_val_i] = value
    ENDFOR 
    FOR i = 0, 3 DO BEGIN ; lbe_sel_ctrl - lbe_defl_step
        temp_index = index+66+i
        IF temp_index MOD 2 EQ 0 THEN temp_index = temp_index-1 ELSE temp_index = temp_index+1
        value = long(packet.dat[temp_index])
        check_limits_read_313, value, i+42
        cdf_varput, hkcdf_id, dighk_products[i+42], value, rec_start = num_digital_cycles
        dighk_values[i+42, dighk_val_i] = value
    ENDFOR 
    FOR i = 0, 10 DO BEGIN ; lbe_ssd_offset0 - lbe_stim_freq_lo
        temp_index = index+74+i
        IF temp_index MOD 2 EQ 0 THEN temp_index = temp_index-1 ELSE temp_index = temp_index+1
        value = long(packet.dat[temp_index])
        check_limits_read_313, value, i+46
        cdf_varput, hkcdf_id, dighk_products[i+46], value, rec_start = num_digital_cycles
        dighk_values[i+46, dighk_val_i] = value
    ENDFOR 
    FOR i = 0, 1 DO BEGIN ; lbe_sel0_window - lbe_sel2_window
        temp_index = index+87+i
        IF temp_index MOD 2 EQ 0 THEN temp_index = temp_index-1 ELSE temp_index = temp_index+1
        value = long(packet.dat[temp_index])
        check_limits_read_313, value, i+57
        cdf_varput, hkcdf_id, dighk_products[i+57], value, rec_start = num_digital_cycles
        dighk_values[i+57, dighk_val_i] = value
    ENDFOR 
    FOR i = 0, 41 DO BEGIN ; lbe_ssd_offset8 - dacm_dfl_2_dfine
        temp_index = index+90+i
        IF temp_index MOD 2 EQ 0 THEN temp_index = temp_index-1 ELSE temp_index = temp_index+1
        value = long(packet.dat[temp_index])
        IF (i EQ 36 OR i EQ 39) AND (ishft(dighk_old_values[11], -7) EQ 1) THEN BEGIN ;dfl_1/2_course/fine/dfine sweeping, checked lbc_logic_ctl_a
            IF value NE dacm_defl_sweep_coarse_exp_value THEN BEGIN 
                temp_string = timestamp+": DACM unexpected value when sweeping: "+dighk_products[i+59]+" from "+$
                              string(dighk_old_values[i+59], format = '(Z4.2)')+" to "+string(value, format = '(Z4.2)')
            ENDIF 
            dighk_old_values[i+59] = value
        ENDIF ELSE check_limits_read_313, value, i+59
        IF (i EQ 37 OR i EQ 40) AND (ishft(dighk_old_values[11], -7) EQ 1) THEN BEGIN ; sweeping, checked lbc_logic_ctl_a
            IF value NE dacm_defl_sweep_fine_exp_value THEN BEGIN 
                temp_string = timestamp+": DACM unexpected value when sweeping: "+dighk_products[i+59]+" from "+$
                              string(dighk_old_values[i+59], format = '(Z4.2)')+" to "+string(value, format = '(Z4.2)')
            ENDIF 
            dighk_old_values[i+59] = value
        ENDIF ELSE check_limits_read_313, value, i+59
        IF (i EQ 38 OR i EQ 41) AND (ishft(dighk_old_values[11], -7) EQ 1) THEN BEGIN ; sweeping, checked lbc_logic_ctl_a
            IF value NE dacm_defl_sweep_dfine_exp_value THEN BEGIN 
                temp_string = timestamp+": DACM unexpected value when sweeping: "+dighk_products[i+59]+" from "+$
                              string(dighk_old_values[i+59], format = '(Z4.2)')+" to "+string(value, format = '(Z4.2)')
            ENDIF 
            dighk_old_values[i+59] = value
        ENDIF ELSE check_limits_read_313, value, i+59
        cdf_varput, hkcdf_id, dighk_products[i+59], value, rec_start = num_digital_cycles
        dighk_values[i+59, dighk_val_i] = value
    ENDFOR 
    FOR i = 0, 33 DO BEGIN ; dacr_pac_cmp_ssd_ctl_mcp_limit - sw_status1
        temp_index = index+133+i
        IF temp_index MOD 2 EQ 0 THEN temp_index = temp_index-1 ELSE temp_index = temp_index+1
        value = long(packet.dat[temp_index])
        IF i GE 27 AND i LE 32 AND (ishft(dighk_old_values[11], -7) EQ 1) THEN BEGIN ;dfl_1/2_course/fine/dfine sweeping, checked lbc_logic_ctl_a 
            IF value NE dighk_old_values[i+101] THEN BEGIN
                IF first_dighk EQ 0 THEN BEGIN 
                    temp_string = timestamp+": Change in dighk: "+dighk_products[i+101]+" from "+$
                                  string(dighk_old_values[i+101], format = '(Z4.2)')+" to "+string(value, format = '(Z4.2)')
                    printf, hkerror_lun, temp_string
                    printf, status_lun, temp_string
                ENDIF 
            ENDIF 
            dighk_old_values[i+101] = value
        ENDIF ELSE check_limits_read_313, value, i+101
        cdf_varput, hkcdf_id, dighk_products[i+101], value, rec_start = num_digital_cycles
        dighk_values[i+101, dighk_val_i] = value
    ENDFOR 
    FOR i = 0, 2 DO BEGIN ; sw_hv_ramp_status - sw_hv_limit_status
        temp_index = index+168+i
        IF temp_index MOD 2 EQ 0 THEN temp_index = temp_index-1 ELSE temp_index = temp_index+1
        value = long(packet.dat[temp_index])
        check_limits_read_313, value, i+135
        cdf_varput, hkcdf_id, dighk_products[i+135], value, rec_start = num_digital_cycles
        dighk_values[i+135, dighk_val_i] = value
    ENDFOR 
    FOR i = 0, 1 DO BEGIN ; sw_eepromchksum - hkp_sampletime
        value2 = long(packet.dat[index+171+(i*2)-1])
        value1 = ishft(long(packet.dat[index+171+(i*2)+1+1]), 8)
        value = value1 OR value2
        check_limits_read_313, value, i+138
        cdf_varput, hkcdf_id, dighk_products[i+138], value, rec_start = num_digital_cycles
        dighk_values[i+138, dighk_val_i] = value
    ENDFOR 
    FOR i = 0, 58 DO BEGIN ; pac_dischare_status - swmaint_pac_fine
        temp_index = index+175+i
        IF temp_index MOD 2 EQ 0 THEN temp_index = temp_index-1 ELSE temp_index = temp_index+1
        value = long(packet.dat[temp_index])
        check_limits_read_313, value, i+140
        cdf_varput, hkcdf_id, dighk_products[i+140], value, rec_start = num_digital_cycles
        dighk_values[i+140, dighk_val_i] = value
    ENDFOR 
    IF dpu_post_327 EQ 1 THEN BEGIN 
        FOR i = 0, 2 DO BEGIN   ; ENA1_ApID - ENA3-ApID
            temp_index = index+234+i
            IF temp_index MOD 2 EQ 0 THEN temp_index = temp_index-1 ELSE temp_index = temp_index+1
            value = long(packet.dat[temp_index])
            IF i EQ 2 THEN start_i = 5 ELSE start_i = 0
            ;IF i EQ 2 THEN stop_i = 2 ELSE stop_i = 7
            FOR jj = start_i, 7 DO BEGIN
                IF value AND ishft(1, (7-jj)) EQ 1 THEN temp_value = 1 ELSE temp_value = 0
                temp_jj = jj-start_i
                cdf_varput, hkcdf_id, dighk_post_327[(i*8)+temp_jj], temp_value, rec_start = num_digital_cycles
                dighk_post_327_values[(i*8)+temp_jj, dighk_val_i] = temp_value
            ENDFOR 
        ENDFOR 
        FOR i = 0, 10 DO BEGIN  ; APID_319_Rate - APID_232_Period
            temp_index = index+237+i
            IF temp_index MOD 2 EQ 0 THEN temp_index = temp_index-1 ELSE temp_index = temp_index+1
            value = long(packet.dat[temp_index])
            cdf_varput, hkcdf_id, dighk_post_327[i+19], value, rec_start = num_digital_cycles
            dighk_post_327_values[i+19, dighk_val_i] = value
        ENDFOR 
    ENDIF 
    num_digital_cycles = num_digital_cycles + 1
    first_dighk = 0
    dighk_val_i = dighk_val_i + 1
    ;IF have_313 EQ 0 THEN check_set_points, sat
ENDELSE 
END 
