; Lorna Ellis
; read_200.pro

; 01/04/06 Changed so ssd_ values are only out of limits if happens
; more than one packet in a row.
; 01/24/07 Added power_warning, thruster_warning, and coarse_pointing
; 02/09/07 Added logic for esa_cm_dc if sweeping
; 08/16/07 Added timestamp for spacecraft error messages
; 06/17/08 Added check on first_dighk sweeping check in esa_cm_dc
; 04/27/20 Change message of SSDs are off

PRO parse_formula, raw, converter, temp_eng
compile_opt strictarrsubs
poly = 0
temp_eng = double(raw)
num_parts = (n_elements(converter))/2
FOR i = 0, num_parts-1 DO BEGIN 
    operator = converter[(i*2)+1]
    CASE operator OF 
        '+': temp_eng = temp_eng + double(converter[(i*2)+2])
        '-': temp_eng = temp_eng - double(converter[(i*2)+2])
        '*': temp_eng = temp_eng * double(converter[(i*2)+2])
        '/': temp_eng = temp_eng / double(converter[(i*2)+2])
        '&': BEGIN 
            temp_eng = fix(temp_eng)
            java_mask = converter[(i*2)+2]
            idl_string = strmid(java_mask, 2, strlen(java_mask)-1)
            reads, idl_string, idl_mask, format = '(Z)'
            temp_eng = temp_eng AND fix(idl_mask)
        END 
        'px': poly = (raw ^ 2) * double(converter[(i*2)+2])
        'py': poly = (temp_eng ^ 2) * double(converter[(i*2)+2])
        ''  : BREAK 
    ENDCASE 
ENDFOR 
temp_eng = temp_eng + poly
END 

PRO convert, raw, converter, eng
compile_opt strictarrsubs
CASE converter[0] OF 
    'formula'    : parse_formula, raw, converter, eng
    'formula1'   : parse_formula, raw, converter, eng
    ELSE         : break
ENDCASE
END 

PRO read_200, packet, hkcdf_id
compile_opt strictarrsubs
COMMON share1
COMMON com_hk
                                ; check checksum
temporary = packet.pkt
host_to_ieee, temporary
load_bytarr, temporary, bytarr
bytarr = [bytarr, packet.dat]
sum = total(bytarr)
IF sum MOD 256 NE 0 THEN BEGIN 
    timestamp = parse_stereo_pkt(packet, /PKT_DATE, /ccsds) ; /ccsds is for anytim2utc
    printf, hkerror_lun, 'Error with checksum, apid 200, time:', timestamp
ENDIF ELSE BEGIN 
    epoch = anytim2cdf(timestamp)
    cdf_varput, hkcdf_id, 'epoch_analog', epoch, rec_start = num_analog_cycles
    IF (abs(epoch-old_hk_epoch) GT 61000) $
      THEN BEGIN 
        old_timestamp = cdf2utc(old_hk_epoch, /ccsds)
        temp_string = timestamp+"  More than a minute between apids200: "+old_timestamp
        printf, hkerror_lun, temp_string
    ENDIF 
    old_hk_epoch = epoch
    value = fix(packet.dat[142-11+1])
    cdf_varput, hkcdf_id, 'block_id', value, rec_start = num_analog_cycles
    value = fix(packet.dat[143-11-1])
    cdf_varput, hkcdf_id, 'device_code', value, rec_start = num_analog_cycles
    FOR i = 0, 36 DO BEGIN ; lrnm_spare - ssd_vm
        tval1 = long(packet.dat[144-11+1+(i*2)])
        tval2 = ishft(long(packet.dat[145-11-1+(i*2)]), 8)
        value = tval1 OR tval2
        cdf_varput, hkcdf_id, hk_products_raw[i], value, rec_start = num_analog_cycles 
        IF (i EQ 27) AND (ishft(dighk_old_values[11], -7) EQ 0) AND (first_dighk EQ 0) THEN BEGIN ; esa_cm_dc not sweeping, checked lbc_logic_ctl_a
           convert, value, reform(hk_conversions[i, *]), value_eng
           cdf_varput, hkcdf_id, hk_products_eng[i], value_eng, rec_start = num_analog_cycles
           CASE 1 OF
              ((finite(esa_cm_dc_static_limits[0]) EQ 1) AND (value_eng LT esa_cm_dc_static_limits[0])): $
                  printf, hkerror_lun, timestamp, " Red limit: ", hk_products[i], " too low ", value_eng
              ((finite(esa_cm_dc_static_limits[1]) EQ 1) AND (value_eng LT esa_cm_dc_static_limits[1])): $
                 printf, hkerror_lun, timestamp, " Yellow limit: ", hk_products[i], " too low", value_eng
              ((finite(esa_cm_dc_static_limits[3]) EQ 1) AND (value_eng GT esa_cm_dc_static_limits[3])): $
                 printf, hkerror_lun, timestamp, " Red limit: ", hk_products[i], " too high", value_eng
              ((finite(esa_cm_dc_static_limits[2]) EQ 1) AND (value_eng GT esa_cm_dc_static_limits[2])): $
                 printf, hkerror_lun, timestamp, " Yellow limit: ", hk_products[i], " too high", value_eng
              ELSE: BREAK
           ENDCASE             
        ENDIF ELSE IF (i EQ 36) AND ((dighk_old_values[68] AND 0x1) EQ 0) THEN BEGIN               ; ssds are off
           printf, hkerror_lun, timestamp, " SSDs off"                                           ; just print once per minute
           convert, value, reform(hk_conversions[i, *]), value_eng
           cdf_varput, hkcdf_id, hk_products_eng[i], value_eng, rec_start = num_analog_cycles
        ENDIF ELSE IF (i NE 18) AND (i NE 21) THEN BEGIN ; pac_cm_ac, mcp_cm_ac
           convert, value, reform(hk_conversions[i, *]), value_eng
           cdf_varput, hkcdf_id, hk_products_eng[i], value_eng, rec_start = num_analog_cycles
           CASE 1 OF
              ((finite(hk_limits[i, 0]) EQ 1) AND (value_eng LT hk_limits[i, 0])): $
                 printf, hkerror_lun, timestamp, " Red limit: ", hk_products[i], " too low ", value_eng
              ((finite(hk_limits[i, 1]) EQ 1) AND (value_eng LT hk_limits[i, 1])): $
                 printf, hkerror_lun, timestamp, " Yellow limit: ", hk_products[i], " too low", value_eng
              ((finite(hk_limits[i, 3]) EQ 1) AND (value_eng GT hk_limits[i, 3])): $
                 printf, hkerror_lun, timestamp, " Red limit: ", hk_products[i], " too high", value_eng
              ((finite(hk_limits[i, 2]) EQ 1) AND (value_eng GT hk_limits[i, 2])): $
                 printf, hkerror_lun, timestamp, " Yellow limit: ", hk_products[i], " too high", value_eng
              ELSE: BREAK
           ENDCASE 
        ENDIF
     ENDFOR 
    FOR i = 0, 3 DO BEGIN       ; plug_id - adc_lu_ctr -- no conversions
       IF i MOD 2 EQ 0 THEN value = fix(packet.dat[218-11+1+i]) ELSE value = fix(packet.dat[218-11-1+i])
       cdf_varput, hkcdf_id, hk_products_raw[37+i], value, rec_start = num_analog_cycles
    ENDFOR 
    FOR i = 0, 15 DO BEGIN      ; adc0_agnd - adc1_vref
       IF i MOD 2 EQ 0 THEN value = fix(packet.dat[224-11+1+i]) ELSE value = fix(packet.dat[224-11-1+i])
       cdf_varput, hkcdf_id, hk_products_raw[41+i], value, rec_start = num_analog_cycles
       convert, value, reform(hk_conversions[(41+i), *]), value_eng
       cdf_varput, hkcdf_id, hk_products_eng[41+i], value_eng, rec_start = num_analog_cycles
       CASE 1 OF
          ((finite(hk_limits[(41+i), 0]) EQ 1) AND (value_eng LT hk_limits[(41+i), 0])): $
             printf, hkerror_lun, timestamp, " Red limit: ", hk_products[41+i], " too low ", value_eng
          ((finite(hk_limits[(41+i), 1]) EQ 1) AND (value_eng LT hk_limits[(41+i), 1])): $
             printf, hkerror_lun, timestamp, " Yellow limit: ", hk_products[41+i], " too low", value_eng
          ((finite(hk_limits[(41+i), 3]) EQ 1) AND (value_eng GT hk_limits[(41+i), 3])): $
             printf, hkerror_lun, timestamp, " Red limit: ", hk_products[41+i], " too high", value_eng
          ((finite(hk_limits[(41+i), 2]) EQ 1) AND (value_eng GT hk_limits[(41+i), 2])): $
             printf, hkerror_lun, timestamp, " Yellow limit: ", hk_products[41+i], " too high", value_eng
          ELSE: BREAK
       ENDCASE 
    ENDFOR 
    FOR i = 0, 7 DO BEGIN       ; ssd_status - ssd_v_pos_dig
        tval1 = long(packet.dat[240-11+1+(i*2)])
        tval2 = ishft(long(packet.dat[241-11-1+(i*2)]), 8)
        value = tval1 OR tval2
        IF i NE 0 THEN value = value AND '03FF'x ; just last 10 bits used
        cdf_varput, hkcdf_id, hk_products_raw[57+i], value, rec_start = num_analog_cycles
        IF ((i+57) NE 57) THEN BEGIN ; ssd_status
            convert, value, reform(hk_conversions[(57+i), *]), value_eng
            cdf_varput, hkcdf_id, hk_products_eng[57+i], value_eng, rec_start = num_analog_cycles
            past_limit = 0
            IF (dighk_old_values[68] AND 0x1) EQ 1 THEN BEGIN           ; ssds are on
               CASE 1 OF
                  ((finite(hk_limits[(57+i), 0]) EQ 1) AND (value_eng LT hk_limits[(57+i), 0])): BEGIN 
                     IF ssd_out_limits[i] GT 0 THEN printf, hkerror_lun, timestamp, " Red limit: ", hk_products[57+i], " too low ", value_eng
                     ssd_out_limits[i] = ssd_out_limits[i] + 1
                  END 
                  ((finite(hk_limits[(57+i), 1]) EQ 1) AND (value_eng LT hk_limits[(57+i), 1])): BEGIN 
                     IF ssd_out_limits[i] GT 0 THEN printf, hkerror_lun, timestamp, " Yellow limit: ", hk_products[57+i], " too low ", value_eng
                     ssd_out_limits[i] = ssd_out_limits[i] + 1
                  END 
                  ((finite(hk_limits[(57+i), 3]) EQ 1) AND (value_eng GT hk_limits[(57+i), 3])): BEGIN 
                     IF ssd_out_limits[i] GT 0 THEN printf, hkerror_lun, timestamp, " Red limit: ", hk_products[57+i], " too high ", value_eng
                     ssd_out_limits[i] = ssd_out_limits[i] + 1
                  END 
                  ((finite(hk_limits[(57+i), 2]) EQ 1) AND (value_eng GT hk_limits[(57+i), 2])): BEGIN 
                     IF ssd_out_limits[i] GT 0 THEN printf, hkerror_lun, timestamp, " Yellow limit: ", hk_products[57+i], " too high ", value_eng
                     ssd_out_limits[i] = ssd_out_limits[i] + 1
                  END 
                  ELSE: BEGIN   ; in limits
                     IF ssd_out_limits[i] EQ 1 THEN ssd_out_once[i] = ssd_out_once[i] + 1
                     ssd_out_limits[i] = 0
                  END 
               ENDCASE
            ENDIF 
         ENDIF
     ENDFOR 
    isc_status = fix(packet.dat[34-11+1])  ; spacecraft status
    value = ishft(isc_status, -3) AND '1'x ; bit 3 -- power_warning
    cdf_varput, hkcdf_id, hk_products_raw[65], value, rec_start = num_analog_cycles
    IF power_warning_old NE -1 AND power_warning_old NE value THEN $
      printf, hkerror_lun, timestamp, ": Change in Power Warning Bit From ", power_warning_old, " to ", value
    power_warning_old = value
    value = ishft(isc_status, -4) AND '1'x ; bit 4 -- thruster_warning
    cdf_varput, hkcdf_id, hk_products_raw[66], value, rec_start = num_analog_cycles
    IF thruster_warning_old NE -1 AND thruster_warning_old NE value THEN $
      printf, hkerror_lun, timestamp, ": Change in Thruster Warning Bit From ", thruster_warning_old, " to ", value
    thruster_warning_old = value
    value = ishft(isc_status, -5) AND '1'x ; bit 5 -- coarse_pointing
    cdf_varput, hkcdf_id, hk_products_raw[67], value, rec_start = num_analog_cycles
    IF coarse_pointing_old NE -1 AND coarse_pointing_old NE value THEN $
      printf, hkerror_lun, timestamp, ": Change in Coarse Pointing Bit From ", coarse_pointing_old, " to ", value
    coarse_pointing_old = value
    num_analog_cycles = num_analog_cycles + 1
ENDELSE 
END 
