; Lorna Ellis
; June 26, 2007
; ratio_harness.pro

; This is a harness program to calculate the s_valid/ra_trig ratios
; for the given days and to update the ratio files. Don't try to cross
; years using this!

PRO ratio_harness
compile_opt strictarrsubs

year = 2007
start_doy = 069
stop_doy = 255
spacecraft = 'B'
;cdfdir = '/Users/lornaellis/splat/splat_user/Input/2007/'
;cdfdir = '/mauidata1/Spacecraft_A/Level1/CDFs/2007/'
cdfdir = '/data1/Spacecraft_B/Level1/CDFs/2007/'
cdf_version = 9
;calib_dir = '~/Temp/'
calib_dir = '/usr/local/bin/ssw/stereo/plastic/data/calibrations/'

num_days = stop_doy - start_doy + 1
year_array = intarr(num_days)
year_array[*] = year
doy_array = intarr(num_days)
svalid_ratio_array = fltarr(32, num_days)
svalid_ratio_valid = intarr(num_days)
pri_ratio_array = fltarr(128, num_days)
pri_ratio_valid = intarr(num_days)
swpri_ratio_array = fltarr(128, num_days)
swpri_ratio_valid = intarr(num_days)

FOR ii = 0, num_days-1 DO BEGIN
    doy = start_doy+ii
    doy_array[ii] = doy
    doy_struct = doy2ex(doy, year)
    cdfname = 'ST'+spacecraft+'_L1_PLA_'+string(year, format = '(I4.4)')+string(doy_struct[5], format = '(I2.2)')+$
              string(doy_struct[4], format = '(I2.2)')+'_'+string(doy, format = '(I3.3)')+'_V'+string(cdf_version, format = '(I2.2)')
    cdfpath = cdfdir+cdfname
    ;calculate_svalid_ratrig_ratio, cdfpath, year, doy, svalid_ratio
    ;svalid_ratio_array[*, ii] = svalid_ratio
    ;svalid_ratio_valid[ii] = 1
    ;calculate_pri0_pri0_3_ratio, cdfpath, year, doy, pri_ratio
    ;pri_ratio_array[*, ii] = pri_ratio
    ;pri_ratio_valid[ii] = 1
    calculate_swpri_wapssdpri_ratio, cdfpath, year, doy, swpri_ratio
    swpri_ratio_array[*, ii] = swpri_ratio
    swpri_ratio_valid[ii] = 1
ENDFOR 

IF spacecraft EQ 'A' THEN sat_index = 0 ELSE sat_index = 1
;update_ratio_file, sat_index, calib_dir, year_array, doy_array, svalid_ratio_array, svalid_ratio_valid
;update_pri_ratio_file, sat_index, calib_dir, year_array, doy_array, pri_ratio_array, pri_ratio_valid
update_swpri_ratio, sat_index, calib_dir, year_array, doy_array, swpri_ratio_array, swpri_ratio_valid

END 
