; Lorna Ellis
; 3/14/2007
; plot_copy

; This looks in a directory that contains the output of the
; science_overview program. It deletes all .ps files. Then is
; transfers all the .png files to the appropriate directories. The
; assumption is that the directory structure will be something like:
; SciencePlots/A/0703/Classbins/.

; 05/24/2007 Changed to scp to fiji, and then delete

; parameters:
;    in:  tempplotpath : directory in which to look for plot files
;         finalplotpath: directory in which to put the plots (see
;                        structure above)

PRO plot_copy, tempplotpath, finalplotpath
compile_opt strictarrsubs

command = 'rm '+tempplotpath+'/*.ps'
spawn, command
temp_st = tempplotpath+'/*'
files_found = file_search(temp_st, count = num_files, /test_regular)
files_found = file_basename(files_found)
num_days = 0
IF num_files GT 0 THEN BEGIN ; ignore if no files there
    ; find spacecraft, year, and months needed 
    FOR ii = 0, num_files-1 DO BEGIN 
        file = files_found[ii]
        st_length = strlen(file)
        IF strmid(file, 0, 3) EQ 'hea' THEN BEGIN 
            sat = strmid(file, st_length-34, 1)            
            year_st = strmid(file, st_length-23, 2) ; just 07, or 08, etc
            month_st = strmid(file, st_length-21, 2)
        ENDIF ELSE BEGIN 
            IF strmid(file, 0, 3) EQ 'pro' THEN sat = strmid(file, st_length-35, 1) $
            ELSE sat = strmid(file, st_length-32, 1)            
            year_st = strmid(file, st_length-21, 2) ; just 07, or 08, etc
            month_st = strmid(file, st_length-19, 2)
        ENDELSE 
        IF num_days EQ 0 THEN BEGIN
            sats = [sat]
            years = [year_st]
            months = [month_st]
            num_days = 1
        ENDIF ELSE BEGIN 
            found = 0
            FOR jj = 0, n_elements(sats)-1 DO BEGIN 
                IF sat EQ sats[jj] AND year_st EQ years[jj] AND month_st EQ months[jj] THEN found = 1
            ENDFOR
            IF found EQ 0 THEN BEGIN 
                sats = [sats, sat]
                years = [years, year_st]
                months = [months, month_st]
                num_days = num_days + 1
            ENDIF 
        ENDELSE 
    ENDFOR 

    ; zip files
    FOR ii = 0, n_elements(sats)-1 DO BEGIN 
        FOR jj = 0, 10 DO BEGIN ; 11 kinds of plots
            CASE jj OF
                0: sub_dir = 'Classbins'
                1: sub_dir = 'Classpoints'
                2: sub_dir = 'Contour'
                3: sub_dir = 'Heavies'
                4: sub_dir = 'Hist_01y0'
                5: sub_dir = 'Hist_01n0'
                6: sub_dir = 'Hist_01'
                7: sub_dir = 'Hist_2'
                8: sub_dir = 'Hist_3'
                9: sub_dir = 'PhaPosTof'
                10: sub_dir = 'Protonmode'
            ENDCASE 
            CASE jj OF
                0: prefix = 'classbins_'
                1: prefix = 'classpoints_'
                2: prefix = 'contour_'
                3: prefix = 'heavies_'
                4: prefix = 'hist_0-1_y0_'
                5: prefix = 'hist_0-1_n0_'
                6: prefix = 'hist_0-1_'
                7: prefix = 'hist_2_'
                8: prefix = 'hist_3_'
                9: prefix = 'pha_pos_tof_'
                10: prefix = 'protonmode_'
            ENDCASE 
            command = 'scp '+tempplotpath+'/'+prefix+'ST'+sats[ii]+'*'+years[ii]+months[ii]+'* '+$
                      finalplotpath+'/'+sats[ii]+'/'+years[ii]+months[ii]+'/'+sub_dir+'/'
            spawn, command
        ENDFOR 
    ENDFOR
ENDIF 

command = 'rm '+tempplotpath+'/*.png'
spawn, command
END 
