;+
; Project     : STEREO - PLASTIC
;
; Name        : plastic_data_gaps
;
; Purpose     : Parse Level 0 PTP file, and check for data gaps
;
; Category    : Telemetry, Data-extraction
;
; Explanation : Takes a PLASTIC Level 0 data PTP file structure
;               as created by READ_STEREO_PKT, parese it, 
;
; History     : version 1, 5/12/06, LB Ellis, written
;
; Contact     : Lorna Ellis (Lorna.Ellis@unh.edu)
;-


PRO check_packet_counts, packet_counts, mode, recent_time_st, tlm_time_st, error_lun, temp_cycle, mode_change
compile_opt strictarrsubs
tab = STRING(9B)
;temp_st = '18:49'
;IF strcmp(strmid(tlm_time_st, 11, 5), temp_st) EQ 1 THEN stop
temp_mode = 3
dummy = where(packet_counts.apid317[8:47], apid317_temp_count)
IF (packet_counts.apid328[0] GT 0) OR (packet_counts.apid329[0] GT 0) THEN temp_mode = 1 $
ELSE IF apid317_temp_count NE 0 THEN temp_mode = 2 ELSE BEGIN 
        dummy = where(packet_counts.apid200[*], apid200_count)
        dummy = where(packet_counts.apid315[*], apid315_count)
        dummy = where(packet_counts.apid317[*], apid317_count)
        IF (temp_cycle EQ 4) OR (temp_cycle EQ 9) THEN BEGIN 
            dummy = where(packet_counts.apid316[*], apid316_count)
            dummy = where(packet_counts.apid319[*], apid319_count)
            dummy = where(packet_counts.apid31a[*], apid31a_count)
            dummy = where(packet_counts.apid31b[*], apid31b_count)
            dummy = where(packet_counts.apid31c[*], apid31c_count)
            dummy = where(packet_counts.apid31d[*], apid31d_count)
            dummy = where(packet_counts.apid31e[*], apid31e_count)
            dummy = where(packet_counts.apid31f[*], apid31f_count)
            dummy = where(packet_counts.apid321[*], apid321_count)
            dummy = where(packet_counts.apid322[*], apid322_count)
            dummy = where(packet_counts.apid323[*], apid323_count)
        ENDIF ELSE BEGIN 
            apid316_count = 0
            apid319_count = 0
            apid31a_count = 0
            apid31b_count = 0
            apid31c_count = 0
            apid31d_count = 0
            apid31e_count = 0
            apid31f_count = 0
            apid321_count = 0
            apid322_count = 0
            apid323_count = 0
        ENDELSE 
        IF (temp_cycle EQ 9) THEN dummy = where(packet_counts.apid320[*], apid320_count) ELSE apid320_count = 0
        dummy = where(packet_counts.apid324[*], apid324_count)
        dummy = where(packet_counts.apid325[*], apid325_count)
        dummy = where(packet_counts.apid326[*], apid326_count)
        dummy = where(packet_counts.apid327[*], apid327_count)
    CASE 1 OF 
        (apid317_count NE 0): temp_mode = 0  ; these are only in science mode
        (apid31a_count NE 0): temp_mode = 0
        (apid31b_count NE 0): temp_mode = 0
        (apid31c_count NE 0): temp_mode = 0
        (apid31d_count NE 0): temp_mode = 0
        (apid31e_count NE 0): temp_mode = 0
        (apid31f_count NE 0): temp_mode = 0
        (apid320_count NE 0): temp_mode = 0
        (apid324_count NE 0): temp_mode = 0
        (apid326_count NE 0): temp_mode = 0

        (apid200_count NE 0): temp_mode = 1 ; these are in proton and science mode
        (apid315_count NE 0): temp_mode = 1
        (apid316_count NE 0): temp_mode = 1
        (apid319_count NE 0): temp_mode = 1
        (apid321_count NE 0): temp_mode = 1
        (apid322_count NE 0): temp_mode = 1
        (apid323_count NE 0): temp_mode = 1
        (apid325_count NE 0): temp_mode = 1
        (apid327_count NE 0): temp_mode = 1
        ELSE: BREAK
    ENDCASE 
ENDELSE 

IF temp_mode NE mode THEN BEGIN 
    temp_cycle = -10
    mode_change = 1
    CASE temp_mode OF 
        0: error_st = '    Mode Change to Science Mode '
        1: error_st = '    Mode Change to Proton Mode '
        2: error_st = '    Mode Change to Engineering Mode '
        3: error_st = '    Mode Change to Non-Science Mode '
    ENDCASE 
    CASE mode OF 
        -1:error_st = error_st+'from Unknown Mode'+tab+tlm_time_st+tab+recent_time_st
        0: error_st = error_st+'from Science Mode'+tab+tlm_time_st+tab+recent_time_st
        1: error_st = error_st+'from Proton Mode'+tab+tlm_time_st+tab+recent_time_st
        2: error_st = error_st+'from Engineering Mode'+tab+tlm_time_st+tab+recent_time_st
        3: error_st = error_st+'from Non-Science Mode'+tab+tlm_time_st+tab+recent_time_st
    ENDCASE 
    printf, error_lun, error_st
    mode = temp_mode
ENDIF ELSE mode_change = 0

CASE mode OF 
    0: BEGIN                    ; science
        ;IF packet_counts.apid200[0] NE 1 THEN BEGIN
         ;   error_st = 'ERROR (Science): Wrong number of apid200 packets: '+string(packet_counts.apid200[0], format = '(I2)')+$
          ;             tab+tlm_time_st+tab+recent_time_st
           ; printf, error_lun, error_st
        ;ENDIF 
        IF packet_counts.apid313[0] NE 1 THEN BEGIN
            error_st = 'ERROR (Science): Wrong number of apid313 packets: '+string(packet_counts.apid313[0], format = '(I2)')+$
                       tab+tlm_time_st+tab+recent_time_st
            printf, error_lun, error_st
        ENDIF 
        FOR i = 0, 16 DO BEGIN 
            IF packet_counts.apid315[i] NE 1 THEN BEGIN
                error_st = 'ERROR (Science): Wrong number of apid315 seq '+string(i, format = '(I2)')+' packets: '+$ 
                           string(packet_counts.apid315[i], format = '(I2)')+tab+tlm_time_st+tab+recent_time_st
                printf, error_lun, error_st
            ENDIF 
        ENDFOR 
        IF (temp_cycle EQ 4) OR (temp_cycle EQ 9) THEN BEGIN 
            FOR i = 0, 31 DO BEGIN 
                IF packet_counts.apid316[i] NE 1 THEN BEGIN
                    error_st = 'ERROR (Science): Wrong number of apid316 seq '+string(i, format = '(I2)')+' packets: '+$ 
                               string(packet_counts.apid316[i], format = '(I2)')+tab+tlm_time_st+tab+recent_time_st
                    printf, error_lun, error_st
                ENDIF 
            ENDFOR 
        ENDIF 
        FOR i = 0, 7 DO BEGIN 
            IF packet_counts.apid317[i] NE 1 THEN BEGIN
                error_st = 'ERROR (Science): Wrong number of apid317 seq '+string(i, format = '(I2)')+' packets: '+$ 
                           string(packet_counts.apid317[i], format = '(I2)')+tab+tlm_time_st+tab+recent_time_st
                printf, error_lun, error_st
            ENDIF 
        ENDFOR 
        FOR i = 8, 47 DO BEGIN 
            IF packet_counts.apid317[i] NE 0 THEN BEGIN
                error_st = 'ERROR (Science): Wrong number of apid317 seq '+string(i, format = '(I2)')+' packets: '+$ 
                           string(packet_counts.apid317[i], format = '(I2)')+tab+tlm_time_st+tab+recent_time_st
                printf, error_lun, error_st
            ENDIF 
        ENDFOR 
        IF (temp_cycle EQ 4) OR (temp_cycle EQ 9) THEN BEGIN 
            FOR i = 0, 4 DO BEGIN 
                IF packet_counts.apid319[i] NE 1 THEN BEGIN
                    error_st = 'ERROR (Science): Wrong number of apid319 seq '+string(i, format = '(I2)')+' packets: '+$ 
                               string(packet_counts.apid319[i], format = '(I2)')+tab+tlm_time_st+tab+recent_time_st
                    printf, error_lun, error_st
                ENDIF 
            ENDFOR 
            FOR i = 0, 31 DO BEGIN 
                IF packet_counts.apid31a[i] NE 1 THEN BEGIN
                    error_st = 'ERROR (Science): Wrong number of apid31a seq '+string(i, format = '(I2)')+' packets: '+$ 
                               string(packet_counts.apid31a[i], format = '(I2)')+tab+tlm_time_st+tab+recent_time_st
                    printf, error_lun, error_st
                ENDIF 
            ENDFOR 
            FOR i = 0, 31 DO BEGIN 
                IF packet_counts.apid31b[i] NE 1 THEN BEGIN
                    error_st = 'ERROR (Science): Wrong number of apid31b seq '+string(i, format = '(I2)')+' packets: '+$ 
                               string(packet_counts.apid31b[i], format = '(I2)')+tab+tlm_time_st+tab+recent_time_st
                    printf, error_lun, error_st
                ENDIF 
            ENDFOR 
            FOR i = 0, 31 DO BEGIN 
                IF packet_counts.apid31c[i] NE 1 THEN BEGIN
                    error_st = 'ERROR (Science): Wrong number of apid31c seq '+string(i, format = '(I2)')+' packets: '+$ 
                               string(packet_counts.apid31c[i], format = '(I2)')+tab+tlm_time_st+tab+recent_time_st
                    printf, error_lun, error_st
                ENDIF 
            ENDFOR 
            FOR i = 0, 19 DO BEGIN 
                IF packet_counts.apid31d[i] NE 1 THEN BEGIN
                    error_st = 'ERROR (Science): Wrong number of apid31d seq '+string(i, format = '(I2)')+' packets: '+$ 
                               string(packet_counts.apid31d[i], format = '(I2)')+tab+tlm_time_st+tab+recent_time_st
                    printf, error_lun, error_st
                ENDIF 
            ENDFOR 
            FOR i = 0, 29 DO BEGIN 
                IF packet_counts.apid31e[i] NE 1 THEN BEGIN
                    error_st = 'ERROR (Science): Wrong number of apid31e seq '+string(i, format = '(I2)')+' packets: '+$ 
                               string(packet_counts.apid31e[i], format = '(I2)')+tab+tlm_time_st+tab+recent_time_st
                    printf, error_lun, error_st
                ENDIF 
            ENDFOR 
            FOR i = 0, 13 DO BEGIN 
                IF packet_counts.apid31f[i] NE 1 THEN BEGIN
                    error_st = 'ERROR (Science): Wrong number of apid31f seq '+string(i, format = '(I2)')+' packets: '+$ 
                               string(packet_counts.apid31f[i], format = '(I2)')+tab+tlm_time_st+tab+recent_time_st
                    printf, error_lun, error_st
                ENDIF 
            ENDFOR 
        ENDIF 
        IF (temp_cycle EQ 9) THEN BEGIN 
            FOR i = 0, 27 DO BEGIN 
                IF packet_counts.apid320[i] NE 1 THEN BEGIN
                    error_st = 'ERROR (Science): Wrong number of apid320 seq '+string(i, format = '(I2)')+' packets: '+$ 
                               string(packet_counts.apid320[i], format = '(I2)')+tab+tlm_time_st+tab+recent_time_st
                    printf, error_lun, error_st
                ENDIF 
            ENDFOR 
        ENDIF 
        IF (temp_cycle EQ 4) OR (temp_cycle EQ 9) THEN BEGIN 
            FOR i = 0, 31 DO BEGIN 
                IF packet_counts.apid321[i] NE 1 THEN BEGIN
                    error_st = 'ERROR (Science): Wrong number of apid321 seq '+string(i, format = '(I2)')+' packets: '+$ 
                               string(packet_counts.apid321[i], format = '(I2)')+tab+tlm_time_st+tab+recent_time_st
                    printf, error_lun, error_st
                ENDIF 
            ENDFOR 
            IF packet_counts.apid322[0] NE 1 THEN BEGIN
                error_st = 'ERROR (Science): Wrong number of apid322 packets: '+$
                           string(packet_counts.apid322[0], format = '(I2)')+$
                           tab+tlm_time_st+tab+recent_time_st
                printf, error_lun, error_st
            ENDIF 
            IF packet_counts.apid323[0] NE 1 THEN BEGIN
                error_st = 'ERROR (Science): Wrong number of apid323 packets: '+$
                           string(packet_counts.apid323[0], format = '(I2)')+$
                           tab+tlm_time_st+tab+recent_time_st
                printf, error_lun, error_st
            ENDIF 
        ENDIF 
        FOR i = 0, 4 DO BEGIN 
            IF packet_counts.apid324[i] NE 1 THEN BEGIN
                error_st = 'ERROR (Science): Wrong number of apid324 seq '+string(i, format = '(I2)')+' packets: '+$ 
                           string(packet_counts.apid324[i], format = '(I2)')+tab+tlm_time_st+tab+recent_time_st
                printf, error_lun, error_st
            ENDIF 
        ENDFOR 
        FOR i = 0, 2 DO BEGIN  
            IF packet_counts.apid325[i] NE 1 THEN BEGIN
                error_st = 'ERROR (Science): Wrong number of apid325 seq '+string(i, format = '(I2)')+' packets: '+$ 
                           string(packet_counts.apid325[i], format = '(I2)')+tab+tlm_time_st+tab+recent_time_st
                printf, error_lun, error_st
            ENDIF 
        ENDFOR 
        FOR i = 0, 2 DO BEGIN 
            IF packet_counts.apid326[i] NE 1 THEN BEGIN
                error_st = 'ERROR (Science): Wrong number of apid326 seq '+string(i, format = '(I2)')+' packets: '+$ 
                           string(packet_counts.apid326[i], format = '(I2)')+tab+tlm_time_st+tab+recent_time_st
                printf, error_lun, error_st
            ENDIF 
        ENDFOR 
        FOR i = 0, 2 DO BEGIN 
            IF packet_counts.apid327[i] NE 1 THEN BEGIN
                error_st = 'ERROR (Science): Wrong number of apid327 seq '+string(i, format = '(I2)')+' packets: '+$ 
                           string(packet_counts.apid327[i], format = '(I2)')+tab+tlm_time_st+tab+recent_time_st
                printf, error_lun, error_st
            ENDIF 
        ENDFOR 
        IF packet_counts.apid328[0] NE 0 THEN BEGIN
            error_st = 'ERROR (Science): Wrong number of apid328 packets: '+string(packet_counts.apid328[0], format = '(I2)')+$
                       tab+tlm_time_st+tab+recent_time_st
            printf, error_lun, error_st
        ENDIF 
        IF packet_counts.apid329[0] NE 0 THEN BEGIN
            error_st = 'ERROR (Science): Wrong number of apid329 packets: '+string(packet_counts.apid329[0], format = '(I2)')+$
                       tab+tlm_time_st+tab+recent_time_st
            printf, error_lun, error_st
        ENDIF 
        IF packet_counts.apid370[0] NE 1 THEN BEGIN
            error_st = 'ERROR (Science): Wrong number of apid370 packets: '+string(packet_counts.apid370[0], format = '(I2)')+$
                       tab+tlm_time_st+tab+recent_time_st
            printf, error_lun, error_st
        ENDIF 
    END 
    1: BEGIN                    ; proton
        ;IF packet_counts.apid200[0] NE 1 THEN BEGIN
         ;   error_st = 'ERROR (Proton): Wrong number of apid200 packets: '+string(packet_counts.apid200[0], format = '(I2)')+tab+$ 
          ;             tlm_time_st+tab+recent_time_st
           ; printf, error_lun, error_st
        ;ENDIF 
        IF packet_counts.apid313[0] NE 1 THEN BEGIN
            error_st = 'ERROR (Proton): Wrong number of apid313 packets: '+string(packet_counts.apid313[0], format = '(I2)')+tab+$ 
                       tlm_time_st+tab+recent_time_st
            printf, error_lun, error_st
        ENDIF 
        FOR i = 0, 16 DO BEGIN 
            IF packet_counts.apid315[i] NE 1 THEN BEGIN
                error_st = 'ERROR (Proton): Wrong number of apid315 seq '+string(i, format = '(I2)')+' packets: '+$ 
                           string(packet_counts.apid315[i], format = '(I2)')+tab+tlm_time_st+tab+recent_time_st
                printf, error_lun, error_st
            ENDIF 
        ENDFOR 
        IF (temp_cycle EQ 4) OR (temp_cycle EQ 9) THEN BEGIN 
            FOR i = 0, 31 DO BEGIN 
                IF packet_counts.apid316[i] NE 1 THEN BEGIN
                    error_st = 'ERROR (Proton): Wrong number of apid316 seq '+string(i, format = '(I2)')+' packets: '+$ 
                               string(packet_counts.apid316[i], format = '(I2)')+tab+tlm_time_st+tab+recent_time_st
                    printf, error_lun, error_st
                ENDIF 
            ENDFOR 
        ENDIF 
        FOR i = 0, 47 DO BEGIN 
            IF packet_counts.apid317[i] NE 0 THEN BEGIN
                error_st = 'ERROR (Proton): Wrong number of apid317 seq '+string(i, format = '(I2)')+' packets: '+$ 
                           string(packet_counts.apid317[i], format = '(I2)')+tab+tlm_time_st+tab+recent_time_st
                printf, error_lun, error_st
            ENDIF 
        ENDFOR 
        IF (temp_cycle EQ 4) OR (temp_cycle EQ 9) THEN BEGIN 
            FOR i = 0, 4 DO BEGIN 
                IF packet_counts.apid319[i] NE 1 THEN BEGIN
                    error_st = 'ERROR (Proton): Wrong number of apid319 seq '+string(i, format = '(I2)')+' packets: '+$ 
                               string(packet_counts.apid319[i], format = '(I2)')+tab+tlm_time_st+tab+recent_time_st
                    printf, error_lun, error_st
                ENDIF 
            ENDFOR 
            FOR i = 0, 31 DO BEGIN 
                IF packet_counts.apid31a[i] NE 0 THEN BEGIN
                    error_st = 'ERROR (Proton): Wrong number of apid31a seq '+string(i, format = '(I2)')+' packets: '+$ 
                               string(packet_counts.apid31a[i], format = '(I2)')+tab+tlm_time_st+tab+recent_time_st
                    printf, error_lun, error_st
                ENDIF 
            ENDFOR 
            FOR i = 0, 31 DO BEGIN 
                IF packet_counts.apid31b[i] NE 0 THEN BEGIN
                    error_st = 'ERROR (Proton): Wrong number of apid31b seq '+string(i, format = '(I2)')+' packets: '+$ 
                               string(packet_counts.apid31b[i], format = '(I2)')+tab+tlm_time_st+tab+recent_time_st
                    printf, error_lun, error_st
                ENDIF 
            ENDFOR 
            FOR i = 0, 31 DO BEGIN 
                IF packet_counts.apid31c[i] NE 0 THEN BEGIN
                    error_st = 'ERROR (Proton): Wrong number of apid31c seq '+string(i, format = '(I2)')+' packets: '+$ 
                               string(packet_counts.apid31c[i], format = '(I2)')+tab+tlm_time_st+tab+recent_time_st
                    printf, error_lun, error_st
                ENDIF 
            ENDFOR 
            FOR i = 0, 19 DO BEGIN 
                IF packet_counts.apid31d[i] NE 0 THEN BEGIN
                    error_st = 'ERROR (Proton): Wrong number of apid31d seq '+string(i, format = '(I2)')+' packets: '+$ 
                               string(packet_counts.apid31d[i], format = '(I2)')+tab+tlm_time_st+tab+recent_time_st
                    printf, error_lun, error_st
                ENDIF 
            ENDFOR 
            FOR i = 0, 29 DO BEGIN 
                IF packet_counts.apid31e[i] NE 0 THEN BEGIN
                    error_st = 'ERROR (Proton): Wrong number of apid31e seq '+string(i, format = '(I2)')+' packets: '+$ 
                               string(packet_counts.apid31e[i], format = '(I2)')+tab+tlm_time_st+tab+recent_time_st
                    printf, error_lun, error_st
                ENDIF 
            ENDFOR 
            FOR i = 0, 13 DO BEGIN 
                IF packet_counts.apid31f[i] NE 0 THEN BEGIN
                    error_st = 'ERROR (Proton): Wrong number of apid31f seq '+string(i, format = '(I2)')+' packets: '+$ 
                               string(packet_counts.apid31f[i], format = '(I2)')+tab+tlm_time_st+tab+recent_time_st
                    printf, error_lun, error_st
                ENDIF 
            ENDFOR 
            FOR i = 0, 27 DO BEGIN 
                IF packet_counts.apid320[i] NE 0 THEN BEGIN
                    error_st = 'ERROR (Proton): Wrong number of apid320 seq '+string(i, format = '(I2)')+' packets: '+$ 
                               string(packet_counts.apid320[i], format = '(I2)')+tab+tlm_time_st+tab+recent_time_st
                    printf, error_lun, error_st
                ENDIF 
            ENDFOR 
            FOR i = 0, 31 DO BEGIN 
                IF packet_counts.apid321[i] NE 1 THEN BEGIN
                    error_st = 'ERROR (Proton): Wrong number of apid321 seq '+string(i, format = '(I2)')+' packets: '+$ 
                               string(packet_counts.apid321[i], format = '(I2)')+tab+tlm_time_st+tab+recent_time_st
                    printf, error_lun, error_st
                ENDIF 
            ENDFOR 
            IF packet_counts.apid322[0] NE 1 THEN BEGIN
                error_st = 'ERROR (Proton): Wrong number of apid322 packets: '+$
                           string(packet_counts.apid322[0], format = '(I2)')+tab+$ 
                           tlm_time_st+tab+recent_time_st
                printf, error_lun, error_st
            ENDIF 
            IF packet_counts.apid323[0] NE 1 THEN BEGIN
                error_st = 'ERROR (Proton): Wrong number of apid323 packets: '+$
                           string(packet_counts.apid323[0], format = '(I2)')+tab+$ 
                           tlm_time_st+tab+recent_time_st
                printf, error_lun, error_st
            ENDIF 
        ENDIF 
        FOR i = 0, 4 DO BEGIN 
            IF packet_counts.apid324[i] NE 0 THEN BEGIN
                error_st = 'ERROR (Proton): Wrong number of apid324 seq '+string(i, format = '(I2)')+' packets: '+$ 
                           string(packet_counts.apid324[i], format = '(I2)')+tab+tlm_time_st+tab+recent_time_st
                printf, error_lun, error_st
            ENDIF 
        ENDFOR 
        FOR i = 0, 2 DO BEGIN  
            IF packet_counts.apid325[i] NE 1 THEN BEGIN
                error_st = 'ERROR (Proton): Wrong number of apid325 seq '+string(i, format = '(I2)')+' packets: '+$ 
                           string(packet_counts.apid325[i], format = '(I2)')+tab+tlm_time_st+tab+recent_time_st
                printf, error_lun, error_st
            ENDIF 
        ENDFOR 
        FOR i = 0, 2 DO BEGIN 
            IF packet_counts.apid326[i] NE 0 THEN BEGIN
                error_st = 'ERROR (Proton): Wrong number of apid326 seq '+string(i, format = '(I2)')+' packets: '+$ 
                           string(packet_counts.apid326[i], format = '(I2)')+tab+tlm_time_st+tab+recent_time_st
                printf, error_lun, error_st
            ENDIF 
        ENDFOR 
        FOR i = 0, 2 DO BEGIN 
            IF packet_counts.apid327[i] NE 1 THEN BEGIN
                error_st = 'ERROR (Proton): Wrong number of apid327 seq '+string(i, format = '(I2)')+' packets: '+$ 
                           string(packet_counts.apid327[i], format = '(I2)')+tab+tlm_time_st+tab+recent_time_st
                printf, error_lun, error_st
            ENDIF 
        ENDFOR 
        IF packet_counts.apid370[0] NE 1 THEN BEGIN
            error_st = 'ERROR (Proton): Wrong number of apid370 packets: '+string(packet_counts.apid370[0], format = '(I2)')+tab+$ 
                       tlm_time_st+tab+recent_time_st
            printf, error_lun, error_st
        ENDIF 
    END 
    2: BEGIN                    ; engineering mode
;        IF packet_counts.apid200[0] NE 1 THEN BEGIN
 ;           error_st = 'ERROR (Eng): Wrong number of apid200 packets: '+string(packet_counts.apid200[0], format = '(I2)')+tab+$ 
  ;                     tlm_time_st+tab+recent_time_st
   ;         printf, error_lun, error_st
    ;    ENDIF 
        IF packet_counts.apid313[0] NE 1 THEN BEGIN
            error_st = 'ERROR (Eng): Wrong number of apid313 packets: '+string(packet_counts.apid313[0], format = '(I2)')+tab+$ 
                       tlm_time_st+tab+recent_time_st
            printf, error_lun, error_st
        ENDIF 
        FOR i = 0, 16 DO BEGIN 
            IF packet_counts.apid315[i] NE 0 THEN BEGIN
                error_st = 'ERROR (Eng): Wrong number of apid315 seq '+string(i, format = '(I2)')+' packets: '+$ 
                           string(packet_counts.apid315[i], format = '(I2)')+tab+tlm_time_st+tab+recent_time_st
                printf, error_lun, error_st
            ENDIF 
        ENDFOR 
        FOR i = 0, 31 DO BEGIN 
            IF packet_counts.apid316[i] NE 1 THEN BEGIN
                error_st = 'ERROR (Eng): Wrong number of apid316 seq '+string(i, format = '(I2)')+' packets: '+$ 
                           string(packet_counts.apid316[i], format = '(I2)')+tab+tlm_time_st+tab+recent_time_st
                printf, error_lun, error_st
            ENDIF 
        ENDFOR 
        FOR i = 0, 47 DO BEGIN 
            IF packet_counts.apid317[i] NE 1 THEN BEGIN
                error_st = 'ERROR (Eng): Wrong number of apid317 seq '+string(i, format = '(I2)')+' packets: '+$ 
                           string(packet_counts.apid317[i], format = '(I2)')+tab+tlm_time_st+tab+recent_time_st
                printf, error_lun, error_st
            ENDIF 
        ENDFOR 
        FOR i = 0, 4 DO BEGIN 
            IF packet_counts.apid319[i] NE 0 THEN BEGIN
                error_st = 'ERROR (Eng): Wrong number of apid319 seq '+string(i, format = '(I2)')+' packets: '+$ 
                           string(packet_counts.apid319[i], format = '(I2)')+tab+tlm_time_st+tab+recent_time_st
                printf, error_lun, error_st
            ENDIF 
        ENDFOR 
        FOR i = 0, 31 DO BEGIN 
            IF packet_counts.apid31a[i] NE 0 THEN BEGIN
                error_st = 'ERROR (Eng): Wrong number of apid31a seq '+string(i, format = '(I2)')+' packets: '+$ 
                           string(packet_counts.apid31a[i], format = '(I2)')+tab+tlm_time_st+tab+recent_time_st
                printf, error_lun, error_st
            ENDIF 
        ENDFOR 
        FOR i = 0, 31 DO BEGIN 
            IF packet_counts.apid31b[i] NE 0 THEN BEGIN
                error_st = 'ERROR (Eng): Wrong number of apid31b seq '+string(i, format = '(I2)')+' packets: '+$ 
                           string(packet_counts.apid31b[i], format = '(I2)')+tab+tlm_time_st+tab+recent_time_st
                printf, error_lun, error_st
            ENDIF 
        ENDFOR 
        FOR i = 0, 31 DO BEGIN 
            IF packet_counts.apid31c[i] NE 0 THEN BEGIN
                error_st = 'ERROR (Eng): Wrong number of apid31c seq '+string(i, format = '(I2)')+' packets: '+$ 
                           string(packet_counts.apid31c[i], format = '(I2)')+tab+tlm_time_st+tab+recent_time_st
                printf, error_lun, error_st
            ENDIF 
        ENDFOR 
        FOR i = 0, 19 DO BEGIN 
            IF packet_counts.apid31d[i] NE 0 THEN BEGIN
                error_st = 'ERROR (Eng): Wrong number of apid31d seq '+string(i, format = '(I2)')+' packets: '+$ 
                           string(packet_counts.apid31d[i], format = '(I2)')+tab+tlm_time_st+tab+recent_time_st
                printf, error_lun, error_st
            ENDIF 
        ENDFOR 
        FOR i = 0, 29 DO BEGIN 
            IF packet_counts.apid31e[i] NE 0 THEN BEGIN
                error_st = 'ERROR (Eng): Wrong number of apid31e seq '+string(i, format = '(I2)')+' packets: '+$ 
                           string(packet_counts.apid31e[i], format = '(I2)')+tab+tlm_time_st+tab+recent_time_st
                printf, error_lun, error_st
            ENDIF 
        ENDFOR 
        FOR i = 0, 13 DO BEGIN 
            IF packet_counts.apid31f[i] NE 0 THEN BEGIN
                error_st = 'ERROR (Eng): Wrong number of apid31f seq '+string(i, format = '(I2)')+' packets: '+$ 
                           string(packet_counts.apid31f[i], format = '(I2)')+tab+tlm_time_st+tab+recent_time_st
                printf, error_lun, error_st
            ENDIF 
        ENDFOR 
        FOR i = 0, 27 DO BEGIN 
            IF packet_counts.apid320[i] NE 0 THEN BEGIN
                error_st = 'ERROR (Eng): Wrong number of apid320 seq '+string(i, format = '(I2)')+' packets: '+$ 
                           string(packet_counts.apid320[i], format = '(I2)')+tab+tlm_time_st+tab+recent_time_st
                printf, error_lun, error_st
            ENDIF 
        ENDFOR 
        FOR i = 0, 31 DO BEGIN 
            IF packet_counts.apid321[i] NE 0 THEN BEGIN
                error_st = 'ERROR (Eng): Wrong number of apid321 seq '+string(i, format = '(I2)')+' packets: '+$ 
                           string(packet_counts.apid321[i], format = '(I2)')+tab+tlm_time_st+tab+recent_time_st
                printf, error_lun, error_st
            ENDIF 
        ENDFOR 
        IF packet_counts.apid322[0] NE 0 THEN BEGIN
            error_st = 'ERROR (Eng): Wrong number of apid322 packets: '+string(packet_counts.apid322[0], format = '(I2)')+tab+$ 
                       tlm_time_st+tab+recent_time_st
            printf, error_lun, error_st
        ENDIF 
        IF packet_counts.apid323[0] NE 0 THEN BEGIN
            error_st = 'ERROR (Eng): Wrong number of apid323 packets: '+string(packet_counts.apid323[0], format = '(I2)')+tab+$ 
                       tlm_time_st+tab+recent_time_st
            printf, error_lun, error_st
        ENDIF 
        FOR i = 0, 4 DO BEGIN 
            IF packet_counts.apid324[i] NE 0 THEN BEGIN
                error_st = 'ERROR (Eng): Wrong number of apid324 seq '+string(i, format = '(I2)')+' packets: '+$ 
                           string(packet_counts.apid324[i], format = '(I2)')+tab+tlm_time_st+tab+recent_time_st
                printf, error_lun, error_st
            ENDIF 
        ENDFOR 
        FOR i = 0, 2 DO BEGIN  
            IF packet_counts.apid325[i] NE 0 THEN BEGIN
                error_st = 'ERROR (Eng): Wrong number of apid325 seq '+string(i, format = '(I2)')+' packets: '+$ 
                           string(packet_counts.apid325[i], format = '(I2)')+tab+tlm_time_st+tab+recent_time_st
                printf, error_lun, error_st
            ENDIF 
        ENDFOR 
        FOR i = 0, 2 DO BEGIN 
            IF packet_counts.apid326[i] NE 0 THEN BEGIN
                error_st = 'ERROR (Eng): Wrong number of apid326 seq '+string(i, format = '(I2)')+' packets: '+$ 
                           string(packet_counts.apid326[i], format = '(I2)')+tab+tlm_time_st+tab+recent_time_st
                printf, error_lun, error_st
            ENDIF 
        ENDFOR 
        FOR i = 0, 2 DO BEGIN 
            IF packet_counts.apid327[i] NE 0 THEN BEGIN
                error_st = 'ERROR (Eng): Wrong number of apid327 seq '+string(i, format = '(I2)')+' packets: '+$ 
                           string(packet_counts.apid327[i], format = '(I2)')+tab+tlm_time_st+tab+recent_time_st
                printf, error_lun, error_st
            ENDIF 
        ENDFOR 
        IF packet_counts.apid328[0] NE 0 THEN BEGIN
            error_st = 'ERROR (Eng): Wrong number of apid328 packets: '+string(packet_counts.apid328[0], format = '(I2)')+tab+$ 
                       tlm_time_st+tab+recent_time_st
            printf, error_lun, error_st
        ENDIF 
        IF packet_counts.apid329[0] NE 0 THEN BEGIN
            error_st = 'ERROR (Eng): Wrong number of apid329 packets: '+string(packet_counts.apid329[0], format = '(I2)')+tab+$ 
                       tlm_time_st+tab+recent_time_st
            printf, error_lun, error_st
        ENDIF 
        IF packet_counts.apid370[0] NE 1 THEN BEGIN
            error_st = 'ERROR (Eng): Wrong number of apid370 packets: '+string(packet_counts.apid370[0], format = '(I2)')+tab+$ 
                       tlm_time_st+tab+recent_time_st
            printf, error_lun, error_st
        ENDIF 
    END
    ELSE: BREAK
ENDCASE 
END 


PRO zero_packet_counts, packet_counts, temp_cycle, mode, mode_change
compile_opt strictarrsubs

packet_counts.apid200[*] = 0
packet_counts.apid313[*] = 0
packet_counts.apid315[*] = 0
IF (mode EQ 2) OR (mode EQ 3) OR (mode_change EQ 1) THEN packet_counts.apid316[*] = 0 ; eng mode
IF ((mode EQ 0) OR (mode EQ 1)) AND ((temp_cycle EQ 4) OR (temp_cycle EQ 9)) THEN packet_counts.apid316[*] = 0
packet_counts.apid317[*] = 0
IF (temp_cycle EQ 4) OR (temp_cycle EQ 9) OR (mode_change EQ 1) THEN BEGIN 
    packet_counts.apid319[*] = 0
    packet_counts.apid31a[*] = 0
    packet_counts.apid31b[*] = 0
    packet_counts.apid31c[*] = 0
    packet_counts.apid31d[*] = 0
    packet_counts.apid31e[*] = 0
    packet_counts.apid31f[*] = 0
    packet_counts.apid321[*] = 0
    packet_counts.apid322[*] = 0
    packet_counts.apid323[*] = 0
ENDIF 
IF (temp_cycle EQ 9) OR (mode_change EQ 1) THEN packet_counts.apid320[*] = 0
packet_counts.apid324[*] = 0
packet_counts.apid325[*] = 0
packet_counts.apid326[*] = 0
packet_counts.apid327[*] = 0
packet_counts.apid328[*] = 0
packet_counts.apid329[*] = 0
packet_counts.apid370[*] = 0

IF (temp_cycle EQ 9) THEN temp_cycle = 0 ELSE $
  IF (mode EQ -1) OR (mode EQ 2) OR (mode EQ 3) THEN temp_cycle = -10 ELSE temp_cycle = temp_cycle + 1

END 


PRO plastic_data_gaps, infilename = infilename, infilepath=infilepath, outfilepath = outfilepath
compile_opt strictarrsubs
tab = STRING(9B)

version = "V01"
infilepath = '/Users/lornaellis/Lorna/Files/CPT/'
outfilepath = 'Output'

IF n_elements(infilename) EQ 1 THEN BEGIN 
    temp = strmid(infilename, 7, 1)
    IF temp[0] EQ 'a' THEN BEGIN ; 'ahead'
        spacecraft = 'ahead'
        year_st = strmid(infilename, 13, 4)
        doy_st = strmid(infilename, 18, 3)
    ENDIF ELSE BEGIN 
        spacecraft = 'behind'
        year_st = strmid(infilename, 14, 4)
        doy_st = strmid(infilename, 19, 3)
    ENDELSE 
ENDIF ELSE BEGIN 
    spacecraft = 'behind'
    year_st = '2006'
    doy_st = '312'
ENDELSE 
infilename = 'B0606161919.tlm'

year = fix(year_st)
doy = fix(doy_st)
if n_elements(infilepath) eq 1 then infile = concat_dir(infilepath, infilename) ELSE infile = infilename
openr, in_lun, infile, /get_lun

IF spacecraft EQ 'ahead' THEN temp_spacecraft = 'A' ELSE temp_spacecraft = 'B'
IF year LT 2001 OR year GT 2999 THEN print, "Error: invalid year", year
time_utc = doy2utc(doy, year)
time_st = utc2str(time_utc)
month_st = strmid(time_st, 5, 2)
day_st = strmid(time_st, 8, 2)
outfileprefix = 'ST'+temp_spacecraft+'_L1_PLA_'+doy_st+'_'+year_st+month_st+day_st+'_'+version
if n_elements(outfilepath) eq 1 then outfileprefix = concat_dir(outfilepath, outfileprefix)
errorfilename = outfileprefix+'.errors'
totalfilename = outfileprefix+'.total'
openw, error_lun, errorfilename, /get_lun
openw, total_lun, totalfilename, /get_lun
printf, total_lun, 'GRH Time'+tab+'Tlm Time'+tab+'Apid'+tab+'Sequence'
printf, error_lun, 'Comment'+tab+'New_Time'+tab+'Old_Time'+tab+'Current_Apid'+tab+'Sequence'

; loop through data
packet = 0
recent_time = -1
apid200_time = -1
apid313_time = -1
apid315_time = -1
apid316_time = -1
apid317_time = -1
apid319_time = -1
apid31a_time = -1
apid31b_time = -1
apid31c_time = -1
apid31d_time = -1
apid31e_time = -1
apid31f_time = -1
apid320_time = -1
apid321_time = -1
apid322_time = -1
apid323_time = -1
apid324_time = -1
apid325_time = -1
apid326_time = -1
apid327_time = -1
apid328_time = -1
apid329_time = -1
apid370_time = -1
apid315_seq = -1 ; 18 packets
apid316_seq = -1 ; 32 packets
apid317_seq = -1 ; 8 packets (science mode); 48 packets (eng mode)
apid319_seq = -1 ; 5 packets
apid31a_seq = -1 ; 32 packets
apid31b_seq = -1 ; 32 packets
apid31c_seq = -1 ; 32 packets
apid31d_seq = -1 ; 20 packets
apid31e_seq = -1 ; 30 packets
apid31f_seq = -1 ; 14 packets
apid320_seq = -1 ; 28 packets
apid321_seq = -1 ; 32 packets
apid324_seq = -1 ; 5 packets
apid325_seq = -1 ; 3 packets
apid326_seq = -1 ; 3 packets
apid327_seq = -1 ; 3 packets
apid319_cycle = -1 
temp_cycle = -10 ; used to count to 9 to only reset and check heavies every 5 cycles (set properly by apid 319 and 320)
mode = -1  ; 0=science, 1=proton, 2=engineering, 3=other
packet_counts = {apid200:intarr(1), apid313:intarr(1), apid315:intarr(18), apid316:intarr(32), apid317:intarr(48), apid319:intarr(5), apid31a:intarr(32), apid31b:intarr(32), apid31c:intarr(32), apid31d:intarr(20), apid31e:intarr(30), apid31f:intarr(14), apid320:intarr(28), apid321:intarr(32), apid322:intarr(1), apid323:intarr(1), apid324:intarr(5), apid325:intarr(3), apid326:intarr(5), apid327:intarr(5), apid328:intarr(1), apid329:intarr(1), apid370:intarr(1)}

WHILE n_elements(packet) NE 0 DO BEGIN
    read_stereo_pkt, in_lun, packet
    IF n_elements(packet) NE 0 THEN BEGIN 
        apid = parse_stereo_pkt(packet, /APID)
        apid_st = string(apid, format = '(Z4.3)')
        tlm_time = parse_stereo_pkt(packet, /PKT_DATE)
        tlm_sec = utc2sec(tlm_time)
        grh_time_st = parse_stereo_pkt(packet, /grh_DATE, /CCSDS) ; /ccsds is for anytim2utc
        tlm_time_st = parse_stereo_pkt(packet, /PKT_DATE, /CCSDS) ; /ccsds is for anytim2utc
        IF n_tags(recent_time) EQ  0 THEN recent_time = tlm_time ; structure would have tags
        recent_sec = utc2sec(recent_time)
        recent_time_st = utc2str(recent_time)
        total_st = grh_time_st+tab+tlm_time_st+tab+apid_st
        IF tlm_sec LT recent_sec THEN BEGIN 
            error_st = 'ERROR: Time went backward'+tab+tlm_time_st+tab+recent_time_st+tab+apid_st+tab
            ;printf, error_lun, error_st
        ENDIF 
        CASE apid OF 
            '200'x: BEGIN
                IF n_tags(apid200_time) NE 0 THEN BEGIN ; skip if first apid200 packet
                    apid200_sec = utc2sec(apid200_time)
                    IF ((tlm_sec - apid200_sec) GT 65) AND ((mode EQ 0) OR (mode EQ 1) OR (mode EQ 2)) THEN BEGIN
                        apid200_time_st = utc2str(apid200_time)
                        error_st = 'Gap'+tab+tlm_time_st+tab+apid200_time_st+tab+apid_st
                        ;printf, error_lun, error_st
                        mode = -1
                    ENDIF 
                    IF tlm_sec EQ apid200_sec THEN BEGIN 
                        apid200_time_st = utc2str(apid200_time)
                        error_st = 'ERROR: Duplicate time'+tab+tlm_time_st+tab+apid200_time_st+tab+apid_st
                        printf, error_lun, error_st
                    ENDIF 
                ENDIF 
                packet_counts.apid200[0] = packet_counts.apid200[0] + 1
                apid200_time = tlm_time
            END 
            '313'x: BEGIN
                IF n_tags(apid313_time) NE 0 THEN BEGIN ; skip if first apid313 packet
                    apid313_sec = utc2sec(apid313_time)
                    IF ((tlm_sec - apid313_sec) GT 65) AND (mode NE 3) THEN BEGIN
                        apid313_time_st = utc2str(apid313_time)
                        error_st = '  Gap'+tab+tlm_time_st+tab+apid313_time_st+tab+apid_st
                        printf, error_lun, error_st
                        mode = -1
                    ENDIF 
                    IF tlm_sec EQ apid313_sec THEN BEGIN 
                        apid313_time_st = utc2str(apid313_time)
                        error_st = 'ERROR: Duplicate time'+tab+tlm_time_st+tab+apid313_time_st+tab+apid_st
                        printf, error_lun, error_st
                    ENDIF 
                ENDIF 
                packet_counts.apid313[0] = packet_counts.apid313[0] + 1
                check_packet_counts, packet_counts, mode, recent_time_st, tlm_time_st, error_lun, temp_cycle, mode_change
                zero_packet_counts, packet_counts, temp_cycle, mode, mode_change
                apid313_time = tlm_time
            END 
            '315'x: BEGIN  ; in science and proton mode
                seq = packet.dat[0]
                total_st = total_st+tab+string(seq, format = '(I2)')
                IF n_tags(apid315_time) NE 0 THEN BEGIN ; skip if first apid315 packet
                    apid315_sec = utc2sec(apid315_time)
                    IF ((tlm_sec - apid315_sec) GT 65) AND (mode NE 3) AND (mode NE 2) THEN BEGIN
                        apid315_time_st = utc2str(apid315_time)
                        error_st = 'Gap'+tab+tlm_time_st+tab+apid315_time_st+tab+apid_st
                        ;printf, error_lun, error_st
                        mode = -1
                    ENDIF 
                    IF (tlm_sec EQ apid315_sec) AND (seq EQ apid315_seq) THEN BEGIN 
                        apid315_time_st = utc2str(apid315_time)
                        error_st = 'ERROR: Duplicate time'+tab+tlm_time_st+tab+apid315_time_st+tab+apid_st+tab+$
                                   string(seq, format = '(I2)')
                        printf, error_lun, error_st
                    ENDIF 
                ENDIF 
                packet_counts.apid315[seq] = packet_counts.apid315[seq] + 1
                apid315_seq = seq
                apid315_time = tlm_time
            END 
            '316'x: BEGIN  ; every minute in eng mode, every 5 minutes in science and proton mode
                ;temporary = packet.pkt
                ;host_to_ieee, temporary
                ;load_bytarr, temporary, bytarr
                ;bytarr = [bytarr, packet.dat]
                ;seq = bytarr[10+1] ; put in header part
                seq = packet.dat[0]
                total_st = total_st+tab+string(seq, format = '(I2)')
;                tmp_st1 = '20:13:32'
 ;               tmp_st2 = '21:00:32'
  ;              IF (strcmp(strmid(tlm_time_st, 11, 8), tmp_st1) EQ 1) OR (strcmp(strmid(tlm_time_st, 11, 8), tmp_st1) EQ 1) THEN BEGIN 
   ;                 FOR i = 0, 260 DO BEGIN
    ;                    total_st = total_st+' '+string(packet.dat[i], format = '(Z2.2)')
     ;               ENDFOR 
      ;          ENDIF 
                IF n_tags(apid316_time) NE 0 THEN BEGIN ; skip if first apid316 packet
                    apid316_sec = utc2sec(apid316_time)
                    IF ((tlm_sec - apid316_sec) GT 65) AND (mode NE 3) AND (mode EQ 2) THEN BEGIN
                        apid316_time_st = utc2str(apid316_time)
                        error_st = 'Gap'+tab+tlm_time_st+tab+apid316_time_st+tab+apid_st
                        ;printf, error_lun, error_st
                        mode = -1
                    ENDIF 
                    IF ((tlm_sec - apid316_sec) GT 305) AND (mode NE 3) AND ((mode EQ 0) OR (mode EQ 1)) THEN BEGIN
                        apid316_time_st = utc2str(apid316_time)
                        error_st = 'Gap'+tab+tlm_time_st+tab+apid316_time_st+tab+apid_st
                        ;printf, error_lun, error_st
                        mode = -1
                    ENDIF 
                    IF (tlm_sec EQ apid316_sec) AND (seq EQ apid316_seq) THEN BEGIN 
                        apid316_time_st = utc2str(apid316_time)
                        error_st = 'ERROR: Duplicate time'+tab+tlm_time_st+tab+apid316_time_st+tab+apid_st+tab+$
                                   string(seq, format = '(I2)')
                        printf, error_lun, error_st
                    ENDIF 
                    IF seq LT 32 THEN packet_counts.apid316[seq] = packet_counts.apid316[seq] + 1 ELSE BEGIN 
                        apid316_time_st = utc2str(apid316_time)
                        error_st = 'ERROR: Invalid seq'+tab+tlm_time_st+tab+apid316_time_st+tab+apid_st+tab+$
                                   string(seq, format = '(I2)')
                        printf, error_lun, error_st
                    ENDELSE 
                ENDIF 
                apid316_seq = seq
                apid316_time = tlm_time
            END 
            '317'x: BEGIN  ; science and eng mode
                ;temporary = packet.pkt
                ;host_to_ieee, temporary
                ;load_bytarr, temporary, bytarr
                ;bytarr = [bytarr, packet.dat]
                ;seq = bytarr[10] ; put in header part
                seq = packet.dat[0]
                tlm_packet_seq = parse_stereo_pkt(packet, /seq_count)
                total_st = total_st+tab+string(seq, format = '(I2)')+tab+string(tlm_packet_seq, format = '(I5)')+tab
                ;FOR i = 0, 260 DO BEGIN
                 ;   total_st = total_st+string(packet.dat[i], format = '(Z2.2)')+' '
                ;ENDFOR 
                IF n_tags(apid317_time) NE 0 THEN BEGIN ; skip if first apid317 packet
                    apid317_sec = utc2sec(apid317_time)
                    IF ((tlm_sec - apid317_sec) GT 65) AND (mode NE 3) AND (mode NE 1) THEN BEGIN
                        apid317_time_st = utc2str(apid317_time)
                        error_st = 'Gap'+tab+tlm_time_st+tab+apid317_time_st+tab+apid_st
                        ;printf, error_lun, error_st
                        ;mode = -1
                    ENDIF 
                    IF (tlm_sec EQ apid317_sec) AND (seq EQ apid317_seq) THEN BEGIN 
                        apid317_time_st = utc2str(apid317_time)
                        error_st = 'ERROR: Duplicate time'+tab+tlm_time_st+tab+apid317_time_st+tab+apid_st+tab+$
                                   string(seq, format = '(I2)')
                        printf, error_lun, error_st
                    ENDIF 
                ENDIF 
                packet_counts.apid317[seq] = packet_counts.apid317[seq] + 1
                apid317_seq = seq
                apid317_time = tlm_time
            END 
            '319'x: BEGIN  ; every 5 minutes in science and proton mode
                seq = packet.dat[0] 
                total_st = total_st+tab+string(seq, format = '(I2)')
                IF seq EQ 0 THEN BEGIN 
                    cycle = packet.dat[4-1]
                    IF (apid319_cycle NE -1) AND (cycle NE apid319_cycle + 5) THEN BEGIN
                        error_st = '319 Cycle Gap ('+string(apid319_cycle, format = '(I3)')+', '+string(cycle, format = '(I3)')+$
                                   ')'+tab+tlm_time_st+tab_apid319_time_st+tab+apid_st
                        printf, error_lun, error_st
                    ENDIF 
                ENDIF 
                IF n_tags(apid319_time) NE 0 THEN BEGIN ; skip if first apid319 packet
                    apid319_sec = utc2sec(apid319_time)
                    IF ((tlm_sec - apid319_sec) GT 305) AND (mode NE 3) AND (mode NE 2) THEN BEGIN
                        apid319_time_st = utc2str(apid319_time)
                        error_st = 'Gap'+tab+tlm_time_st+tab+apid319_time_st+tab+apid_st
                        ;printf, error_lun, error_st
                        mode = -1
                    ENDIF 
                    IF (tlm_sec EQ apid319_sec) AND (seq EQ apid319_seq) THEN BEGIN 
                        apid319_time_st = utc2str(apid319_time)
                        error_st = 'ERROR: Duplicate time'+tab+tlm_time_st+tab+apid319_time_st+tab+apid_st+tab+$
                                   string(seq, format = '(I2)')
                        printf, error_lun, error_st
                    ENDIF 
                ENDIF 
                packet_counts.apid319[seq] = packet_counts.apid319[seq] + 1
                apid319_seq = seq
                apid319_time = tlm_time
                temp_cycle = 4
            END 
            '31a'x: BEGIN  ; every 5 minutes in science
                seq = packet.dat[0] 
                total_st = total_st+tab+string(seq, format = '(I2)')
                IF seq EQ 0 THEN BEGIN 
                    cycle = packet.dat[2-1]
                    IF (apid319_cycle NE -1) AND (cycle NE apid319_cycle) THEN BEGIN
                        error_st = '31a Cycle Problem ('+string(apid319_cycle, format = '(I3)')+', '+string(cycle, format = '(I3)')+$
                                   ')'+tab+tlm_time_st+tab_apid31a_time_st+tab+apid_st
                        printf, error_lun, error_st
                    ENDIF 
                ENDIF 
                IF n_tags(apid31a_time) NE 0 THEN BEGIN ; skip if first apid31a packet
                    apid31a_sec = utc2sec(apid31a_time)
                    IF ((tlm_sec - apid31a_sec) GT 305) AND (mode NE 3) AND (mode NE 2) AND (mode NE 1) THEN BEGIN
                        apid31a_time_st = utc2str(apid31a_time)
                        error_st = 'Gap'+tab+tlm_time_st+tab+apid31a_time_st+tab+apid_st
                        ;printf, error_lun, error_st
                        mode = -1
                    ENDIF 
                    IF (tlm_sec EQ apid31a_sec) AND (seq EQ apid31a_seq) THEN BEGIN 
                        apid31a_time_st = utc2str(apid31a_time)
                        error_st = 'ERROR: Duplicate time'+tab+tlm_time_st+tab+apid31a_time_st+tab+apid_st+tab+$
                                   string(seq, format = '(I2)')
                        printf, error_lun, error_st
                    ENDIF 
                ENDIF 
                packet_counts.apid31a[seq] = packet_counts.apid31a[seq] + 1
                apid31a_seq = seq
                apid31a_time = tlm_time
            END 
            '31b'x: BEGIN  ; every 5 minutes in science
                seq = packet.dat[0] 
                total_st = total_st+tab+string(seq, format = '(I2)')
                IF seq EQ 0 THEN BEGIN 
                    cycle = packet.dat[2-1]
                    IF (apid319_cycle NE -1) AND (cycle NE apid319_cycle) THEN BEGIN
                        error_st = '31b Cycle Problem ('+string(apid319_cycle, format = '(I3)')+', '+string(cycle, format = '(I3)')+$
                                   ')'+tab+tlm_time_st+tab_apid31b_time_st+tab+apid_st
                        printf, error_lun, error_st
                    ENDIF 
                ENDIF 
                IF n_tags(apid31b_time) NE 0 THEN BEGIN ; skip if first apid31b packet
                    apid31b_sec = utc2sec(apid31b_time)
                    IF ((tlm_sec - apid31b_sec) GT 305) AND (mode NE 3) AND (mode NE 2) AND (mode NE 1) THEN BEGIN
                        apid31b_time_st = utc2str(apid31b_time)
                        error_st = 'Gap'+tab+tlm_time_st+tab+apid31b_time_st+tab+apid_st
                        ;printf, error_lun, error_st
                        mode = -1
                    ENDIF 
                    IF (tlm_sec EQ apid31b_sec) AND (seq EQ apid31b_seq) THEN BEGIN 
                        apid31b_time_st = utc2str(apid31b_time)
                        error_st = 'ERROR: Duplicate time'+tab+tlm_time_st+tab+apid31b_time_st+tab+apid_st+tab+$
                                   string(seq, format = '(I2)')
                        printf, error_lun, error_st
                    ENDIF 
                ENDIF 
                packet_counts.apid31b[seq] = packet_counts.apid31b[seq] + 1
                apid31b_seq = seq
                apid31b_time = tlm_time
            END 
            '31c'x: BEGIN  ; every 5 minutes in science
                seq = packet.dat[0] 
                total_st = total_st+tab+string(seq, format = '(I2)')
                IF seq EQ 0 THEN BEGIN 
                    cycle = packet.dat[2-1]
                    IF (apid319_cycle NE -1) AND (cycle NE apid319_cycle) THEN BEGIN
                        error_st = '31c Cycle Problem ('+string(apid319_cycle, format = '(I3)')+', '+string(cycle, format = '(I3)')+$
                                   ')'+tab+tlm_time_st+tab_apid31c_time_st+tab+apid_st
                        printf, error_lun, error_st
                    ENDIF 
                ENDIF 
                IF n_tags(apid31c_time) NE 0 THEN BEGIN ; skip if first apid31c packet
                    apid31c_sec = utc2sec(apid31c_time)
                    IF ((tlm_sec - apid31c_sec) GT 305) AND (mode NE 3) AND (mode NE 2) AND (mode NE 1) THEN BEGIN
                        apid31c_time_st = utc2str(apid31c_time)
                        error_st = 'Gap'+tab+tlm_time_st+tab+apid31c_time_st+tab+apid_st
                        ;printf, error_lun, error_st
                        mode = -1
                    ENDIF 
                    IF (tlm_sec EQ apid31c_sec) AND (seq EQ apid31c_seq) THEN BEGIN 
                        apid31c_time_st = utc2str(apid31c_time)
                        error_st = 'ERROR: Duplicate time'+tab+tlm_time_st+tab+apid31c_time_st+tab+apid_st+tab+$
                                   string(seq, format = '(I2)')
                        printf, error_lun, error_st
                    ENDIF 
                ENDIF 
                packet_counts.apid31c[seq] = packet_counts.apid31c[seq] + 1
                apid31c_seq = seq
                apid31c_time = tlm_time
            END 
            '31d'x: BEGIN  ; every 5 minutes in science
                seq = packet.dat[0] 
                total_st = total_st+tab+string(seq, format = '(I2)')
                IF seq EQ 0 THEN BEGIN 
                    cycle = packet.dat[2-1]
                    IF (apid319_cycle NE -1) AND (cycle NE apid319_cycle) THEN BEGIN
                        error_st = '31d Cycle Problem ('+string(apid319_cycle, format = '(I3)')+', '+string(cycle, format = '(I3)')+$
                                   ')'+tab+tlm_time_st+tab_apid31d_time_st+tab+apid_st
                        printf, error_lun, error_st
                    ENDIF 
                ENDIF 
                IF n_tags(apid31d_time) NE 0 THEN BEGIN ; skip if first apid31d packet
                    apid31d_sec = utc2sec(apid31d_time)
                    IF ((tlm_sec - apid31d_sec) GT 305) AND (mode NE 3) AND (mode NE 2) AND (mode NE 1) THEN BEGIN
                        apid31d_time_st = utc2str(apid31d_time)
                        error_st = 'Gap'+tab+tlm_time_st+tab+apid31d_time_st+tab+apid_st
                        ;printf, error_lun, error_st
                        mode = -1
                    ENDIF 
                    IF (tlm_sec EQ apid31d_sec) AND (seq EQ apid31d_seq) THEN BEGIN 
                        apid31d_time_st = utc2str(apid31d_time)
                        error_st = 'ERROR: Duplicate time'+tab+tlm_time_st+tab+apid31d_time_st+tab+apid_st+tab+$
                                   string(seq, format = '(I2)')
                        printf, error_lun, error_st
                    ENDIF 
                ENDIF 
                packet_counts.apid31d[seq] = packet_counts.apid31d[seq] + 1
                apid31d_seq = seq
                apid31d_time = tlm_time
            END 
            '31e'x: BEGIN  ; every 5 minutes in science
                seq = packet.dat[0] 
                total_st = total_st+tab+string(seq, format = '(I2)')
                IF seq EQ 0 THEN BEGIN 
                    cycle = packet.dat[2-1]
                    IF (apid319_cycle NE -1) AND (cycle NE apid319_cycle) THEN BEGIN
                        error_st = '31e Cycle Problem ('+string(apid319_cycle, format = '(I3)')+', '+string(cycle, format = '(I3)')+$
                                   ')'+tab+tlm_time_st+tab_apid31e_time_st+tab+apid_st
                        printf, error_lun, error_st
                    ENDIF 
                ENDIF 
                IF n_tags(apid31e_time) NE 0 THEN BEGIN ; skip if first apid31e packet
                    apid31e_sec = utc2sec(apid31e_time)
                    IF ((tlm_sec - apid31e_sec) GT 305) AND (mode NE 3) AND (mode NE 2) AND (mode NE 1) THEN BEGIN
                        apid31e_time_st = utc2str(apid31e_time)
                        error_st = 'Gap'+tab+tlm_time_st+tab+apid31e_time_st+tab+apid_st
                        ;printf, error_lun, error_st
                        mode = -1
                    ENDIF 
                    IF (tlm_sec EQ apid31e_sec) AND (seq EQ apid31e_seq) THEN BEGIN 
                        apid31e_time_st = utc2str(apid31e_time)
                        error_st = 'ERROR: Duplicate time'+tab+tlm_time_st+tab+apid31e_time_st+tab+apid_st+tab+$
                                   string(seq, format = '(I2)')
                        printf, error_lun, error_st
                    ENDIF 
                ENDIF 
                packet_counts.apid31e[seq] = packet_counts.apid31e[seq] + 1
                apid31e_seq = seq
                apid31e_time = tlm_time
            END 
            '31f'x: BEGIN  ; every 5 minutes in science
                seq = packet.dat[0] 
                total_st = total_st+tab+string(seq, format = '(I2)')
                IF seq EQ 0 THEN BEGIN 
                    cycle = packet.dat[2-1]
                    IF (apid319_cycle NE -1) AND (cycle NE apid319_cycle) THEN BEGIN
                        error_st = '31f Cycle Problem ('+string(apid319_cycle, format = '(I3)')+', '+string(cycle, format = '(I3)')+$
                                   ')'+tab+tlm_time_st+tab_apid31f_time_st+tab+apid_st
                        printf, error_lun, error_st
                    ENDIF 
                ENDIF 
                IF n_tags(apid31f_time) NE 0 THEN BEGIN ; skip if first apid31f packet
                    apid31f_sec = utc2sec(apid31f_time)
                    IF ((tlm_sec - apid31f_sec) GT 305) AND (mode NE 3) AND (mode NE 2) AND (mode NE 1) THEN BEGIN
                        apid31f_time_st = utc2str(apid31f_time)
                        error_st = 'Gap'+tab+tlm_time_st+tab+apid31f_time_st+tab+apid_st
                        ;printf, error_lun, error_st
                        mode = -1
                    ENDIF 
                    IF (tlm_sec EQ apid31f_sec) AND (seq EQ apid31f_seq) THEN BEGIN 
                        apid31f_time_st = utc2str(apid31f_time)
                        error_st = 'ERROR: Duplicate time'+tab+tlm_time_st+tab+apid31f_time_st+tab+apid_st+tab+$
                                   string(seq, format = '(I2)')
                        printf, error_lun, error_st
                    ENDIF 
                ENDIF 
                packet_counts.apid31f[seq] = packet_counts.apid31f[seq] + 1
                apid31f_seq = seq
                apid31f_time = tlm_time
            END 
            '320'x: BEGIN  ; every 5 minutes in science
                seq = packet.dat[0] 
                total_st = total_st+tab+string(seq, format = '(I2)')
                IF seq EQ 0 THEN BEGIN 
                    cycle = packet.dat[2-1]
                    IF (apid319_cycle NE -1) AND (cycle NE apid319_cycle-5) THEN BEGIN
                        error_st = '320 Cycle Problem ('+string(apid319_cycle, format = '(I3)')+', '+string(cycle, format = '(I3)')+$
                                   ')'+tab+tlm_time_st+tab_apid320_time_st+tab+apid_st
                        printf, error_lun, error_st
                    ENDIF 
                ENDIF 
                IF n_tags(apid320_time) NE 0 THEN BEGIN ; skip if first apid320 packet
                    apid320_sec = utc2sec(apid320_time)
                    IF ((tlm_sec - apid320_sec) GT 605) AND (mode NE 3) AND (mode NE 2) AND (mode NE 1) THEN BEGIN
                        apid320_time_st = utc2str(apid320_time)
                        error_st = 'Gap'+tab+tlm_time_st+tab+apid320_time_st+tab+apid_st
                        ;printf, error_lun, error_st
                        mode = -1
                    ENDIF 
                    IF (tlm_sec EQ apid320_sec) AND (seq EQ apid320_seq) THEN BEGIN 
                        apid320_time_st = utc2str(apid320_time)
                        error_st = 'ERROR: Duplicate time'+tab+tlm_time_st+tab+apid320_time_st+tab+apid_st+tab+$
                                   string(seq, format = '(I2)')
                        printf, error_lun, error_st
                    ENDIF 
                ENDIF 
                packet_counts.apid320[seq] = packet_counts.apid320[seq] + 1
                apid320_seq = seq
                apid320_time = tlm_time
                temp_cycle = 9
            END 
            '321'x: BEGIN  ; every 5 minutes in science and proton
                seq = packet.dat[0] 
                total_st = total_st+tab+string(seq, format = '(I2)')
                IF seq EQ 0 THEN BEGIN 
                    cycle = packet.dat[2-1]
                    IF (apid319_cycle NE -1) AND (cycle NE apid319_cycle) THEN BEGIN
                        error_st = '321 Cycle Problem ('+string(apid319_cycle, format = '(I3)')+', '+$
                                   string(cycle, format = '(I3)')+$
                                   ')'+tab+tlm_time_st+tab_apid321_time_st+tab+apid_st
                        printf, error_lun, error_st
                    ENDIF 
                ENDIF 
                IF n_tags(apid321_time) NE 0 THEN BEGIN ; skip if first apid321 packet
                    apid321_sec = utc2sec(apid321_time)
                    IF ((tlm_sec - apid321_sec) GT 305) AND (mode NE 3) AND (mode NE 2) THEN BEGIN
                        apid321_time_st = utc2str(apid321_time)
                        error_st = 'Gap'+tab+tlm_time_st+tab+apid321_time_st+tab+apid_st
                        ;printf, error_lun, error_st
                        mode = -1
                    ENDIF 
                    IF (tlm_sec EQ apid321_sec) AND (seq EQ apid321_seq) THEN BEGIN 
                        apid321_time_st = utc2str(apid321_time)
                        error_st = 'ERROR: Duplicate time'+tab+tlm_time_st+tab+apid321_time_st+tab+apid_st+tab+$
                                   string(seq, format = '(I2)')
                        printf, error_lun, error_st
                    ENDIF 
                ENDIF 
                packet_counts.apid321[seq] = packet_counts.apid321[seq] + 1
                apid321_seq = seq
                apid321_time = tlm_time
            END 
            '322'x: BEGIN  ; every 5 minutes in science and proton
                seq = packet.dat[0] 
                total_st = total_st+tab+string(seq, format = '(I2)')
                IF seq EQ 0 THEN BEGIN 
                    cycle = packet.dat[2-1]
                    IF (apid319_cycle NE -1) AND (cycle NE apid319_cycle) THEN BEGIN
                        error_st = '322 Cycle Problem ('+string(apid319_cycle, format = '(I3)')+', '+string(cycle, format = '(I3)')+$
                                   ')'+tab+tlm_time_st+tab_apid322_time_st+tab+apid_st
                        printf, error_lun, error_st
                    ENDIF 
                ENDIF 
                IF n_tags(apid322_time) NE 0 THEN BEGIN ; skip if first apid322 packet
                    apid322_sec = utc2sec(apid322_time)
                    IF ((tlm_sec - apid322_sec) GT 305) AND (mode NE 3) AND (mode NE 2) THEN BEGIN
                        apid322_time_st = utc2str(apid322_time)
                        error_st = 'Gap'+tab+tlm_time_st+tab+apid322_time_st+tab+apid_st
                        ;printf, error_lun, error_st
                        mode = -1
                    ENDIF 
                    IF (tlm_sec EQ apid322_sec) AND (seq EQ apid322_seq) THEN BEGIN 
                        apid322_time_st = utc2str(apid322_time)
                        error_st = 'ERROR: Duplicate time'+tab+tlm_time_st+tab+apid322_time_st+tab+apid_st+tab+$
                                   string(seq, format = '(I2)')
                        printf, error_lun, error_st
                    ENDIF 
                ENDIF 
                packet_counts.apid322[seq] = packet_counts.apid322[seq] + 1
                apid322_seq = seq
                apid322_time = tlm_time
            END 
            '323'x: BEGIN  ; every 5 minutes in science and proton
                seq = packet.dat[0] 
                total_st = total_st+tab+string(seq, format = '(I2)')
                IF seq EQ 0 THEN BEGIN 
                    cycle = packet.dat[2-1]
                    IF (apid319_cycle NE -1) AND (cycle NE apid319_cycle) THEN BEGIN
                        error_st = '323 Cycle Problem ('+string(apid319_cycle, format = '(I3)')+', '+string(cycle, format = '(I3)')+$
                                   ')'+tab+tlm_time_st+tab_apid323_time_st+tab+apid_st
                        printf, error_lun, error_st
                    ENDIF 
                ENDIF 
                IF n_tags(apid323_time) NE 0 THEN BEGIN ; skip if first apid323 packet
                    apid323_sec = utc2sec(apid323_time)
                    IF ((tlm_sec - apid323_sec) GT 305) AND (mode NE 3) AND (mode NE 2) THEN BEGIN
                        apid323_time_st = utc2str(apid323_time)
                        error_st = 'Gap'+tab+tlm_time_st+tab+apid323_time_st+tab+apid_st
                        ;printf, error_lun, error_st
                        mode = -1
                    ENDIF 
                    IF (tlm_sec EQ apid323_sec) AND (seq EQ apid323_seq) THEN BEGIN 
                        apid323_time_st = utc2str(apid323_time)
                        error_st = 'ERROR: Duplicate time'+tab+tlm_time_st+tab+apid323_time_st+tab+apid_st+tab+$
                                   string(seq, format = '(I2)')
                        printf, error_lun, error_st
                    ENDIF 
                ENDIF 
                packet_counts.apid323[seq] = packet_counts.apid323[seq] + 1
                apid323_seq = seq
                apid323_time = tlm_time
            END 
            '324'x: BEGIN  ; in science mode
                seq = packet.dat[0]
                total_st = total_st+tab+string(seq, format = '(I2)')
                IF n_tags(apid324_time) NE 0 THEN BEGIN ; skip if first apid324 packet
                    apid324_sec = utc2sec(apid324_time)
                    IF ((tlm_sec - apid324_sec) GT 65) AND (mode NE 3) AND (mode NE 2) AND (mode NE 1) THEN BEGIN
                        apid324_time_st = utc2str(apid324_time)
                        error_st = 'Gap'+tab+tlm_time_st+tab+apid324_time_st+tab+apid_st
                        ;printf, error_lun, error_st
                        mode = -1
                    ENDIF 
                    IF (tlm_sec EQ apid324_sec) AND (seq EQ apid324_seq) THEN BEGIN 
                        apid324_time_st = utc2str(apid324_time)
                        error_st = 'ERROR: Duplicate time'+tab+tlm_time_st+tab+apid324_time_st+tab+apid_st+tab+$
                                   string(seq, format = '(I2)')
                        printf, error_lun, error_st
                    ENDIF 
                ENDIF 
                packet_counts.apid324[seq] = packet_counts.apid324[seq] + 1
                apid324_seq = seq
                apid324_time = tlm_time
            END 
            '325'x: BEGIN  ; in science and proton mode
                seq = packet.dat[0]
                total_st = total_st+tab+string(seq, format = '(I2)')
                IF n_tags(apid325_time) NE 0 THEN BEGIN ; skip if first apid325 packet
                    apid325_sec = utc2sec(apid325_time)
                    IF ((tlm_sec - apid325_sec) GT 65) AND (mode NE 3) AND (mode NE 2) THEN BEGIN
                        apid325_time_st = utc2str(apid325_time)
                        error_st = 'Gap'+tab+tlm_time_st+tab+apid325_time_st+tab+apid_st
                        ;printf, error_lun, error_st
                        mode = -1
                    ENDIF 
                    IF (tlm_sec EQ apid325_sec) AND (seq EQ apid325_seq) THEN BEGIN 
                        apid325_time_st = utc2str(apid325_time)
                        error_st = 'ERROR: Duplicate time'+tab+tlm_time_st+tab+apid325_time_st+tab+apid_st+tab+$
                                   string(seq, format = '(I2)')
                        printf, error_lun, error_st
                    ENDIF 
                ENDIF 
                packet_counts.apid325[seq] = packet_counts.apid325[seq] + 1
                apid325_seq = seq
                apid325_time = tlm_time
            END 
            '326'x: BEGIN  ; in science mode
                seq = packet.dat[0]
                total_st = total_st+tab+string(seq, format = '(I2)')
                IF n_tags(apid326_time) NE 0 THEN BEGIN ; skip if first apid326 packet
                    apid326_sec = utc2sec(apid326_time)
                    IF ((tlm_sec - apid326_sec) GT 65) AND (mode NE 3) AND (mode NE 2) AND (mode NE 1) THEN BEGIN
                        apid326_time_st = utc2str(apid326_time)
                        error_st = 'Gap'+tab+tlm_time_st+tab+apid326_time_st+tab+apid_st
                        ;printf, error_lun, error_st
                        mode = -1
                    ENDIF 
                    IF (tlm_sec EQ apid326_sec) AND (seq EQ apid326_seq) THEN BEGIN 
                        apid326_time_st = utc2str(apid326_time)
                        error_st = 'ERROR: Duplicate time'+tab+tlm_time_st+tab+apid326_time_st+tab+apid_st+tab+$
                                   string(seq, format = '(I2)')
                        printf, error_lun, error_st
                    ENDIF 
                ENDIF 
                packet_counts.apid326[seq] = packet_counts.apid326[seq] + 1
                apid326_seq = seq
                apid326_time = tlm_time
            END 
            '327'x: BEGIN  ; in science and proton mode
                seq = packet.dat[0]
                total_st = total_st+tab+string(seq, format = '(I2)')
                IF n_tags(apid327_time) NE 0 THEN BEGIN ; skip if first apid327 packet
                    apid327_sec = utc2sec(apid327_time)
                    IF ((tlm_sec - apid327_sec) GT 65) AND (mode NE 3) AND (mode NE 2) THEN BEGIN
                        apid327_time_st = utc2str(apid327_time)
                        error_st = 'Gap'+tab+tlm_time_st+tab+apid327_time_st+tab+apid_st
                        ;printf, error_lun, error_st
                        mode = -1
                    ENDIF 
                    IF (tlm_sec EQ apid327_sec) AND (seq EQ apid327_seq) THEN BEGIN 
                        apid327_time_st = utc2str(apid327_time)
                        error_st = 'ERROR: Duplicate time'+tab+tlm_time_st+tab+apid327_time_st+tab+apid_st+tab+$
                                   string(seq, format = '(I2)')
                        printf, error_lun, error_st
                    ENDIF 
                ENDIF 
                packet_counts.apid327[seq] = packet_counts.apid327[seq] + 1
                apid327_seq = seq
                apid327_time = tlm_time
            END 
            '328'x: BEGIN  ; in proton mode
                packet_counts.apid328[0] = packet_counts.apid328[0] + 1
            END 
            '329'x: BEGIN  ; in proton mode
                packet_counts.apid329[0] = packet_counts.apid329[0] + 1
            END 
            '370'x: BEGIN  ; in all modes
                IF n_tags(apid370_time) NE 0 THEN BEGIN ; skip if first apid370 packet
                    apid370_sec = utc2sec(apid370_time)
                    IF ((tlm_sec - apid370_sec) GT 65) THEN BEGIN
                        apid370_time_st = utc2str(apid370_time)
                        error_st = 'Gap'+tab+tlm_time_st+tab+apid370_time_st+tab+apid_st
                        ;printf, error_lun, error_st
                        mode = -1
                    ENDIF 
                    IF (tlm_sec EQ apid370_sec) THEN BEGIN 
                        apid370_time_st = utc2str(apid370_time)
                        error_st = 'ERROR: Duplicate time'+tab+tlm_time_st+tab+apid370_time_st+tab+apid_st+tab+$
                                   string(seq, format = '(I2)')
                        printf, error_lun, error_st
                    ENDIF 
                ENDIF 
                packet_counts.apid370[0] = packet_counts.apid370[0] + 1
                apid370_time = tlm_time
            END 
            ELSE: BREAK 
        ENDCASE
        IF (apid EQ '200'x) OR ((apid GE '300'x) AND (apid LE '3FF'x)) THEN printf, total_lun, total_st
        recent_time = tlm_time
            
     ENDIF 
ENDWHILE

close, in_lun
free_lun, in_lun
close, error_lun
free_lun, error_lun
close, total_lun
free_lun, total_lun

print, "Done ", infilename

END 
