; Lorna Ellis
; 09/10/2014
; find_num_summed2.pro

; This finds the num_summed for an 5-min rate when we don't
; have apid 319 in sidelobe 2 (and are missing 1-min data).


PRO find_num_summed2, apid_str, summed, data, num_min, temp_spacecraft
compile_opt strictarrsubs
COMMON share1
COMMON share2

year  = strmid(timestamp, 0, 4)
month = strmid(timestamp, 5, 2)
date  = strmid(timestamp, 8, 2)

b_file = '/data1/Spacecraft_'+temp_spacecraft+'/Beacon/CDFs/'+year+'/'+month+'/ST'+temp_spacecraft+'_LB_PLASTIC_'+$
         year+month+date+'_V11.cdf'
b_id = cdf_open(b_file)
cdf_control, b_id, get_var_info = b_epoch_info, var = 'Epoch1', /zvariable
IF (b_epoch_info.maxrec GT 0) THEN BEGIN 
    cdf_varget, b_id, 'Epoch1',          b_epoch, rec_count = b_epoch_info.maxrec+1, /zvariable
    cdf_varget, b_id, 'SChannel_switch', b_schan, rec_count = b_epoch_info.maxrec+1, /zvariable

    size = size(data)
    num_dimen = size[0]
    red_data = total(data, 1)
    FOR ii = 2, num_dimen-1 DO BEGIN
        red_data = total(red_data, 1)
    ENDFOR 
    fix_arr = where(red_data GE 0 AND reform(summed[0, *]) EQ -1, fix_c)
    IF fix_c GT 0 THEN BEGIN 
        FOR fix_i = 0, fix_c-1 DO BEGIN
            temp_summed = intarr(128)
            index       = fix_arr[fix_i]
            min         = min(abs(b_epoch - epochs5_heavy[index]), min_i)
            IF min GT 1 THEN BEGIN 
                printf, error_lun, time_string(epochs5_heavy[index], /epoch), ' Find_num_summed2: missing epoch1, Apid: ', apid_str
                bad = 1
                stop
            ENDIF ELSE BEGIN 
                bad = 0
                first_schan = b_schan[min_i]
                IF first_schan EQ 0 THEN first_schan = 128
                FOR jj = 0, num_min-1 DO BEGIN 
                    temp_epoch = b_epoch[min_i+jj]
                    IF jj GT 0 THEN $
                      IF temp_epoch LT b_epoch[min_i]-(60000*jj)-30 $ 
                        OR temp_epoch GT b_epoch[min_i]+(60000*jj)+30 THEN BEGIN
                        printf, error_lun, time_string(epochs5_heavy[index], /epoch), $
                                ' Find_num_summed2: epoch1 does not line up. Apid: ', apid_str
                        bad = 1
                    ENDIF
                    temp_schan = b_schan[min_i+jj]
                    IF temp_schan EQ 0 THEN temp_schan = 128
                    IF first_schan EQ -1 THEN bad = 1 ELSE $
                      IF temp_schan EQ first_schan THEN temp_summed = temp_summed + 1 ELSE $ ; increment all
                      IF temp_schan LT first_schan THEN BEGIN ; schan lower than first
                        temp_summed[ 0:temp_schan-1] = temp_summed[ 0:temp_schan-1] + 1
                        IF first_schan LT 128 THEN temp_summed[first_schan:127] = temp_summed[first_schan:127] + 1
                    ENDIF ELSE BEGIN ; schan higher than first
                        temp_summed[0:first_schan-1] = temp_summed[0:first_schan-1] + 1
                        IF  temp_schan LT 128 THEN temp_summed[ temp_schan:127] = temp_summed[ temp_schan:127] + 1
                    ENDELSE 
                ENDFOR 
            ENDELSE 
            IF bad EQ 0 THEN summed[*, index] = temp_summed
        ENDFOR 
    ENDIF 
ENDIF 
cdf_close, b_id

END 
