; Lorna Ellis
; 09/10/2014
; find_num_summed1.pro

; This finds the num_summed for an 5-min rate when we don't
; have apid 319 in sidelobe 1.


PRO find_num_summed1, apid_str, summed, data, num_min
compile_opt strictarrsubs
COMMON share1
COMMON share2

size = size(data)
num_dimen = size[0]
red_data = total(data, 1)
FOR ii = 2, num_dimen-1 DO BEGIN
    red_data = total(red_data, 1)
ENDFOR 
fix_arr = where(red_data GE 0 AND reform(summed[0, *]) EQ -1, fix_c)
IF fix_c GT 0 THEN BEGIN 
    FOR fix_i = 0, fix_c-1 DO BEGIN
        temp_summed = intarr(128)
        index       = fix_arr[fix_i]
        min         = min(abs(epochs1 - epochs5_heavy[index]), min_i)
        IF min GT 1 THEN BEGIN 
            printf, error_lun, time_string(epochs5_heavy[index], /epoch), ' Find_num_summed1: missing epoch1, Apid: ', apid_str
            bad = 1
        ENDIF ELSE BEGIN 
            bad = 0
            first_schan = schan1[min_i]
            IF first_schan EQ 0 THEN first_schan = 128
            FOR jj = 0, num_min-1 DO BEGIN 
                temp_epoch = epochs1[min_i+jj]
                IF jj GT 0 THEN $
                  IF temp_epoch LT epochs1[min_i]-(60000*jj)-30 $ 
                    OR temp_epoch GT epochs1[min_i]+(60000*jj)+30 THEN BEGIN
                    printf, error_lun, time_string(epochs5_heavy[index], /epoch), $
                            ' Find_num_summed1: epoch1 does not line up. Apid: ', apid_str
                    bad = 1
                ENDIF
                temp_schan = schan1[min_i+jj]
                IF temp_schan EQ 0 THEN temp_schan = 128
                IF first_schan EQ -1 THEN bad = 1 ELSE $
                  IF temp_schan EQ first_schan THEN temp_summed = temp_summed + 1 ELSE $ ; increment all
                  IF temp_schan LT first_schan THEN BEGIN ; schan lower than first
                    temp_summed[ 0:temp_schan-1] = temp_summed[ 0:temp_schan-1] + 1
                    IF first_schan LT 128 THEN temp_summed[first_schan:127] = temp_summed[first_schan:127] + 1
                ENDIF ELSE BEGIN ; schan higher than first
                    temp_summed[0:first_schan-1] = temp_summed[0:first_schan-1] + 1
                    IF  temp_schan LT 128 THEN temp_summed[ temp_schan:127] = temp_summed[ temp_schan:127] + 1
                ENDELSE 
            ENDFOR 
        ENDELSE 
        IF bad EQ 0 THEN summed[*, index] = temp_summed
    ENDFOR 
ENDIF 

END 
