; Lorna Ellis
; 09/10/2014
; find_num_summed.pro

; This finds the num_summed for an 5-min rate when we don't
; have apid 319 in sidelobe, goes to next day.

; 12/23/2014 Fix bug when little data.
; 01/03/2015 Fix bug crossing year.
; 01/20/2015 Fix bug when reach end of day.
; 02/06/2015 Add new_num_cycles1 (because after add 370 data).

PRO find_num_summed, apid_str, summed, data, num_min, temp_spacecraft, new_num_cycles1
compile_opt strictarrsubs
COMMON share1
COMMON share2

year  = strmid(timestamp, 0, 4)
month = strmid(timestamp, 5, 2)
date  = strmid(timestamp, 8, 2)

temp_epoch = reform(epochs1)
temp_schan = reform(schan1 ) 

IF apid_str EQ '321' AND temp_spacecraft EQ 'A' THEN BEGIN
    weird_start = time_double('2014-08-06/14:55:00.000', /epoch)
    weird_stop  = time_double('2014-08-06/19:11:00.000', /epoch)
ENDIF 

; next day
temp_date = strmid(year, 2, 2)+month+date
date2doy, temp_date, doy
IF (year MOD 4 EQ 0 AND doy EQ 366) OR (doy EQ 365) THEN BEGIN
    year = year+1
    doy  = 1
ENDIF ELSE doy = doy + 1
doy_to_month_date, year, doy, month, date
year_st  = string(year,  format = '(I4.4)')
month_st = string(month, format = '(I2.2)')
date_st  = string( date, format = '(I2.2)')

next_file = '/data1/Spacecraft_'+temp_spacecraft+'/Level1/CDFs/'+year_st+'/ST'+temp_spacecraft+'_L1_PLA_'+$
         year_st+month_st+date_st+'_'+string(doy, format = '(I3.3)')+'_V10.cdf'
found = file_test(next_file)
IF found EQ 1 THEN BEGIN 
    next_id = cdf_open(next_file)
    cdf_control, next_id, get_var_info = next_epoch_info, var = 'epoch1', /zvariable
    IF (next_epoch_info.maxrec GT 0) THEN BEGIN 
        cdf_varget, next_id,  'epoch1', next_epoch, rec_count = next_epoch_info.maxrec+1, /zvariable
        cdf_varget, next_id, 's_chan1', next_schan, rec_count = next_epoch_info.maxrec+1, /zvariable
        temp_epoch = [reform(temp_epoch), reform(next_epoch)]
        temp_schan = [reform(temp_schan), reform(next_schan)]
    ENDIF
    cdf_close, next_id
ENDIF 

size = size(data)
num_dimen = size[0]
red_data = total(data, 1)
FOR ii = 2, num_dimen-1 DO BEGIN
    red_data = total(red_data, 1)
ENDFOR 
IF n_elements(summed) EQ 1 THEN BEGIN 
    fix_arr = where(red_data GE 0, fix_c) 
    summed  = intarr(128, n_elements(red_data))
    summed[*, *] = -1
ENDIF ELSE fix_arr = where(red_data GE 0 AND reform(summed[0, *]) EQ -1, fix_c)
temp_num_min = num_min

IF fix_c GT 0 THEN BEGIN 
    FOR fix_i = 0, fix_c-1 DO BEGIN
        temp_summed = intarr(128)
        index       = fix_arr[fix_i]
        min         = min(abs(temp_epoch - epochs5_heavy[index]), min_i)
        ;IF time_string(epochs5_heavy[index], /epoch) EQ '2014-08-05/07:55:38' THEN stop
       IF min GT 1000 THEN BEGIN 
            printf, error_lun, time_string(epochs5_heavy[index], /epoch), ' Find_num_summed1: missing epoch1, Apid: ', apid_str
            bad = 1
        ENDIF ELSE BEGIN 
            bad = 0
            first_schan = temp_schan[min_i]
            IF apid_str EQ '321' AND num_min EQ 20 AND temp_spacecraft EQ 'A' THEN BEGIN 
                IF temp_epoch[min_i] GT weird_start AND temp_epoch[min_i] LT weird_stop THEN temp_num_min = 5 ELSE temp_num_min = 20
            ENDIF 
            IF first_schan EQ 0 THEN first_schan = 128
            FOR jj = 0, temp_num_min-1 DO BEGIN 
                IF min_i+jj GE new_num_cycles1 THEN BEGIN ; yes, this does need to be GE not GT
                    printf, error_lun, time_string(epochs5_heavy[index], /epoch), ' Find_num_summed2: missing epoch1, Apid: ', apid_str
                    bad = 1
                ENDIF ELSE BEGIN 
                    temp2_epoch = temp_epoch[min_i+jj]
                    IF jj GT 0 THEN $
                      IF temp2_epoch LT temp_epoch[min_i]-(60000*jj)-30 $ 
                        OR temp2_epoch GT temp_epoch[min_i]+(60000*jj)+30 THEN BEGIN
                        printf, error_lun, time_string(epochs5_heavy[index], /epoch), $
                                ' Find_num_summed: epoch1 does not line up. Apid: ', apid_str
                        bad = 1
                    ENDIF
                    IF jj+min_i GE n_elements(temp_schan) THEN temp2_schan = -1 ELSE $
                      temp2_schan = temp_schan[min_i+jj]
                    IF temp2_schan EQ 0 THEN temp2_schan = 128
                    IF (first_schan EQ -1) OR (temp2_schan EQ -1) THEN bad = 1 ELSE $
                      IF temp2_schan EQ first_schan THEN temp_summed = temp_summed + 1 ELSE $ ; increment all
                      IF temp2_schan LT first_schan THEN BEGIN ; schan lower than first
                        temp_summed[ 0:temp2_schan-1] = temp_summed[ 0:temp2_schan-1] + 1
                        IF first_schan LT 128 THEN temp_summed[ first_schan:127] = temp_summed[first_schan:127] + 1
                    ENDIF ELSE BEGIN ; schan higher than first
                        temp_summed[0:first_schan-1] = temp_summed[0:first_schan-1] + 1
                        IF  temp2_schan LT 128 THEN temp_summed[temp2_schan:127] = temp_summed[temp2_schan:127] + 1
                    ENDELSE 
                ENDELSE 
            ENDFOR 
        ENDELSE 
        IF bad EQ 0 THEN summed[*, index] = temp_summed
    ENDFOR 
ENDIF 

END 
