; Lorna Ellis
; 05/23/2011
; find_heavy_start.pro

; This if for DPU 32A and after. It finds how many cycles to go back
; to get the correct start time.

; in:  sat  : spacecraft
;      epoch: wanted start time
;      cycle: wanted cycle
;      schan: wanted schan
;      prod : string with product for error message
;      version
; out: cycle_index: index into num_cycles5_heavy, epochs5_heavy, schan5_heavy
;    : back_day   : 0 if current day, 1 if must go back a day, -1 if not yet written, -2 = error on prev day

; 07/08/2011 Add check for not yet written.
; 11/19/2012 Set back_day to -1 when unknown.
; 10/17/2014 Check for when prev day has close time.

PRO find_heavy_start, sat, epoch, cycle, schan, prod, cycle_index, back_day, version
compile_opt strictarrsubs
COMMON share1
COMMON share2
COMMON com_heavy

;IF cycles5_heavy[232] GT -1 THEN stop
back_day = -1
index = where(abs(epoch-epochs5_heavy) LT 60000, count) ; within one minute
IF count EQ 0 THEN BEGIN ; check previous day -- or unwritten
    current_day = 0
    good_i = where(epochs5_heavy GT 0, good_count)
    IF good_count GT 0 THEN BEGIN 
        IF epoch GT epochs5_heavy[good_i[good_count-1]] THEN BEGIN 
            back_day    = -1
            cycle_index =  0
            current_day =  1
        ENDIF 
    ENDIF
    IF current_day EQ 0 THEN BEGIN ; previous day
        pkt_struct = time_struct(pkt_epoch, /epoch)
        new_struct = time_struct(epoch,     /epoch)
        IF new_struct.doy EQ pkt_struct.doy THEN BEGIN
            IF num_cycles5_heavy GT 0 OR telem_vers LE 1 THEN $
              printf, error_lun, time_string(pkt_epoch, /epoch), ' Find_heavy_start1: cannot find time ', prod
        ; assume it was previous, if not already written (data gap)
            index = where(epoch GT epochs5_heavy AND epochs5_heavy GT 0, count)
            back_day = 0
            IF count EQ 0 THEN BEGIN 
                IF num_cycles5_heavy GT 0 OR telem_vers LE 1 THEN $
                  printf, error_lun, time_string(pkt_epoch, /epoch), ' Find_heavy_start2: cannot find time ', prod 
            ENDIF ELSE cycle_index = index[count-1]
        ENDIF ELSE BEGIN
            IF (new_struct.doy EQ (pkt_struct.doy-1)) OR ((pkt_struct.doy EQ 1) AND (new_struct.year EQ (pkt_struct.year-1))) THEN BEGIN 
                old_file = 'ST'+sat+'_L1_PLA_'+string(new_struct.year, format = '(I4.4)')+string(new_struct.month, format = '(I2.2)')+$
                           string(new_struct.date, format = '(I2.2)')+'_'+string(new_struct.doy, format = '(I3.3)')+$
                           '_V'+string(version, format = '(I2.2)')
                IF sat EQ 'A' THEN old_dir = '/data1/Spacecraft_A/' ELSE old_dir = '/data2/Spacecraft_B/'
                old_dir  = old_dir+'Level1/CDFs/'+string(new_struct.year, format = '(I4.4)')+'/'
                old_path = old_dir+old_file
                old_id   = cdf_open(old_path)
                cdf_control, old_id, get_var_info = info_old_heavy, var = 'epoch_heavy', /zvariable
                IF info_old_heavy.maxrec GE 0 THEN BEGIN 
                    cdf_varget, old_id, 'epoch_heavy', temp_old_epoch, rec_count = info_old_heavy.maxrec+1, /zvariable
                    old_epoch = cdf2utc(temp_old_epoch, /ccsds)
                    cdf_varget, old_id, 'cycle_apid319',  old_cycle, rec_count = info_old_heavy.maxrec+1, /zvariable
                    cdf_varget, old_id, 's_chan_apid319', old_schan, rec_count = info_old_heavy.maxrec+1, /zvariable
                    index = where(abs(epoch-temp_old_epoch) LT 60000, count) ; within one minute
                    IF count EQ 0 THEN BEGIN 
                        index = where(abs(epoch-temp_old_epoch) LT 300000, count) ; within five minute
                        IF count GT 0 THEN BEGIN ; found time that was close -- problem
                            printf, error_lun, time_string(pkt_epoch, /epoch), ' Find_heavy_start3: cannot find time ', prod
                            back_day = -2
                        ENDIF ELSE back_day = 1
                    ENDIF ELSE BEGIN 
                        IF old_cycle[index[0]] EQ -1 THEN old_cycle = cycle ELSE $
                          IF (old_cycle[index[0]] NE cycle) AND (cycle NE -1) THEN $
                          printf, error_lun, time_string(pkt_epoch, /epoch), ' Find_heavy_start1: wrong cycle ', prod
                        IF old_schan[index[0]] EQ -1 THEN old_schan = schan ELSE $
                          IF (old_schan[index[0]] NE schan) AND (schan NE -1) THEN $
                          printf, error_lun, time_string(pkt_epoch, /epoch), ' Find_heavy_start1: wrong schan ', prod
                        cycle_index = index[0]
                        back_day    = 1
                    ENDELSE 
                ENDIF ELSE BEGIN 
                    printf, error_lun, time_string(pkt_epoch, /epoch), ' Find_heavy_start: no records on prev day ', prod
                ENDELSE 
            ENDIF ELSE BEGIN 
                printf, error_lun, time_string(pkt_epoch, /epoch), ' Find_heavy_start4: cannot find time ', prod
            ENDELSE 
        ENDELSE 
    ENDIF 
ENDIF ELSE BEGIN
    ;IF timestamp GE '2012-11-02T22:16:47.242' THEN stop
    IF cycles5_heavy[index[0]] EQ -1 THEN cycles5_heavy[index[0]] = cycle ELSE $
      IF cycles5_heavy[index[0]] NE cycle AND cycle NE -1 THEN $
      printf, error_lun, time_string(pkt_epoch, /epoch), ' Find_heavy_start2: wrong cycle ', prod
    IF schan5_heavy[index[0]] EQ -1 THEN schan5_heavy[index[0]] = schan ELSE $
      IF schan5_heavy[index[0]] NE schan AND schan NE -1 THEN $
      printf, error_lun, time_string(pkt_epoch, /epoch), ' Find_heavy_start2: wrong schan ', prod
    cycle_index = index[0]
    back_day    = 0
ENDELSE 
;IF cycles5_heavy[232] GT -1 THEN stop

END 
