; Lorna Ellis
; 09/04/2014
; check_set_points.pro

; This checks the dig hk values from the first packet of the day
; against expected values.

; 12/08/2014 Change so check all values in day.

PRO write_set_pt_header, setpt_lun, temp_string2, file
compile_opt strictarrsubs
tab = string(9B)
temp_string = 'Date analyzed: '+temp_string2
printf, setpt_lun, temp_string
temp_string = 'Set Point File Used:'+tab+file
printf, setpt_lun, temp_string
temp_string = 'Product'+tab+'Expected Value (hex)'+tab+'Value Found (hex)'
printf, setpt_lun, temp_string
END 

PRO check_set_points, sat
compile_opt strictarrsubs
COMMON share1
COMMON com_hk

IF dighk_val_i GT 0 THEN BEGIN 
    date                = strmid(timestamp, 0, 4)+strmid(timestamp, 5, 2)+strmid(timestamp, 8, 2)
    dir                 = '~/splat/Tables/'
    file                = 'ST'+sat+'_set_points.txt'
    path                = dir+file
    line                = ''
    exp_values          = lonarr(199) 
    exp_post_327_values = lonarr( 30)
    bad_values          = intarr(199)
    bad_post_327_values = intarr( 30)

    temp_string         = time_string(pkt_epoch, /epoch)
    temp_string2        = strmid(temp_string, 0, 4)+strmid(temp_string, 5, 2)+strmid(temp_string, 8, 2)

    openr, set_point_lun, path, /get_lun
    readf, set_point_lun, line
    found               = 0
    WHILE found EQ 0 DO BEGIN 
        readf, set_point_lun, line
        parts = strsplit(line, /extract)
        IF parts[0] LE temp_string2 THEN found = 1
        IF eof(set_point_lun) EQ 1  THEN found = 1
    ENDWHILE 
    close,    set_point_lun
    free_lun, set_point_lun

    reads, parts[1], dpu_ver, format = '(Z)'
    FOR ii = 0, dighk_val_i-1 DO BEGIN 
        IF dighk_values[0, ii] NE dpu_ver THEN bad_values[0] = 1
        bad1_i = where(reform(dighk_values[  3:138, ii]) NE long(parts[  4:139]), bc1)
        bad2_i = where(reform(dighk_values[140:198, ii]) NE long(parts[141:199]), bc2)
        IF n_elements(parts) GT 200 THEN $
          bad3_i = where(dighk_post_327_values[0:29, ii] NE long(parts[200:229]), bc3) ELSE bc3 = 0
        IF bc1 GT 0 THEN bad_values[bad1_i+  3] = ii
        IF bc2 GT 0 THEN bad_values[bad2_i+140] = ii
        IF bc3 GT 0 THEN bad_post_327_values[bad3_i] = ii
    ENDFOR 
    
    tab                 = string(9B)
    exp_values          = long(parts[  1:199])
    IF n_elements(parts) GT 200 THEN exp_post_327_values = long(parts[200:229])
    have_setpt_error    = 0
    FOR ii = 0, 198 DO BEGIN
        CASE ii OF 
            000: BEGIN
               IF dighk_values[ii] NE dpu_ver THEN BEGIN
                    IF have_setpt_error EQ 0 THEN BEGIN
                        write_set_pt_header, setpt_lun, temp_string2, file
                        have_setpt_error = 1
                    ENDIF 
                    temp_string = dighk_products[ii]+tab+parts[1]+tab 
                ENDIF 
            END 
            001: dummy = dummy  ; cmd_rcvd_cnt
            002: dummy = dummy  ; cmd_exec_cnt
            144: dummy = dummy  ; analog_limit_status, in dighk errors
            154: dummy = dummy  ; analog_lim_pt4_status, in dighk errors
            157: dummy = dummy  ; analog_lim_pt5_status, in dighk errors
            ELSE: BEGIN 
                IF bad_values[ii] GT 0 THEN BEGIN 
                    IF have_setpt_error EQ 0 THEN BEGIN
                        write_set_pt_header, setpt_lun, temp_string2, file
                        have_setpt_error = 1
                    ENDIF 
                    temp_string = dighk_products[ii]+tab
                    IF exp_values[ii] GT 255 THEN $
                      temp_string = temp_string+string(exp_values[ii], format = '(Z4.4)')+tab ELSE $
                      temp_string = temp_string+string(exp_values[ii], format = '(Z2.2)')+tab
                    IF dighk_values[ii] GT 255 THEN $
                      temp_string = temp_string+string(dighk_values[ii, bad_values[ii]], format = '(Z4.4)') ELSE $
                      temp_string = temp_string+string(dighk_values[ii, bad_values[ii]], format = '(Z2.2)') 
                    printf, setpt_lun, temp_string
                ENDIF  
            END 
        ENDCASE 
    ENDFOR 
    FOR ii = 0, 29 DO BEGIN 
        IF bad_post_327_values[ii] GT 0 THEN BEGIN 
            IF have_setpt_error EQ 0 THEN BEGIN
                write_set_pt_header, setpt_lun, temp_string2, file
                have_setpt_error = 1
            ENDIF 
            temp_string = dighk_post_327[ii]+tab
            IF exp_post_327_values[ii] GT 255 THEN $
              temp_string = temp_string+string(exp_post_327_values[ii], format = '(Z4.4)')+tab ELSE $
              temp_string = temp_string+string(exp_post_327_values[ii], format = '(Z2.2)')+tab 
            IF dighk_post_327_values[ii] GT 255 THEN $
              temp_string = temp_string+string(dighk_post_327_values[ii, bad_post_327_values[ii]], format = '(Z4.4)') ELSE $
              temp_string = temp_string+string(dighk_post_327_values[ii, bad_post_327_values[ii]], format = '(Z2.2)') 
            printf, setpt_lun, temp_string
        ENDIF 
    ENDFOR 
ENDIF 
END 
