PRO check_seq_heavy, back_cycles
compile_opt strictarrsubs
COMMON share1
COMMON share2
COMMON com_heavy

CASE apid OF
    '319'x: BEGIN   
        wrote = wrote_319
        last_epoch = last_epoch_319
    END 
    '31a'x: BEGIN  
        wrote = wrote_31a
        IF last_epoch_31a GE last_epoch_31b THEN last_epoch = last_epoch_31a ELSE last_epoch = last_epoch_31b
    END 
    '31b'x: BEGIN  
        wrote = wrote_31b
        IF last_epoch_31b GE last_epoch_31a THEN last_epoch = last_epoch_31b ELSE last_epoch = last_epoch_31a
    END 
    '31c'x: BEGIN  
        wrote = wrote_31c
        IF last_epoch_31c GE last_epoch_31d THEN last_epoch = last_epoch_31c ELSE last_epoch = last_epoch_31d
    END 
    '31d'x: BEGIN  
        wrote = wrote_31d
        IF last_epoch_31d GE last_epoch_31c THEN last_epoch = last_epoch_31d ELSE last_epoch = last_epoch_31c
    END 
    '31e'x: BEGIN  
        wrote = wrote_31e
        last_epoch = last_epoch_31e
    END 
    '31f'x: BEGIN  
        wrote = wrote_31f
        last_epoch = last_epoch_31f
    END 
    '320'x: BEGIN  
        wrote = wrote_320
        last_epoch = last_epoch_320
    END 
    '321'x: BEGIN  
        wrote = wrote_321
        last_epoch = last_epoch_321
    END 
ENDCASE 

diff = abs(last_epoch-pkt_epoch)
back_cycles = -1
IF diff LT 30000 THEN BEGIN  ; check this time against time of previous packet
    diff = abs(pkt_epoch-epochs5_heavy[num_cycles5_heavy-1]) ; check if on next cycle; not yet written
    IF wrote[num_cycles5_heavy-1] EQ 0 OR diff GT 270000 THEN dummy = dummy $  ; still collecting data
      ELSE printf, error_lun, timestamp, ' ', string(apid, format = '(Z)'), ' processing error in check_seq_heavy'
ENDIF ELSE BEGIN  ; we have a new time -- look for if old time (for old data) exists in epochs
     ; first check if it is newer than existing epochs
     ; if so, write cycle
    diff = last_epoch-epochs5_heavy[num_cycles5_heavy-1]
    IF diff GT 30000 THEN BEGIN 
        write_cycle5_heavy, -1, -1, last_epoch
        done = 1
    ENDIF ELSE done = 0

    ; now check if matches previous cycle
    found = 0
    IF done EQ 0 THEN BEGIN 
        back_cycles = 1
        WHILE found EQ 0 AND back_cycles LE num_cycles5_heavy DO BEGIN
            diff = abs(epochs5_heavy[num_cycles5_heavy-back_cycles]-last_epoch)
            IF diff LT 30000 THEN BEGIN
                found = 1
            ENDIF ELSE back_cycles = back_cycles + 1
        ENDWHILE 
    ENDIF 
    IF found EQ 0 THEN back_cycles = -1
ENDELSE 
END 
