; 09/04/2014 Check for num_cycles1 gt 0.
; 09/17/2014 Add apid 370

PRO check_seq1, back_cycles
compile_opt strictarrsubs
COMMON share1
COMMON share2
COMMON com_alph_prot
COMMON com_pha
COMMON com_mon

CASE apid OF
    '315'x: BEGIN   
        wrote = wrote_315
        last_epoch = last_epoch_315
    END 
    '316'x: BEGIN  
        wrote = wrote_316_1
        last_epoch = last_epoch_316
    END 
    '317'x: BEGIN  
        wrote = wrote_317
        last_epoch = last_epoch_317
    END 
    '324'x: BEGIN  
        wrote = wrote_324
        last_epoch = last_epoch_324
    END 
    '325'x: BEGIN  
        wrote = wrote_325
        last_epoch = last_epoch_325
    END 
    '326'x: BEGIN  
        wrote = wrote_326
        last_epoch = last_epoch_326
    END 
    '327'x: BEGIN  
        wrote = wrote_327
        last_epoch = last_epoch_327
    END 
    '370'x: BEGIN  
        wrote = wrote_370
        last_epoch = last_epoch_370
    END 
ENDCASE 

diff = abs(last_epoch-pkt_epoch)
back_cycles = -1

IF diff LT 30000 THEN BEGIN  ; check this time against time of previous packet
    diff = abs(pkt_epoch-epochs1[num_cycles1-1]) ; check if on next cycle; not yet written
    IF wrote[num_cycles1-1] EQ 0 OR diff GT 90000 THEN dummy = dummy $  ; still collecting data
      ELSE printf, error_lun, timestamp, ' ', string(apid, format = '(Z)'), ' processing error in check_seq1'
ENDIF ELSE BEGIN  ; we have a new time -- look for if old time (for old data) exists in epochs
     ; first check if it is newer than existing epochs
     ; if so, write cycle
    IF num_cycles1 GT 0 THEN diff = last_epoch-epochs1[num_cycles1-1]
    IF diff GT 30000 THEN BEGIN 
        write_cycle1, -1, -1, last_epoch
        done = 1
    ENDIF ELSE done = 0

    ; now check if matches previous cycle
    found = 0
    IF done EQ 0 THEN BEGIN 
        back_cycles = 1
        WHILE found EQ 0 AND back_cycles LE num_cycles1 DO BEGIN
            diff = abs(epochs1[num_cycles1-back_cycles]-last_epoch)
            IF diff LT 30000 THEN BEGIN
                found = 1
            ENDIF ELSE back_cycles = back_cycles + 1
        ENDWHILE 
    ENDIF 
    IF found EQ 0 THEN back_cycles = -1
ENDELSE 
END 
