; Lorna Ellis
; 09/18/2014
; check_mom.pro

; This puts the moments from apid 370 into the CDFs as necessary.

; 10/21/2014 Fix bug when only have 370 at end of day.
; 12/23/2014 Fix bug when only zeros in data.
; 01/08/2014 Add Error=0 cases.
; 01/09/2015 Check when num_cycles1 eq 0.
; 12/09/2019 Fix bug where check_mom is not reached.

PRO check_mom, sat
compile_opt strictarrsubs
COMMON share1
COMMON share2
COMMON com_moments

large_num = 5000
num_back  = 0

; check previous day
year_st     = strmid(timestamp, 0, 4)
month_st    = strmid(timestamp, 5, 2)
date_st     = strmid(timestamp, 8, 2)
temp_string = strmid(year_st, 2, 2)+month_st+date_st
date2doy, temp_string, doy
back_doy    = doy-1
IF back_doy LT 1 THEN BEGIN
    back_year = fix(year_st)-1
    IF back_year MOD 4 EQ 0 THEN back_doy = 366 ELSE back_doy = 365
ENDIF ELSE back_year = fix(year_st)
doy_to_month_date, back_year, back_doy, back_month, back_date
back_file = '/data1/Spacecraft_'+sat+'/Level1/CDFs/'+string(back_year, format = '(I4.4)')+'/'+$
           'ST'+sat+'_L1_PLA_'+string(back_year, format = '(I4.4)')+string(back_month, format = '(I2.2)')+$
           string(back_date, format = '(I2.2)')+'_'+string(back_doy, format = '(I3.3)')+'_V10.cdf'
back_id = cdf_open(back_file)
cdf_control, back_id, get_var_info = back_info, var = 'epoch1', /zvariable
IF back_info.maxrec GE 0 THEN BEGIN 
    cdf_varget, back_id, 'epoch1',            epoch_back, rec_count = back_info.maxrec+1, /zvariable
    cdf_varget, back_id, 'cycle1',           cycle1_back, rec_count = back_info.maxrec+1, /zvariable
    cdf_varget, back_id, 's_chan1',          schan1_back, rec_count = back_info.maxrec+1, /zvariable
    cdf_varget, back_id, 'moment_meta',        meta_back, rec_count = back_info.maxrec+1, /zvariable
    cdf_varget, back_id, 'density_main',      den_m_back, rec_count = back_info.maxrec+1, /zvariable
    cdf_varget, back_id, 'velocity_main',     vel_m_back, rec_count = back_info.maxrec+1, /zvariable
    cdf_varget, back_id, 'temperature_main',  tem_m_back, rec_count = back_info.maxrec+1, /zvariable
    cdf_varget, back_id, 'heat_flux_main',    hfl_m_back, rec_count = back_info.maxrec+1, /zvariable
    cdf_varget, back_id, 'density_s',         den_s_back, rec_count = back_info.maxrec+1, /zvariable
    cdf_varget, back_id, 'velocity_s',        vel_s_back, rec_count = back_info.maxrec+1, /zvariable
    cdf_varget, back_id, 'temperature_s',     tem_s_back, rec_count = back_info.maxrec+1, /zvariable
    cdf_varget, back_id, 'heat_flux_s',       hfl_s_back, rec_count = back_info.maxrec+1, /zvariable
    insert_i = back_info.maxrec+1
    FOR ii = 0, 4 DO BEGIN ; just need beginning of times
        IF (strmid(time_string(mom_epoch_370[ii], /epoch), 11, 5) EQ '23:58') OR $
          (strmid(time_string(mom_epoch_370[ii], /epoch), 11, 5) EQ '23:59') THEN BEGIN 
            num_back = num_back + 1
            found_i = where(abs(epoch_back - mom_epoch_370[ii]) LT 1000, count)
            IF count GT 1 THEN BEGIN
                printf, error_lun, 'Check_mom: more matching times than expected'
            ENDIF ELSE IF count EQ 1 THEN BEGIN ; have time
                IF den_m_back[found_i] LT -1E30 THEN BEGIN ; no old mom data
                    cdf_varput, back_id, 'moment_meta',       [-1, -1, -1, mom_source_370[ii]], rec_start = found_i
                    cdf_varput, back_id, 'density_main',      mom_370[    0, 0, ii], rec_start = found_i
                    cdf_varput, back_id, 'density_s',         mom_370[    0, 1, ii], rec_start = found_i
                    cdf_varput, back_id, 'velocity_main',     mom_370[ 1: 3, 0, ii], rec_start = found_i
                    cdf_varput, back_id, 'velocity_s',        mom_370[ 1: 3, 1, ii], rec_start = found_i
                    cdf_varput, back_id, 'temperature_main',  mom_370[ 4: 9, 0, ii], rec_start = found_i
                    cdf_varput, back_id, 'temperature_s',     mom_370[ 4: 9, 1, ii], rec_start = found_i
                    cdf_varput, back_id, 'heat_flux_main',    mom_370[10:12, 0, ii], rec_start = found_i
                    cdf_varput, back_id, 'heat_flux_s',       mom_370[10:12, 1, ii], rec_start = found_i
                ENDIF ELSE IF (meta_back[3, found_i] NE mom_source_370[ii]) OR $
                  (den_m_back  [found_i] NE mom_370[0, 0,  ii]) OR $
                  (den_s_back  [found_i] NE mom_370[0, 1,  ii]) OR $
                  (array_equal(vel_m_back[*, found_i], mom_370[ 1: 3, 0, ii]) NE 1) OR $
                  (array_equal(vel_s_back[*, found_i], mom_370[ 1: 3, 1, ii]) NE 1) OR $
                  (array_equal(tem_m_back[*, found_i], mom_370[ 4: 9, 0, ii]) NE 1) OR $
                  (array_equal(tem_s_back[*, found_i], mom_370[ 4: 9, 1, ii]) NE 1) OR $
                  (array_equal(hfl_m_back[*, found_i], mom_370[10:12, 0, ii]) NE 1) OR $
                  (array_equal(hfl_s_back[*, found_i], mom_370[10:12, 1, ii]) NE 1) THEN BEGIN 
                    printf, error_lun, 'Check_Mom1: conflict in prev day '+time_string(epochs1[found_i], /epoch)
                ENDIF 
            ENDIF ELSE BEGIN ; don't have time
               special_case = 0
               IF time_string(mom_epoch_370[ii],/epoch) EQ '2016-12-31/23:58:55' THEN BEGIN ; special case
                  insert_i = insert_i - 2
                  special_case = 1
               ENDIF
               IF time_string(mom_epoch_370[ii],/epoch) EQ '2016-12-31/23:59:55' THEN BEGIN ; special case
                  special_case = 1
               ENDIF
               IF time_string(mom_epoch_370[ii], /epoch) GT time_string(epoch_back[back_info.maxrec], /epoch) OR $
                  special_case eq 1 THEN BEGIN ; add to end
                  IF special_case eq 0 then $
                     cdf_varput, back_id, 'epoch1',           mom_epoch_370[ii],     rec_start = insert_i
                  cdf_varput, back_id, 'error1',           0,                     rec_start = insert_i
                  cdf_varput, back_id, 'moment_meta',      [-1, -1, -1, mom_source_370[ii]], rec_start = insert_i
                  cdf_varput, back_id, 'density_main',     mom_370[    0, 0, ii], rec_start = insert_i
                  cdf_varput, back_id, 'density_s',        mom_370[    0, 1, ii], rec_start = insert_i
                  cdf_varput, back_id, 'velocity_main',    mom_370[ 1: 3, 0, ii], rec_start = insert_i
                  cdf_varput, back_id, 'velocity_s',       mom_370[ 1: 3, 1, ii], rec_start = insert_i
                  cdf_varput, back_id, 'temperature_main', mom_370[ 4: 9, 0, ii], rec_start = insert_i
                  cdf_varput, back_id, 'temperature_s',    mom_370[ 4: 9, 1, ii], rec_start = insert_i
                  cdf_varput, back_id, 'heat_flux_main',   mom_370[10:12, 0, ii], rec_start = insert_i
                  cdf_varput, back_id, 'heat_flux_s',      mom_370[10:12, 1, ii], rec_start = insert_i
                  insert_i = insert_i + 1
               ENDIF ELSE printf, error_lun, 'Check_mom: Lorna, add code for when need to insert in prev day'
            ENDELSE 
        ENDIF 
    ENDFOR 
ENDIF 
cdf_close, back_id

index_370 = num_back
; on to today!
must_change = 0
IF mom_370_i GT 0 THEN BEGIN 
    IF num_cycles1 GT 0 THEN BEGIN 
        cdf_varget, cdf_id, 'cycle1',           cycle1_old, rec_count = num_cycles1, /zvariable
        cdf_varget, cdf_id, 'cycle1',           cycle1_old, rec_count = num_cycles1, /zvariable
        cdf_varget, cdf_id, 's_chan1',          schan1_old, rec_count = num_cycles1, /zvariable
        cdf_varget, cdf_id, 'moment_meta',        meta_old, rec_count = num_cycles1, /zvariable
        cdf_varget, cdf_id, 'density_main',      den_m_old, rec_count = num_cycles1, /zvariable
        cdf_varget, cdf_id, 'velocity_main',     vel_m_old, rec_count = num_cycles1, /zvariable
        cdf_varget, cdf_id, 'temperature_main',  tem_m_old, rec_count = num_cycles1, /zvariable
        cdf_varget, cdf_id, 'heat_flux_main',    hfl_m_old, rec_count = num_cycles1, /zvariable
        cdf_varget, cdf_id, 'density_s',         den_s_old, rec_count = num_cycles1, /zvariable
        cdf_varget, cdf_id, 'velocity_s',        vel_s_old, rec_count = num_cycles1, /zvariable
        cdf_varget, cdf_id, 'temperature_s',     tem_s_old, rec_count = num_cycles1, /zvariable
        cdf_varget, cdf_id, 'heat_flux_s',       hfl_s_old, rec_count = num_cycles1, /zvariable
        index_old = 0
        epoch_old = epochs1[0:num_cycles1-1] 
        WHILE index_old LE num_cycles1-1 DO BEGIN 
            IF index_370 EQ mom_370_i THEN index_old = index_old + 1 ELSE BEGIN ; done. do nothing.
                IF abs(epochs1[index_old] - mom_epoch_370[index_370]) LT 1000 THEN BEGIN ; same time
                    IF den_m_old[index_old] LT -1E30 THEN BEGIN ; no old mom data
                        meta_old[3, index_old] = mom_source_370[index_370]
                        den_m_old[index_old] = mom_370[0, 0, index_370]
                        den_s_old[index_old] = mom_370[0, 1, index_370]
                        vel_m_old[*, index_old] = mom_370[ 1: 3, 0, index_370]
                        vel_s_old[*, index_old] = mom_370[ 1: 3, 1, index_370]
                        tem_m_old[*, index_old] = mom_370[ 4: 9, 0, index_370]
                        tem_s_old[*, index_old] = mom_370[ 4: 9, 1, index_370]
                        hfl_m_old[*, index_old] = mom_370[10:12, 0, index_370]
                        hfl_s_old[*, index_old] = mom_370[10:12, 1, index_370]
                        must_change = 1
                    ENDIF ELSE IF (cycle1_old [index_old] NE mom_cycle_370[ index_370]+1) OR $
                                ;(schan1_old [index_old] NE mom_schan_370[ index_370]) OR $
                      (meta_old[3, index_old] NE mom_source_370[index_370]) OR $
                      (den_m_old  [index_old] NE mom_370[0, 0,  index_370]) OR $
                      (den_s_old  [index_old] NE mom_370[0, 1,  index_370]) OR $
                      (array_equal(vel_m_old[*, index_old], mom_370[ 1: 3, 0, index_370]) NE 1) OR $
                      (array_equal(vel_s_old[*, index_old], mom_370[ 1: 3, 1, index_370]) NE 1) OR $
                      (array_equal(tem_m_old[*, index_old], mom_370[ 4: 9, 0, index_370]) NE 1) OR $
                      (array_equal(tem_s_old[*, index_old], mom_370[ 4: 9, 1, index_370]) NE 1) OR $
                      (array_equal(hfl_m_old[*, index_old], mom_370[10:12, 0, index_370]) NE 1) OR $
                      (array_equal(hfl_s_old[*, index_old], mom_370[10:12, 1, index_370]) NE 1) THEN BEGIN 
                        printf, error_lun, 'Check_Mom1: conflict '+time_string(epochs1[index_old], /epoch)
                    ENDIF 
                    index_old = index_old + 1
                    index_370 = index_370 + 1
                ENDIF ELSE IF epochs1[index_old] GT mom_epoch_370[index_370] THEN BEGIN ; need to insert time
                    temp_mom_time = strmid(time_string(mom_epoch_370[index_370], /epoch), 0, 10)
                    temp_old_time = strmid(time_string(epochs1      [index_old], /epoch), 0, 10)
                    IF temp_mom_time EQ temp_old_time THEN BEGIN ; same day
                        IF (index_old) EQ 0 THEN BEGIN
                            IF must_change EQ 0 THEN BEGIN
                                insert_before = [index_old]
                                insert_370    = [index_370]
                                must_change   = 1
                            ENDIF ELSE BEGIN  
                                insert_before = [insert_before, index_old]
                                insert_370    = [insert_370,    index_370]
                            ENDELSE 
                        ENDIF ELSE BEGIN ; check for old data
                            IF (epochs1[index_old]-epochs1[index_old-1] GT 60000) AND $ ; more than a minute
                              ((meta_old[3, index_old-1] NE mom_source_370[index_370]) OR $
                              (den_m_old  [index_old-1] NE mom_370[0, 0,  index_370]) OR $
                              (den_s_old  [index_old-1] NE mom_370[0, 1,  index_370]) OR $
                              (array_equal(vel_m_old[*, index_old-1], mom_370[ 1: 3, 0, index_370]) NE 1) OR $
                              (array_equal(vel_s_old[*, index_old-1], mom_370[ 1: 3, 1, index_370]) NE 1) OR $
                              (array_equal(tem_m_old[*, index_old-1], mom_370[ 4: 9, 0, index_370]) NE 1) OR $
                              (array_equal(tem_s_old[*, index_old-1], mom_370[ 4: 9, 1, index_370]) NE 1) OR $
                              (array_equal(hfl_m_old[*, index_old-1], mom_370[10:12, 0, index_370]) NE 1) OR $
                              (array_equal(hfl_s_old[*, index_old-1], mom_370[10:12, 1, index_370]) NE 1)) THEN BEGIN 
                                IF n_elements(insert_before) EQ 0 THEN BEGIN
                                    insert_before = [index_old]
                                    insert_370    = [index_370]
                                    must_change   = 1
                                ENDIF ELSE BEGIN  
                                    insert_before = [insert_before, index_old]
                                    insert_370    = [insert_370,    index_370]
                                ENDELSE 
                            ENDIF 
                        ENDELSE 
                    ENDIF ELSE BEGIN 
                        printf, error_lun, 'Check_mom: Lorna, check this case. Should not be here'
                    ENDELSE 
                    index_370 = index_370 + 1
                ENDIF ELSE index_old = index_old+1
            ENDELSE 
        ENDWHILE 
    ENDIF 

    WHILE index_370 LT mom_370_i DO BEGIN 
        IF n_elements(insert_before) EQ 0 THEN BEGIN 
            insert_before = [large_num] 
            insert_370    = [index_370]
            must_change = 1
        ENDIF ELSE BEGIN 
            insert_before = [insert_before, large_num] ; arbitrary large number
            insert_370    = [insert_370,    index_370]
        ENDELSE 
        index_370  = index_370 + 1
    ENDWHILE 

    IF must_change EQ 1 THEN BEGIN 
        IF num_cycles1 GT 0 THEN BEGIN 
            cdf_varget, cdf_id, 'error1',           error1_old, rec_count = num_cycles1, /zvariable
            cdf_varget, cdf_id, 'proton_peak',   proton_pk_old, rec_count = num_cycles1, /zvariable
            cdf_varget, cdf_id, 'alpha_peak',     alpha_pk_old, rec_count = num_cycles1, /zvariable
            cdf_varget, cdf_id, 'pha',                 pha_old, rec_count = num_cycles1, /zvariable
            cdf_varget, cdf_id, 'pha_start_esa', start_esa_old, rec_count = num_cycles1, /zvariable 
            cdf_varget, cdf_id, 'pha_missing',    pha_miss_old, rec_count = num_cycles1, /zvariable 
            cdf_varget, cdf_id, 'h_alpha',         h_alpha_old, rec_count = num_cycles1, /zvariable
            cdf_varget, cdf_id, 'h+peak',           h_p_pk_old, rec_count = num_cycles1, /zvariable
            cdf_varget, cdf_id, 'he++peak',      he_p_p_pk_old, rec_count = num_cycles1, /zvariable
            cdf_varget, cdf_id, 'he++tcr',      he_p_p_tcr_old, rec_count = num_cycles1, /zvariable
            read_mon_indices, apid317_products
            mon_old = lonarr(n_elements(apid317_products), 128, 32, num_cycles1)
            FOR ii = 0, n_elements(apid317_products)-1 DO BEGIN 
                name = apid317_products[ii]+'_full'
                cdf_varget, cdf_id, name, temp_values, rec_count = num_cycles1, /zvariable
                mon_old[ii, *, *, *] = temp_values
            ENDFOR
        ENDIF 
        
        num_add         = n_elements(insert_370)
        IF num_add EQ 0 THEN BEGIN 
            IF num_cycles1 GT 0 THEN BEGIN 
                epoch_temp      = reform(epoch_old)       
                error_temp      = reform(error1_old)      
                cycle1_temp     = reform(cycle1_old)      
                schan1_temp     = reform(schan1_old)      
                den_m_temp      = reform(den_m_old)       
                den_s_temp      = reform(den_s_old)       
                pha_miss_temp   = reform(pha_miss_old)    
                start_esa_temp  = reform(start_esa_old)   
                meta_temp       = reform(meta_old)        
                vel_m_temp      = reform(vel_m_old)       
                vel_s_temp      = reform(vel_s_old)       
                tem_m_temp      = reform(tem_m_old)       
                tem_s_temp      = reform(tem_s_old)       
                hfl_m_temp      = reform(hfl_m_old)       
                hfl_s_temp      = reform(hfl_s_old)       
                proton_pk_temp  = reform(proton_pk_old)   
                alpha_pk_temp   = reform(alpha_pk_old)    
                pha_temp        = reform(pha_old)         
                h_alpha_temp    = reform(h_alpha_old)     
                h_p_pk_temp     = reform(h_p_pk_old)      
                he_p_p_pk_temp  = reform(he_p_p_pk_old)   
                he_p_p_tcr_temp = reform(he_p_p_tcr_old)  
                mon_temp        = reform(mon_old)         
            ENDIF ELSE stop ; don't expect this -- no data?
        ENDIF ELSE BEGIN 
            epoch_temp      = dblarr(             num_cycles1+num_add) ; 1 dim
            error_temp      = intarr(             num_cycles1+num_add) 
            cycle1_temp     = intarr(             num_cycles1+num_add) 
            schan1_temp     = intarr(             num_cycles1+num_add) 
            den_m_temp      = dblarr(             num_cycles1+num_add) 
            den_s_temp      = dblarr(             num_cycles1+num_add) 
            pha_miss_temp   = lonarr(             num_cycles1+num_add) 
            start_esa_temp  = intarr(             num_cycles1+num_add) 
            meta_temp       = lonarr(          4, num_cycles1+num_add) ; 2 dim
            vel_m_temp      = dblarr(          3, num_cycles1+num_add) 
            vel_s_temp      = dblarr(          3, num_cycles1+num_add) 
            tem_m_temp      = dblarr(          6, num_cycles1+num_add) 
            tem_s_temp      = dblarr(          6, num_cycles1+num_add) 
            hfl_m_temp      = dblarr(          3, num_cycles1+num_add) 
            hfl_s_temp      = dblarr(          3, num_cycles1+num_add) 
            proton_pk_temp  = intarr(          4, num_cycles1+num_add) 
            alpha_pk_temp   = intarr(          4, num_cycles1+num_add) 
            pha_temp        = intarr(    768,  9, num_cycles1+num_add) ; 3 dim
            h_alpha_temp    = lonarr(20,   8,  8, num_cycles1+num_add) ; 4 dim
            h_p_pk_temp     = lonarr(10,   8,  8, num_cycles1+num_add) 
            he_p_p_pk_temp  = lonarr(10,   8,  8, num_cycles1+num_add) 
            he_p_p_tcr_temp = lonarr(10,   8,  8, num_cycles1+num_add) 
            mon_temp        = lonarr(32, 128, 32, num_cycles1+num_add) 

            epoch_temp     [         *] = -1E31
            error_temp     [         *] = -1
            cycle1_temp    [         *] = -1
            schan1_temp    [         *] = -1
            den_m_temp     [         *] = -1E31
            den_s_temp     [         *] = -1E31
            pha_miss_temp  [         *] = -1
            start_esa_temp [         *] = -1
            meta_temp      [      *, *] = -1
            vel_m_temp     [      *, *] = -1E31
            vel_s_temp     [      *, *] = -1E31
            tem_m_temp     [      *, *] = -1E31
            tem_s_temp     [      *, *] = -1E31
            hfl_m_temp     [      *, *] = -1E31
            hfl_s_temp     [      *, *] = -1E31
            proton_pk_temp [      *, *] = -1
            alpha_pk_temp  [      *, *] = -1
            pha_temp       [   *, *, *] = -1
            h_alpha_temp   [*, *, *, *] = -1
            h_p_pk_temp    [*, *, *, *] = -1
            he_p_p_pk_temp [*, *, *, *] = -1
            he_p_p_tcr_temp[*, *, *, *] = -1
            mon_temp       [*, *, *, *] = -1
        ENDELSE 

        IF num_add GT 0 THEN BEGIN 
            IF insert_before[0] EQ large_num AND num_cycles1 GT 0 THEN BEGIN 
                epoch_temp     [         0:num_cycles1-1] = epoch_old    
                error_temp     [         0:num_cycles1-1] = error1_old   
                cycle1_temp    [         0:num_cycles1-1] = cycle1_old   
                schan1_temp    [         0:num_cycles1-1] = schan1_old   
                den_m_temp     [         0:num_cycles1-1] = den_m_old    
                den_s_temp     [         0:num_cycles1-1] = den_s_old    
                pha_miss_temp  [         0:num_cycles1-1] = pha_miss_old 
                start_esa_temp [         0:num_cycles1-1] = start_esa_old
                meta_temp      [      *, 0:num_cycles1-1] = meta_old     
                vel_m_temp     [      *, 0:num_cycles1-1] = vel_m_old    
                vel_s_temp     [      *, 0:num_cycles1-1] = vel_s_old    
                tem_m_temp     [      *, 0:num_cycles1-1] = tem_m_old    
                tem_s_temp     [      *, 0:num_cycles1-1] = tem_s_old    
                hfl_m_temp     [      *, 0:num_cycles1-1] = hfl_m_old    
                hfl_s_temp     [      *, 0:num_cycles1-1] = hfl_s_old    
                proton_pk_temp [      *, 0:num_cycles1-1] = proton_pk_old
                alpha_pk_temp  [      *, 0:num_cycles1-1] = alpha_pk_old 
                pha_temp       [   *, *, 0:num_cycles1-1] = pha_old       
                h_alpha_temp   [*, *, *, 0:num_cycles1-1] = h_alpha_old   
                h_p_pk_temp    [*, *, *, 0:num_cycles1-1] = h_p_pk_old    
                he_p_p_pk_temp [*, *, *, 0:num_cycles1-1] = he_p_p_pk_old 
                he_p_p_tcr_temp[*, *, *, 0:num_cycles1-1] = he_p_p_tcr_old
                mon_temp       [*, *, *, 0:num_cycles1-1] = mon_old       
            ENDIF 
        ENDIF 

        FOR ii = 0, num_add-1 DO BEGIN 
            IF ii EQ 0 THEN BEGIN
                start_temp = 0 
                start_old  = 0
            ENDIF ELSE BEGIN 
                IF insert_before[ii-1] EQ large_num THEN start_temp = insert_before[ii]+ii-1 $ ; == stop_temp so won't write
                  ELSE start_temp = insert_before[ii-1]+ii
                start_old  = insert_before[ii-1]
            ENDELSE 
            IF insert_before[ii] EQ large_num THEN BEGIN 
                stop_temp = num_cycles1-1+ii
                stop_old  = num_cycles1-1 
            ENDIF ELSE BEGIN 
                stop_temp = insert_before[ii]+ii-1
                stop_old  = insert_before[ii]-1
            ENDELSE 

            IF (insert_before[ii] NE 0) AND (stop_temp GE start_temp) THEN BEGIN
                epoch_temp     [         start_temp:stop_temp] = epoch_old     [         start_old:stop_old] ; 1 dim
                error_temp     [         start_temp:stop_temp] = error1_old    [         start_old:stop_old]
                cycle1_temp    [         start_temp:stop_temp] = cycle1_old    [         start_old:stop_old]
                schan1_temp    [         start_temp:stop_temp] = schan1_old    [         start_old:stop_old]
                den_m_temp     [         start_temp:stop_temp] = den_m_old     [         start_old:stop_old]
                den_s_temp     [         start_temp:stop_temp] = den_s_old     [         start_old:stop_old]
                pha_miss_temp  [         start_temp:stop_temp] = pha_miss_old  [         start_old:stop_old]
                start_esa_temp [         start_temp:stop_temp] = start_esa_old [         start_old:stop_old]
                meta_temp      [      *, start_temp:stop_temp] = meta_old      [      *, start_old:stop_old] ; 2 dim
                vel_m_temp     [      *, start_temp:stop_temp] = vel_m_old     [      *, start_old:stop_old]
                vel_s_temp     [      *, start_temp:stop_temp] = vel_s_old     [      *, start_old:stop_old]
                tem_m_temp     [      *, start_temp:stop_temp] = tem_m_old     [      *, start_old:stop_old]
                tem_s_temp     [      *, start_temp:stop_temp] = tem_s_old     [      *, start_old:stop_old]
                hfl_m_temp     [      *, start_temp:stop_temp] = hfl_m_old     [      *, start_old:stop_old]
                hfl_s_temp     [      *, start_temp:stop_temp] = hfl_s_old     [      *, start_old:stop_old]
                proton_pk_temp [      *, start_temp:stop_temp] = proton_pk_old [      *, start_old:stop_old]
                alpha_pk_temp  [      *, start_temp:stop_temp] = alpha_pk_old  [      *, start_old:stop_old]
                pha_temp       [   *, *, start_temp:stop_temp] = pha_old       [   *, *, start_old:stop_old] ; 3 dim
                h_alpha_temp   [*, *, *, start_temp:stop_temp] = h_alpha_old   [*, *, *, start_old:stop_old] ; 4 dim
                h_p_pk_temp    [*, *, *, start_temp:stop_temp] = h_p_pk_old    [*, *, *, start_old:stop_old]
                he_p_p_pk_temp [*, *, *, start_temp:stop_temp] = he_p_p_pk_old [*, *, *, start_old:stop_old]
                he_p_p_tcr_temp[*, *, *, start_temp:stop_temp] = he_p_p_tcr_old[*, *, *, start_old:stop_old]
                mon_temp       [*, *, *, start_temp:stop_temp] = mon_old       [*, *, *, start_old:stop_old]
            ENDIF 
            IF insert_before[ii] EQ 0 THEN BEGIN 
                error_temp [   ii] = 0
                epoch_temp [   ii] = mom_epoch_370[    insert_370[ii]] ; 1 dim
                cycle1_temp[   ii] = mom_cycle_370[    insert_370[ii]] 
                schan1_temp[   ii] = mom_schan_370[    insert_370[ii]] 
                den_m_temp [   ii] = mom_370    [0, 0, insert_370[ii]] 
                den_s_temp [   ii] = mom_370    [0, 1, insert_370[ii]] 
                meta_temp  [*, ii] = [-1, -1, -1, mom_source_370[insert_370[ii]]] ; 2 dim
                vel_m_temp [*, ii] = mom_370[ 1: 3, 0, insert_370[ii]] 
                vel_s_temp [*, ii] = mom_370[ 1: 3, 1, insert_370[ii]] 
                tem_m_temp [*, ii] = mom_370[ 4: 9, 0, insert_370[ii]] 
                tem_s_temp [*, ii] = mom_370[ 4: 9, 1, insert_370[ii]] 
                hfl_m_temp [*, ii] = mom_370[10:12, 0, insert_370[ii]] 
                hfl_s_temp [*, ii] = mom_370[10:12, 1, insert_370[ii]] 
            ENDIF ELSE IF insert_before[ii] EQ large_num THEN BEGIN
                temp_i = num_cycles1+ii
                ;IF ii GT 0 THEN BEGIN
                ;    IF insert_before[ii-1] LT large_num THEN temp_i = insert_before[ii-1]+ii ; overwrite
                ;ENDIF 
                IF epoch_temp[temp_i] GT 0 THEN stop ; problem indexing
                error_temp [   temp_i] = 0
                epoch_temp [   temp_i] = mom_epoch_370[    insert_370[ii]] ; 1 dim
                cycle1_temp[   temp_i] = mom_cycle_370[    insert_370[ii]] 
                schan1_temp[   temp_i] = mom_schan_370[    insert_370[ii]] 
                den_m_temp [   temp_i] = mom_370    [0, 0, insert_370[ii]] 
                den_s_temp [   temp_i] = mom_370    [0, 1, insert_370[ii]] 
                meta_temp  [*, temp_i] = [-1, -1, -1, mom_source_370[insert_370[ii]]] ; 2 dim
                vel_m_temp [*, temp_i] = mom_370[ 1: 3, 0, insert_370[ii]] 
                vel_s_temp [*, temp_i] = mom_370[ 1: 3, 1, insert_370[ii]] 
                tem_m_temp [*, temp_i] = mom_370[ 4: 9, 0, insert_370[ii]] 
                tem_s_temp [*, temp_i] = mom_370[ 4: 9, 1, insert_370[ii]] 
                hfl_m_temp [*, temp_i] = mom_370[10:12, 0, insert_370[ii]] 
                hfl_s_temp [*, temp_i] = mom_370[10:12, 1, insert_370[ii]] 
            ENDIF ELSE BEGIN 
                error_temp [   insert_before[ii]+ii] = 0
                epoch_temp [   insert_before[ii]+ii] = mom_epoch_370 [   insert_370[ii]] ; 1 dim
                cycle1_temp[   insert_before[ii]+ii] = mom_cycle_370 [   insert_370[ii]]
                schan1_temp[   insert_before[ii]+ii] = mom_schan_370 [   insert_370[ii]]
                den_m_temp [   insert_before[ii]+ii] = mom_370[    0, 0, insert_370[ii]]
                den_s_temp [   insert_before[ii]+ii] = mom_370[    0, 1, insert_370[ii]]
                meta_temp  [*, insert_before[ii]+ii] = [-1, -1, -1, mom_source_370[insert_370[ii]]] ; 2 dim
                vel_m_temp [*, insert_before[ii]+ii] = mom_370[ 1: 3, 0, insert_370[ii]]
                vel_s_temp [*, insert_before[ii]+ii] = mom_370[ 1: 3, 1, insert_370[ii]]
                tem_m_temp [*, insert_before[ii]+ii] = mom_370[ 4: 9, 0, insert_370[ii]]
                tem_s_temp [*, insert_before[ii]+ii] = mom_370[ 4: 9, 1, insert_370[ii]]
                hfl_m_temp [*, insert_before[ii]+ii] = mom_370[10:12, 0, insert_370[ii]]
                hfl_s_temp [*, insert_before[ii]+ii] = mom_370[10:12, 1, insert_370[ii]]
            ENDELSE 
        ENDFOR 

        IF num_add GT 0 THEN BEGIN 
            IF insert_before[ii-1] LT num_cycles1-1+num_add THEN BEGIN
                epoch_temp     [         insert_before[ii-1]+num_add:num_cycles1-1+num_add] = epoch_old     [         insert_before[ii-1]:num_cycles1-1]
                error_temp     [         insert_before[ii-1]+num_add:num_cycles1-1+num_add] = error1_old    [         insert_before[ii-1]:num_cycles1-1]
                cycle1_temp    [         insert_before[ii-1]+num_add:num_cycles1-1+num_add] = cycle1_old    [         insert_before[ii-1]:num_cycles1-1]
                schan1_temp    [         insert_before[ii-1]+num_add:num_cycles1-1+num_add] = schan1_old    [         insert_before[ii-1]:num_cycles1-1]
                den_m_temp     [         insert_before[ii-1]+num_add:num_cycles1-1+num_add] = den_m_old     [         insert_before[ii-1]:num_cycles1-1]
                den_s_temp     [         insert_before[ii-1]+num_add:num_cycles1-1+num_add] = den_s_old     [         insert_before[ii-1]:num_cycles1-1]
                pha_miss_temp  [         insert_before[ii-1]+num_add:num_cycles1-1+num_add] = pha_miss_old  [         insert_before[ii-1]:num_cycles1-1]
                start_esa_temp [         insert_before[ii-1]+num_add:num_cycles1-1+num_add] = start_esa_old [         insert_before[ii-1]:num_cycles1-1]
                meta_temp      [      *, insert_before[ii-1]+num_add:num_cycles1-1+num_add] = meta_old      [      *, insert_before[ii-1]:num_cycles1-1]
                vel_m_temp     [      *, insert_before[ii-1]+num_add:num_cycles1-1+num_add] = vel_m_old     [      *, insert_before[ii-1]:num_cycles1-1]
                vel_s_temp     [      *, insert_before[ii-1]+num_add:num_cycles1-1+num_add] = vel_s_old     [      *, insert_before[ii-1]:num_cycles1-1]
                tem_m_temp     [      *, insert_before[ii-1]+num_add:num_cycles1-1+num_add] = tem_m_old     [      *, insert_before[ii-1]:num_cycles1-1]
                tem_s_temp     [      *, insert_before[ii-1]+num_add:num_cycles1-1+num_add] = tem_s_old     [      *, insert_before[ii-1]:num_cycles1-1]
                hfl_m_temp     [      *, insert_before[ii-1]+num_add:num_cycles1-1+num_add] = hfl_m_old     [      *, insert_before[ii-1]:num_cycles1-1]
                hfl_s_temp     [      *, insert_before[ii-1]+num_add:num_cycles1-1+num_add] = hfl_s_old     [      *, insert_before[ii-1]:num_cycles1-1]
                proton_pk_temp [      *, insert_before[ii-1]+num_add:num_cycles1-1+num_add] = proton_pk_old [      *, insert_before[ii-1]:num_cycles1-1]
                alpha_pk_temp  [      *, insert_before[ii-1]+num_add:num_cycles1-1+num_add] = alpha_pk_old  [      *, insert_before[ii-1]:num_cycles1-1]
                pha_temp       [   *, *, insert_before[ii-1]+num_add:num_cycles1-1+num_add] = pha_old       [   *, *, insert_before[ii-1]:num_cycles1-1]
                h_alpha_temp   [*, *, *, insert_before[ii-1]+num_add:num_cycles1-1+num_add] = h_alpha_old   [*, *, *, insert_before[ii-1]:num_cycles1-1]
                h_p_pk_temp    [*, *, *, insert_before[ii-1]+num_add:num_cycles1-1+num_add] = h_p_pk_old    [*, *, *, insert_before[ii-1]:num_cycles1-1]
                he_p_p_pk_temp [*, *, *, insert_before[ii-1]+num_add:num_cycles1-1+num_add] = he_p_p_pk_old [*, *, *, insert_before[ii-1]:num_cycles1-1]
                he_p_p_tcr_temp[*, *, *, insert_before[ii-1]+num_add:num_cycles1-1+num_add] = he_p_p_tcr_old[*, *, *, insert_before[ii-1]:num_cycles1-1]
                mon_temp       [*, *, *, insert_before[ii-1]+num_add:num_cycles1-1+num_add] = mon_old       [*, *, *, insert_before[ii-1]:num_cycles1-1]
                num_cycles1 = num_cycles1+num_add
            ENDIF
        ENDIF 

        cdf_varput, cdf_id, 'epoch1',            epoch_temp, rec_start = 0
        cdf_varput, cdf_id, 'error1',            error_temp, rec_start = 0
        cdf_varput, cdf_id, 'cycle1',           cycle1_temp, rec_start = 0
        cdf_varput, cdf_id, 's_chan1',          schan1_temp, rec_start = 0
        cdf_varput, cdf_id, 'moment_meta',        meta_temp, rec_start = 0
        cdf_varput, cdf_id, 'density_main',      den_m_temp, rec_start = 0
        cdf_varput, cdf_id, 'velocity_main',     vel_m_temp, rec_start = 0
        cdf_varput, cdf_id, 'temperature_main',  tem_m_temp, rec_start = 0
        cdf_varput, cdf_id, 'heat_flux_main',    hfl_m_temp, rec_start = 0
        cdf_varput, cdf_id, 'density_s',         den_s_temp, rec_start = 0
        cdf_varput, cdf_id, 'velocity_s',        vel_s_temp, rec_start = 0
        cdf_varput, cdf_id, 'temperature_s',     tem_s_temp, rec_start = 0
        cdf_varput, cdf_id, 'heat_flux_s',       hfl_s_temp, rec_start = 0
        cdf_varput, cdf_id, 'pha',                 pha_temp, rec_start = 0
        cdf_varput, cdf_id, 'pha_missing',    pha_miss_temp, rec_start = 0
        cdf_varput, cdf_id, 'pha_start_esa', start_esa_temp, rec_start = 0
        cdf_varput, cdf_id, 'proton_peak',   proton_pk_temp, rec_start = 0 
        cdf_varput, cdf_id, 'alpha_peak',     alpha_pk_temp, rec_start = 0 
        cdf_varput, cdf_id, 'h_alpha',         h_alpha_temp, rec_start = 0
        cdf_varput, cdf_id, 'h+peak',           h_p_pk_temp, rec_start = 0
        cdf_varput, cdf_id, 'he++peak',      he_p_p_pk_temp, rec_start = 0        
        cdf_varput, cdf_id, 'he++tcr',      he_p_p_tcr_temp, rec_start = 0
        
        FOR ii = 0, n_elements(apid317_products)-1 DO BEGIN 
            temp_values = reform(mon_temp[ii, *, *, *])
            name = apid317_products[ii]+'_full'
            cdf_varput, cdf_id, name, temp_values, rec_start = 0
        ENDFOR

        epochs1 = epoch_temp
        schan1  = schan1_temp
    ENDIF 
ENDIF ELSE IF mom_370_i GT 0 THEN BEGIN 
    meta_temp = intarr(4, mom_370_i-num_back)
    meta_temp[*, *] = -1
    meta_temp[3, *] = mom_source_370[num_back:mom_370_i-1]
    error_arr = intarr(mom_370_i-num_back)
    cdf_varput, cdf_id, 'error1',                error_arr , rec_start = 0
    cdf_varput, cdf_id, 'epoch1',            mom_epoch_370[          num_back:mom_370_i-1] , rec_start = 0
    cdf_varput, cdf_id, 'cycle1',            mom_cycle_370[          num_back:mom_370_i-1] , rec_start = 0
    cdf_varput, cdf_id, 's_chan1',           mom_schan_370[          num_back:mom_370_i-1] , rec_start = 0
    cdf_varput, cdf_id, 'density_main',     reform(mom_370[    0, 0, num_back:mom_370_i-1]), rec_start = 0
    cdf_varput, cdf_id, 'density_s',        reform(mom_370[    0, 1, num_back:mom_370_i-1]), rec_start = 0
    cdf_varput, cdf_id, 'velocity_main',    reform(mom_370[ 1: 3, 0, num_back:mom_370_i-1]), rec_start = 0
    cdf_varput, cdf_id, 'velocity_s',       reform(mom_370[ 1: 3, 1, num_back:mom_370_i-1]), rec_start = 0
    cdf_varput, cdf_id, 'temperature_main', reform(mom_370[ 4: 9, 0, num_back:mom_370_i-1]), rec_start = 0
    cdf_varput, cdf_id, 'temperature_s',    reform(mom_370[ 4: 9, 1, num_back:mom_370_i-1]), rec_start = 0
    cdf_varput, cdf_id, 'heat_flux_main',   reform(mom_370[10:12, 0, num_back:mom_370_i-1]), rec_start = 0
    cdf_varput, cdf_id, 'heat_flux_s',      reform(mom_370[10:12, 1, num_back:mom_370_i-1]), rec_start = 0
    cdf_varput, cdf_id, 'moment_meta',        meta_temp, rec_start = 0
ENDIF 

END 
