; Lorna Ellis
; 09/04/2014
; check_missing_apids.pro

; This checks various configurations
; 0: all apids
; 1: Off: 31AB, 31E, 31F, 320, 370 ("reduced telemetry")
; 2: Off: 315, 319, 31AB, 31CD, 31E, 31F, 320, 324, 325, 326, 327, 370 ("Sidelobe 1")
; 3: Off: 315, 316, 319, 31AB, 31CD, 31E, 31F, 320, 321, 324, 325, 326, 327, 370 ("Sidelobe 2")
;

; 11/26/2014 Check for no data.

PRO check_missing_apids, sat, year, doy, error_lun, have_apids
compile_opt strictarrsubs

IF array_equal(have_apids, 0) EQ 1 THEN BEGIN
    printf, error_lun, ' '
    printf, error_lun, 'No Data in File'
ENDIF ELSE BEGIN 
    CASE year OF 
        2006: check_apid_orig, error_lun, have_apids
        2007: check_apid_orig, error_lun, have_apids
        2008: check_apid_orig, error_lun, have_apids
        2009: check_apid_orig, error_lun, have_apids
        2010: check_apid_orig, error_lun, have_apids
        2011: check_apid_orig, error_lun, have_apids
        2012: check_apid_orig, error_lun, have_apids
        2013: CASE sat OF 
            'A': check_apid_orig, error_lun, have_apids
            'B': IF doy LT 365 THEN check_apid_orig, error_lun, have_apids $
                 ELSE check_apid_red_tel, error_lun, have_apids
        ENDCASE 
        2014: CASE sat OF
            'A': IF doy LT 192 THEN check_apid_red_tel, error_lun, have_apids ELSE $
              IF doy LT 193 THEN check_apid_orig, error_lun, have_apids    ELSE $
              IF doy LT 217 THEN check_apid_red_tel, error_lun, have_apids ELSE $
          IF doy LT 219 THEN check_apid_orig, error_lun, have_apids    ELSE $
              IF doy LT 231 THEN check_apid_red_tel, error_lun, have_apids ELSE $
              check_apid_side1, error_lun, have_apids
            'B': IF doy LT 57 THEN check_apid_red_tel, error_lun, have_apids $
                 ELSE IF doy LT 59 THEN check_apid_orig, error_lun, have_apids $
                      ELSE check_apid_red_tel, error_lun, have_apids
        ENDCASE
        2015: CASE sat OF
            'A': IF doy LT 6 THEN check_apid_side1, error_lun, have_apids ELSE $
              IF doy LT 321 THEN check_apid_side2, error_lun, have_apids ELSE $
              check_apid_red_tel, error_lun, have_apids
            'B': check_apid_red_tel, error_lun, have_apids
        ENDCASE 
        2016: IF doy LT 136 THEN check_apid_red_tel, error_lun, have_apids ELSE $
          check_apid_orig, error_lun, have_apids
        2017: check_apid_orig, error_lun, have_apids
        2018: check_apid_orig, error_lun, have_apids
        2019: check_apid_orig, error_lun, have_apids
        2020: check_apid_orig, error_lun, have_apids
        2021: check_apid_orig, error_lun, have_apids
        2022: check_apid_orig, error_lun, have_apids
        2023: check_apid_orig, error_lun, have_apids
        2024: check_apid_orig, error_lun, have_apids
        2025: check_apid_orig, error_lun, have_apids
        2026: check_apid_orig, error_lun, have_apids
        2027: check_apid_orig, error_lun, have_apids
        2028: check_apid_orig, error_lun, have_apids
        2029: check_apid_orig, error_lun, have_apids
        2030: check_apid_orig, error_lun, have_apids
    ENDCASE 
ENDELSE 
END 
