;+
; Project     : STEREO - PLASTIC
;
; Name        : check_l0_tlm_short.pro
;
; Purpose     : Check L0 file against .tlm file from Berkeley
;               GSE. Checks all data in the .tlm file to see if it is
;               in the Lo file. Uses more memory; takes less time than
;               check_l0_tlm
;
; Category    : Telemetry, Data-extraction
;
; History     : version 1, 5/19/06, LB Ellis, written
;
; Contact     : Lorna Ellis (Lorna.Ellis@unh.edu)
;-


PRO check_l0_tlm_short
compile_opt strictarrsubs
tab = STRING(9B)

version = "V01"
tlmfilepath = '/Users/lornaellis/Lorna/Files/CPT'
l0filepath = '/Users/lornaellis/Lorna/Files/CPT'
outfilepath = 'Output'

spacecraft = 'behind'
year_st = '2006'
doy_st = '312'
tlmfilename = 'B0606170620.tlm'
l0filename = 'plastc_behind_2006_312_1_00.ptp'

year = fix(year_st)
doy = fix(doy_st)
if n_elements(tlmfilepath) eq 1 then tlmfile = concat_dir(tlmfilepath, tlmfilename) ELSE tlmfile = tlmfilename
if n_elements(l0filepath) eq 1 then l0file = concat_dir(l0filepath, l0filename) ELSE l0file = l0filename

IF spacecraft EQ 'ahead' THEN temp_spacecraft = 'A' ELSE temp_spacecraft = 'B'
IF year LT 2001 OR year GT 2999 THEN print, "Error: invalid year", year
time_utc = doy2utc(doy, year)
time_st = utc2str(time_utc)
month_st = strmid(time_st, 5, 2)
day_st = strmid(time_st, 8, 2)
outfileprefix = 'compare_short_'+spacecraft+'_'+doy_st+'_'+tlmfilename
if n_elements(outfilepath) eq 1 then outfileprefix = concat_dir(outfilepath, outfileprefix)
errorfilename = outfileprefix+'.errors'
openw, error_lun, errorfilename, /get_lun
printf, error_lun, 'Time'+tab+'Current_Apid'+tab+'Sequence'

; loop through data
apid_array = ['313'x, '315'x, '316'x, '317'x, '318'x, '319'x, '31a'x, '31b'x, '31c'x, '31d'x, '31e'x, '31f'x, '320'x, '321'x, '322'x, '323'x, '324'x, '325'x, '326'x, '327'x, '328'x, '329'x, '370'x]
times_313 = strarr(1000)
times_315 = strarr(10000)
times_316 = strarr(100000)
times_317 = strarr(10000)
times_318 = strarr(1000)
times_319 = strarr(1000)
times_31a = strarr(10000)
times_31b = strarr(10000)
times_31c = strarr(10000)
times_31d = strarr(10000)
times_31e = strarr(10000)
times_31f = strarr(10000)
times_320 = strarr(10000)
times_321 = strarr(10000)
times_322 = strarr(1000)
times_323 = strarr(1000)
times_324 = strarr(10000)
times_325 = strarr(10000)
times_326 = strarr(10000)
times_327 = strarr(10000)
times_328 = strarr(100000)
times_329 = strarr(100000)
times_370 = strarr(1000)
seq_313 = intarr(1000)
seq_315 = intarr(10000)
seq_316 = intarr(100000)
seq_317 = intarr(10000)
seq_318 = intarr(1000)
seq_319 = intarr(1000)
seq_31a = intarr(10000)
seq_31b = intarr(10000)
seq_31c = intarr(10000)
seq_31d = intarr(10000)
seq_31e = intarr(10000)
seq_31f = intarr(10000)
seq_320 = intarr(10000)
seq_321 = intarr(10000)
seq_322 = intarr(1000)
seq_323 = intarr(1000)
seq_324 = intarr(10000)
seq_325 = intarr(10000)
seq_326 = intarr(10000)
seq_327 = intarr(10000)
seq_328 = intarr(100000)
seq_329 = intarr(100000)
seq_370 = intarr(1000)
index_313 = 0
index_315 = 0
index_316 = 0
index_317 = 0
index_318 = 0
index_319 = 0
index_31a = 0
index_31b = 0
index_31c = 0
index_31d = 0
index_31e = 0
index_31f = 0
index_320 = 0
index_321 = 0
index_322 = 0
index_323 = 0
index_324 = 0
index_325 = 0
index_326 = 0
index_327 = 0
index_328 = 0
index_329 = 0L
index_370 = 0

openr, tlm_lun, tlmfile, /get_lun
packet = 0
last_time = ' '
first_time = '2500-00-00T00:00:00.000'
WHILE n_elements(packet) NE 0 DO BEGIN
    read_stereo_pkt, tlm_lun, packet
    IF n_elements(packet) NE 0 THEN BEGIN 
        apid = parse_stereo_pkt(packet, /APID)
        tlm_time = parse_stereo_pkt(packet, /PKT_DATE, /ccsds)
        IF tlm_time GT last_time THEN last_time = tlm_time
        IF tlm_time LT first_time THEN first_time = tlm_time
        CASE apid OF 
            '313'x: BEGIN 
                tlm_seq = 0
                times_313[index_313] = tlm_time
                seq_313[index_313] = tlm_seq
                index_313 = index_313 + 1
            END 
            '315'x: BEGIN 
                tlm_seq = packet.dat[0]
                times_315[index_315] = tlm_time
                seq_315[index_315] = tlm_seq
                index_315 = index_315 + 1
            END 
            '316'x: BEGIN 
                temporary = packet.pkt
                host_to_ieee, temporary
                load_bytarr, temporary, bytarr
                bytarr = [bytarr, packet.dat]
                tlm_seq = bytarr[10] ; put in header part
                times_316[index_316] = tlm_time
                seq_316[index_316] = tlm_seq
                index_316 = index_316 + 1
            END             
            '317'x: BEGIN 
                temporary = packet.pkt
                host_to_ieee, temporary
                load_bytarr, temporary, bytarr
                bytarr = [bytarr, packet.dat]
                tlm_seq = bytarr[10] ; put in header part
                times_317[index_317] = tlm_time
                seq_317[index_317] = tlm_seq
                index_317 = index_317 + 1
            END             
            '318'x: BEGIN 
                tlm_seq = 0
                times_318[index_318] = tlm_time
                seq_318[index_318] = tlm_seq
                index_318 = index_318 + 1
            END 
            '319'x: BEGIN 
                tlm_seq = packet.dat[0]
                times_319[index_319] = tlm_time
                seq_319[index_319] = tlm_seq
                index_319 = index_319 + 1
            END 
            '31a'x: BEGIN 
                tlm_seq = packet.dat[0]
                times_31a[index_31a] = tlm_time
                seq_31a[index_31a] = tlm_seq
                index_31a = index_31a + 1
            END 
            '31b'x: BEGIN 
                tlm_seq = packet.dat[0]
                times_31b[index_31b] = tlm_time
                seq_31b[index_31b] = tlm_seq
                index_31b = index_31b + 1
            END 
            '31c'x: BEGIN 
                tlm_seq = packet.dat[0]
                times_31c[index_31c] = tlm_time
                seq_31c[index_31c] = tlm_seq
                index_31c = index_31c + 1
            END 
            '31d'x: BEGIN 
                tlm_seq = packet.dat[0]
                times_31d[index_31d] = tlm_time
                seq_31d[index_31d] = tlm_seq
                index_31d = index_31d + 1
            END 
            '31e'x: BEGIN 
                tlm_seq = packet.dat[0]
                times_31e[index_31e] = tlm_time
                seq_31e[index_31e] = tlm_seq
                index_31e = index_31e + 1
            END 
            '31f'x: BEGIN 
                tlm_seq = packet.dat[0]
                times_31f[index_31f] = tlm_time
                seq_31f[index_31f] = tlm_seq
                index_31f = index_31f + 1
            END 
            '320'x: BEGIN 
                tlm_seq = packet.dat[0]
                times_320[index_320] = tlm_time
                seq_320[index_320] = tlm_seq
                index_320 = index_320 + 1
            END 
            '321'x: BEGIN 
                tlm_seq = packet.dat[0]
                times_321[index_321] = tlm_time
                seq_321[index_321] = tlm_seq
                index_321 = index_321 + 1
            END 
            '322'x: BEGIN 
                tlm_seq = packet.dat[0]
                times_322[index_322] = tlm_time
                seq_322[index_322] = tlm_seq
                index_322 = index_322 + 1
            END 
            '323'x: BEGIN 
                tlm_seq = packet.dat[0]
                times_323[index_323] = tlm_time
                seq_323[index_323] = tlm_seq
                index_323 = index_323 + 1
            END 
            '324'x: BEGIN 
                tlm_seq = packet.dat[0]
                times_324[index_324] = tlm_time
                seq_324[index_324] = tlm_seq
                index_324 = index_324 + 1
            END 
            '325'x: BEGIN 
                tlm_seq = packet.dat[0]
                times_325[index_325] = tlm_time
                seq_325[index_325] = tlm_seq
                index_325 = index_325 + 1
            END 
            '326'x: BEGIN 
                tlm_seq = packet.dat[0]
                times_326[index_326] = tlm_time
                seq_326[index_326] = tlm_seq
                index_326 = index_326 + 1
            END 
            '327'x: BEGIN 
                tlm_seq = packet.dat[0]
                times_327[index_327] = tlm_time
                seq_327[index_327] = tlm_seq
                index_327 = index_327 + 1
            END 
            '328'x: BEGIN 
                tlm_seq = 0
                times_328[index_328] = tlm_time
                seq_328[index_328] = tlm_seq
                index_328 = index_328 + 1
            END 
            '329'x: BEGIN 
                tlm_seq = 0
                times_329[index_329] = tlm_time
                seq_329[index_329] = tlm_seq
                index_329 = index_329 + 1
            END 
            '370'x: BEGIN 
                tlm_seq = 0
                times_370[index_370] = tlm_time
                seq_370[index_370] = tlm_seq
                index_370 = index_370 + 1
            END 
            ELSE: BREAK
        ENDCASE 
    ENDIF
ENDWHILE
close, tlm_lun
free_lun, tlm_lun
print, 'Finished tlm file ', first_time, ' ', last_time

openr, l0_lun, l0file, /get_lun
packet = 0
l0_counter = 0
too_late = 0 ; set to 1 when gone beyond last_time
WHILE (n_elements(packet) NE 0) AND (too_late EQ 0) DO BEGIN
    read_stereo_pkt, l0_lun, packet
    IF n_elements(packet) NE 0 THEN BEGIN 
        apid = parse_stereo_pkt(packet, /APID)
        l0_time = parse_stereo_pkt(packet, /PKT_DATE, /ccsds)
        IF l0_time GT last_time THEN too_late = 1
        IF l0_counter EQ 10000 THEN BEGIN
            print, l0_time
            l0_counter = 0
        ENDIF ELSE l0_counter = l0_counter + 1
        IF tlm_time GE first_time THEN BEGIN 
            CASE apid OF 
                '313'x: BEGIN 
                    l0_seq = 0
                    reverse_times = reverse(sort(times_313)) ; provides indexes into times
                    found = 0
                    l0_index = 0L
                    WHILE (l0_index LT n_elements(reverse_times)) AND (found EQ 0) DO BEGIN 
                        IF (l0_time LT times_313[reverse_times[l0_index]]) THEN l0_index = l0_index + 1 ELSE found = 1
                    ENDWHILE
                    found = 0
                    WHILE (l0_index LT n_elements(reverse_times)) AND (found EQ 0) DO BEGIN 
                        IF (l0_time EQ times_313[reverse_times[l0_index]]) AND (found EQ 0) THEN  BEGIN 
                            IF seq_313[reverse_times[l0_index]] EQ l0_seq THEN BEGIN 
                                seq_313[reverse_times[l0_index]] = -1
                                times_313[reverse_times[l0_index]] = ''
                                found = 1
                            ENDIF ELSE l0_index = l0_index+1
                        ENDIF ELSE found = 1
                    ENDWHILE 
                END 
                '315'x: BEGIN 
                    l0_seq = packet.dat[0]
                    reverse_times = reverse(sort(times_315)) ; provides indexes into times
                    found = 0
                    l0_index = 0L
                    WHILE (l0_index LT n_elements(reverse_times)) AND (found EQ 0) DO BEGIN 
                        IF (l0_time LT times_315[reverse_times[l0_index]]) THEN l0_index = l0_index + 1 ELSE found = 1
                    ENDWHILE
                    found = 0
                    WHILE (l0_index LT n_elements(reverse_times)) AND (found EQ 0) DO BEGIN 
                        IF (l0_time EQ times_315[reverse_times[l0_index]]) AND (found EQ 0) THEN  BEGIN 
                            IF seq_315[reverse_times[l0_index]] EQ l0_seq THEN BEGIN 
                                seq_315[reverse_times[l0_index]] = -1
                                times_315[reverse_times[l0_index]] = ''
                                found = 1
                            ENDIF ELSE l0_index = l0_index+1
                        ENDIF ELSE found = 1
                    ENDWHILE 
                END 
                '316'x: BEGIN 
                    temporary = packet.pkt
                    host_to_ieee, temporary
                    load_bytarr, temporary, bytarr
                    bytarr = [bytarr, packet.dat]
                    l0_seq = bytarr[10] ; put in header part
                    reverse_times = reverse(sort(times_316)) ; provides indexes into times
                    found = 0
                    l0_index = 0L
                    WHILE (l0_index LT n_elements(reverse_times)) AND (found EQ 0) DO BEGIN 
                        IF (l0_time LT times_316[reverse_times[l0_index]]) THEN l0_index = l0_index + 1 ELSE found = 1
                    ENDWHILE
                    found = 0
                    WHILE (l0_index LT n_elements(reverse_times)) AND (found EQ 0) DO BEGIN 
                        IF (l0_time EQ times_316[reverse_times[l0_index]]) AND (found EQ 0) THEN  BEGIN 
                            IF seq_316[reverse_times[l0_index]] EQ l0_seq THEN BEGIN 
                                seq_316[reverse_times[l0_index]] = -1
                                times_316[reverse_times[l0_index]] = ''
                                found = 1
                            ENDIF ELSE l0_index = l0_index+1
                        ENDIF ELSE found = 1
                    ENDWHILE 
                END                             
                '317'x: BEGIN 
                    temporary = packet.pkt
                    host_to_ieee, temporary
                    load_bytarr, temporary, bytarr
                    bytarr = [bytarr, packet.dat]
                    l0_seq = bytarr[10] ; put in header part
                    reverse_times = reverse(sort(times_317)) ; provides indexes into times
                    found = 0
                    l0_index = 0L
                    WHILE (l0_index LT n_elements(reverse_times)) AND (found EQ 0) DO BEGIN 
                        IF (l0_time LT times_317[reverse_times[l0_index]]) THEN l0_index = l0_index + 1 ELSE found = 1
                    ENDWHILE
                    found = 0
                    WHILE (l0_index LT n_elements(reverse_times)) AND (found EQ 0) DO BEGIN 
                        IF (l0_time EQ times_317[reverse_times[l0_index]]) AND (found EQ 0) THEN  BEGIN 
                            IF seq_317[reverse_times[l0_index]] EQ l0_seq THEN BEGIN 
                                seq_317[reverse_times[l0_index]] = -1
                                times_317[reverse_times[l0_index]] = ''
                                found = 1
                            ENDIF ELSE l0_index = l0_index+1
                        ENDIF ELSE found = 1
                    ENDWHILE 
                END                             
                '318'x: BEGIN 
                    l0_seq = 0
                    reverse_times = reverse(sort(times_318)) ; provides indexes into times
                    found = 0
                    l0_index = 0L
                    WHILE (l0_index LT n_elements(reverse_times)) AND (found EQ 0) DO BEGIN 
                        IF (l0_time LT times_318[reverse_times[l0_index]]) THEN l0_index = l0_index + 1 ELSE found = 1
                    ENDWHILE
                    found = 0
                    WHILE (l0_index LT n_elements(reverse_times)) AND (found EQ 0) DO BEGIN 
                        IF (l0_time EQ times_318[reverse_times[l0_index]]) AND (found EQ 0) THEN  BEGIN 
                            IF seq_318[reverse_times[l0_index]] EQ l0_seq THEN BEGIN 
                                seq_318[reverse_times[l0_index]] = -1
                                times_318[reverse_times[l0_index]] = ''
                                found = 1
                            ENDIF ELSE l0_index = l0_index+1
                        ENDIF ELSE found = 1
                    ENDWHILE 
                END 
                '319'x: BEGIN 
                    l0_seq = packet.dat[0]
                    reverse_times = reverse(sort(times_319)) ; provides indexes into times
                    found = 0
                    l0_index = 0L
                    WHILE (l0_index LT n_elements(reverse_times)) AND (found EQ 0) DO BEGIN 
                        IF (l0_time LT times_319[reverse_times[l0_index]]) THEN l0_index = l0_index + 1 ELSE found = 1
                    ENDWHILE
                    found = 0
                    WHILE (l0_index LT n_elements(reverse_times)) AND (found EQ 0) DO BEGIN 
                        IF (l0_time EQ times_319[reverse_times[l0_index]]) AND (found EQ 0) THEN  BEGIN 
                            IF seq_319[reverse_times[l0_index]] EQ l0_seq THEN BEGIN 
                                seq_319[reverse_times[l0_index]] = -1
                                times_319[reverse_times[l0_index]] = ''
                                found = 1
                            ENDIF ELSE l0_index = l0_index+1
                        ENDIF ELSE found = 1
                    ENDWHILE 
                END 
                '31a'x: BEGIN 
                    l0_seq = packet.dat[0]
                    reverse_times = reverse(sort(times_31a)) ; provides indexes into times
                    found = 0
                    l0_index = 0L
                    WHILE (l0_index LT n_elements(reverse_times)) AND (found EQ 0) DO BEGIN 
                        IF (l0_time LT times_31a[reverse_times[l0_index]]) THEN l0_index = l0_index + 1 ELSE found = 1
                    ENDWHILE
                    found = 0
                    WHILE (l0_index LT n_elements(reverse_times)) AND (found EQ 0) DO BEGIN 
                        IF (l0_time EQ times_31a[reverse_times[l0_index]]) AND (found EQ 0) THEN  BEGIN 
                            IF seq_31a[reverse_times[l0_index]] EQ l0_seq THEN BEGIN 
                                seq_31a[reverse_times[l0_index]] = -1
                                times_31a[reverse_times[l0_index]] = ''
                                found = 1
                            ENDIF ELSE l0_index = l0_index+1
                        ENDIF ELSE found = 1
                    ENDWHILE 
                END 
                '31b'x: BEGIN 
                    l0_seq = packet.dat[0]
                    reverse_times = reverse(sort(times_31b)) ; provides indexes into times
                    found = 0
                    l0_index = 0L
                    WHILE (l0_index LT n_elements(reverse_times)) AND (found EQ 0) DO BEGIN 
                        IF (l0_time LT times_31b[reverse_times[l0_index]]) THEN l0_index = l0_index + 1 ELSE found = 1
                    ENDWHILE
                    found = 0
                    WHILE (l0_index LT n_elements(reverse_times)) AND (found EQ 0) DO BEGIN 
                        IF (l0_time EQ times_31b[reverse_times[l0_index]]) AND (found EQ 0) THEN  BEGIN 
                            IF seq_31b[reverse_times[l0_index]] EQ l0_seq THEN BEGIN 
                                seq_31b[reverse_times[l0_index]] = -1
                                times_31b[reverse_times[l0_index]] = ''
                                found = 1
                            ENDIF ELSE l0_index = l0_index+1
                        ENDIF ELSE found = 1
                    ENDWHILE 
                END 
                '31c'x: BEGIN 
                    l0_seq = packet.dat[0]
                    reverse_times = reverse(sort(times_31c)) ; provides indexes into times
                    found = 0
                    l0_index = 0L
                    WHILE (l0_index LT n_elements(reverse_times)) AND (found EQ 0) DO BEGIN 
                        IF (l0_time LT times_31c[reverse_times[l0_index]]) THEN l0_index = l0_index + 1 ELSE found = 1
                    ENDWHILE
                    found = 0
                    WHILE (l0_index LT n_elements(reverse_times)) AND (found EQ 0) DO BEGIN 
                        IF (l0_time EQ times_31c[reverse_times[l0_index]]) AND (found EQ 0) THEN  BEGIN 
                            IF seq_31c[reverse_times[l0_index]] EQ l0_seq THEN BEGIN 
                                seq_31c[reverse_times[l0_index]] = -1
                                times_31c[reverse_times[l0_index]] = ''
                                found = 1
                            ENDIF ELSE l0_index = l0_index+1
                        ENDIF ELSE found = 1
                    ENDWHILE 
                END 
                '31d'x: BEGIN 
                    l0_seq = packet.dat[0]
                    reverse_times = reverse(sort(times_31d)) ; provides indexes into times
                    found = 0
                    l0_index = 0L
                    WHILE (l0_index LT n_elements(reverse_times)) AND (found EQ 0) DO BEGIN 
                        IF (l0_time LT times_31d[reverse_times[l0_index]]) THEN l0_index = l0_index + 1 ELSE found = 1
                    ENDWHILE
                    found = 0
                    WHILE (l0_index LT n_elements(reverse_times)) AND (found EQ 0) DO BEGIN 
                        IF (l0_time EQ times_31d[reverse_times[l0_index]]) AND (found EQ 0) THEN  BEGIN 
                            IF seq_31d[reverse_times[l0_index]] EQ l0_seq THEN BEGIN 
                                seq_31d[reverse_times[l0_index]] = -1
                                times_31d[reverse_times[l0_index]] = ''
                                found = 1
                            ENDIF ELSE l0_index = l0_index+1
                        ENDIF ELSE found = 1
                    ENDWHILE 
                END 
                '31e'x: BEGIN 
                    l0_seq = packet.dat[0]
                    reverse_times = reverse(sort(times_31e)) ; provides indexes into times
                    found = 0
                    l0_index = 0L
                    WHILE (l0_index LT n_elements(reverse_times)) AND (found EQ 0) DO BEGIN 
                        IF (l0_time LT times_31e[reverse_times[l0_index]]) THEN l0_index = l0_index + 1 ELSE found = 1
                    ENDWHILE
                    found = 0
                    WHILE (l0_index LT n_elements(reverse_times)) AND (found EQ 0) DO BEGIN 
                        IF (l0_time EQ times_31e[reverse_times[l0_index]]) AND (found EQ 0) THEN  BEGIN 
                            IF seq_31e[reverse_times[l0_index]] EQ l0_seq THEN BEGIN 
                                seq_31e[reverse_times[l0_index]] = -1
                                times_31e[reverse_times[l0_index]] = ''
                                found = 1
                            ENDIF ELSE l0_index = l0_index+1
                        ENDIF ELSE found = 1
                    ENDWHILE 
                END 
                '31f'x: BEGIN 
                    l0_seq = packet.dat[0]
                    reverse_times = reverse(sort(times_31f)) ; provides indexes into times
                    found = 0
                    l0_index = 0L
                    WHILE (l0_index LT n_elements(reverse_times)) AND (found EQ 0) DO BEGIN 
                        IF (l0_time LT times_31f[reverse_times[l0_index]]) THEN l0_index = l0_index + 1 ELSE found = 1
                    ENDWHILE
                    found = 0
                    WHILE (l0_index LT n_elements(reverse_times)) AND (found EQ 0) DO BEGIN 
                        IF (l0_time EQ times_31f[reverse_times[l0_index]]) AND (found EQ 0) THEN  BEGIN 
                            IF seq_31f[reverse_times[l0_index]] EQ l0_seq THEN BEGIN 
                                seq_31f[reverse_times[l0_index]] = -1
                                times_31f[reverse_times[l0_index]] = ''
                                found = 1
                            ENDIF ELSE l0_index = l0_index+1
                        ENDIF ELSE found = 1
                    ENDWHILE 
                END 
                '320'x: BEGIN 
                    l0_seq = packet.dat[0]
                    reverse_times = reverse(sort(times_320)) ; provides indexes into times
                    found = 0
                    l0_index = 0L
                    WHILE (l0_index LT n_elements(reverse_times)) AND (found EQ 0) DO BEGIN 
                        IF (l0_time LT times_320[reverse_times[l0_index]]) THEN l0_index = l0_index + 1 ELSE found = 1
                    ENDWHILE
                    found = 0
                    WHILE (l0_index LT n_elements(reverse_times)) AND (found EQ 0) DO BEGIN 
                        IF (l0_time EQ times_320[reverse_times[l0_index]]) AND (found EQ 0) THEN  BEGIN 
                            IF seq_320[reverse_times[l0_index]] EQ l0_seq THEN BEGIN 
                                seq_320[reverse_times[l0_index]] = -1
                                times_320[reverse_times[l0_index]] = ''
                                found = 1
                            ENDIF ELSE l0_index = l0_index+1
                        ENDIF ELSE found = 1
                    ENDWHILE 
                END 
                '321'x: BEGIN 
                    l0_seq = packet.dat[0]
                    reverse_times = reverse(sort(times_321)) ; provides indexes into times
                    found = 0
                    l0_index = 0L
                    WHILE (l0_index LT n_elements(reverse_times)) AND (found EQ 0) DO BEGIN 
                        IF (l0_time LT times_321[reverse_times[l0_index]]) THEN l0_index = l0_index + 1 ELSE found = 1
                    ENDWHILE
                    found = 0
                    WHILE (l0_index LT n_elements(reverse_times)) AND (found EQ 0) DO BEGIN 
                        IF (l0_time EQ times_321[reverse_times[l0_index]]) AND (found EQ 0) THEN  BEGIN 
                            IF seq_321[reverse_times[l0_index]] EQ l0_seq THEN BEGIN 
                                seq_321[reverse_times[l0_index]] = -1
                                times_321[reverse_times[l0_index]] = ''
                                found = 1
                            ENDIF ELSE l0_index = l0_index+1
                        ENDIF ELSE found = 1
                    ENDWHILE 
                END 
                '322'x: BEGIN 
                    l0_seq = packet.dat[0]
                    reverse_times = reverse(sort(times_322)) ; provides indexes into times
                    found = 0
                    l0_index = 0L
                    WHILE (l0_index LT n_elements(reverse_times)) AND (found EQ 0) DO BEGIN 
                        IF (l0_time LT times_322[reverse_times[l0_index]]) THEN l0_index = l0_index + 1 ELSE found = 1
                    ENDWHILE
                    found = 0
                    WHILE (l0_index LT n_elements(reverse_times)) AND (found EQ 0) DO BEGIN 
                        IF (l0_time EQ times_322[reverse_times[l0_index]]) AND (found EQ 0) THEN  BEGIN 
                            IF seq_322[reverse_times[l0_index]] EQ l0_seq THEN BEGIN 
                                seq_322[reverse_times[l0_index]] = -1
                                times_322[reverse_times[l0_index]] = ''
                                found = 1
                            ENDIF ELSE l0_index = l0_index+1
                        ENDIF ELSE found = 1
                    ENDWHILE 
                END 
                '323'x: BEGIN 
                    l0_seq = packet.dat[0]
                    reverse_times = reverse(sort(times_323)) ; provides indexes into times
                    found = 0
                    l0_index = 0L
                    WHILE (l0_index LT n_elements(reverse_times)) AND (found EQ 0) DO BEGIN 
                        IF (l0_time LT times_323[reverse_times[l0_index]]) THEN l0_index = l0_index + 1 ELSE found = 1
                    ENDWHILE
                    found = 0
                    WHILE (l0_index LT n_elements(reverse_times)) AND (found EQ 0) DO BEGIN 
                        IF (l0_time EQ times_323[reverse_times[l0_index]]) AND (found EQ 0) THEN  BEGIN 
                            IF seq_323[reverse_times[l0_index]] EQ l0_seq THEN BEGIN 
                                seq_323[reverse_times[l0_index]] = -1
                                times_323[reverse_times[l0_index]] = ''
                                found = 1
                            ENDIF ELSE l0_index = l0_index+1
                        ENDIF ELSE found = 1
                    ENDWHILE 
                END 
                '324'x: BEGIN 
                    l0_seq = packet.dat[0]
                    reverse_times = reverse(sort(times_324)) ; provides indexes into times
                    found = 0
                    l0_index = 0L
                    WHILE (l0_index LT n_elements(reverse_times)) AND (found EQ 0) DO BEGIN 
                        IF (l0_time LT times_324[reverse_times[l0_index]]) THEN l0_index = l0_index + 1 ELSE found = 1
                    ENDWHILE
                    found = 0
                    WHILE (l0_index LT n_elements(reverse_times)) AND (found EQ 0) DO BEGIN 
                        IF (l0_time EQ times_324[reverse_times[l0_index]]) AND (found EQ 0) THEN  BEGIN 
                            IF seq_324[reverse_times[l0_index]] EQ l0_seq THEN BEGIN 
                                seq_324[reverse_times[l0_index]] = -1
                                times_324[reverse_times[l0_index]] = ''
                                found = 1
                            ENDIF ELSE l0_index = l0_index+1
                        ENDIF ELSE found = 1
                    ENDWHILE 
                END 
                '325'x: BEGIN 
                    l0_seq = packet.dat[0]
                    reverse_times = reverse(sort(times_325)) ; provides indexes into times
                    found = 0
                    l0_index = 0L
                    WHILE (l0_index LT n_elements(reverse_times)) AND (found EQ 0) DO BEGIN 
                        IF (l0_time LT times_325[reverse_times[l0_index]]) THEN l0_index = l0_index + 1 ELSE found = 1
                    ENDWHILE
                    found = 0
                    WHILE (l0_index LT n_elements(reverse_times)) AND (found EQ 0) DO BEGIN 
                        IF (l0_time EQ times_325[reverse_times[l0_index]]) AND (found EQ 0) THEN  BEGIN 
                            IF seq_325[reverse_times[l0_index]] EQ l0_seq THEN BEGIN 
                                seq_325[reverse_times[l0_index]] = -1
                                times_325[reverse_times[l0_index]] = ''
                                found = 1
                            ENDIF ELSE l0_index = l0_index+1
                        ENDIF ELSE found = 1
                    ENDWHILE 
                END 
                '326'x: BEGIN 
                    l0_seq = packet.dat[0]
                    reverse_times = reverse(sort(times_326)) ; provides indexes into times
                    found = 0
                    l0_index = 0L
                    WHILE (l0_index LT n_elements(reverse_times)) AND (found EQ 0) DO BEGIN 
                        IF (l0_time LT times_326[reverse_times[l0_index]]) THEN l0_index = l0_index + 1 ELSE found = 1
                    ENDWHILE
                    found = 0
                    WHILE (l0_index LT n_elements(reverse_times)) AND (found EQ 0) DO BEGIN 
                        IF (l0_time EQ times_326[reverse_times[l0_index]]) AND (found EQ 0) THEN  BEGIN 
                            IF seq_326[reverse_times[l0_index]] EQ l0_seq THEN BEGIN 
                                seq_326[reverse_times[l0_index]] = -1
                                times_326[reverse_times[l0_index]] = ''
                                found = 1
                            ENDIF ELSE l0_index = l0_index+1
                        ENDIF ELSE found = 1
                    ENDWHILE 
                END 
                '327'x: BEGIN 
                    l0_seq = packet.dat[0]
                    reverse_times = reverse(sort(times_327)) ; provides indexes into times
                    found = 0
                    l0_index = 0L
                    WHILE (l0_index LT n_elements(reverse_times)) AND (found EQ 0) DO BEGIN 
                        IF (l0_time LT times_327[reverse_times[l0_index]]) THEN l0_index = l0_index + 1 ELSE found = 1
                    ENDWHILE
                    found = 0
                    WHILE (l0_index LT n_elements(reverse_times)) AND (found EQ 0) DO BEGIN 
                        IF (l0_time EQ times_327[reverse_times[l0_index]]) AND (found EQ 0) THEN  BEGIN 
                            IF seq_327[reverse_times[l0_index]] EQ l0_seq THEN BEGIN 
                                seq_327[reverse_times[l0_index]] = -1
                                times_327[reverse_times[l0_index]] = ''
                                found = 1
                            ENDIF ELSE l0_index = l0_index+1
                        ENDIF ELSE found = 1
                    ENDWHILE 
                END 
                '328'x: BEGIN 
                    l0_seq = 0
                    reverse_times = reverse(sort(times_328)) ; provides indexes into times
                    found = 0
                    l0_index = 0L
                    WHILE (l0_index LT n_elements(reverse_times)) AND (found EQ 0) DO BEGIN 
                        IF (l0_time LT times_328[reverse_times[l0_index]]) THEN l0_index = l0_index + 1 ELSE found = 1
                    ENDWHILE
                    found = 0
                    WHILE (l0_index LT n_elements(reverse_times)) AND (found EQ 0) DO BEGIN 
                        IF (l0_time EQ times_328[reverse_times[l0_index]]) AND (found EQ 0) THEN  BEGIN 
                            IF seq_328[reverse_times[l0_index]] EQ l0_seq THEN BEGIN 
                                seq_328[reverse_times[l0_index]] = -1
                                times_328[reverse_times[l0_index]] = ''
                                found = 1
                            ENDIF ELSE l0_index = l0_index+1
                        ENDIF ELSE found = 1
                    ENDWHILE 
                END 
                '329'x: BEGIN 
                    l0_seq = 0
                    reverse_times = reverse(sort(times_329)) ; provides indexes into times
                    found = 0
                    l0_index = 0L
                    WHILE (l0_index LT n_elements(reverse_times)) AND (found EQ 0) DO BEGIN 
                        IF (l0_time LT times_329[reverse_times[l0_index]]) THEN l0_index = l0_index + 1 ELSE found = 1
                    ENDWHILE
                    found = 0
                    WHILE (l0_index LT n_elements(reverse_times)) AND (found EQ 0) DO BEGIN 
                        IF (l0_time EQ times_329[reverse_times[l0_index]]) AND (found EQ 0) THEN  BEGIN 
                            IF seq_329[reverse_times[l0_index]] EQ l0_seq THEN BEGIN 
                                seq_329[reverse_times[l0_index]] = -1
                                times_329[reverse_times[l0_index]] = ''
                                found = 1
                            ENDIF ELSE l0_index = l0_index+1
                        ENDIF ELSE found = 1
                    ENDWHILE 
                END 
                '370'x: BEGIN 
                    l0_seq = 0
                    reverse_times = reverse(sort(times_370)) ; provides indexes into times
                    found = 0
                    l0_index = 0L
                    WHILE (l0_index LT n_elements(reverse_times)) AND (found EQ 0) DO BEGIN 
                        IF (l0_time LT times_370[reverse_times[l0_index]]) THEN l0_index = l0_index + 1 ELSE found = 1
                    ENDWHILE
                    found = 0
                    WHILE (l0_index LT n_elements(reverse_times)) AND (found EQ 0) DO BEGIN 
                        IF (l0_time EQ times_370[reverse_times[l0_index]]) AND (found EQ 0) THEN  BEGIN 
                            IF seq_370[reverse_times[l0_index]] EQ l0_seq THEN BEGIN 
                                seq_370[reverse_times[l0_index]] = -1
                                times_370[reverse_times[l0_index]] = ''
                                found = 1
                            ENDIF ELSE l0_index = l0_index+1
                        ENDIF ELSE found = 1
                    ENDWHILE 
                END 
                ELSE: BREAK
            ENDCASE 
        ENDIF  
    ENDIF
ENDWHILE
close, l0_lun
free_lun, l0_lun
print, 'Finished l0 file'
    
FOR j = 0L, n_elements(times_313)-1 DO BEGIN
    IF times_313[j] NE '' THEN BEGIN 
        error_st = times_313[j]+tab+'313'+tab+string(seq_313[j], format = '(I2)')
        printf, error_lun, error_st
    ENDIF
ENDFOR 
FOR j = 0L, n_elements(times_315)-1 DO BEGIN
    IF times_315[j] NE '' THEN BEGIN 
        error_st = times_315[j]+tab+'315'+tab+string(seq_315[j], format = '(I2)')
        printf, error_lun, error_st
    ENDIF
ENDFOR 
FOR j = 0L, n_elements(times_316)-1 DO BEGIN
    IF times_316[j] NE '' THEN BEGIN 
        error_st = times_316[j]+tab+'316'+tab+string(seq_316[j], format = '(I2)')
        printf, error_lun, error_st
    ENDIF
ENDFOR 
FOR j = 0L, n_elements(times_317)-1 DO BEGIN
    IF times_317[j] NE '' THEN BEGIN 
        error_st = times_317[j]+tab+'317'+tab+string(seq_317[j], format = '(I2)')
        printf, error_lun, error_st
    ENDIF
ENDFOR 
FOR j = 0L, n_elements(times_318)-1 DO BEGIN
    IF times_318[j] NE '' THEN BEGIN 
        error_st = times_318[j]+tab+'318'+tab+string(seq_318[j], format = '(I2)')
        printf, error_lun, error_st
    ENDIF
ENDFOR 
FOR j = 0L, n_elements(times_319)-1 DO BEGIN
    IF times_319[j] NE '' THEN BEGIN 
        error_st = times_319[j]+tab+'319'+tab+string(seq_319[j], format = '(I2)')
        printf, error_lun, error_st
    ENDIF
ENDFOR 
FOR j = 0L, n_elements(times_31a)-1 DO BEGIN
    IF times_31a[j] NE '' THEN BEGIN 
        error_st = times_31a[j]+tab+'31a'+tab+string(seq_31a[j], format = '(I2)')
        printf, error_lun, error_st
    ENDIF
ENDFOR 
FOR j = 0L, n_elements(times_31b)-1 DO BEGIN
    IF times_31b[j] NE '' THEN BEGIN 
        error_st = times_31b[j]+tab+'31b'+tab+string(seq_31b[j], format = '(I2)')
        printf, error_lun, error_st
    ENDIF
ENDFOR 
FOR j = 0L, n_elements(times_31c)-1 DO BEGIN
    IF times_31c[j] NE '' THEN BEGIN 
        error_st = times_31c[j]+tab+'31c'+tab+string(seq_31c[j], format = '(I2)')
        printf, error_lun, error_st
    ENDIF
ENDFOR 
FOR j = 0L, n_elements(times_31d)-1 DO BEGIN
    IF times_31d[j] NE '' THEN BEGIN 
        error_st = times_31d[j]+tab+'31d'+tab+string(seq_31d[j], format = '(I2)')
        printf, error_lun, error_st
    ENDIF
ENDFOR 
FOR j = 0L, n_elements(times_31e)-1 DO BEGIN
    IF times_31e[j] NE '' THEN BEGIN 
        error_st = times_31e[j]+tab+'31e'+tab+string(seq_31e[j], format = '(I2)')
        printf, error_lun, error_st
    ENDIF
ENDFOR 
FOR j = 0L, n_elements(times_31f)-1 DO BEGIN
    IF times_31f[j] NE '' THEN BEGIN 
        error_st = times_31f[j]+tab+'31f'+tab+string(seq_31f[j], format = '(I2)')
        printf, error_lun, error_st
    ENDIF
ENDFOR 
FOR j = 0L, n_elements(times_320)-1 DO BEGIN
    IF times_320[j] NE '' THEN BEGIN 
        error_st = times_320[j]+tab+'320'+tab+string(seq_320[j], format = '(I2)')
        printf, error_lun, error_st
    ENDIF
ENDFOR 
FOR j = 0L, n_elements(times_321)-1 DO BEGIN
    IF times_321[j] NE '' THEN BEGIN 
        error_st = times_321[j]+tab+'321'+tab+string(seq_321[j], format = '(I2)')
        printf, error_lun, error_st
    ENDIF
ENDFOR 
FOR j = 0L, n_elements(times_322)-1 DO BEGIN
    IF times_322[j] NE '' THEN BEGIN 
        error_st = times_322[j]+tab+'322'+tab+string(seq_322[j], format = '(I2)')
        printf, error_lun, error_st
    ENDIF
ENDFOR 
FOR j = 0L, n_elements(times_323)-1 DO BEGIN
    IF times_323[j] NE '' THEN BEGIN 
        error_st = times_323[j]+tab+'323'+tab+string(seq_323[j], format = '(I2)')
        printf, error_lun, error_st
    ENDIF
ENDFOR 
FOR j = 0L, n_elements(times_324)-1 DO BEGIN
    IF times_324[j] NE '' THEN BEGIN 
        error_st = times_324[j]+tab+'324'+tab+string(seq_324[j], format = '(I2)')
        printf, error_lun, error_st
    ENDIF
ENDFOR 
FOR j = 0L, n_elements(times_325)-1 DO BEGIN
    IF times_325[j] NE '' THEN BEGIN 
        error_st = times_325[j]+tab+'325'+tab+string(seq_325[j], format = '(I2)')
        printf, error_lun, error_st
    ENDIF
ENDFOR 
FOR j = 0L, n_elements(times_326)-1 DO BEGIN
    IF times_326[j] NE '' THEN BEGIN 
        error_st = times_326[j]+tab+'326'+tab+string(seq_326[j], format = '(I2)')
        printf, error_lun, error_st
    ENDIF
ENDFOR 
FOR j = 0L, n_elements(times_327)-1 DO BEGIN
    IF times_327[j] NE '' THEN BEGIN 
        error_st = times_327[j]+tab+'327'+tab+string(seq_327[j], format = '(I2)')
        printf, error_lun, error_st
    ENDIF
ENDFOR 
FOR j = 0L, n_elements(times_328)-1 DO BEGIN
    IF times_328[j] NE '' THEN BEGIN 
        error_st = times_328[j]+tab+'328'+tab+string(seq_328[j], format = '(I2)')
        printf, error_lun, error_st
    ENDIF
ENDFOR 
FOR j = 0L, n_elements(times_329)-1 DO BEGIN
    IF times_329[j] NE '' THEN BEGIN 
        error_st = times_329[j]+tab+'329'+tab+string(seq_329[j], format = '(I2)')
        printf, error_lun, error_st
    ENDIF
ENDFOR 
FOR j = 0L, n_elements(times_370)-1 DO BEGIN
    IF times_370[j] NE '' THEN BEGIN 
        error_st = times_370[j]+tab+'370'+tab+string(seq_370[j], format = '(I2)')
        printf, error_lun, error_st
    ENDIF
ENDFOR 

close, error_lun
free_lun, error_lun

print, "Done ", tlmfilename

END 
