;+
; Project     : STEREO - PLASTIC
;
; Name        : check_l0_tlm.pro
;
; Purpose     : Check L0 file against .tlm file from Berkeley
;               GSE. Checks all data in the .tlm file to see if it is in the Lo file.
;
; Category    : Telemetry, Data-extraction
;
; History     : version 1, 5/19/06, LB Ellis, written
;
; Contact     : Lorna Ellis (Lorna.Ellis@unh.edu)
;-


PRO check_l0_tlm
compile_opt strictarrsubs
tab = STRING(9B)

version = "V01"
tlmfilepath = '/Users/lornaellis/Lorna/Files/Sim3/B060315'
l0filepath = '/Users/lornaellis/Lorna/Files/Sim3'
outfilepath = 'Output'

spacecraft = 'behind'
year_st = '2006'
doy_st = '311'
tlmfilename = 'B0603151236.tlm'
l0filename = 'plastc_behind_2006_311_1_02.fin'

year = fix(year_st)
doy = fix(doy_st)
if n_elements(tlmfilepath) eq 1 then tlmfile = concat_dir(tlmfilepath, tlmfilename) ELSE tlmfile = tlmfilename
if n_elements(l0filepath) eq 1 then l0file = concat_dir(l0filepath, l0filename) ELSE l0file = l0filename

IF spacecraft EQ 'ahead' THEN temp_spacecraft = 'A' ELSE temp_spacecraft = 'B'
IF year LT 2001 OR year GT 2999 THEN print, "Error: invalid year", year
time_utc = doy2utc(doy, year)
time_st = utc2str(time_utc)
month_st = strmid(time_st, 5, 2)
day_st = strmid(time_st, 8, 2)
outfileprefix = 'compare_'+spacecraft+'_'+doy_st+'_'+tlmfilename
if n_elements(outfilepath) eq 1 then outfileprefix = concat_dir(outfilepath, outfileprefix)
errorfilename = outfileprefix+'.errors'
openw, error_lun, errorfilename, /get_lun
printf, error_lun, 'Time'+tab+'Current_Apid'+tab+'Sequence'

; loop through data
apid_array = ['313'x, '315'x, '316'x, '317'x, '318'x, '319'x, '31a'x, '31b'x, '31c'x, '31d'x, '31e'x, '31f'x, '320'x, '321'x, '322'x, '323'x, '324'x, '325'x, '326'x, '327'x, '328'x, '329'x, '370'x]
FOR i = 0, n_elements(apid_array)-1 DO BEGIN 
    current_apid = apid_array[i]
    index = 0
    openr, tlm_lun, tlmfile, /get_lun
    IF (apid_array[i] EQ '328'x) OR (apid_array[i] EQ '329'x) THEN BEGIN 
        times = strarr(100000)
        seq = intarr(100000)
    ENDIF ELSE BEGIN 
        times = strarr(10000)
        seq = intarr(10000)
    ENDELSE 
    packet = 0
    WHILE n_elements(packet) NE 0 DO BEGIN
        read_stereo_pkt, tlm_lun, packet
        IF n_elements(packet) NE 0 THEN BEGIN 
            apid = parse_stereo_pkt(packet, /APID)
            IF apid EQ current_apid THEN BEGIN 
                tlm_time = parse_stereo_pkt(packet, /PKT_DATE, /ccsds)
                CASE apid OF 
                    '313'x: tlm_seq = 0
                    '315'x: tlm_seq = packet.dat[0]
                    '316'x: BEGIN
                        temporary = packet.pkt
                        host_to_ieee, temporary
                        load_bytarr, temporary, bytarr
                        bytarr = [bytarr, packet.dat]
                        tlm_seq = bytarr[10] ; put in header part
                    END 
                    '317'x: BEGIN 
                        temporary = packet.pkt
                        host_to_ieee, temporary
                        load_bytarr, temporary, bytarr
                        bytarr = [bytarr, packet.dat]
                        tlm_seq = bytarr[10] ; put in header part
                    END 
                    '318'x: tlm_seq = 0
                    '319'x: tlm_seq = packet.dat[0]
                    '31a'x: tlm_seq = packet.dat[0]
                    '31b'x: tlm_seq = packet.dat[0]
                    '31c'x: tlm_seq = packet.dat[0]
                    '31d'x: tlm_seq = packet.dat[0]
                    '31e'x: tlm_seq = packet.dat[0]
                    '31f'x: tlm_seq = packet.dat[0]
                    '320'x: tlm_seq = packet.dat[0]
                    '321'x: tlm_seq = packet.dat[0]
                    '322'x: tlm_seq = packet.dat[0]
                    '323'x: tlm_seq = packet.dat[0]
                    '324'x: tlm_seq = packet.dat[0]
                    '325'x: tlm_seq = packet.dat[0]
                    '326'x: tlm_seq = packet.dat[0]
                    '327'x: tlm_seq = packet.dat[0]
                    '328'x: tlm_seq = 0
                    '329'x: tlm_seq = 0
                    '370'x: tlm_seq = 0
                    ELSE: BREAK
                ENDCASE 
                times[index] = tlm_time
                seq[index] = tlm_seq
                index = index + 1
            ENDIF
        ENDIF 
    ENDWHILE
    close, tlm_lun
    free_lun, tlm_lun

    openr, l0_lun, l0file, /get_lun
    packet = 0
    WHILE n_elements(packet) NE 0 DO BEGIN
        reverse_times = reverse(sort(times)) ; provides indexes into times
        read_stereo_pkt, l0_lun, packet
        IF n_elements(packet) NE 0 THEN BEGIN 
            apid = parse_stereo_pkt(packet, /APID)
            IF apid EQ current_apid THEN BEGIN 
                l0_time = parse_stereo_pkt(packet, /PKT_DATE, /ccsds)
                found = 0
                l0_index = 0
                WHILE (l0_index LT n_elements(reverse_times)) AND (found EQ 0) DO BEGIN 
                    IF (l0_time LT times[reverse_times[l0_index]]) THEN l0_index = l0_index + 1 ELSE found = 1
                ENDWHILE
                found = 0
                WHILE (l0_index LT n_elements(reverse_times)) AND (found EQ 0) DO BEGIN 
                    IF (l0_time EQ times[reverse_times[l0_index]]) AND (found EQ 0) THEN  BEGIN 
                        CASE apid OF 
                            '313'x: l0_seq = 0
                            '315'x: l0_seq = packet.dat[0]
                            '316'x: BEGIN
                                temporary = packet.pkt
                                host_to_ieee, temporary
                                load_bytarr, temporary, bytarr
                                bytarr = [bytarr, packet.dat]
                                l0_seq = bytarr[10] ; put in header part
                            END 
                            '317'x: BEGIN 
                                temporary = packet.pkt
                                host_to_ieee, temporary
                                load_bytarr, temporary, bytarr
                                bytarr = [bytarr, packet.dat]
                                l0_seq = bytarr[10] ; put in header part
                            END 
                            '318'x: l0_seq = 0
                            '319'x: l0_seq = packet.dat[0]
                            '31a'x: l0_seq = packet.dat[0]
                            '31b'x: l0_seq = packet.dat[0]
                            '31c'x: l0_seq = packet.dat[0]
                            '31d'x: l0_seq = packet.dat[0]
                            '31e'x: l0_seq = packet.dat[0]
                            '31f'x: l0_seq = packet.dat[0]
                            '320'x: l0_seq = packet.dat[0]
                            '321'x: l0_seq = packet.dat[0]
                            '322'x: l0_seq = packet.dat[0]
                            '323'x: l0_seq = packet.dat[0]
                            '324'x: l0_seq = packet.dat[0]
                            '325'x: l0_seq = packet.dat[0]
                            '326'x: l0_seq = packet.dat[0]
                            '327'x: l0_seq = packet.dat[0]
                            '328'x: l0_seq = 0
                            '329'x: l0_seq = 0
                            '370'x: l0_seq = 0
                            ELSE: BREAK
                        ENDCASE 
                        IF seq[reverse_times[l0_index]] EQ l0_seq THEN BEGIN 
                            seq[reverse_times[l0_index]] = -1
                            times[reverse_times[l0_index]] = ''
                            found = 1
                        ENDIF ELSE l0_index = l0_index+1
                    ENDIF ELSE found = 1
                ENDWHILE 
            ENDIF
        ENDIF 
    ENDWHILE
    close, l0_lun
    free_lun, l0_lun
    
    FOR j = 0L, n_elements(times)-1 DO BEGIN
        IF times[j] NE '' THEN BEGIN 
            error_st = times[j]+tab+string(current_apid, format = '(Z3.3)')+tab+string(seq[j], format = '(I2)')
            printf, error_lun, error_st
        ENDIF
    ENDFOR 
    print, string(apid_array[i], format = '(Z3.3)')
ENDFOR 

close, error_lun
free_lun, error_lun

print, "Done ", tlmfilename

END 
