; This is not an exhaustive algorithm. It only looks at data with
; matching cycle numbers and within 30 seconds of each other.

; 03/28/2007 Check if have data before writing.
; 08/30/2007 Changed so only check abs(diff) for same cycle
; 10/11/2007 Changed so keep 1 min and 5 min variables separate.
; 06/01/2011 Added check for version 10.
; 07/06/2011 Added check for DPU 32A.
; 09/02/2014 Check if cycles_319 gt 0.
; 09/10/2014 Check if have 322 data.
; 02/06/2015 Add new_num_cycles1 (because after add 370 data).
; 02/17/2015 Move check_error for 1min to plastic_process_l0 because
; has to be before check_mom.
; 07/22/2015 Fix problem when very spotty telemetry.
; 07/30/2015 Another one.

PRO check_data, version, temp_spacecraft
compile_opt strictarrsubs
COMMON share1
COMMON share2

FOR i5_h = 0, num_cycles5_heavy-1 DO BEGIN 
    check_error, -1, i5_h, -1
ENDFOR 


;FOR i5_h = 0, num_cycles5_heavy-1 DO BEGIN 
;    e5_h = epochs5_heavy[i5_h]
;    c5_h = cycles5_heavy[i5_h]
;    FOR i1 = 0, num_cycles1-1 DO BEGIN 
;        e1 = epochs1[i1]
;        c1 = cycles1[i1]
;        diff = e1-e5_h
;        IF (c1 EQ c5_h AND abs(diff) LT 30000) OR $
;          ((c1-1 EQ c5_h OR c1-2+256 EQ c5_h) AND diff GT 30000 AND diff LT 90000) OR $
;          ((c1-2 EQ c5_h OR c1-3+256 EQ c5_h) AND diff GT 90000 AND diff LT 150000) OR $
;          ((c1-3 EQ c5_h OR c1-4+256 EQ c5_h) AND diff GT 150000 AND diff LT 210000) OR $
;          ((c1-4 EQ c5_h OR c1-5+256 EQ c5_h) AND diff GT 210000 AND diff LT 270000) THEN BEGIN 
;            IF suspect5_heavy[i5_h] EQ 1 THEN set_end_error, i1, i5_h, -1
;        ENDIF 
;    ENDFOR 
;ENDFOR 

;FOR i1 = 0, num_cycles1-1 DO BEGIN 
;    e1 = epochs1[i1]
;    c1 = cycles1[i1]
;    FOR i5_h = 0, num_cycles5_heavy-1 DO BEGIN 
;        e5_h = epochs5_heavy[i5_h]
;        c5_h = cycles5_heavy[i5_h]
;        diff = e1-e5_h
;        IF (c1 EQ c5_h AND abs(diff) LT 30000) OR $
;          ((c1-1 EQ c5_h OR c1-2+256 EQ c5_h) AND diff GT 30000 AND diff LT 90000) OR $
;          ((c1-2 EQ c5_h OR c1-3+256 EQ c5_h) AND diff GT 90000 AND diff LT 150000) OR $
;          ((c1-3 EQ c5_h OR c1-4+256 EQ c5_h) AND diff GT 150000 AND diff LT 210000) OR $
;          ((c1-4 EQ c5_h OR c1-5+256 EQ c5_h) AND diff GT 210000 AND diff LT 270000) THEN BEGIN 
;            IF suspect1[i1] EQ 1 THEN set_end_error, i1, i5_h, -1
;        ENDIF 
;    ENDFOR 
;ENDFOR 

; I am purposely skipping the 5m check because the monitor rates are
; kind of different

IF num_cycles5_mon GT 0 THEN BEGIN 
    temp_data = suspect5_mon[0:num_cycles5_mon-1]
    cdf_varput, cdf_id, 'error5_mon', temp_data, /zvariable
ENDIF

IF num_cycles5_heavy GT 0 THEN BEGIN
    temp_data = suspect5_heavy[0:num_cycles5_heavy-1]
    IF version LT 10 THEN cdf_varput, cdf_id, 'error5_heavy', temp_data, /zvariable ELSE BEGIN
        suspect_31ab = suspect_31a OR suspect_31b
        suspect_31cd = suspect_31c OR suspect_31d
        cdf_varput, cdf_id, 'error_sw_z>2_h',      suspect_31ab, /zvariable 
        cdf_varput, cdf_id, 'error_sw_z>2_l',      suspect_31cd, /zvariable 
        cdf_varput, cdf_id, 'error_wap_ssd_tcr',   suspect_31e,  /zvariable 
        cdf_varput, cdf_id, 'error_wap_ssd_dcr',   suspect_31f,  /zvariable 
        cdf_varput, cdf_id, 'error_wap_nossd_dcr', suspect_320,  /zvariable 
        cdf_varput, cdf_id, 'error_sw_pri',        suspect_321,  /zvariable 
        cdf_varput, cdf_id, 'error_wap_ssd_pri',   suspect_322,  /zvariable 
        cdf_varput, cdf_id, 'error_wap_nossd_pri', suspect_323,  /zvariable 
    ENDELSE 
    IF version GE 10 THEN BEGIN 
        IF dpu_post_327 EQ 0 THEN BEGIN ; new CDF, old DPU
            cdf_control, cdf_id, get_var_info = info, var = 'cycle_apid319', /zvariable
            cdf_varget, cdf_id, 'cycle_apid319', cycles, rec_count = info.maxrec+1, /zvariable
            cdf_varput, cdf_id, 'cycle_sw_z>2_h',      reform(cycles), /zvariable
            cdf_varput, cdf_id, 'cycle_sw_z>2_l',      reform(cycles), /zvariable
            cdf_varput, cdf_id, 'cycle_wap_ssd_tcr',   reform(cycles), /zvariable
            cdf_varput, cdf_id, 'cycle_wap_ssd_dcr',   reform(cycles), /zvariable
            cdf_varput, cdf_id, 'cycle_wap_nossd_dcr', reform(cycles), /zvariable
            cdf_varput, cdf_id, 'cycle_sw_pri',        reform(cycles), /zvariable
            cdf_varput, cdf_id, 'cycle_wap_ssd_pri',   reform(cycles), /zvariable
            cdf_varput, cdf_id, 'cycle_wap_nossd_pri', reform(cycles), /zvariable
            cdf_control, cdf_id, get_var_info = info, var = 's_chan_apid319', /zvariable
            cdf_varget, cdf_id, 's_chan_apid319', schan, rec_count = info.maxrec+1, /zvariable
            cdf_varput, cdf_id, 's_chan_sw_z>2_h',      reform(schan), /zvariable
            cdf_varput, cdf_id, 's_chan_sw_z>2_l',      reform(schan), /zvariable
            cdf_varput, cdf_id, 's_chan_wap_ssd_tcr',   reform(schan), /zvariable
            cdf_varput, cdf_id, 's_chan_wap_ssd_dcr',   reform(schan), /zvariable
            cdf_varput, cdf_id, 's_chan_wap_nossd_dcr', reform(schan), /zvariable
            cdf_varput, cdf_id, 's_chan_sw_pri',        reform(schan), /zvariable
            cdf_varput, cdf_id, 's_chan_wap_ssd_pri',   reform(schan), /zvariable
            cdf_varput, cdf_id, 's_chan_wap_nossd_pri', reform(schan), /zvariable
        ENDIF ELSE BEGIN ; new DPU (32A)
            ; Check cycles
            cdf_control, cdf_id, get_var_info = cycles_info_319,  var = 'cycle_apid319',       /zvariable
            cdf_control, cdf_id, get_var_info = cycles_info_31ab, var = 'cycle_sw_z>2_h',      /zvariable
            cdf_control, cdf_id, get_var_info = cycles_info_31cd, var = 'cycle_sw_z>2_l',      /zvariable
            cdf_control, cdf_id, get_var_info = cycles_info_31e,  var = 'cycle_wap_ssd_tcr',   /zvariable
            cdf_control, cdf_id, get_var_info = cycles_info_31f,  var = 'cycle_wap_ssd_dcr',   /zvariable
            cdf_control, cdf_id, get_var_info = cycles_info_320,  var = 'cycle_wap_nossd_dcr', /zvariable
            cdf_control, cdf_id, get_var_info = cycles_info_321,  var = 'cycle_sw_pri',        /zvariable
            cdf_control, cdf_id, get_var_info = cycles_info_322,  var = 'cycle_wap_ssd_pri',   /zvariable
            cdf_control, cdf_id, get_var_info = cycles_info_323,  var = 'cycle_wap_nossd_pri', /zvariable
            IF cycles_info_319.maxrec GT 0 THEN BEGIN 
                cdf_varget, cdf_id, 'cycle_apid319',       cycles_319,  rec_count = cycles_info_319.maxrec+1,  /zvariable
            ENDIF 
            IF cycles_info_322.maxrec GT 0 THEN BEGIN 
                cdf_varget, cdf_id, 'cycle_wap_ssd_pri',   cycles_322,  rec_count = cycles_info_322.maxrec+1,  /zvariable
            ENDIF 
            IF n_elements(cycles_319) EQ 0 AND n_elements(cycles_322) EQ 0 THEN BEGIN ; sidelobe 2
               IF cycles_info_321.maxrec GT 0 THEN BEGIN
                  cdf_varget, cdf_id, 'cycle_sw_pri',   cycles_321,  rec_count = cycles_info_321.maxrec+1,  /zvariable
                  temp_cycles = cycles_321
               ENDIF 
            ENDIF ELSE IF n_elements(cycles_319) EQ 0 THEN BEGIN ; sidelobe 1
                cdf_varget, cdf_id, 'cycle_wap_ssd_pri',   cycles_322,  rec_count = cycles_info_322.maxrec+1,  /zvariable
                temp_cycles = cycles_322
            ENDIF ELSE temp_cycles = cycles_319
            IF n_elements(temp_cycles) EQ 0 THEN BEGIN ; spotty telemetry
               IF cycles_info_323.maxrec GT 0 THEN BEGIN
                  cdf_varget, cdf_id, 'cycle_wap_nossd_pri',   cycles_323,  rec_count = cycles_info_323.maxrec+1,  /zvariable
                  temp_cycles = cycles_323
               ENDIF 
           ENDIF 
            IF cycles_info_31ab.maxrec GT 0 THEN BEGIN 
                cdf_varget, cdf_id, 'cycle_sw_z>2_h',      cycles_31ab, rec_count = cycles_info_31ab.maxrec+1, /zvariable
                bad_31ab = where((temp_cycles NE cycles_31ab) AND (cycles_31ab NE -1), bad_31ab_count)
                IF bad_31ab_count GT 0 THEN BEGIN
                    FOR bad_i = 0, bad_31ab_count-1 DO BEGIN 
                        printf, error_lun, 'Check data: 31AB mismatching cycle ', time_string(epochs5_heavy[bad_31ab[bad_i]], /epoch), $
                                temp_cycles[bad_31ab[bad_i]], cycles_31ab[bad_31ab[bad_i]] 
                    ENDFOR 
                ENDIF 
            ENDIF 
            IF cycles_info_31cd.maxrec GT 0 THEN BEGIN 
                cdf_varget, cdf_id, 'cycle_sw_z>2_l',      cycles_31cd, rec_count = cycles_info_31cd.maxrec+1, /zvariable
                bad_31cd = where((temp_cycles NE cycles_31cd) AND (cycles_31cd NE -1), bad_31cd_count)
                IF bad_31cd_count GT 0 THEN BEGIN
                    FOR bad_i = 0, bad_31cd_count-1 DO BEGIN 
                        printf, error_lun, 'Check data: 31CD mismatching cycle ', time_string(epochs5_heavy[bad_31cd[bad_i]], /epoch), $
                                temp_cycles[bad_31cd[bad_i]], cycles_31cd[bad_31cd[bad_i]] 
                    ENDFOR 
                ENDIF 
            ENDIF 
            IF cycles_info_31e.maxrec GT 0 THEN BEGIN 
                cdf_varget, cdf_id, 'cycle_wap_ssd_tcr',   cycles_31e,  rec_count = cycles_info_31e.maxrec+1,  /zvariable
                bad_31e  = where((temp_cycles NE cycles_31e ) AND (cycles_31e  NE -1), bad_31e_count)
                IF bad_31e_count GT 0 THEN BEGIN
                    FOR bad_i = 0, bad_31e_count-1 DO BEGIN 
                        printf, error_lun, 'Check data: 31E mismatching cycle ', time_string(epochs5_heavy[bad_31e[bad_i]], /epoch), $
                                temp_cycles[bad_31e[bad_i]], cycles_31e[bad_31e[bad_i]] 
                    ENDFOR 
                ENDIF 
            ENDIF 
            IF cycles_info_31f.maxrec GT 0 THEN BEGIN 
                cdf_varget, cdf_id, 'cycle_wap_ssd_dcr',   cycles_31f,  rec_count = cycles_info_31f.maxrec+1,  /zvariable
                bad_31f  = where((temp_cycles NE cycles_31f ) AND (cycles_31f  NE -1), bad_31f_count)
                IF bad_31f_count GT 0 THEN BEGIN
                    FOR bad_i = 0, bad_31f_count-1 DO BEGIN 
                        printf, error_lun, 'Check data: 31F mismatching cycle ', time_string(epochs5_heavy[bad_31f[bad_i]], /epoch), $
                                temp_cycles[bad_31f[bad_i]], cycles_31f[bad_31f[bad_i]] 
                    ENDFOR 
                ENDIF 
            ENDIF 
            IF cycles_info_320.maxrec GT 0 THEN BEGIN 
                cdf_varget, cdf_id, 'cycle_wap_nossd_dcr', cycles_320,  rec_count = cycles_info_320.maxrec+1,  /zvariable
                bad_320  = where((temp_cycles NE cycles_320 ) AND (cycles_320  NE -1), bad_320_count)
                IF bad_320_count GT 0 THEN BEGIN
                    FOR bad_i = 0, bad_320_count-1 DO BEGIN 
                        printf, error_lun, 'Check data: 320 mismatching cycle ', time_string(epochs5_heavy[bad_320[bad_i]], /epoch), $
                                temp_cycles[bad_320[bad_i]], cycles_320[bad_320[bad_i]] 
                    ENDFOR 
                ENDIF 
            ENDIF 
            IF cycles_info_321.maxrec GT 0 THEN BEGIN 
                cdf_varget, cdf_id, 'cycle_sw_pri',        cycles_321,  rec_count = cycles_info_321.maxrec+1,  /zvariable
                bad_321  = where((temp_cycles NE cycles_321 ) AND (cycles_321  NE -1), bad_321_count)
                IF bad_321_count GT 0 THEN BEGIN
                    FOR bad_i = 0, bad_321_count-1 DO BEGIN 
                        printf, error_lun, 'Check data: 321 mismatching cycle ', time_string(epochs5_heavy[bad_321[bad_i]], /epoch), $
                                temp_cycles[bad_321[bad_i]], cycles_321[bad_321[bad_i]] 
                    ENDFOR 
                ENDIF 
            ENDIF 
            IF cycles_info_322.maxrec GT 0 THEN BEGIN 
                cdf_varget, cdf_id, 'cycle_wap_ssd_pri',   cycles_322,  rec_count = cycles_info_322.maxrec+1,  /zvariable
                bad_322  = where((temp_cycles NE cycles_322 ) AND (cycles_322  NE -1), bad_322_count)
                IF bad_322_count GT 0 THEN BEGIN
                    FOR bad_i = 0, bad_322_count-1 DO BEGIN 
                        printf, error_lun, 'Check data: 322 mismatching cycle ', time_string(epochs5_heavy[bad_322[bad_i]], /epoch), $
                                temp_cycles[bad_322[bad_i]], cycles_322[bad_322[bad_i]] 
                    ENDFOR 
                ENDIF 
            ENDIF 
            IF cycles_info_323.maxrec GT 0 THEN BEGIN 
                cdf_varget, cdf_id, 'cycle_wap_nossd_pri', cycles_323,  rec_count = cycles_info_323.maxrec+1,  /zvariable
                bad_323  = where((temp_cycles NE cycles_323 ) AND (cycles_323  NE -1), bad_323_count)
                IF bad_323_count GT 0 THEN BEGIN
                    FOR bad_i = 0, bad_323_count-1 DO BEGIN 
                        printf, error_lun, 'Check data: 323 mismatching cycle ', time_string(epochs5_heavy[bad_323[bad_i]], /epoch), $
                                temp_cycles[bad_323[bad_i]], cycles_323[bad_323[bad_i]] 
                    ENDFOR 
                ENDIF 
            ENDIF 

            ; check SChan
            cdf_control, cdf_id, get_var_info = schan_info_319,  var = 's_chan_apid319',       /zvariable
            cdf_control, cdf_id, get_var_info = schan_info_31ab, var = 's_chan_sw_z>2_h',      /zvariable
            cdf_control, cdf_id, get_var_info = schan_info_31cd, var = 's_chan_sw_z>2_l',      /zvariable
            cdf_control, cdf_id, get_var_info = schan_info_31e,  var = 's_chan_wap_ssd_tcr',   /zvariable
            cdf_control, cdf_id, get_var_info = schan_info_31f,  var = 's_chan_wap_ssd_dcr',   /zvariable
            cdf_control, cdf_id, get_var_info = schan_info_320,  var = 's_chan_wap_nossd_dcr', /zvariable
            cdf_control, cdf_id, get_var_info = schan_info_321,  var = 's_chan_sw_pri',        /zvariable
            cdf_control, cdf_id, get_var_info = schan_info_322,  var = 's_chan_wap_ssd_pri',   /zvariable
            cdf_control, cdf_id, get_var_info = schan_info_323,  var = 's_chan_wap_nossd_pri', /zvariable
            IF schan_info_319.maxrec GT 0 THEN BEGIN 
                cdf_varget, cdf_id, 's_chan_apid319',       schan_319,  rec_count = schan_info_319.maxrec+1,  /zvariable
            ENDIF 
            IF n_elements(cycles_319) EQ 0 THEN BEGIN
                cdf_varget, cdf_id, 's_chan_wap_ssd_pri',   schan_322,  rec_count = schan_info_322.maxrec+1,  /zvariable
                temp_schan = schan_322
            ENDIF ELSE temp_schan = schan_319
            IF schan_info_31ab.maxrec GT 0 THEN BEGIN 
                cdf_varget, cdf_id, 's_chan_sw_z>2_h',      schan_31ab, rec_count = schan_info_31ab.maxrec+1, /zvariable
                bad_31ab = where((temp_schan NE schan_31ab) AND (schan_31ab NE -1), bad_31ab_count)
                IF bad_31ab_count GT 0 THEN BEGIN
                    FOR bad_i = 0, bad_31ab_count-1 DO BEGIN 
                        printf, error_lun, 'Check data: 31AB mismatching schan ', time_string(epochs5_heavy[bad_31ab[bad_i]], /epoch), $
                                temp_schan, schan_31ab[bad_31ab[bad_i]]
                    ENDFOR
                ENDIF 
            ENDIF 
            IF schan_info_31cd.maxrec GT 0 THEN BEGIN 
                cdf_varget, cdf_id, 's_chan_sw_z>2_l',      schan_31cd, rec_count = schan_info_31cd.maxrec+1, /zvariable
                bad_31cd = where((temp_schan NE schan_31cd) AND (schan_31cd NE -1), bad_31cd_count)
                IF bad_31cd_count GT 0 THEN BEGIN
                    FOR bad_i = 0, bad_31cd_count-1 DO BEGIN 
                        printf, error_lun, 'Check data: 31CD mismatching schan ', time_string(epochs5_heavy[bad_31cd[bad_i]], /epoch), $
                                temp_schan, schan_31cd[bad_31cd[bad_i]]
                    ENDFOR
                ENDIF 
            ENDIF 
            IF schan_info_31e.maxrec GT 0 THEN BEGIN 
                cdf_varget, cdf_id, 's_chan_wap_ssd_tcr',   schan_31e,  rec_count = schan_info_31e.maxrec+1,  /zvariable
                bad_31e  = where((temp_schan NE schan_31e ) AND (schan_31e  NE -1), bad_31e_count)
                IF bad_31e_count GT 0 THEN BEGIN
                    FOR bad_i = 0, bad_31e_count-1 DO BEGIN 
                        printf, error_lun, 'Check data: 31E mismatching schan ', time_string(epochs5_heavy[bad_31e[bad_i]], /epoch), $
                                temp_schan, schan_31e[bad_31e[bad_i]]
                    ENDFOR
                ENDIF 
            ENDIF 
            IF schan_info_31f.maxrec GT 0 THEN BEGIN 
                cdf_varget, cdf_id, 's_chan_wap_ssd_dcr',   schan_31f,  rec_count = schan_info_31f.maxrec+1,  /zvariable
                bad_31f  = where((temp_schan NE schan_31f ) AND (schan_31f  NE -1), bad_31f_count)
                IF bad_31f_count GT 0 THEN BEGIN
                    FOR bad_i = 0, bad_31f_count-1 DO BEGIN 
                        printf, error_lun, 'Check data: 31F mismatching schan ', time_string(epochs5_heavy[bad_31f[bad_i]], /epoch), $
                                temp_schan, schan_31f[bad_31f[bad_i]]
                    ENDFOR
                ENDIF 
            ENDIF 
            IF schan_info_320.maxrec GT 0 THEN BEGIN 
                cdf_varget, cdf_id, 's_chan_wap_nossd_dcr', schan_320,  rec_count = schan_info_320.maxrec+1,  /zvariable
                bad_320  = where((temp_schan NE schan_320 ) AND (schan_320  NE -1), bad_320_count)
                IF bad_320_count GT 0 THEN BEGIN
                    FOR bad_i = 0, bad_320_count-1 DO BEGIN 
                        printf, error_lun, 'Check data: 320 mismatching schan ', time_string(epochs5_heavy[bad_320[bad_i]], /epoch), $
                                temp_schan, schan_320[bad_320[bad_i]]
                    ENDFOR
                ENDIF 
            ENDIF 
            IF schan_info_321.maxrec GT 0 THEN BEGIN 
                cdf_varget, cdf_id, 's_chan_sw_pri',        schan_321,  rec_count = schan_info_321.maxrec+1,  /zvariable
                bad_321  = where((temp_schan NE schan_321 ) AND (schan_321  NE -1), bad_321_count)
                IF bad_321_count GT 0 THEN BEGIN
                    FOR bad_i = 0, bad_321_count-1 DO BEGIN 
                        printf, error_lun, 'Check data: 321 mismatching schan ', time_string(epochs5_heavy[bad_321[bad_i]], /epoch), $
                                temp_schan, schan_321[bad_321[bad_i]]
                    ENDFOR
                ENDIF 
            ENDIF 
            IF schan_info_322.maxrec GT 0 THEN BEGIN 
                cdf_varget, cdf_id, 's_chan_wap_ssd_pri',   schan_322,  rec_count = schan_info_322.maxrec+1,  /zvariable
                bad_322  = where((temp_schan NE schan_322 ) AND (schan_322  NE -1), bad_322_count)
                IF bad_322_count GT 0 THEN BEGIN
                    FOR bad_i = 0, bad_322_count-1 DO BEGIN 
                        printf, error_lun, 'Check data: 322 mismatching schan ', time_string(epochs5_heavy[bad_322[bad_i]], /epoch), $
                                temp_schan, schan_322[bad_322[bad_i]]
                    ENDFOR
                ENDIF 
            ENDIF 
            IF schan_info_323.maxrec GT 0 THEN BEGIN 
                cdf_varget, cdf_id, 's_chan_wap_nossd_pri', schan_323,  rec_count = schan_info_323.maxrec+1,  /zvariable
                bad_323  = where((temp_schan NE schan_323 ) AND (schan_323  NE -1), bad_323_count)
                IF bad_323_count GT 0 THEN BEGIN
                    FOR bad_i = 0, bad_323_count-1 DO BEGIN 
                       printf, error_lun, 'Check data: 323 mismatching schan ', time_string(epochs5_heavy[bad_323[bad_i]], /epoch), $
                                temp_schan, schan_323[bad_323[bad_i]]
                    ENDFOR
                ENDIF 
            ENDIF 
  
            cdf_control, cdf_id, get_var_info = epoch1_info, var = 'epoch1',      /zvariable
            cdf_control, cdf_id, get_var_info = schan1_info, var = 's_chan1',     /zvariable
            cdf_control, cdf_id, get_var_info = epoch5_info, var = 'epoch_heavy', /zvariable
            IF (epoch1_info.maxrec GT 0) THEN BEGIN 
                IF schan1_info.maxrec NE epoch1_info.maxrec THEN $
                  printf, error_lun, timestamp, 'Check data: Schan1 does not match epoch 1'
                cdf_varget, cdf_id, 'epoch1',  epochs1, rec_count = epoch1_info.maxrec+1, /zvariable
                cdf_varget, cdf_id, 's_chan1', schan1,  rec_count = epoch1_info.maxrec+1, /zvariable
            ENDIF 
            cdf_varget, cdf_id, 'epoch_heavy',  epoch5, rec_count = epoch5_info.maxrec+1, /zvariable
            new_num_cycles1 = epoch1_info.maxrec+1

            ; check num_summed (end of day is concern)
            cdf_control, cdf_id, get_var_info = summed_info_31ab, var = 'num_summed_sw_z>2_h',      /zvariable
            cdf_control, cdf_id, get_var_info = summed_info_31cd, var = 'num_summed_sw_z>2_l',      /zvariable
            cdf_control, cdf_id, get_var_info = summed_info_31e,  var = 'num_summed_wap_ssd_tcr',   /zvariable
            cdf_control, cdf_id, get_var_info = summed_info_31f,  var = 'num_summed_wap_ssd_dcr',   /zvariable
            cdf_control, cdf_id, get_var_info = summed_info_320,  var = 'num_summed_wap_nossd_dcr', /zvariable
            cdf_control, cdf_id, get_var_info = summed_info_321,  var = 'num_summed_sw_pri',        /zvariable
            cdf_control, cdf_id, get_var_info = summed_info_322,  var = 'num_summed_wap_ssd_pri',   /zvariable
            cdf_control, cdf_id, get_var_info = summed_info_323,  var = 'num_summed_wap_nossd_pri', /zvariable
            IF (summed_info_31ab.maxrec GT 0) AND (cycles_info_31ab.maxrec GT 0) THEN BEGIN 
                cdf_varget, cdf_id, 'num_summed_sw_z>2_h',      summed_31ab, rec_count = summed_info_31ab.maxrec+1, /zvariable
                bad_31ab = where((cycles_31ab NE -1) AND (reform(summed_31ab[0, *]) EQ 1), bad_31ab_count)
                IF bad_31ab_count GT 0 THEN printf, error_lun, timestamp, ' Check data: 31AB missing num_summed: '+string(bad_31ab)
            ENDIF 
            IF (summed_info_31cd.maxrec GT 0) AND (cycles_info_31cd.maxrec GT 0) THEN BEGIN 
                cdf_varget, cdf_id, 'num_summed_sw_z>2_l',      summed_31cd, rec_count = summed_info_31cd.maxrec+1, /zvariable
                bad_31cd = where((cycles_31cd NE -1) AND (reform(summed_31cd[0, *]) EQ 1), bad_31cd_count)
                IF bad_31cd_count GT 0 THEN printf, error_lun, timestamp, ' Check data: 31CD missing num_summed: '+string(bad_31cd)
            ENDIF 
            IF (summed_info_31e.maxrec GT 0) AND (cycles_info_31e.maxrec GT 0) THEN BEGIN 
                cdf_varget, cdf_id, 'num_summed_wap_ssd_tcr',   summed_31e,  rec_count = summed_info_31e.maxrec+1,  /zvariable
                bad_31e  = where((cycles_31e  NE -1) AND (reform(summed_31e [0, *]) EQ 1), bad_31e_count)
                IF bad_31e_count  GT 0 THEN printf, error_lun, timestamp, ' Check data: 31E missing num_summed: ' +string(bad_31e)
            ENDIF 
            IF (summed_info_31f.maxrec GT 0) AND (cycles_info_31f.maxrec GT 0) THEN BEGIN 
                cdf_varget, cdf_id, 'num_summed_wap_ssd_dcr',   summed_31f,  rec_count = summed_info_31f.maxrec+1,  /zvariable
                bad_31f  = where((cycles_31f  NE -1) AND (reform(summed_31f [0, *]) EQ 1), bad_31f_count)
                IF bad_31f_count  GT 0 THEN printf, error_lun, timestamp, ' Check data: 31F missing num_summed: ' +string(bad_31f)
            ENDIF 
            IF (summed_info_320.maxrec GT 0) AND (cycles_info_320.maxrec GT 0) THEN BEGIN 
                cdf_varget, cdf_id, 'num_summed_wap_nossd_dcr', summed_320,  rec_count = summed_info_320.maxrec+1,  /zvariable
                bad_320  = where((cycles_320  NE -1) AND (reform(summed_320 [0, *]) EQ 1), bad_320_count)
                IF bad_320_count  GT 0 THEN printf, error_lun, timestamp, ' Check data: 320 missing num_summed: ' +string(bad_320)
            ENDIF 
            IF ((summed_info_321.maxrec GT 0) AND (cycles_info_321.maxrec GT 0)) THEN BEGIN 
                cdf_varget, cdf_id, 'num_summed_sw_pri',        summed_321,  rec_count = summed_info_321.maxrec+1,  /zvariable
                bad_321  = where((cycles_321  NE -1) AND (reform(summed_321 [0, *]) EQ 1), bad_321_count)
                IF bad_321_count  GT 0 THEN printf, error_lun, timestamp, ' Check data: 321 missing num_summed: ' +string(bad_321)
            ENDIF ELSE summed_321 = -1
            IF have_telem_vers[2] EQ 1 OR have_telem_vers[3] EQ 1 THEN BEGIN ; sidelobe 
                IF (cycles_info_321.maxrec GT 0) THEN BEGIN 
                    cdf_varget, cdf_id, 'sw_priority',              sw_pri,  rec_count = cycles_info_321.maxrec+1,  /zvariable
                    IF (strmid(timestamp, 0, 10) EQ '2014-08-05') OR (strmid(timestamp, 0, 10) EQ '2014-08-06') THEN $
                      find_num_summed, '321', summed_321, sw_pri, 5, temp_spacecraft, new_num_cycles1 ELSE $
                      find_num_summed, '321', summed_321, sw_pri, 20, temp_spacecraft, new_num_cycles1
                    cdf_varput, cdf_id, 'num_summed_sw_pri',    summed_321,  /zvariable
                ENDIF 
            ENDIF 
            IF ((summed_info_322.maxrec GT 0) AND (cycles_info_322.maxrec GT 0)) THEN BEGIN 
                cdf_varget, cdf_id, 'num_summed_wap_ssd_pri',   summed_322,  rec_count = summed_info_322.maxrec+1,  /zvariable
                bad_322  = where((cycles_322  NE -1) AND (reform(summed_322 [0, *]) EQ 1), bad_322_count)
                IF bad_322_count  GT 0 THEN printf, error_lun, timestamp, ' Check data: 322 missing num_summed: ' +string(bad_322)
            ENDIF ELSE summed_322 = -1
            IF have_telem_vers[2] EQ 1 OR have_telem_vers[3] EQ 1 THEN BEGIN ; sidelobe 
                IF (cycles_info_322.maxrec GT 0) THEN BEGIN 
                    cdf_varget, cdf_id, 'wap_priority_ssd',    wap_ssd_pri,  rec_count = cycles_info_322.maxrec+1,  /zvariable
                    find_num_summed, '322', summed_322, wap_ssd_pri, 5, temp_spacecraft, new_num_cycles1
                    cdf_varput, cdf_id, 'num_summed_wap_ssd_pri',    summed_322,  /zvariable
                ENDIF 
            ENDIF 
            IF ((summed_info_323.maxrec GT 0) AND (cycles_info_323.maxrec GT 0)) THEN BEGIN 
                cdf_varget, cdf_id, 'num_summed_wap_nossd_pri', summed_323,  rec_count = summed_info_323.maxrec+1,  /zvariable
                bad_323  = where((cycles_323  NE -1) AND (reform(summed_323 [0, *]) EQ 1), bad_323_count)
                IF bad_323_count  GT 0 THEN printf, error_lun, timestamp, ' Check data: 323 missing num_summed: ' +string(bad_323)
            ENDIF ELSE summed_323 = -1
            IF have_telem_vers[2] EQ 1 OR have_telem_vers[3] EQ 1 THEN BEGIN ; sidelobe 
                IF (cycles_info_323.maxrec GT 0) THEN BEGIN 
                    cdf_varget, cdf_id, 'wap_priority_no_ssd', wap_nossd_pri,  rec_count = cycles_info_323.maxrec+1,  /zvariable
                    find_num_summed, '323', summed_323, wap_nossd_pri, 5, temp_spacecraft, new_num_cycles1
                    cdf_varput, cdf_id, 'num_summed_wap_nossd_pri',    summed_323,  /zvariable
                ENDIF 
            ENDIF 
        ENDELSE 
    ENDIF 
ENDIF 
END 
