PRO check_cycle5_heavy, new_cycle, new_schan, version
compile_opt strictarrsubs
COMMON share1
COMMON share2
COMMON com_heavy
IF num_cycles5_heavy GT 0 THEN last_cycle = cycles5_heavy[num_cycles5_heavy-1] ELSE last_cycle = -1
IF new_cycle NE last_cycle AND last_cycle NE -1 THEN $
  printf, error_lun, 'Non-matching cycle counts ', string(apid, format = '(Z)'), ' ', timestamp $
ELSE BEGIN 
    temp_epoch = epochs5_heavy[num_cycles5_heavy-1]
    time_diff = abs(pkt_epoch-temp_epoch)
    IF (time_diff GT 90000) $ ; 60000 would be one minute
      THEN BEGIN 
        temp = cdf2utc(temp_epoch)
        temp_timestamp = anytim2utc(temp, /ccsds)
        temp_string = timestamp+" same cycle num for more than a minute: "+string(fix(new_cycle))+' '+$
                      string(apid, format = '(Z)')+' '+temp_timestamp
        printf, error_lun, temp_string
        suspect5_heavy[num_cycles5_heavy-1] = 1
        suspect5_heavy[num_cycles5_heavy] = 1
        write_cycle5_heavy, new_cycle, new_schan, pkt_epoch
    ENDIF ELSE BEGIN 
        CASE apid OF
            '319'x: wrote = wrote_319
            '31a'x: wrote = wrote_31a
            '31b'x: wrote = wrote_31b
            '31c'x: wrote = wrote_31c
            '31d'x: wrote = wrote_31d
            '31e'x: wrote = wrote_31e
            '31f'x: wrote = wrote_31f
            '320'x: wrote = wrote_320
            '321'x: wrote = wrote_321
            '322'x: wrote = wrote_322
            '323'x: wrote = wrote_323
        ENDCASE 
        IF (time_diff LT 30000) AND (wrote[num_cycles5_heavy-1] EQ 1) THEN BEGIN 
            temp = cdf2utc(temp_epoch)
            temp_timestamp = anytim2utc(temp, /ccsds)
            temp_string = timestamp+" cycles too close: "+string(fix(new_cycle))+' '+string(apid, format = '(Z)')+' '+temp_timestamp
            printf, error_lun, temp_string
            suspect5_heavy[num_cycles5_heavy-1] = 1
            suspect5_heavy[num_cycles5_heavy] = 1
            write_cycle5_heavy, new_cycle, new_schan, pkt_epoch
        ENDIF ELSE BEGIN 
            old_schan = schan5_heavy[num_cycles5_heavy-1]
            IF old_schan EQ -1 THEN BEGIN 
                schan5_heavy[num_cycles5_heavy-1] = new_schan 
                IF version LT 10 THEN cdf_varput, cdf_id, 's_chan5_heavy', new_schan, rec_start = num_cycles5_heavy-1 ELSE $
                  cdf_varput, cdf_id, 's_chan_apid319', new_schan, rec_start = num_cycles5_heavy-1
            ENDIF ELSE IF new_schan EQ -1 THEN dummy = dummy ELSE IF old_schan NE new_schan THEN BEGIN 
                printf, error_lun, 'Non-matching schan ', timestamp, ' ', old_schan, ' ', new_schan, ' ', string(apid, format = '(Z)')
                suspect5_heavy[num_cycles5_heavy-1] = 1
            ENDIF 
        ENDELSE 
    ENDELSE 
ENDELSE 
END 

