; 09/07/2007 don't check schan if in eng mode (i.e. if apid eq 316), and mode for apid 317
; 09/26/2007 Changed format of error messages.

; NB: mode parameter is only set if apid is 317!!!

PRO check_cycle1, new_cycle, new_schan, mode
compile_opt strictarrsubs
COMMON share1
COMMON share2
IF num_cycles1 GT 0 THEN last_cycle = cycles1[num_cycles1-1] ELSE last_cycle = -1
IF new_cycle NE last_cycle AND last_cycle NE -1 THEN BEGIN 
    printf, error_lun, timestamp, ' Non-matching cycles ', string(apid, format = '(Z3.3)'), ' ', new_cycle, ' ', last_cycle
ENDIF ELSE BEGIN 
    temp_epoch = epochs1[num_cycles1-1]
    time_diff = abs(pkt_epoch-temp_epoch)
    IF (time_diff GT 90000) $ ; 60000 would be one minute
      THEN BEGIN 
        IF pkt_epoch GT temp_epoch THEN BEGIN 
            temp = cdf2utc(temp_epoch)
            temp_timestamp = anytim2utc(temp, /ccsds)
            temp_string = timestamp+" same cycle num for more than a minute: "+string(fix(new_cycle))+' '+$
                          string(apid, format = '(Z)')+' '+temp_timestamp
            printf, error_lun, temp_string
            suspect1[num_cycles1-1] = 1
            suspect1[num_cycles1] = 1
            write_cycle1, new_cycle, new_schan, pkt_epoch
        ENDIF 
    ENDIF ELSE BEGIN 
        CASE apid OF
            '315'x: wrote = wrote_315
            '316'x: wrote = wrote_316_1
            '317'x: wrote = wrote_317
            '324'x: wrote = wrote_324
            '325'x: wrote = wrote_325
            '326'x: wrote = wrote_326
            '327'x: wrote = wrote_327
        ENDCASE 
        eng_mode = 0
        IF (apid EQ '316'x) THEN eng_mode = 1
        IF apid EQ '317'x THEN BEGIN
            IF mode NE 1 THEN eng_mode = 1
        ENDIF 
        IF (time_diff LT 30000) AND (wrote[num_cycles1-1] EQ 1) THEN BEGIN 
            temp = cdf2utc(temp_epoch)
            temp_timestamp = anytim2utc(temp, /ccsds)
            temp_string = timestamp+" check_cycle1: cycles too close: "+string(fix(new_cycle))+' '+string(apid, format = '(Z)')+' '+$
                          temp_timestamp
            printf, error_lun, temp_string
            suspect1[num_cycles1-1] = 1
            suspect1[num_cycles1] = 1
            write_cycle1, new_cycle, new_schan, pkt_epoch
        ENDIF ELSE BEGIN 
            old_schan = schan1[num_cycles1-1]
            IF old_schan EQ -1 THEN BEGIN 
                schan1[num_cycles1-1] = new_schan 
                cdf_varput, cdf_id, 's_chan1', new_schan, rec_start = num_cycles1-1
            ENDIF ELSE IF (new_schan EQ -1) OR eng_mode EQ 1 THEN dummy = dummy ELSE IF old_schan NE new_schan THEN BEGIN 
                printf, error_lun, timestamp, ' Non-matching schan ', old_schan, ' ', new_schan, ' ', $
                        string(apid, format = '(Z)')
                suspect1[num_cycles1-1] = 1
            ENDIF 
        ENDELSE 
    ENDELSE 
ENDELSE 
END 

