; Lorna Ellis
; 3/13/2007
; check_cdfs.pro

; This looks in a directory with CDF files and checks to make sure
; that we don't have only science cdfs or only the sphk cdf for any
; given day. If we are missing one, it attempts to copy it over

; parameters:
;   in: datadir    : root of path to where CDFs reside (through Spacecraft_)
;       cdfdir     : within datadir, where to find CDFs (should then have
;                    year below this)
;       cdfreadpath: directory in which to copy CDFs that we want to
;                    use in cdf_read


PRO check_cdfs, datadir, cdfdir, cdfreadpath
compile_opt strictarrsubs

temp_st = cdfreadpath+'/*'
files_found = file_search(temp_st, count = num_files, /test_regular)
files_found = file_basename(files_found)
num_days = 0
IF num_files GT 0 THEN BEGIN ; ignore if no files there

    ; find spacecraft, year, and doy 
    FOR ii = 0, num_files-1 DO BEGIN 
        file = files_found[ii]
        sat = strmid(file, 2, 1)
        IF strlen(file) EQ 31 THEN BEGIN
            year_st = strmid(file, 11, 4)
            doy_st = strmid(file, 20, 3)
            end_st = strmid(file, 11, 20)
        ENDIF ELSE BEGIN 
            year_st = strmid(file, 14, 4)
            doy_st = strmid(file, 23, 3)
            end_st = strmid(file, 14, 20)
        ENDELSE 
        IF num_days EQ 0 THEN BEGIN
            sats = [sat]
            years = [year_st]
            doys = [doy_st]
            ends = [end_st]
            num_files_per_doy = [1]
            num_days = 1
        ENDIF ELSE BEGIN 
            found = 0
            FOR jj = 0, n_elements(sats)-1 DO BEGIN 
                IF sat EQ sats[jj] AND year_st EQ years[jj] AND doy_st EQ doys[jj] THEN BEGIN 
                    num_files_per_doy[jj] = num_files_per_doy[jj] + 1
                    found = 1
                ENDIF 
            ENDFOR 
            IF found EQ 0 THEN BEGIN 
                sats = [sats, sat]
                years = [years, year_st]
                doys = [doys, doy_st]
                ends = [ends, end_st]
                num_files_per_doy = [num_files_per_doy, 1]
                num_days = num_days + 1
            ENDIF 
        ENDELSE 
    ENDFOR 

    ; copy missing files
    FOR ii = 0, n_elements(sats)-1 DO BEGIN 
        IF num_files_per_doy[ii] NE 4 THEN BEGIN ; need to copy something
            FOR jj = 0, 3 DO BEGIN 
                CASE jj OF
                    0: filename = 'ST'+sats[ii]+'_L1_PLA_'+ends[ii]
                    1: filename = 'ST'+sats[ii]+'_L1_PLA_HK_'+ends[ii]
                    2: filename = 'ST'+sats[ii]+'_L1_PLA_CL_'+ends[ii]
                    3: filename = 'ST'+sats[ii]+'_L1_PLA_SC_'+ends[ii]
                ENDCASE
                filepath = cdfreadpath+'/'+filename
                IF file_test(filepath) NE 1 THEN BEGIN ; need to copy
                    command = 'cp '+datadir+sats[ii]+'/'+cdfdir+'/'+years[ii]+'/'+filename+' '+cdfreadpath+'/.'
                    spawn, command
                ENDIF 
            ENDFOR
        ENDIF
    ENDFOR 
ENDIF 
END 
