; Lorna Ellis
; March 7, 2006
; check_cdf.pro

; This file reads a cdf and writes out the data in text files so I can
; easily check if it is correct.

PRO check_cdf
compile_opt strictarrsubs

in_dir = '/home/lorna/Level1/IDL/Output'
cdf_name = 'STA_L1_PLA_303_20061030_V01'
out_dir = '/home/lorna/Level1/IDL/Output'
cdf_file = concat_dir(in_dir, cdf_name)
tab = STRING(9B)

cdf_id = cdf_open(cdf_file)
cdf_control, cdf_id, get_var_info = info, variable = 'Epoch1'
cdf_varget, cdf_id, 'Epoch1', epoch, rec_count = info.maxrec

; PHA
pha_name = 'PHA_'+cdf_name
pha_file = concat_dir(out_dir, pha_name)
openw, pha_lun, pha_file, /get_lun
temp_st = 'PHA data from cdf file: '+cdf_name
printf, pha_lun, temp_st
temp_st = 'Date'+tab+'Time'+tab+'swpe'+tab+'swpd'+tab+'quad'+tab+'ssd_id'+tab+'ssde_un'+tab+'tof'+tab+'pos'+tab+'sect'+tab+'pri'
printf, pha_lun, temp_st
cdf_varget, cdf_id, 'PHA', pha, rec_count = info.maxrec
FOR i = 0, info.maxrec-1 DO BEGIN 
    temp_pha = reform(pha[*, *, i])
    found_valid_pha = 0
    FOR j = 0, 767 DO BEGIN 
        temp_temp_pha = reform(temp_pha[j, *])
        IF array_equal(temp_temp_pha, -1) EQ 0 THEN BEGIN ; valid event
            IF found_valid_pha EQ 0 THEN BEGIN ; get timestamp
                cdf_epoch, epoch[i], year, month, day, hour, min, sec, milli, /breakdown_epoch
                year_st = string(year, format = '(I4.4)')
                month_st = string(month, format = '(I2.2)')
                day_st = string(day, format = '(I2.2)')
                hour_st = string(hour, format = '(I2.2)')
                min_st = string(min, format = '(I2.2)')
                sec_st = string(sec, format = '(I2.2)')
                milli_st = string(milli, format = '(I3.3)')
                date = month_st+'/'+day_st+'/'+year_st
                time = hour_st+':'+min_st+':'+sec_st+':'+milli_st
                timestamp = date+tab+time
                found_valid_pha = 1
            ENDIF 
            temp_st = timestamp
            FOR k = 0, 8 DO BEGIN
                temp_st = temp_st+tab+string(temp_temp_pha[k])
            ENDFOR
            printf, pha_lun, temp_st
        ENDIF
    ENDFOR
ENDFOR
close, pha_lun
free_lun, pha_lun

cdf_close, cdf_id
print, "Done"

END 
