; Lorna Ellis
; 12/13/2013
; check_bad_321_a.pro

; This checks for times that should be omitted. 

PRO check_bad_321_a, pkt_epoch, count
compile_opt strictarrsubs

IF pkt_epoch LT time_epoch('2012-01-01/00:00:00.000') THEN BEGIN 
    bad_times = [time_epoch('2011-08-23/05:30:11.508'), $
                 time_epoch('2011-09-14/15:43:09.746'), $
                 time_epoch('2011-09-14/15:53:09.746'), $
                 time_epoch('2011-09-14/16:08:09.746'), $
                 time_epoch('2011-09-20/13:26:17.301'), $
                 time_epoch('2011-09-30/04:20:16.195'), $
                 time_epoch('2011-10-19/12:48:15.148'), $
                 time_epoch('2011-10-19/13:53:15.141'), $
                 time_epoch('2011-10-19/15:08:15.137'), $
                 time_epoch('2011-10-28/05:23:13.945'), $
                 time_epoch('2011-10-28/05:33:13.945'), $
                 time_epoch('2011-11-13/17:03:12.426'), $
                 time_epoch('2011-11-25/04:46:12.063'), $
                 time_epoch('2011-12-25/05:49:09.324')]
ENDIF ELSE IF pkt_epoch LT time_epoch('2013-01-01/00:00:00.000') THEN BEGIN 
    bad_times = [time_epoch('2012-02-23/19:27:05.523'), $
                 time_epoch('2012-02-27/21:22:05.125'), $
                 time_epoch('2012-03-21/16:50:04.031'), $
                 time_epoch('2012-04-19/11:56:02.637'), $
                 time_epoch('2012-04-19/13:01:02.637'), $
                 time_epoch('2012-07-09/21:22:58.652'), $
                 time_epoch('2012-07-18/17:34:58.406'), $
                 time_epoch('2012-08-21/13:09:54.738'), $
                 time_epoch('2012-08-22/10:51:54.711'), $
                 time_epoch('2012-10-19/05:09:48.488'), $
                 time_epoch('2012-10-24/16:14:47.797'), $
                 time_epoch('2012-10-24/16:34:47.797'), $
                 time_epoch('2012-11-02/18:21:47.242'), $
                 time_epoch('2012-11-02/19:11:47.242'), $
                 time_epoch('2012-11-02/19:16:47.242'), $
                 time_epoch('2012-11-02/19:21:47.242'), $
                 time_epoch('2012-11-02/20:01:47.242'), $
                 time_epoch('2012-11-02/22:11:47.242'), $
                 time_epoch('2012-11-02/22:21:47.242'), $
                 time_epoch('2012-11-03/00:56:47.238'), $
                 time_epoch('2012-11-03/01:06:47.238'), $
                 time_epoch('2012-11-03/01:11:47.238'), $
                 time_epoch('2012-11-03/03:51:47.234'), $
                 time_epoch('2012-11-03/04:51:47.234'), $
                 time_epoch('2012-11-03/06:41:47.230'), $
                 time_epoch('2012-11-16/07:51:46.321'), $
                 time_epoch('2012-11-16/08:31:46.309'), $
                 time_epoch('2012-11-16/09:11:46.305'), $
                 time_epoch('2012-11-16/12:56:46.285'), $
                 time_epoch('2012-11-16/15:11:46.273'), $
                 time_epoch('2012-12-10/11:58:43.734'), $
                 time_epoch('2012-12-10/12:03:43.734'), $
                 time_epoch('2012-12-12/05:43:43.676'), $
                 time_epoch('2012-12-12/05:53:43.676'), $
                 time_epoch('2012-12-12/05:58:43.676'), $
                 time_epoch('2012-12-15/00:53:43.531'), $
                 time_epoch('2012-12-16/07:43:43.438'), $
                 time_epoch('2012-12-16/08:38:43.434'), $
                 time_epoch('2012-12-17/02:53:43.367'), $
                 time_epoch('2012-12-25/04:58:42.430'), $
                 time_epoch('2012-12-26/00:08:42.328'), $
                 time_epoch('2012-12-31/00:13:41.680'), $
                 time_epoch('2012-12-31/00:18:41.680'), $
                 time_epoch('2012-12-31/00:23:41.680')]
ENDIF ELSE IF pkt_epoch LT time_epoch('2013-07-01/00:00:00.000') THEN BEGIN 
    bad_times = [time_epoch('2013-01-06/20:28:40.906'), $
                 time_epoch('2013-01-13/15:10:40.590'), $
                 time_epoch('2013-01-13/15:45:40.590'), $
                 time_epoch('2013-01-13/16:20:40.590'), $
                 time_epoch('2013-01-13/16:40:40.590'), $
                 time_epoch('2013-01-13/18:15:40.586'), $
                 time_epoch('2013-01-13/19:10:40.586'), $
                 time_epoch('2013-01-13/19:15:40.586'), $
                 time_epoch('2013-01-13/19:20:40.586'), $
                 time_epoch('2013-01-13/19:35:40.586'), $
                 time_epoch('2013-01-13/19:40:40.586'), $
                 time_epoch('2013-01-13/19:45:40.586'), $
                 time_epoch('2013-01-13/20:20:40.586'), $
                 time_epoch('2013-01-13/20:30:40.582'), $
                 time_epoch('2013-01-13/20:50:40.582'), $
                 time_epoch('2013-01-13/20:55:40.582'), $
                 time_epoch('2013-01-13/21:10:40.582'), $
                 time_epoch('2013-01-13/21:15:40.582'), $
                 time_epoch('2013-01-13/21:55:40.582'), $
                 time_epoch('2013-01-13/22:00:40.582'), $
                 time_epoch('2013-01-13/22:20:40.582'), $
                 time_epoch('2013-01-13/22:25:40.582'), $
                 time_epoch('2013-01-13/23:15:40.582'), $
                 time_epoch('2013-01-14/00:00:40.582'), $
                 time_epoch('2013-01-14/00:15:40.582'), $
                 time_epoch('2013-01-14/00:45:40.582'), $
                 time_epoch('2013-01-14/00:50:40.582'), $
                 time_epoch('2013-01-14/00:55:40.582'), $
                 time_epoch('2013-01-14/01:00:40.582'), $
                 time_epoch('2013-01-14/01:05:40.582'), $
                 time_epoch('2013-01-14/01:10:40.582'), $
                 time_epoch('2013-01-14/01:15:40.582'), $
                 time_epoch('2013-01-14/01:50:40.582'), $
                 time_epoch('2013-01-14/02:05:40.582'), $
                 time_epoch('2013-01-14/02:10:40.578'), $
                 time_epoch('2013-01-14/02:15:40.578'), $
                 time_epoch('2013-01-14/02:45:40.578'), $
                 time_epoch('2013-01-14/02:55:40.578'), $
                 time_epoch('2013-01-14/03:25:40.578'), $
                 time_epoch('2013-01-14/04:05:40.578'), $
                 time_epoch('2013-01-14/04:15:40.578'), $
                 time_epoch('2013-01-14/05:40:40.574'), $
                 time_epoch('2013-01-14/05:55:40.574'), $
                 time_epoch('2013-01-14/14:20:40.559'), $
                 time_epoch('2013-01-17/17:50:40.469'), $
                 time_epoch('2013-03-06/10:12:36.813'), $
                 time_epoch('2013-03-07/04:47:36.730'), $
                 time_epoch('2013-03-12/09:17:36.137'), $
                 time_epoch('2013-03-31/14:19:34.867'), $
                 time_epoch('2013-04-01/11:04:34.809'), $
                 time_epoch('2013-04-01/11:34:34.809'), $
                 time_epoch('2013-04-15/19:04:33.301'), $
                 time_epoch('2013-04-15/21:39:33.289'), $
                 time_epoch('2013-04-15/21:59:33.285'), $
                 time_epoch('2013-05-07/18:21:32.098'), $
                 time_epoch('2013-05-27/15:56:30.082'), $
                 time_epoch('2013-05-30/09:31:29.988'), $
                 time_epoch('2013-06-03/01:03:29.906'), $
                 time_epoch('2013-06-06/03:58:29.813'), $
                 time_epoch('2013-06-06/05:53:29.809'), $
                 time_epoch('2013-06-06/12:23:29.801'), $
                 time_epoch('2013-06-06/17:18:29.793'), $
                 time_epoch('2013-06-14/13:43:29.199'), $
                 time_epoch('2013-06-18/14:33:28.676'), $
                 time_epoch('2013-06-21/04:08:28.371'), $
                 time_epoch('2013-06-21/04:13:28.371'), $
                 time_epoch('2013-06-23/06:18:28.129'), $
                 time_epoch('2013-06-23/06:23:28.129'), $
                 time_epoch('2013-06-30/05:08:27.488')]
ENDIF ELSE IF pkt_epoch LT time_epoch('2014-01-01/00:00:00.000') THEN BEGIN 
    bad_times = [time_epoch('2013-07-06/09:10:27.309'), $
                 time_epoch('2013-08-12/20:27:24.496'), $
                 time_epoch('2013-08-19/20:17:24.082'), $
                 time_epoch('2013-08-19/20:22:24.082'), $
                 time_epoch('2013-08-23/01:57:23.758'), $
                 time_epoch('2013-08-23/07:12:23.734'), $
                 time_epoch('2013-08-23/09:52:23.723'), $
                 time_epoch('2013-08-26/14:02:23.348'), $
                 time_epoch('2013-09-07/20:32:22.063'), $
                 time_epoch('2013-09-10/00:17:21.895'), $
                 time_epoch('2013-09-10/00:27:21.895'), $
                 time_epoch('2013-09-10/00:32:21.895'), $
                 time_epoch('2013-09-10/00:37:21.895'), $
                 time_epoch('2013-09-10/00:52:21.895'), $
                 time_epoch('2013-09-10/14:27:21.875'), $
                 time_epoch('2013-09-10/14:37:21.875'), $
                 time_epoch('2013-09-10/14:57:21.875'), $
                 time_epoch('2013-09-28/04:59:19.945'), $
                 time_epoch('2013-11-09/14:41:12.355'), $
                 time_epoch('2013-11-17/06:16:11.098'), $
                 time_epoch('2013-11-20/04:29:10.813'), $
                 time_epoch('2013-12-15/05:39:07.273'), $
                 time_epoch('2013-12-18/22:04:06.645')]
ENDIF ELSE IF pkt_epoch LT time_epoch('2015-01-01/00:00:00.000') THEN BEGIN
    bad_times = [time_epoch('2014-02-28/01:23:56.949'), $
                 time_epoch('2014-02-28/01:28:56.949'), $
                 time_epoch('2014-02-28/01:38:56.949'), $
                 time_epoch('2014-04-04/18:10:52.152'), $
                 time_epoch('2014-05-21/00:52:45.996'), $
                 time_epoch('2014-06-02/23:17:44.309'), $
                 time_epoch('2014-06-09/07:44:43.406'), $
                 time_epoch('2014-06-23/19:14:40.492'), $
                 time_epoch('2014-06-23/20:39:40.484'), $
                 time_epoch('2014-07-19/14:29:39.242'), $
                 time_epoch('2014-07-19/14:54:39.238'), $
                 time_epoch('2014-07-19/16:14:39.230'), $
                 time_epoch('2014-07-19/16:24:39.230'), $
                 time_epoch('2014-07-19/16:54:39.227'), $
                 time_epoch('2014-07-19/18:14:39.219'), $
                 time_epoch('2014-07-19/18:39:39.215'), $
                 time_epoch('2014-07-19/18:44:39.215'), $
                 time_epoch('2014-07-19/20:34:39.203'), $
                 time_epoch('2014-07-19/20:44:39.203'), $
                 time_epoch('2014-08-02/22:59:38.063'), $
                 time_epoch('2014-08-02/23:04:38.063'), $
                 time_epoch('2014-08-03/00:39:38.063'), $
                 time_epoch('2014-08-29/00:10:35.809'), $
                 time_epoch('2014-09-02/06:12:35.664'), $
                 time_epoch('2014-09-02/08:12:35.664'), $
                 time_epoch('2014-09-02/08:32:35.664'), $
                 time_epoch('2014-09-03/16:52:35.680'), $
                 time_epoch('2014-09-08/15:32:35.313'), $
                 time_epoch('2014-09-08/16:12:35.309'), $
                 time_epoch('2014-09-08/16:32:35.309'), $
                 time_epoch('2014-10-23/19:34:30.566'), $
                 time_epoch('2014-11-02/23:54:29.414'), $
                 time_epoch('2014-11-16/14:37:28.328')]
ENDIF ELSE IF pkt_epoch LT time_epoch('2015-10-01/00:00:00.000') THEN BEGIN
    bad_times = [time_epoch('2015-01-02/20:09:21.473'), $
                 time_epoch('2015-01-03/19:29:21.414'), $
                 time_epoch('2015-08-17/17:08:30.984'), $
                 time_epoch('2015-08-17/17:18:30.984'), $
                 time_epoch('2015-08-17/17:43:30.980'), $
                 time_epoch('2015-08-17/17:53:30.980'), $
                 time_epoch('2015-08-17/17:58:30.980'), $
                 time_epoch('2015-08-18/17:33:30.863'), $
                 time_epoch('2015-08-18/17:43:30.863'), $
                 time_epoch('2015-08-18/18:08:30.859'), $
                 time_epoch('2015-08-18/18:18:30.859'), $
                 time_epoch('2015-08-18/18:23:30.859'), $
                 time_epoch('2015-08-19/15:33:30.766'), $
                 time_epoch('2015-08-19/15:48:30.762'), $
                 time_epoch('2015-08-19/15:53:30.762'), $
                 time_epoch('2015-08-19/16:03:30.762'), $
                 time_epoch('2015-08-19/16:18:30.762'), $
                 time_epoch('2015-08-19/16:33:30.762'), $
                 time_epoch('2015-08-19/16:43:30.758'), $
                 time_epoch('2015-08-19/16:48:30.758'), $
                 time_epoch('2015-08-19/17:08:30.758'), $
                 time_epoch('2015-08-19/17:13:30.758'), $
                 time_epoch('2015-08-19/17:23:30.758'), $
                 time_epoch('2015-08-19/17:28:30.758'), $
                 time_epoch('2015-08-19/17:38:30.754'), $
                 time_epoch('2015-08-19/17:53:30.754'), $
                 time_epoch('2015-08-19/18:08:30.754'), $
                 time_epoch('2015-08-19/18:18:30.754'), $
                 time_epoch('2015-08-19/18:23:30.754'), $
                 time_epoch('2015-08-19/18:33:30.750'), $
                 time_epoch('2015-08-19/18:48:30.750'), $
                 time_epoch('2015-08-19/19:03:30.750'), $
                 time_epoch('2015-08-19/19:13:30.750'), $
                 time_epoch('2015-08-19/19:18:30.750'), $
                 time_epoch('2015-08-19/19:33:30.746'), $
                 time_epoch('2015-08-19/19:38:30.746'), $
                 time_epoch('2015-08-20/13:38:30.672'), $
                 time_epoch('2015-08-20/13:43:30.672'), $
                 time_epoch('2015-08-20/13:53:30.672'), $
                 time_epoch('2015-08-20/14:03:30.672'), $
                 time_epoch('2015-08-20/14:18:30.672'), $
                 time_epoch('2015-08-20/14:23:30.672'), $
                 time_epoch('2015-08-21/10:08:30.598'), $
                 time_epoch('2015-08-21/10:33:30.594'), $
                 time_epoch('2015-08-21/10:38:30.594'), $
                 time_epoch('2015-08-22/11:03:30.516'), $
                 time_epoch('2015-08-22/11:28:30.516'), $
                 time_epoch('2015-08-22/11:33:30.516'), $
                 time_epoch('2015-08-23/09:38:30.457'), $
                 time_epoch('2015-08-23/09:48:30.453'), $
                 time_epoch('2015-08-23/09:53:30.453'), $
                 time_epoch('2015-08-23/09:58:30.453'), $
                 time_epoch('2015-08-23/10:13:30.453'), $
                 time_epoch('2015-08-23/10:18:30.453'), $
                 time_epoch('2015-08-24/14:38:30.395'), $
                 time_epoch('2015-08-24/14:43:30.395'), $
                 time_epoch('2015-08-24/14:48:30.395'), $
                 time_epoch('2015-08-24/14:58:30.395'), $
                 time_epoch('2015-08-24/15:03:30.395'), $
                 time_epoch('2015-08-24/17:53:30.387'), $
                 time_epoch('2015-09-07/17:52:29.344'), $
                 time_epoch('2015-09-07/17:57:29.344'), $
                 time_epoch('2015-09-07/18:02:29.344'), $
                 time_epoch('2015-09-07/18:07:29.344'), $
                 time_epoch('2015-09-07/18:12:29.344'), $
                 time_epoch('2015-09-07/18:17:29.344'), $
                 time_epoch('2015-09-07/18:27:29.344'), $
                 time_epoch('2015-09-08/21:12:29.184'), $
                 time_epoch('2015-09-08/21:17:29.184'), $
                 time_epoch('2015-09-08/21:27:29.180'), $
                 time_epoch('2015-09-08/21:32:29.180'), $
                 time_epoch('2015-09-08/21:37:29.180'), $
                 time_epoch('2015-09-08/21:47:29.180'), $
                 time_epoch('2015-09-09/19:32:29.047'), $
                 time_epoch('2015-09-09/19:37:29.047'), $
                 time_epoch('2015-09-09/19:57:29.043'), $
                 time_epoch('2015-09-11/01:37:28.871'), $
                 time_epoch('2015-09-11/02:02:28.867'), $
                 time_epoch('2015-09-11/11:52:28.805'), $
                 time_epoch('2015-09-11/12:07:28.805'), $
                 time_epoch('2015-09-12/15:47:28.629'), $
                 time_epoch('2015-09-12/15:57:28.629'), $
                 time_epoch('2015-09-12/16:07:28.625'), $
                 time_epoch('2015-09-12/16:12:28.625'), $
                 time_epoch('2015-09-13/12:57:28.496'), $
                 time_epoch('2015-09-13/13:17:28.496'), $
                 time_epoch('2015-09-13/13:27:28.496'), $
                 time_epoch('2015-09-14/12:52:28.363'), $
                 time_epoch('2015-09-15/21:07:28.180'), $
                 time_epoch('2015-09-15/21:27:28.180'), $
                 time_epoch('2015-09-16/15:07:28.082'), $
                 time_epoch('2015-09-17/17:42:27.938'), $
                 time_epoch('2015-09-18/15:27:27.828'), $
                 time_epoch('2015-09-19/12:57:27.730'), $
                 time_epoch('2015-09-19/17:37:27.711'), $
                 time_epoch('2015-09-19/21:22:27.695'), $
                 time_epoch('2015-09-21/00:47:27.586'), $
                 time_epoch('2015-09-21/00:52:27.586'), $
                 time_epoch('2015-09-21/01:07:27.582'), $
                 time_epoch('2015-09-21/01:17:27.582'), $
                 time_epoch('2015-09-21/20:52:27.516'), $
                 time_epoch('2015-09-21/20:57:27.516'), $
                 time_epoch('2015-09-21/21:12:27.516'), $
                 time_epoch('2015-09-21/21:17:27.516'), $
                 time_epoch('2015-09-21/21:22:27.516'), $
                 time_epoch('2015-09-22/08:22:27.480'), $
                 time_epoch('2015-09-22/08:27:27.480'), $
                 time_epoch('2015-09-23/20:52:27.344'), $
                 time_epoch('2015-09-23/20:57:27.344'), $
                 time_epoch('2015-09-23/21:22:27.340'), $
                 time_epoch('2015-09-24/20:47:27.297'), $
                 time_epoch('2015-09-24/20:52:27.297'), $
                 time_epoch('2015-09-24/21:07:27.297'), $
                 time_epoch('2015-09-24/21:17:27.297'), $
                 time_epoch('2015-09-25/08:12:27.281'), $
                 time_epoch('2015-09-25/08:17:27.281'), $
                 time_epoch('2015-09-25/08:32:27.281'), $
                 time_epoch('2015-09-25/08:37:27.281'), $
                 time_epoch('2015-09-25/08:42:27.281'), $
                 time_epoch('2015-09-26/18:02:27.250'), $
                 time_epoch('2015-09-26/18:17:27.246'), $
                 time_epoch('2015-09-26/18:22:27.246'), $
                 time_epoch('2015-09-26/18:32:27.246'), $
                 time_epoch('2015-09-27/07:57:27.238'), $
                 time_epoch('2015-09-27/08:17:27.238'), $
                 time_epoch('2015-09-27/08:27:27.238'), $
                 time_epoch('2015-09-27/08:32:27.238'), $
                 time_epoch('2015-09-28/15:27:27.223'), $
                 time_epoch('2015-09-29/14:27:27.219'), $
                 time_epoch('2015-09-29/15:02:27.219'), $
                 time_epoch('2015-09-29/22:22:27.219'), $
                 time_epoch('2015-09-29/23:17:27.219'), $
                 time_epoch('2015-09-30/01:12:27.223'), $
                 time_epoch('2015-09-30/20:52:27.230'), $
                 time_epoch('2015-09-30/22:22:27.230'), $
                 time_epoch('2015-09-30/22:28:27.230')]
ENDIF ELSE IF pkt_epoch LT time_epoch('2015-11-01/00:00:00.000') THEN BEGIN
    bad_times = [time_epoch('2015-10-01/20:40:27.227'), $
                 time_epoch('2015-10-01/21:05:27.227'), $
                 time_epoch('2015-10-01/21:10:27.227'), $
                 time_epoch('2015-10-02/20:40:27.199'), $
                 time_epoch('2015-10-02/21:00:27.199'), $
                 time_epoch('2015-10-02/21:05:27.199'), $
                 time_epoch('2015-10-02/21:10:27.199'), $
                 time_epoch('2015-10-03/21:30:27.164'), $
                 time_epoch('2015-10-03/21:40:27.164'), $
                 time_epoch('2015-10-03/21:45:27.164'), $
                 time_epoch('2015-10-04/15:15:27.137'), $
                 time_epoch('2015-10-04/15:25:27.133'), $
                 time_epoch('2015-10-04/15:30:27.133'), $
                 time_epoch('2015-10-05/17:25:27.082'), $
                 time_epoch('2015-10-05/17:30:27.082'), $
                 time_epoch('2015-10-05/17:35:27.082'), $
                 time_epoch('2015-10-06/16:35:27.031'), $
                 time_epoch('2015-10-06/16:45:27.027'), $
                 time_epoch('2015-10-06/16:50:27.027'), $
                 time_epoch('2015-10-06/16:55:27.027'), $
                 time_epoch('2015-10-07/16:25:26.965'), $
                 time_epoch('2015-10-07/16:30:26.965'), $
                 time_epoch('2015-10-07/16:45:26.965'), $
                 time_epoch('2015-10-07/16:50:26.965'), $
                 time_epoch('2015-10-07/16:55:26.965'), $
                 time_epoch('2015-10-08/14:25:26.898'), $
                 time_epoch('2015-10-08/14:40:26.898'), $
                 time_epoch('2015-10-08/14:45:26.898'), $
                 time_epoch('2015-10-08/14:50:26.898'), $
                 time_epoch('2015-10-09/20:30:26.801'), $
                 time_epoch('2015-10-09/20:35:26.801'), $
                 time_epoch('2015-10-09/20:40:26.797'), $
                 time_epoch('2015-10-09/20:45:26.797'), $
                 time_epoch('2015-10-09/20:50:26.797'), $
                 time_epoch('2015-10-09/20:55:26.797'), $
                 time_epoch('2015-10-10/15:05:26.730'), $
                 time_epoch('2015-10-10/15:20:26.730'), $
                 time_epoch('2015-10-10/15:25:26.730'), $
                 time_epoch('2015-10-10/15:30:26.727'), $
                 time_epoch('2015-10-10/15:35:26.727'), $
                 time_epoch('2015-10-11/16:00:26.625'), $
                 time_epoch('2015-10-11/16:10:26.625'), $
                 time_epoch('2015-10-11/16:15:26.625'), $
                 time_epoch('2015-10-11/16:20:26.625'), $
                 time_epoch('2015-10-11/16:25:26.625'), $
                 time_epoch('2015-10-11/16:30:26.625'), $
                 time_epoch('2015-10-12/08:05:26.551'), $
                 time_epoch('2015-10-12/08:10:26.551'), $
                 time_epoch('2015-10-14/15:20:26.270'), $
                 time_epoch('2015-10-14/15:40:26.270'), $
                 time_epoch('2015-10-14/15:45:26.270'), $
                 time_epoch('2015-10-15/20:40:26.102'), $
                 time_epoch('2015-10-15/20:45:26.102'), $
                 time_epoch('2015-10-15/20:50:26.102'), $
                 time_epoch('2015-10-16/10:05:26.020'), $
                 time_epoch('2015-10-16/10:10:26.020'), $
                 time_epoch('2015-10-17/20:50:25.805'), $
                 time_epoch('2015-10-17/20:55:25.805'), $
                 time_epoch('2015-10-18/16:10:25.680'), $
                 time_epoch('2015-10-18/16:20:25.680'), $
                 time_epoch('2015-10-18/16:35:25.680'), $
                 time_epoch('2015-10-18/16:40:25.680'), $
                 time_epoch('2015-10-19/16:15:25.469'), $
                 time_epoch('2015-10-19/16:30:25.465'), $
                 time_epoch('2015-10-19/16:35:25.465'), $
                 time_epoch('2015-10-20/20:40:25.289'), $
                 time_epoch('2015-10-20/20:45:25.289'), $
                 time_epoch('2015-10-22/00:55:25.117'), $
                 time_epoch('2015-10-22/01:10:25.113'), $
                 time_epoch('2015-10-22/01:15:25.113'), $
                 time_epoch('2015-10-22/01:20:25.113'), $
                 time_epoch('2015-10-22/01:25:25.113'), $
                 time_epoch('2015-10-22/20:05:25.004'), $
                 time_epoch('2015-10-22/20:10:25.004'), $
                 time_epoch('2015-10-22/20:25:25.004'), $
                 time_epoch('2015-10-22/20:30:25.000'), $
                 time_epoch('2015-10-22/20:35:25.000'), $
                 time_epoch('2015-10-23/15:15:24.898'), $
                 time_epoch('2015-10-23/15:30:24.898'), $
                 time_epoch('2015-10-23/15:35:24.898'), $
                 time_epoch('2015-10-23/15:40:24.898'), $
                 time_epoch('2015-10-23/15:45:24.898'), $
                 time_epoch('2015-10-24/15:50:24.773'), $
                 time_epoch('2015-10-24/15:55:24.773'), $
                 time_epoch('2015-10-24/16:05:24.773'), $
                 time_epoch('2015-10-24/16:10:24.770'), $
                 time_epoch('2015-10-24/16:15:24.770'), $
                 time_epoch('2015-10-25/15:35:24.656'), $
                 time_epoch('2015-10-25/15:40:24.656'), $
                 time_epoch('2015-10-25/15:45:24.656'), $
                 time_epoch('2015-10-25/15:55:24.656'), $
                 time_epoch('2015-10-25/16:00:24.656'), $
                 time_epoch('2015-10-26/19:25:24.531'), $
                 time_epoch('2015-10-26/19:30:24.531'), $
                 time_epoch('2015-10-27/09:45:24.473'), $
                 time_epoch('2015-10-27/09:50:24.473'), $
                 time_epoch('2015-10-28/16:00:24.359'), $
                 time_epoch('2015-10-28/16:05:24.359'), $
                 time_epoch('2015-10-29/08:35:24.309'), $
                 time_epoch('2015-10-29/08:40:24.305'), $
                 time_epoch('2015-10-29/08:55:24.305'), $
                 time_epoch('2015-10-29/09:00:24.305'), $
                 time_epoch('2015-10-30/15:55:24.219'), $
                 time_epoch('2015-10-31/15:55:24.160'), $
                 time_epoch('2015-10-31/16:00:24.160')]
ENDIF ELSE IF pkt_epoch LT time_epoch('2015-11-10/00:00:00.000') THEN BEGIN
    bad_times = [time_epoch('2015-11-01/16:40:24.109'), $
                 time_epoch('2015-11-01/16:50:24.109'), $
                 time_epoch('2015-11-02/16:05:24.070'), $
                 time_epoch('2015-11-02/16:10:24.070'), $
                 time_epoch('2015-11-02/16:25:24.070'), $
                 time_epoch('2015-11-02/17:20:24.070'), $
                 time_epoch('2015-11-03/20:02:24.074'), $
                 time_epoch('2015-11-03/20:07:24.074'), $
                 time_epoch('2015-11-03/20:12:24.074'), $
                 time_epoch('2015-11-03/20:22:24.074'), $
                 time_epoch('2015-11-03/20:32:24.074'), $
                 time_epoch('2015-11-03/21:37:24.074'), $
                 time_epoch('2015-11-04/20:32:24.078'), $
                 time_epoch('2015-11-04/20:52:24.078'), $
                 time_epoch('2015-11-04/21:02:24.078'), $
                 time_epoch('2015-11-05/23:27:24.078'), $
                 time_epoch('2015-11-06/09:32:24.074'), $
                 time_epoch('2015-11-06/09:37:24.074'), $
                 time_epoch('2015-11-07/09:52:24.059'), $
                 time_epoch('2015-11-08/21:52:24.020'), $
                 time_epoch('2015-11-08/22:07:24.020'), $
                 time_epoch('2015-11-08/22:27:24.020'), $
                 time_epoch('2015-11-09/13:32:23.992'), $
                 time_epoch('2015-11-09/14:02:23.992')]
ENDIF ELSE IF pkt_epoch LT time_epoch('2016-08-21/00:00:00.000') THEN BEGIN
    bad_times = [time_epoch('2015-12-19/18:40:20.559'), $
                 time_epoch('2015-12-28/07:07:20.520'), $
                 time_epoch('2015-12-28/07:17:20.520'), $
                 time_epoch('2015-12-28/07:22:20.520'), $
                 time_epoch('2015-12-28/07:52:20.516'), $
                 time_epoch('2015-12-28/07:57:20.516'), $
                 time_epoch('2015-12-28/08:47:20.516'), $
                 time_epoch('2015-12-28/08:57:20.516'), $
                 time_epoch('2015-12-28/09:07:20.516'), $
                 time_epoch('2015-12-28/09:17:20.516'), $
                 time_epoch('2015-12-28/09:22:20.516'), $
                 time_epoch('2015-12-28/09:37:20.516'), $
                 time_epoch('2015-12-28/09:42:20.516'), $
                 time_epoch('2015-12-28/09:47:20.516'), $
                 time_epoch('2015-12-28/09:57:20.516'), $
                 time_epoch('2015-12-28/10:02:20.512'), $
                 time_epoch('2015-12-28/10:12:20.512'), $
                 time_epoch('2015-12-28/10:17:20.512'), $
                 time_epoch('2015-12-28/10:22:20.512'), $
                 time_epoch('2015-12-28/10:27:20.512')]
ENDIF ELSE IF pkt_epoch LT time_epoch('2017-01-01/00:00:00.000') THEN BEGIN
    bad_times = [time_epoch('2016-01-31/18:39:18.027'), $
                 time_epoch('2016-01-31/18:54:18.027'), $
                 time_epoch('2016-01-31/19:09:18.027'), $
                 time_epoch('2016-01-31/19:14:18.027'), $
                 time_epoch('2016-01-31/21:14:18.020'), $
                 time_epoch('2016-01-31/21:54:18.016'), $
                 time_epoch('2016-02-04/05:44:17.684'), $
                 time_epoch('2016-02-08/15:54:17.168'), $
                 time_epoch('2016-02-08/21:44:17.145'), $
                 time_epoch('2016-02-09/00:59:17.129'), $
                 time_epoch('2016-02-09/06:04:17.105'), $
                 time_epoch('2016-02-11/06:29:16.852'), $
                 time_epoch('2016-02-11/07:34:16.848'), $
                 time_epoch('2016-02-24/00:16:16.215'), $
                 time_epoch('2016-02-24/00:21:16.215'), $
                 time_epoch('2016-02-24/00:31:16.215'), $
                 time_epoch('2016-02-26/15:16:16.266'), $
                 time_epoch('2016-02-26/15:21:16.266'), $
                 time_epoch('2016-03-04/17:06:16.121'), $
                 time_epoch('2016-03-11/20:41:15.434'), $
                 time_epoch('2016-03-12/05:41:15.391'), $
                 time_epoch('2016-04-09/01:03:13.824'), $
                 time_epoch('2016-04-09/01:13:13.820'), $
                 time_epoch('2016-04-09/23:18:13.727'), $
                 time_epoch('2016-04-16/07:18:13.020'), $
                 time_epoch('2016-04-16/07:48:13.020'), $
                 time_epoch('2016-04-20/13:23:12.668'), $
                 time_epoch('2016-05-02/00:11:12.617'), $
                 time_epoch('2016-05-02/00:36:12.617'), $
                 time_epoch('2016-05-02/00:41:12.617'), $
                 time_epoch('2016-05-08/20:11:12.313'), $
                 time_epoch('2016-05-08/20:46:12.313'), $
                 time_epoch('2016-05-08/20:51:12.313'), $
                 time_epoch('2016-05-08/21:06:12.309'), $
                 time_epoch('2016-05-08/21:11:12.309'), $
                 time_epoch('2016-05-08/21:16:12.309'), $
                 time_epoch('2016-05-08/21:26:12.309'), $
                 time_epoch('2016-05-08/22:01:12.309'), $
                 time_epoch('2016-05-08/22:36:12.305'), $
                 time_epoch('2016-05-08/23:21:12.301'), $
                 time_epoch('2016-05-09/01:56:12.293'), $
                 time_epoch('2016-05-29/16:44:10.258'), $
                 time_epoch('2016-05-29/16:59:10.258'), $
                 time_epoch('2016-06-14/10:27:09.465'), $
                 time_epoch('2016-07-22/01:06:06.387'), $
                 time_epoch('2016-08-20/00:00:04.332'), $
                 time_epoch('2016-08-20/00:15:04.332'), $
                 time_epoch('2016-09-03/08:40:02.781'), $
                 time_epoch('2016-09-03/08:50:02.781'), $
                 time_epoch('2016-09-20/12:22:02.117'), $
                 time_epoch('2016-09-20/12:27:02.117'), $
                 time_epoch('2016-09-20/12:32:02.117'), $
                 time_epoch('2016-09-20/12:37:02.117'), $
                 time_epoch('2016-09-20/12:42:02.117'), $
                 time_epoch('2016-09-20/13:17:02.117'), $
                 time_epoch('2016-09-20/13:22:02.117'), $
                 time_epoch('2016-09-20/13:27:02.117'), $
                 time_epoch('2016-09-20/13:32:02.113'), $
                 time_epoch('2016-09-20/13:37:02.113'), $
                 time_epoch('2016-09-20/13:42:02.113'), $
                 time_epoch('2016-09-20/13:47:02.113'), $
                 time_epoch('2016-09-20/13:52:02.113'), $
                 time_epoch('2016-09-20/13:57:02.113'), $
                 time_epoch('2016-11-04/11:44:59.008'), $
                 time_epoch('2016-11-04/12:29:59.008'), $
                 time_epoch('2016-11-04/12:59:59.004'), $
                 time_epoch('2016-11-04/13:29:59.004'), $
                 time_epoch('2016-11-12/19:04:58.656'), $
                 time_epoch('2016-11-17/21:21:58.680')]
ENDIF ELSE IF pkt_epoch LT time_epoch('2018-01-01/00:00:00.000') THEN BEGIN
   bad_times = [time_epoch('2017-01-04/06:13:55.602'), $
                time_epoch('2017-01-04/06:23:55.602'), $
                time_epoch('2017-01-10/17:58:55.043'), $
                time_epoch('2017-01-10/18:33:55.043'), $
                time_epoch('2017-01-13/15:58:54.797'), $
                time_epoch('2017-01-27/13:40:54.379'), $
                time_epoch('2017-01-27/14:30:54.375'), $
                time_epoch('2017-02-14/11:25:52.969'), $
                time_epoch('2017-02-14/11:30:52.969'), $
                time_epoch('2017-02-14/11:35:52.969'), $
                time_epoch('2017-02-14/11:40:52.969'), $
                time_epoch('2017-02-14/11:45:52.969'), $
                time_epoch('2017-02-14/11:50:52.965'), $
                time_epoch('2017-02-14/11:55:52.965'), $
                time_epoch('2017-02-17/20:17:52.770'), $
                time_epoch('2017-02-23/07:17:52.734'), $
                time_epoch('2017-02-23/07:22:52.734'), $
                time_epoch('2017-04-25/06:56:48.883'), $
                time_epoch('2017-05-25/00:18:46.887'), $
                time_epoch('2017-08-03/06:27:42.512'), $
                time_epoch('2017-08-03/06:32:42.512'), $
                time_epoch('2017-10-08/21:49:39.375'), $
                time_epoch('2017-10-08/22:19:39.375'), $
                time_epoch('2017-10-09/01:49:39.375'), $
                time_epoch('2017-10-09/01:54:39.375'), $
                time_epoch('2017-10-26/01:16:38.992'), $
                time_epoch('2017-10-26/03:11:38.988'), $
                time_epoch('2017-10-26/04:16:38.984'), $
                time_epoch('2017-10-26/13:21:38.953'), $
                time_epoch('2017-10-26/15:16:38.945'), $
                time_epoch('2017-10-27/02:46:38.910'), $
                time_epoch('2017-10-27/04:11:38.906'), $
                time_epoch('2017-11-15/23:28:38.328'), $
                time_epoch('2017-11-29/09:33:38.207'), $
                time_epoch('2017-12-26/19:05:37.328')]
ENDIF ELSE IF pkt_epoch LT time_epoch('2019-01-01/00:00:00.000') THEN BEGIN
   bad_times = [time_epoch('2018-01-11/02:15:36.254'), $
                time_epoch('2018-01-14/07:50:35.934'), $
                time_epoch('2018-01-14/07:55:35.934'), $
                time_epoch('2018-01-14/10:40:35.922'), $
                time_epoch('2018-01-14/10:45:35.922'), $
                time_epoch('2018-01-14/10:50:35.922'), $
                time_epoch('2018-01-14/10:55:35.922'), $
                time_epoch('2018-01-14/11:00:35.918'), $
                time_epoch('2018-02-24/02:27:33.316'), $
                time_epoch('2018-02-24/16:07:33.281'), $
                time_epoch('2018-02-24/16:12:33.281'), $
                time_epoch('2018-03-14/12:29:33.051'), $
                time_epoch('2018-03-14/12:59:33.051'), $
                time_epoch('2018-04-22/03:56:31.055'), $
                time_epoch('2018-04-28/10:26:30.605'), $
                time_epoch('2018-04-28/10:31:30.605'), $
                time_epoch('2018-04-28/10:46:30.605'), $
                time_epoch('2018-04-28/11:21:30.602'), $
                time_epoch('2018-04-28/11:26:30.602'), $
                time_epoch('2018-04-28/11:41:30.602'), $
                time_epoch('2018-04-28/11:46:30.602'), $
                time_epoch('2018-04-28/11:51:30.602'), $
                time_epoch('2018-04-28/11:56:30.602'), $
                time_epoch('2018-04-28/12:01:30.598'), $
                time_epoch('2018-04-28/12:11:30.598'), $
                time_epoch('2018-04-28/12:16:30.598'), $
                time_epoch('2018-04-28/12:21:30.598'), $
                time_epoch('2018-04-28/12:26:30.598'), $
                time_epoch('2018-04-28/12:31:30.598'), $
                time_epoch('2018-04-28/12:41:30.598'), $
                time_epoch('2018-04-28/12:46:30.598'), $
                time_epoch('2018-04-28/12:51:30.598'), $
                time_epoch('2018-04-28/13:06:30.598'), $
                time_epoch('2018-04-28/13:26:30.594'), $
                time_epoch('2018-04-28/13:31:30.594'), $
                time_epoch('2018-04-28/13:41:30.594'), $
                time_epoch('2018-04-28/14:16:30.594'), $
                time_epoch('2018-04-28/14:21:30.594'), $
                time_epoch('2018-04-28/14:26:30.590'), $
                time_epoch('2018-04-28/20:26:30.570'), $
                time_epoch('2018-04-29/04:41:30.543'), $
                time_epoch('2018-05-08/07:01:29.621'), $
                time_epoch('2018-05-18/15:08:29.340'), $
                time_epoch('2018-05-18/15:13:29.340'), $
                time_epoch('2018-05-19/11:58:29.355'), $
                time_epoch('2018-05-28/04:43:29.129'), $
                time_epoch('2018-05-28/11:03:29.113'), $
                time_epoch('2018-05-28/11:43:29.113'), $
                time_epoch('2018-05-28/12:33:29.109'), $
                time_epoch('2018-06-01/21:53:28.691'), $
                time_epoch('2018-06-01/21:58:28.691'), $
                time_epoch('2018-06-05/23:08:28.316'), $
                time_epoch('2018-06-21/18:13:27.504'), $
                time_epoch('2018-06-21/18:18:27.504'), $
                time_epoch('2018-06-21/18:23:27.504'), $
                time_epoch('2018-06-21/18:28:27.504'), $
                time_epoch('2018-06-21/18:33:27.504'), $
                time_epoch('2018-08-20/23:32:25.164'), $
                time_epoch('2018-08-30/04:39:25.023'), $
                time_epoch('2018-10-08/18:50:09.719'), $
                time_epoch('2018-10-08/19:00:09.719'), $
                time_epoch('2018-11-12/12:20:08.906'), $
                time_epoch('2018-12-06/16:06:07.973'), $
                time_epoch('2018-12-06/16:11:07.973')]
ENDIF ELSE IF pkt_epoch LT time_epoch('2020-01-01/00:00:00.000') THEN BEGIN
   bad_times = [time_epoch('2019-01-12/03:41:06.352'), $
                time_epoch('2019-01-31/18:49:05.816'), $
                time_epoch('2019-02-04/23:09:05.832'), $
                time_epoch('2019-02-04/23:14:05.832'), $
                time_epoch('2019-02-04/23:19:05.832'), $
                time_epoch('2019-02-04/23:24:05.832'), $
                time_epoch('2019-02-05/00:49:05.832'), $
                time_epoch('2019-03-29/02:17:02.559'), $
                time_epoch('2019-03-29/03:02:02.555'), $
                time_epoch('2019-03-29/03:07:02.555'), $
                time_epoch('2019-03-29/08:12:02.539'), $
                time_epoch('2019-03-29/08:22:02.539'), $
                time_epoch('2019-03-29/08:32:02.535'), $
                time_epoch('2019-07-27/03:38:57.867'), $
                time_epoch('2019-12-05/18:59:53.527'), $
                time_epoch('2019-12-05/19:04:53.527'), $
                time_epoch('2019-12-25/03:59:53.055'), $
                time_epoch('2019-12-26/11:19:52.973')]
ENDIF ELSE IF pkt_epoch LT time_epoch('2020-10-28/00:00:00.000') THEN BEGIN
   bad_times = [time_epoch('2020-03-07/07:36:49.609'), $
                time_epoch('2020-06-04/18:20:45.938'), $
                time_epoch('2020-10-26/22:19:40.563'), $
                time_epoch('2020-10-26/23:49:40.563'), $
                time_epoch('2020-10-27/01:24:40.563'), $
                time_epoch('2020-10-27/01:54:40.563'), $
                time_epoch('2020-10-27/02:04:40.563'), $
                time_epoch('2020-10-27/02:19:40.563')]
ENDIF ELSE IF pkt_epoch LT time_epoch('2020-11-06/00:00:00.000') THEN BEGIN
   bad_times = [time_epoch('2020-11-05/11:38:40.844'), $
                time_epoch('2020-11-05/11:48:40.844')]
ENDIF

found_i = where(pkt_epoch EQ bad_times, count)

END 
