; Lorna Ellis
; 11/05/2007
; change_epoch_harness.pro

; This is a harness program for change_epoch.pro. It allows us to go
; back and change just the epochs in already-created CDFs. It lines up
; the data cdf epochs with the analog housekeeping.

; NOTE: This assumes doing just within one year.

PRO change_epoch_harness, start_doy, stop_doy, year, sat, version
compile_opt strictarrsubs

FOR ii = start_doy, stop_doy DO BEGIN
    utc = doy2utc(ii, year)
    utc_st = utc2str(utc)
    data_cdf = '/data1/Spacecraft_'+sat+'/Level1/CDFs/'+string(year, format = '(I4.4)')+'/ST'+sat+'_L1_PLA_'+string(year, format = '(I4.4)')+$
               strmid(utc_st, 5, 2)+strmid(utc_st, 8, 2)+'_'+string(ii, format = '(I3.3)')+'_V'+string(version, format = '(I2.2)')
    hk_cdf = '/data1/Spacecraft_'+sat+'/Level1/CDFs/'+string(year, format = '(I4.4)')+'/ST'+sat+'_L1_PLA_HK_'+string(year, format = '(I4.4)')+$
             strmid(utc_st, 5, 2)+strmid(utc_st, 8, 2)+'_'+string(ii, format = '(I3.3)')+'_V'+string(version, format = '(I2.2)')
    data_id = cdf_open(data_cdf)
    hk_id = cdf_open(hk_cdf)
    change_epoch, data_id = data_id, hk_id = hk_id
    cdf_close, data_id
    cdf_close, hk_id
    print, 'finished ', ii
ENDFOR 
print, 'done'
END 
