; Lorna Ellis
; 11/02/2007
; change_epoch.pro

; This program checks the epoch values across PLASTIC level 1 CDFs. If
; there are epoch values within the same second, it changes the
; subseconds of other data products to that of the analog
; housekeeping.

; 05/25/2011 Add version.
; 06/29/2011 Add check for duplicates on A on 6/27/2011.

PRO change_epoch, data_id = data_id, hk_id = hk_id, version, sat
compile_opt strictarrsubs

IF n_elements(data_id) EQ 0 THEN BEGIN ; no cdf specified
    cdf_dir = '/Users/lornaellis/Temp/Temp6/'
    data_cdf = 'STB_L1_PLA_20070703_184_V09'
    hk_cdf = 'STB_L1_PLA_HK_20070703_184_V09'
    data_path = cdf_dir+data_cdf
    hk_path = cdf_dir+hk_cdf
    data_id = cdf_open(data_path)
    hk_id = cdf_open(hk_path)
    need_to_close = 1
ENDIF ELSE need_to_close = 0

; get hk_epoch
cdf_control, hk_id, get_var_info = epoch1info, var = 'epoch_analog', /zvariable
IF epoch1info.maxrec GE 0 THEN BEGIN 
    cdf_varget, hk_id, 'epoch_analog', temp_epoch_analog, rec_count = epoch1info.maxrec+1, /zvariable
    epoch_analog = cdf2utc(temp_epoch_analog, /ccsds)
    analog_base = strmid(epoch_analog, 0, 20)
    analog_sub = strmid(epoch_analog, 20, 3)
    IF (strmid(epoch_analog[0], 0, 10) EQ '2011-06-27') AND (sat EQ 'A') THEN BEGIN
        check_bad_analog, analog_base
    ENDIF 

    ; epoch1
    cdf_control, data_id, get_var_info = epoch1info, var = 'epoch1', /zvariable
    IF epoch1info.maxrec GE 0 THEN BEGIN 
        cdf_varget, data_id, 'epoch1', temp_epoch1, rec_count = epoch1info.maxrec+1, /zvariable
        epoch1 = cdf2utc(temp_epoch1, /ccsds)
        epoch1_base = strmid(epoch1, 0, 20)
        FOR ii = 0, epoch1info.maxrec DO BEGIN 
            analog_i = where(epoch1_base[ii] EQ analog_base, count)
            IF count GT 1 THEN stop ELSE $
              IF count EQ 1 THEN BEGIN
                epoch1[ii] = epoch_analog[analog_i]
            ENDIF 
        ENDFOR 
        temp_epoch = reform(anytim2cdf(epoch1))
        cdf_varput, data_id, 'epoch1', temp_epoch
    ENDIF 

    ; epoch5_mon
    cdf_control, data_id, get_var_info = epoch5_moninfo, var = 'epoch5_mon', /zvariable
    IF epoch5_moninfo.maxrec GE 0 THEN BEGIN 
        cdf_varget, data_id, 'epoch5_mon', temp_epoch5_mon, rec_count = epoch5_moninfo.maxrec+1, /zvariable
        epoch5_mon = cdf2utc(temp_epoch5_mon, /ccsds)
        epoch5_mon_base = strmid(epoch5_mon, 0, 20)
        FOR ii = 0, epoch5_moninfo.maxrec DO BEGIN 
            analog_i = where(epoch5_mon_base[ii] EQ analog_base, count)
            IF count GT 1 THEN stop ELSE $
              IF count EQ 1 THEN BEGIN
                epoch5_mon[ii] = epoch_analog[analog_i]
            ENDIF 
        ENDFOR 
        temp_epoch = reform(anytim2cdf(epoch5_mon))
        cdf_varput, data_id, 'epoch5_mon', temp_epoch
    ENDIF 

    ; epoch5_heavy
    IF version LT 10 THEN prod = 'epoch5_heavy' ELSE prod = 'epoch_heavy'
    cdf_control, data_id, get_var_info = epoch5_heavyinfo, var = prod, /zvariable
    IF epoch5_heavyinfo.maxrec GE 0 THEN BEGIN 
        cdf_varget, data_id, prod, temp_epoch5_heavy, rec_count = epoch5_heavyinfo.maxrec+1, /zvariable
        epoch5_heavy = cdf2utc(temp_epoch5_heavy, /ccsds)
        epoch5_heavy_base = strmid(epoch5_heavy, 0, 20)
        FOR ii = 0, epoch5_heavyinfo.maxrec DO BEGIN 
            analog_i = where(epoch5_heavy_base[ii] EQ analog_base, count)
            IF count GT 1 THEN stop ELSE BEGIN 
                IF count EQ 1 THEN BEGIN
                    epoch5_heavy[ii] = epoch_analog[analog_i]
                ENDIF
            ENDELSE 
        ENDFOR 
        temp_epoch = reform(anytim2cdf(epoch5_heavy))
        cdf_varput, data_id, prod, temp_epoch
    ENDIF 
ENDIF 

IF need_to_close EQ 1 THEN BEGIN
    cdf_close, data_id
    cdf_close, hk_id
ENDIF 

END 
