; Lorna Ellis
; September 13, 2007
; calculate_swpri_wapssdpri_ratio.pro

; This program reads a Level1 CDF and creates a daily ratio of
; sum(sw_pri) to (sum(sw_pri)+sum(wap_ssd_pri)). 

; Input: cdffilename, year, day
; Output: ratio (array of 128 values)

PRO calculate_swpri_wapssdpri_ratio, cdffilename, year, doy, ratio
compile_opt strictarrsubs

cdf_id = cdf_open(cdffilename)
cdf_control, cdf_id, get_var_info = epoch5info, var = 'epoch5_mon', /zvariable
IF epoch5info.maxrec GT -1 THEN BEGIN 
    cdf_varget, cdf_id, 'sw_priority', sw_pri, rec_count = epoch5info.maxrec+1, /zvariable ; [128,16,4,x] [ESA,Defl,Class,Time]
    cdf_varget, cdf_id, 'wap_priority_ssd', wap_ssd_pri, rec_count = epoch5info.maxrec+1, /zvariable ; [128,2,x] [ESA,Class,Time]

; remove fill values
    invalid = where(sw_pri EQ -1, count)
    IF count GT 0 THEN BEGIN
        sw_pri[invalid] = 0
    ENDIF 
    invalid = where(wap_ssd_pri EQ -1, count)
    IF count GT 0 THEN BEGIN
        wap_ssd_pri[invalid] = 0
    ENDIF 
    
    ; sum over defl
    sw_pri = total(sw_pri, 2)

    ; sum over class
    sw_pri = total(sw_pri, 2)
    wap_ssd_pri = total(wap_ssd_pri, 2)

    ; sum over time
    sw_pri = total(sw_pri, 2)
    wap_ssd_pri = total(wap_ssd_pri, 2)

    ; add
    total = sw_pri+wap_ssd_pri

    ; divide
    ratio = float(sw_pri)/float(total)
ENDIF ELSE BEGIN
    ratio = fltarr(128)
    ratio[*] = 0
ENDELSE 

cdf_close, cdf_id

END 
