; Lorna Ellis
; June 25, 2007
; calculate_svalid_ratrig_ratio.pro

; This program reads a Level1 CDF and creates a daily ratio of
; s_valid/ra_trig. It removes cases where either rate is saturated. It
; only uses science mode data. 

; Input: cdffilename, year, day
; Output: ratio (array of 32 values)

; 11/07/2007 Added check for if only one record.

PRO calculate_svalid_ratrig_ratio, cdffilename, year, doy, ratio
compile_opt strictarrsubs

cdf_id = cdf_open(cdffilename)
cdf_control, cdf_id, get_var_info = epoch5info, var = 'epoch5_mon', /zvariable
IF epoch5info.maxrec GT -1 THEN BEGIN 
    cdf_varget, cdf_id, 'ra_trig_norm_science', ra_trig, rec_count = epoch5info.maxrec+1, /zvariable
    cdf_varget, cdf_id, 's_valid_norm_science', s_valid, rec_count = epoch5info.maxrec+1, /zvariable

; remove fill values
    invalid = where(ra_trig EQ -1, count)
    IF count GT 0 THEN BEGIN
        ra_trig[invalid] = 0
        s_valid[invalid] = 0
    ENDIF 
    invalid = where(s_valid EQ -1, count)
    IF count GT 0 THEN BEGIN
        ra_trig[invalid] = 0
        s_valid[invalid] = 0
    ENDIF 
    
; remove saturated values
    invalid = where(ra_trig EQ 507904, count)
    IF count GT 0 THEN BEGIN
        ra_trig[invalid] = 0
        s_valid[invalid] = 0
    ENDIF 
    invalid = where(s_valid EQ 507904, count)
    IF count GT 0 THEN BEGIN
        ra_trig[invalid] = 0
        s_valid[invalid] = 0
    ENDIF 

; sum each
    ra_trig_sum = total(ra_trig, 2) ; sum over defl
    IF n_elements(ra_trig_sum) GT 32 THEN ra_trig_sum = total(ra_trig_sum, 2) ; sum over time
    s_valid_sum = total(s_valid, 2)
    IF n_elements(s_valid_sum) GT 32 THEN s_valid_sum = total(s_valid_sum, 2)

; divide
    ratio = float(s_valid_sum)/float(ra_trig_sum)
ENDIF ELSE BEGIN
    ratio = fltarr(32)
    ratio[*] = 0
ENDELSE 

cdf_close, cdf_id

END 
