; Lorna Ellis
; July 23, 2007
; calculate_pri0_pri0_3_ratio.pro

; This program reads a Level1 CDF and creates a daily ratio of
; sw pri 0 to sw pro 0-3. 

; Input: cdffilename, year, day
; Output: ratio (array of 128 values)

PRO calculate_pri0_pri0_3_ratio, cdffilename, year, doy, ratio
compile_opt strictarrsubs

cdf_id = cdf_open(cdffilename)
cdf_control, cdf_id, get_var_info = epoch5info, var = 'epoch5_mon', /zvariable
IF epoch5info.maxrec GT -1 THEN BEGIN 
    cdf_varget, cdf_id, 'sw_priority', sw_pri, rec_count = epoch5info.maxrec+1, /zvariable

; remove fill values
    invalid = where(sw_pri EQ -1, count)
    IF count GT 0 THEN BEGIN
        sw_pri[invalid] = 0
    ENDIF 
    invalid = where(sw_pri EQ -1, count)
    IF count GT 0 THEN BEGIN
        sw_pri[invalid] = 0
    ENDIF 
    
    ; find each priority
    pri_0 = reform(sw_pri[*, *, 0, *])
    pri_1 = reform(sw_pri[*, *, 1, *])
    pri_2 = reform(sw_pri[*, *, 2, *])
    pri_3 = reform(sw_pri[*, *, 3, *])

    ; sum over defl
    pri_0 = total(pri_0, 2)
    pri_1 = total(pri_1, 2)
    pri_2 = total(pri_2, 2)
    pri_3 = total(pri_3, 2)

    ; sum over time
    IF n_elements(pri_0) GT 128 THEN BEGIN 
        pri_0 = total(pri_0, 2)
        pri_1 = total(pri_1, 2)
        pri_2 = total(pri_2, 2)
        pri_3 = total(pri_3, 2)
    ENDIF 

    ; add
    total = pri_0+pri_1+pri_2+pri_3

    ; divide
    ratio = float(pri_0)/float(total)
ENDIF ELSE BEGIN
    ratio = fltarr(128)
    ratio[*] = 0
ENDELSE 

cdf_close, cdf_id

END 
