; Lorna Ellis
; 04/15/2008
; write_raw_ascii.pro

; This is part of the pha_play program. It writes out the raw pha data
; as well as nm and nq information for the specified product.

; Input: valid_pha: intarr[16,num_valid_pha]
;        plot_name: product name (string)
;        bit      : the bit set in valid_pha[14,*] for this product
;        cdf_base_brief: string for file name
; valid_pha indices are: 0: swpe
;                        1: swpd
;                        2: quadrant
;                        3: ssd_id
;                        4: ssde
;                        5: tof
;                        6: pos
;                        7: section
;                        8: priority
;                        9: new priority assigned by this program
;                       10: nm by original algorithm
;                       11: nq by original algorithm
;                       12: nm by new algorithm (if one is used) or emeas (abg algorithm)
;                       13: nq by new algorithm (if one is used) or tns (abg algorithm)
;                       14: products that this pha event belongs to
;                       (by bitwise addition)

; 05/12/2008 Fixed bug with indexing (wanted_i[ii])
;            Fixed bug with reversing deflections (valid_pha has unreversed)
; 05/19/2008 Added valid_mass_mq
; 07/18/2008 Fixed bug with parentheses.
; 10/16/2008 Added abg alternatives:
;            05/23/2008 add elements to valid_mass_mq if abg algorithm used (abg)
;            06/24/2008 temporary restriction on mass range (abg)
; 05/16/2013 Adjusted for schan in valid_pha

PRO write_raw_ascii, valid_pha, valid_mass_mq, plot_name, bit, cdf_base_brief
compile_opt strictarrsubs
COMMON com_pha_play
tab = string(9B)

outname = plot_dir+'/'+plot_name+'_'+cdf_base_brief
IF esa_range_format EQ 1 THEN outname = outname+esa_st
outname = outname+'_'+suffix+'.txt'

openw, out_lun, outname, /get_lun
temp_string = 'PHA data for file: '+cdf_base+' '+plot_name
printf, out_lun, temp_string
temp_string = 'Esa steps: '+string(esa_start, format = '(I3)')+'-'+string(esa_stop, format = '(I3)')
printf, out_lun, temp_string
temp_string = 'Time'+tab+'SWPE'+tab+'SWPD'+tab+'Quadrant'+tab+'SSD_ID'+tab+'SSDE'+tab+'TOF'+tab+'POS'+tab+'Section'+tab+'Priority_orig'+$
              tab+'Priority_new'+tab+'nm_orig'+tab+'nq_orig'+tab+'mass_orig'+tab+'m/q_orig'+tab+'schan'+tab+$
              'nm_new'+tab+'nq_new'+tab+'mass_new'+tab+'m/q_new'
printf, out_lun, temp_string
wanted_i = where((valid_pha[14, *] AND bit) GT 0, count)
IF count GT 0 THEN BEGIN
    FOR ii = 0L, count-1 DO BEGIN

        ; abg code
        temp_mass = valid_mass_mq[0, wanted_i[ii]] ; mass check for PHA testing abg
        temp_mq   = valid_mass_mq[1, wanted_i[ii]] ; m/q check for PHA testing abg
        ;print, 'write ascii  mass ', temp_mass, ' m/1 ', temp_mq
        ; end abg code

        temp_string = time_string(time_double(valid_epoch1[valid_pha_epoch1[wanted_i[ii]]], /epoch))
        swpe = valid_pha[0, wanted_i[ii]]
        swpd = valid_pha[1, wanted_i[ii]]
        IF swpe MOD 2 EQ 1 THEN swpd = 31-swpd ; reverse deflection on odd esas
        temp_string = temp_string+tab+string(swpe)+tab+string(swpd)
        FOR jj = 2, 11 DO BEGIN
            temp_string = temp_string+tab+string(valid_pha        [jj, wanted_i[ii]])
        ENDFOR 
        FOR jj = 0, 1 DO BEGIN 
            temp_string = temp_string+tab+string(valid_mass_mq    [jj, wanted_i[ii]])
        ENDFOR 
        temp_string = temp_string+tab+string     (valid_pha       [15, wanted_i[ii]]) ; schan
        IF which_mass_mq_algorithm GT 0 THEN BEGIN 
            FOR jj = 12, 13 DO BEGIN ; new nm nq
                temp_string = temp_string+tab+string(valid_pha    [jj, wanted_i[ii]])
            ENDFOR 
            FOR jj = 2, 3 DO BEGIN 
                temp_string = temp_string+tab+string(valid_mass_mq[jj, wanted_i[ii]])
            ENDFOR 
        ENDIF 

        ; abg code
        IF which_mass_mq_algorithm GT 1 THEN BEGIN
            temp_mass = valid_mass_mq[2, wanted_i[ii]]
            temp_mq = valid_mass_mq[3, wanted_i[ii]]
            FOR jj = 12, 13 DO BEGIN ; new nm nq
                temp_string = temp_string+tab+string(valid_pha[jj, wanted_i[ii]])
            ENDFOR
            FOR jj = 2, 7 DO BEGIN 
                temp_string = temp_string+tab+string(valid_mass_mq[jj, wanted_i[ii]])
            ENDFOR
        ENDIF 
        IF (temp_mass GT 10 AND temp_mass LT 22) $
          AND (temp_mq GT 2 AND temp_mq LT 4) $
          THEN BEGIN
            printf, out_lun,  temp_string ; temporary restrictions abg
        ENDIF 
        ; end abg code

        printf, out_lun, temp_string
    ENDFOR 
ENDIF 

close, out_lun
free_lun, out_lun
END 
