; Lorna Ellis
; 10/28/2011
; write_norm_ascii.pro

; Writes ascii files for norm data. Split from plot_pha_pp.pro.

; 02/16/2012 Fixed bugs relating to num cycles counted.
; 02/28/2012 Added want_num_cycles option.
; 04/03/2012 Check for non-finite output.
; 06/14/2013 Changed for over day boundary (when averaging over hour).

PRO write_norm_ascii, want_ascii, ascii_ave_time, ascii_norm_format, when_sum_defl, want_tplot, $
  swpha_newnorm, wappha_ssd_newnorm, wappha_nossd_newnorm, supranoe_ssd_newnorm, $
  supranoe_nossd_newnorm, suprawide_newnorm, swz_newnorm, swhalpha_newnorm, $
  swpha_newraw, wappha_ssd_newraw, wappha_nossd_newraw, supranoe_ssd_newraw, $
  supranoe_nossd_newraw, suprawide_newraw, swz_newraw, swhalpha_newraw, $
  cdf_base_brief, num_bins, $
  swpha_norm, wappha_ssd_norm, wappha_nossd_norm, supranoe_ssd_norm, $
  supranoe_nossd_norm, suprawide_norm, swz_norm, swhalpha_norm, $
  summed_swpha_counts_time, summed_wappha_ssd_counts_time, $
  summed_wappha_nossd_counts_time, summed_supranoe_ssd_counts_time, $
  summed_supranoe_nossd_counts_time, summed_suprawide_counts_time, $
  summed_swz_counts_time, summed_swhalpha_counts_time, tplot_times

                   
COMMON com_pha_play
compile_opt strictarrsubs

tab = STRING(9B)
num_esa = esa_stop-esa_start+1
IF esa_start EQ 0 AND esa_stop EQ 127 THEN BEGIN ; purposely set to one because 0-127 won't be opened by excel
    IF norm_esa_sum EQ 1 THEN temp2_esa_start = 1 ELSE temp2_esa_start = 0 
    temp2_esa_stop = 127
ENDIF ELSE BEGIN 
    temp2_esa_start = esa_start
    temp2_esa_stop  = esa_stop
ENDELSE 
comb_norm_cycles_time = norm_cycles_time
; NB: The next section (comb_norm) takes the place of dividing by 2 in
; the old version when summing ESAs because this uses the full number
; of cycles in the 2 sets of ESAs.
IF norm_esa_sum EQ 2 THEN BEGIN ; combine num_cycles 
    comb_norm_cycles_time[*, *] = !values.f_nan
    size = size(norm_cycles_time)
    FOR ii = 0, size[1]-1 DO BEGIN 
        IF ii MOD 2 EQ 0 THEN comb_norm_cycles_time[ii, *] = norm_cycles_time[ii, *] + norm_cycles_time[ii+1, *] $
          ELSE comb_norm_cycles_time[ii, *] = !values.f_nan
    ENDFOR 
ENDIF 
FOR ii = 0, 7 DO BEGIN          ; category of plot
    temp_num_bins = num_bins[ii]
    IF plots_wanted[ii] EQ 1 THEN BEGIN 
        num_records  = n_elements(norm_times)
        temp_newnorm = dblarr(num_esa, temp_num_bins, num_records) ; this will be made smaller
        temp_newraw  = dblarr(num_esa, temp_num_bins, num_records) ; this will be made smaller
        FOR jj = 0, temp_num_bins-1 DO BEGIN ; one file for each bin
            CASE ii OF
                0: BEGIN
                    temp_name = 'swpha'
                    IF when_sum_defl EQ 0 THEN norm_data = reform(swpha_norm[*, jj, *]) ELSE $ ; take just this bin
                      norm_data = reform(swpha_norm              [*, *,    jj, *]) 
                    raw_data    = reform(summed_swpha_counts_time[*, *, *, jj, *])
                    raw_data    = total (raw_data, 2, /nan) ; sum over deflection
                    raw_data    = total (raw_data, 2, /nan) ; sum over priority
                END 
                1: BEGIN
                    temp_name = 'wappha_ssd'
                    norm_data = reform(wappha_ssd_norm              [*,       jj, *]) ; take just this bin
                    raw_data  = reform(summed_wappha_ssd_counts_time[*, *, *, jj, *])
                    raw_data  = total (raw_data, 2, /nan) ; sum over deflection
                    raw_data  = total (raw_data, 2, /nan) ; sum over priority
                END 
                2: BEGIN
                    temp_name = 'wappha_nossd'
                    norm_data = reform(wappha_nossd_norm              [*,       jj, *]) ; take just this bin
                    raw_data  = reform(summed_wappha_nossd_counts_time[*, *, *, jj, *])
                    raw_data  = total (raw_data, 2, /nan) ; sum over deflection
                    raw_data  = total (raw_data, 2, /nan) ; sum over priority
                END 
                3: BEGIN
                    temp_name = 'supranoe_ssd'
                    norm_data = reform(supranoe_ssd_norm              [*,       jj, *]) ; take just this bin
                    raw_data  = reform(summed_supranoe_ssd_counts_time[*, *, *, jj, *])
                    raw_data  = total (raw_data, 2, /nan) ; sum over deflection
                    raw_data  = total (raw_data, 2, /nan) ; sum over priority
                END 
                4: BEGIN
                    temp_name = 'supranoe_nossd'
                    norm_data = reform(supranoe_nossd_norm              [*,       jj, *]) ; take just this bin
                    raw_data  = reform(summed_supranoe_nossd_counts_time[*, *, *, jj, *])
                    raw_data  = total (raw_data, 2, /nan) ; sum over deflection
                    raw_data  = total (raw_data, 2, /nan) ; sum over priority
                END 
                5: BEGIN
                    temp_name = 'suprawide'
                    norm_data = reform(suprawide_norm              [*,       jj, *]) ; take just this bin
                    raw_data  = reform(summed_suprawide_counts_time[*, *, *, jj, *])
                    raw_data  = total (raw_data, 2, /nan) ; sum over deflection
                    raw_data  = total (raw_data, 2, /nan) ; sum over priority
                END 
                6: BEGIN
                    temp_name = 'swz'
                    IF when_sum_defl EQ 0 THEN norm_data = reform(swz_norm[*, jj, *]) ELSE $ ; take just this bin 
                      norm_data = reform(swz_norm              [*, *,    jj, *]) 
                    raw_data    = reform(summed_swz_counts_time[*, *, *, jj, *])
                    raw_data    = total (raw_data, 2, /nan) ; sum over deflection
                    raw_data    = total (raw_data, 2, /nan) ; sum over priority
                END 
                7: BEGIN
                    temp_name = 'swhalpha'
                    IF when_sum_defl EQ 0 THEN norm_data = reform(swhalpha_norm[*, jj, *]) ELSE $ ; take just this bin
                      norm_data = reform(swhalpha_norm              [*, *,    jj, *]) 
                    raw_data    = reform(summed_swhalpha_counts_time[*, *, *, jj, *])
                    raw_data    = total (raw_data, 2, /nan) ; sum over deflection
                    raw_data    = total (raw_data, 2, /nan) ; sum over priority
                END 
            ENDCASE 
            outname = plot_dir+'/norm_'+temp_name+'_'+cdf_base_brief
            out_prefix = outname
            IF esa_range_format EQ 1 THEN outname = outname+esa_st
            temp_outname = outname+'_'+suffix+'_'+labels[ii, jj]
            outname = temp_outname+'.txt'
            IF want_ascii EQ 1 THEN BEGIN 
                openw, out_lun, outname, /get_lun
                temp_string = 'Normalized counts for file: '+cdf_base+' '+temp_name+' Bin Number: '+$
                              string(jj)+' '+labels[ii, jj]
                printf, out_lun, temp_string
                temp_string = 'Esa steps: '+string(temp2_esa_start, format = '(I3)')+'-'+$
                              string(temp2_esa_stop, format = '(I3)')
                printf, out_lun, temp_string
                IF norm_interval EQ -1 THEN temp_norm_interval = 'all day' ELSE $
                  temp_norm_interval = string(norm_interval, format = '(I3.3)')
                temp_string = 'Normalization interval: '+ temp_norm_interval + $
                              ' minutes. ESAs summed for normalization: '+$
                              string(norm_esa_sum, format = '(I1.1)')
                IF ii EQ 0 OR ii EQ 6 OR ii EQ 7 THEN BEGIN
                    IF when_sum_defl EQ 0 THEN temp_string = temp_string+'. Defl summed before normalization.' ELSE $
                      temp_string = temp_string+'. Defl summed after normalization.'
                ENDIF 
                IF ascii_ave_time EQ 1 THEN temp_string = temp_string+' Output averaged over 1 hour' $
                ELSE IF ascii_ave_time GT 1 THEN $
                  temp_string = temp_string+' Output averaged over '+string(ascii_ave_time, format = '(I2.2)')+' hours'
                printf, out_lun, temp_string
                temp_string = 'Start Time'+tab+'Min Num Cycles'+tab+'Max Num Cycles'
                FOR kk = temp2_esa_start, temp2_esa_stop DO BEGIN
                    IF kk MOD norm_esa_sum EQ 0 THEN BEGIN ; skip odd esas if summing 2 esas
                        temp_string = temp_string+tab+'ESA '+string(kk, format = '(I3.3)')+' Norm'
                        IF ascii_norm_format EQ 0 THEN temp_string = temp_string+' Counts' ELSE $
                          temp_string = temp_string+' Cts/Sec'
                        temp_string = temp_string+tab+'ESA '+string(kk, format = '(I3.3)')+' Raw Cts'
                    ENDIF 
                ENDFOR 
                printf, out_lun, temp_string
            ENDIF 
            IF want_num_cycles EQ 1 THEN BEGIN 
                outname2 = temp_outname+'_num_cycle.txt'
                openw, out_lun2, outname2, /get_lun
                temp_string2 = 'Num cycles for file: '+cdf_base+' '+temp_name+' Bin Number: '+$
                              string(jj)+' '+labels[ii, jj]
                printf, out_lun2, temp_string2
                temp_string2 = 'Esa steps: '+string(temp2_esa_start, format = '(I3)')+'-'+$
                              string(temp2_esa_stop, format = '(I3)')
                printf, out_lun2, temp_string2
                IF norm_interval EQ -1 THEN temp_norm_interval = 'all day' ELSE $
                  temp_norm_interval = string(norm_interval, format = '(I3.3)')
                temp_string2 = 'Normalization interval: '+ temp_norm_interval + $
                              ' minutes. ESAs summed for normalization: '+$
                              string(norm_esa_sum, format = '(I1.1)')
                IF ii EQ 0 OR ii EQ 6 OR ii EQ 7 THEN BEGIN
                    IF when_sum_defl EQ 0 THEN temp_string2 = temp_string2+'. Defl summed before normalization.' ELSE $
                      temp_string2 = temp_string2+'. Defl summed after normalization.'
                ENDIF 
                IF ascii_ave_time EQ 1 THEN temp_string2 = temp_string2+' Output averaged over 1 hour' $
                ELSE IF ascii_ave_time GT 1 THEN $
                  temp_string2 = temp_string2+' Output averaged over '+string(ascii_ave_time, format = '(I2.2)')+' hours'
                printf, out_lun2, temp_string2
                temp_string2 = 'Start Time'
                FOR kk = temp2_esa_start, temp2_esa_stop DO BEGIN
                    IF kk MOD norm_esa_sum EQ 0 THEN BEGIN ; skip odd esas if summing 2 esas
                        temp_string2 = temp_string2+tab+'ESA '+string(kk, format = '(I3.3)')
                    ENDIF 
                ENDFOR 
                printf, out_lun2, temp_string2
            ENDIF 
            temp_newnorm_i = 0  ; index into temp_newnorm
            
            IF when_sum_defl EQ 1 AND (ii EQ 0 OR ii EQ 6 OR ii EQ 7) THEN BEGIN ; contains deflection
                temp_arr = indgen(num_esa)+esa_start ; defl 0 shortchanged time
                mod_i = where(temp_arr MOD 2 EQ 0, MOD_count, complement = nmod_i, ncomplement = nmod_count)
            ENDIF 
                                ; no need to accumulate any data
            IF ascii_ave_time EQ 0 THEN BEGIN 
                IF want_tplot EQ 1 THEN tplot_times = norm_times
                temp_avg = dblarr(128)
                FOR kk = 0, num_records-1 DO BEGIN  
                    IF when_sum_defl EQ 1 AND (ii EQ 0 OR ii EQ 6 OR ii EQ 7) THEN $
                      temp_norm_data = reform(norm_data[*, *, kk]) $
                    ELSE temp_norm_data = reform(norm_data[*,    kk]) 
                    temp_string = time_string(norm_times[kk])+tab+$
                                  string(min(norm_cycles_time[*, kk], /nan))+tab+$
                                  string(max(norm_cycles_time[*, kk], /nan))
                    IF want_num_cycles EQ 1 THEN BEGIN
                        temp_string2 = time_string(norm_times[kk])
                        FOR ll = temp2_esa_start, temp2_esa_stop DO BEGIN 
                            IF ll MOD norm_esa_sum EQ 0 THEN BEGIN ; skip odd esas if summing 2 esas
                                temp_string2 = temp_string2+tab+string(comb_norm_cycles_time[ll-temp2_esa_start, kk])
                            ENDIF 
                        ENDFOR 
                        printf, out_lun2, temp_string2
                    ENDIF 
                    IF ascii_norm_format EQ 0 THEN BEGIN ; just counts
                        IF when_sum_defl EQ 1 AND (ii EQ 0 OR ii EQ 6 OR ii EQ 7) THEN $
                          temp_norm_data = total(temp_norm_data, 2, /nan) ; sum over defl
                        temp_newnorm[*, jj, kk] = temp_norm_data
                        temp_newraw [*, jj,  *] = raw_data
                    ENDIF ELSE BEGIN ; counts/sec
                        IF when_sum_defl EQ 1 AND (ii EQ 0 OR ii EQ 6 OR ii EQ 7) THEN BEGIN ; contains deflection
                            IF mod_count GT 0 THEN BEGIN 
                                temp_norm_data  [mod_i, 0 ] = $
                                  temp_norm_data[mod_i, 0 ]/(comb_norm_cycles_time[mod_i, kk] * (0.0124 + 0.0128)) 
                                temp_norm_data  [mod_i, 15] = $
                                  temp_norm_data[mod_i, 15]/(comb_norm_cycles_time[mod_i, kk] *  0.0128 * 2)
                            ENDIF 
                            IF nmod_count GT 0 THEN BEGIN 
                                temp_norm_data  [nmod_i, 0 ] = $
                                  temp_norm_data[nmod_i, 0 ]/(comb_norm_cycles_time[nmod_i, kk] *  0.0128 * 2)
                                temp_norm_data  [nmod_i, 15] = $
                                  temp_norm_data[nmod_i, 15]/(comb_norm_cycles_time[nmod_i, kk] * (0.0124 + 0.0128)) 
                            ENDIF 
                            ; deflection
                            FOR ll = 1, 14 DO BEGIN 
                                temp_norm_data[*, ll] = temp_norm_data[*, ll]/$
                                  (comb_norm_cycles_time[*, kk] * 0.0128 * 2)
                            ENDFOR 
                                ; sum over deflection
                            temp_norm_data = total(temp_norm_data, 2, /nan)
                        ENDIF ELSE BEGIN 
                            temp_norm_data = temp_norm_data/(comb_norm_cycles_time[*, kk] * 0.0128 * 32)
                        ENDELSE 
                    ENDELSE 
                    FOR ll = 0, num_esa-1 DO BEGIN
                        IF ll MOD norm_esa_sum EQ 0 THEN BEGIN ; skip odd esas if summing 2 esas
                            IF finite(temp_norm_data[ll]) EQ 1 THEN temp_string = temp_string+tab+string(temp_norm_data[ll]) $
                              ELSE temp_string = temp_string+tab+'-1.00E+31'
                            IF finite(raw_data[ll, kk])   EQ 1 THEN temp_string = temp_string+tab+string(raw_data[ll, kk]) $
                              ELSE temp_string = temp_string+tab+'-1.00E+31'
                            temp_newnorm[ll, jj, temp_newnorm_i] = temp_norm_data[ll]
                            temp_newraw [ll, jj, temp_newnorm_i] = raw_data[ll, temp_newnorm_i]
                        ENDIF 
                    ENDFOR
                    temp_newnorm_i++
                    IF want_ascii EQ 1 THEN printf, out_lun, temp_string                    
                ENDFOR 
            ENDIF ELSE BEGIN    ; averaging by hour(s)
                norm_times_st = time_struct(norm_times)
                start_hour    = (norm_times_st[0]).hour
                start_st      = string(norm_times_st[0].year,  format = '(I4.4)')+'-'+$
                                string(norm_times_st[0].month, format = '(I2.2)')+'-'+$
                                string(norm_times_st[0].date,  format = '(I2.2)')+'/'
                num_hours     = ceil((stop_time-start_time)/(60*60))
                hour_i        = start_hour
                temp_string   = start_st+string(hour_i, format = '(I2.2)')+':00:00'
                temp_start    = time_double(temp_string, /epoch)
                IF want_tplot EQ 1 THEN tplot_times = dblarr(num_hours)
                FOR mm = 0, num_hours-1 DO BEGIN 
                    wanted_i = where(norm_times GE temp_start AND $
                                     norm_times LT (temp_start+(ascii_ave_time*3600)), count)
                    temp_string = time_string(temp_start)
                    IF count GT 0 THEN BEGIN 
                        norm_cycles_avg = total(norm_cycles_time[*, wanted_i], 2)
                        raw_data_avg    = total(raw_data        [*, wanted_i], 2, /nan)
                        IF when_sum_defl EQ 1 AND (ii EQ 0 OR ii EQ 6 OR ii EQ 7) THEN $
                          norm_data_avg = total(norm_data    [*, *, wanted_i], 3, /nan) ELSE $
                          norm_data_avg = total(norm_data       [*, wanted_i], 2, /nan) 
                        IF want_num_cycles EQ 1 THEN BEGIN
                            temp_norm_cycles_time = total(comb_norm_cycles_time[*, wanted_i], 2, /nan)
                            temp_string2 = temp_string
                            FOR ll = temp2_esa_start, temp2_esa_stop DO BEGIN 
                                IF ll MOD norm_esa_sum EQ 0 THEN BEGIN ; skip odd esas if summing 2 esas
                                    temp_string2 = temp_string2+tab+string(temp_norm_cycles_time[ll-temp2_esa_start])
                                ENDIF 
                            ENDFOR 
                            printf, out_lun2, temp_string2
                        ENDIF 
                        temp_string = temp_string+tab+$
                                      string(min(norm_cycles_avg, /nan))+tab+$
                                      string(max(norm_cycles_avg, /nan))
                        IF ascii_norm_format EQ 0 THEN BEGIN ; just counts
                            IF when_sum_defl EQ 1 AND (ii EQ 0 OR ii EQ 6 OR ii EQ 7) THEN $
                              norm_data_avg = total(norm_data_avg, 2, /nan) ; sum over defl
                        ENDIF ELSE BEGIN ; counts/sec
                            IF when_sum_defl EQ 1 AND (ii EQ 0 OR ii EQ 6 OR ii EQ 7) THEN BEGIN ; contains deflection
                                temp_norm_cycles_time = total(comb_norm_cycles_time[*, wanted_i], 2, /nan)
                                IF mod_count GT 0 THEN BEGIN 
                                    norm_data_avg  [mod_i, 0 ] = $
                                      norm_data_avg[mod_i, 0 ]/(temp_norm_cycles_time[mod_i]* (0.0124 + 0.0128))
                                    norm_data_avg  [mod_i, 15] = $
                                      norm_data_avg[mod_i, 15]/(temp_norm_cycles_time[mod_i] *  0.0128 * 2)
                                ENDIF 
                                IF nmod_count GT 0 THEN BEGIN 
                                    norm_data_avg  [nmod_i, 0 ] = $
                                      norm_data_avg[nmod_i, 0 ]/(temp_norm_cycles_time[nmod_i] *  0.0128 * 2)
                                    norm_data_avg  [nmod_i, 15] = $
                                      norm_data_avg[nmod_i, 15]/(temp_norm_cycles_time[nmod_i] * (0.0124 + 0.0128)) 
                                ENDIF 
                            ; deflection
                                FOR ll = 1, 14 DO BEGIN 
                                    norm_data_avg[*, ll] = norm_data_avg[*, ll]/$
                                      (temp_norm_cycles_time * 0.0128 * 2)
                                ENDFOR 
                                ; sum over deflection
                                norm_data_avg = total(norm_data_avg, 2, /nan)
                            ENDIF ELSE BEGIN  ; no defl
                                norm_data_avg = norm_data_avg/((total(comb_norm_cycles_time[*, wanted_i], 2, /nan))* 0.0128 *32)
                            ENDELSE 
                        ENDELSE 
                        FOR ll = 0, num_esa-1 DO BEGIN
                            IF (ll+esa_start) MOD norm_esa_sum EQ 0 THEN BEGIN ; skip odd esas if summing 2 esas
                                IF finite(norm_data_avg[ll]) EQ 1 THEN  temp_string = temp_string+tab+string(norm_data_avg[ll]) $
                                  ELSE  temp_string = temp_string+tab+'-1.00E+31'
                                IF finite(raw_data_avg [ll]) EQ 1 THEN temp_string = temp_string+tab+string(raw_data_avg [ll]) $
                                  ELSE  temp_string = temp_string+tab+'-1.00E+31'
                                temp_newnorm[ll, jj, mm] = norm_data_avg[ll]
                                temp_newraw [ll, jj, mm] = raw_data_avg [ll]
                            ENDIF 
                        ENDFOR 
                    ENDIF 
                    IF want_ascii EQ 1 THEN printf, out_lun, temp_string
                    IF want_tplot EQ 1 THEN tplot_times[mm] = temp_start
                    hour_i     = hour_i + 1
                    temp_start = temp_start + 3600 ; advance by an hour
                ENDFOR 
                num_records = num_hours
            ENDELSE 
            IF want_ascii EQ 1 THEN BEGIN 
                close, out_lun
                free_lun, out_lun
            ENDIF 
            IF want_num_cycles EQ 1 THEN BEGIN
                close, out_lun2
                free_lun, out_lun2
            ENDIF 
        ENDFOR  
        IF want_tplot EQ 1 THEN BEGIN
            CASE ii OF
                0: BEGIN
                    swpha_newnorm          = temp_newnorm[*, *, 0:num_records-1]
                    swpha_newraw           = temp_newraw [*, *, 0:num_records-1]
                END 
                1: BEGIN
                    wappha_ssd_newnorm     = temp_newnorm[*, *, 0:num_records-1]
                    wappha_ssd_newraw      = temp_newraw [*, *, 0:num_records-1]
                END 
                2: BEGIN
                    wappha_nossd_newnorm   = temp_newnorm[*, *, 0:num_records-1]
                    wappha_nossd_newraw    = temp_newraw [*, *, 0:num_records-1]
                END 
                3: BEGIN
                    supranoe_ssd_newnorm   = temp_newnorm[*, *, 0:num_records-1]
                    supranoe_ssd_newraw    = temp_newraw [*, *, 0:num_records-1]
                END 
                4: BEGIN
                    supranoe_nossd_newnorm = temp_newnorm[*, *, 0:num_records-1]
                    supranoe_nossd_newraw  = temp_newraw [*, *, 0:num_records-1]
                END 
                5: BEGIN
                    suprawide_newnorm      = temp_newnorm[*, *, 0:num_records-1]
                    suprawide_newraw       = temp_newraw [*, *, 0:num_records-1]
                END 
                6: BEGIN
                    swz_newnorm            = temp_newnorm[*, *, 0:num_records-1]
                    swz_newraw             = temp_newraw [*, *, 0:num_records-1]
                END 
                7: BEGIN
                    swhalpha_newnorm       = temp_newnorm[*, *, 0:num_records-1]
                    swhalpha_newraw        = temp_newraw [*, *, 0:num_records-1]
                END 
            ENDCASE 
        ENDIF 
    ENDIF 
ENDFOR 
END 
