; Lorna Ellis
; 05/21/2007
; read_pha_data_pp.pro

; This is a rewrite of the read_pha_data routine in science_overview.

; 08/06/2007 Added 10th field to valid_pha
; 10/01/2007 Added limit by section
; 10/26/2007 If no valid_pha, set to -1
; 12/07/2007 Added which_pha
; 01/24/2008 Changed format of start_time and stop_time
; 02/12/2008 Fixed problem with num_summed.
; 04/15/2008 Added fields 11-15 for nm_orig, nq_orig, nm_new, nq_new, products
; 04/18/2008 Separated section 0 and 1
; 05/27/2008 Added check for data gap when checking cycles
; 06/13/2008 Fixed bug in checking num_summed
; 07/17/2008 Fixed bug with lining up epochs
; 07/28/2008 Remove 5 minute data where schan = -1
;            Changed so timing set on epoch rather than cycle
; 10/06/2008 Added valid_pha_buffer
; 03/04/2009 Remove pha with -1 schan if normalizing
; 04/04/2011 Add check for ii-kk<0 when checking for data gap.
; 04/05/2011 Remove data when cycle1 = -1 (for normalization only).
;            Remove cycle data when all fill.
; 04/06/2011 Fix bug when cycle5 ends prematurely.
; 05/03/2011 Check for ii-kk<0 when checking for another data gap.
; 06/29/2011 Modify for V10 CDFs (DPU 32A).
; 10/10/2011 Rewrite for efficiency, and for new accumulation times.
; 02/03/2012 Remove 1 min data where schan = -1.
; 02/08/2012 Check when num_summed doesn't match across products.
; 06/13/2012 Remove times when num_summed gt 5.
; 06/13/2012 Check for DPU 327.
; 06/14/2012 Check for errors in 322 and 323.
; 06/27/2012 When Schan = 0, change section to 0.
; 09/26/2012 Fixed typo in line 191.
; 05/16/2013 Added schan to valid_pha (16th element)
; 06/04/2013 Change a lot, so this just reads data (doesn't limit), for more than one day.

PRO remove_diff, array, test_array
compile_opt strictarrsubs
bad_i1 = where(array NE test_array)
bad_i2 = array_indices(array, bad_i1)
bad_i3 = uniq  (bad_i2[1, *])
bad_i4 = reform(bad_i2[1, bad_i3])
array[*, bad_i4] = -1
END 


PRO read_pha_data_pp, which_pha, past_first, pha, sw_pri, wap_pri_ssd, wap_pri_nossd, have_data, epoch5, error5, num_summed
; in: which_pha : 1=just those that go in rates (for normalization)
;                 2=just those that don't go in rates (so we know what is missing)
;                 3=all (normalization won't make sense);
;     past_first: 0=on first cdf file, otherwise need to concatinate data
;
; out: pha          : array[768, 9, time] -- [768 is possible # of events]
; pha indices are: 0: swpe
;                  1: swpd
;                  2: quadrant
;                  3: ssd_id
;                  4: ssde
;                  5: tof
;                  6: pos
;                  7: section
;                  8: priority
;                  9: blank -- for new bin
;      sw_pri       : array[128,16,4,time] -- [esa, summed defl., class, time]
;      wap_pri_ssd  : array[128,   2,time] -- [esa,               class, time]
;      wap_pri_nossd: array[128,   2,time] -- [esa,               class, time]
;      have_data    : flag -- 0=no data
;      epoch5       : double array
;      error5       : flag (array)
;      num_summed   : [128,time] -- [esa,time]
COMMON com_pha_play
compile_opt strictarrsubs


cdf_varget, cdf_id, 'pha', temp_pha, rec_count = epoch1_info.maxrec+1, /zvariable
IF past_first EQ 0 THEN pha = temp_pha ELSE pha = [[[pha]], [[temp_pha]]] ; concat over 3rd dim.


; read 5-min data
IF which_pha NE 3 THEN BEGIN ; don't want all pha
    have_data = 0
    IF version LT 10 THEN BEGIN 
        cdf_control, cdf_id, get_var_info = epoch5_info, var = 'epoch5_heavy', /zvariable
        IF epoch5_info.maxrec GE 0 THEN BEGIN 
            have_data = 1
            cdf_varget, cdf_id, 'epoch5_heavy',          temp_epoch5,         rec_count = epoch5_info.maxrec+1, /zvariable
            cdf_varget, cdf_id, 'error5_heavy',          temp_error5,         rec_count = epoch5_info.maxrec+1, /zvariable
            cdf_varget, cdf_id, 's_chan5_heavy',         temp_s_chan5,        rec_count = epoch5_info.maxrec+1, /zvariable
            cdf_varget, cdf_id, 'heavy_ion_num_summed5', temp_num_summed,     rec_count = epoch5_info.maxrec+1, /zvariable
            cdf_varget, cdf_id, 'sw_priority',           temp_sw_pri,         rec_count = epoch5_info.maxrec+1, /zvariable 
            cdf_varget, cdf_id, 'wap_priority_ssd',      temp_wap_pri_ssd,    rec_count = epoch5_info.maxrec+1, /zvariable 
            cdf_varget, cdf_id, 'wap_priority_no_ssd',   temp_wap_pri_nossd,  rec_count = epoch5_info.maxrec+1, /zvariable 
        ENDIF 
    ENDIF ELSE BEGIN
        cdf_control, cdf_id, get_var_info = epoch5_info, var = 'epoch_heavy', /zvariable
        IF epoch5_info.maxrec GE 0 THEN BEGIN 
            have_data = 1
            cdf_varget, cdf_id, 'epoch_heavy',              temp_epoch5,         rec_count = epoch5_info.maxrec+1, /zvariable
            cdf_varget, cdf_id, 'error_sw_pri',             temp_error5,         rec_count = epoch5_info.maxrec+1, /zvariable
            cdf_varget, cdf_id, 'error_wap_ssd_pri',        temp_error_322,      rec_count = epoch5_info.maxrec+1, /zvariable
            cdf_varget, cdf_id, 'error_wap_nossd_pri',      temp_error_323,      rec_count = epoch5_info.maxrec+1, /zvariable
            cdf_varget, cdf_id, 'num_summed_sw_pri',        temp_num_summed,     rec_count = epoch5_info.maxrec+1, /zvariable
            cdf_varget, cdf_id, 'num_summed_wap_ssd_pri',   temp_num_summed_322, rec_count = epoch5_info.maxrec+1, /zvariable
            cdf_varget, cdf_id, 'num_summed_wap_nossd_pri', temp_num_summed_323, rec_count = epoch5_info.maxrec+1, /zvariable
            cdf_varget, cdf_id, 'sw_priority',              temp_sw_pri,         rec_count = epoch5_info.maxrec+1, /zvariable 
            cdf_varget, cdf_id, 'wap_priority_ssd',         temp_wap_pri_ssd,    rec_count = epoch5_info.maxrec+1, /zvariable 
            cdf_varget, cdf_id, 'wap_priority_no_ssd',      temp_wap_pri_nossd,  rec_count = epoch5_info.maxrec+1, /zvariable 
            epoch_struct = time_struct(temp_epoch5[0], /epoch) ; check for dpu version 327
            IF (sat EQ 'A' AND (epoch_struct.year LT 2011 OR (epoch_struct.year EQ 2011 AND epoch_struct.doy LE 168))) OR $
              (sat EQ 'B' AND (epoch_struct.year LT 2011 OR (epoch_struct.year EQ 2011 AND epoch_struct.doy LE 179))) THEN BEGIN 
                cdf_varget, cdf_id, 's_chan_apid319',           temp_s_chan5,        rec_count = epoch5_info.maxrec+1, /zvariable
            ENDIF ELSE BEGIN  ; dpu_post_327
                cdf_varget, cdf_id, 's_chan_sw_pri',            temp_s_chan5,        rec_count = epoch5_info.maxrec+1, /zvariable
                cdf_varget, cdf_id, 's_chan_wap_ssd_pri',       temp_s_chan_322,     rec_count = epoch5_info.maxrec+1, /zvariable
                cdf_varget, cdf_id, 's_chan_wap_nossd_pri',     temp_s_chan_323,     rec_count = epoch5_info.maxrec+1, /zvariable
                IF array_equal(temp_s_chan_322, temp_s_chan5) NE 1 THEN remove_diff, temp_s_chan5, temp_s_chan_322
                IF array_equal(temp_s_chan_323, temp_s_chan5) NE 1 THEN remove_diff, temp_s_chan5, temp_s_chan_323
            ENDELSE 
            IF array_equal(temp_error_322, temp_error5) NE 1 THEN BEGIN
                bad_i = where(temp_error_322 EQ 1, bad_count)
                IF bad_count GT 0 THEN temp_error5[bad_i] = 1
            ENDIF 
            IF array_equal(temp_error_323, temp_error5) NE 1 THEN BEGIN 
                bad_i = where(temp_error_323 EQ 1, bad_count)
                IF bad_count GT 0 THEN temp_error5[bad_i] = 1
            ENDIF 
            IF array_equal(temp_num_summed_322, temp_num_summed) NE 1 THEN remove_diff, temp_num_summed, temp_num_summed_322
            IF array_equal(temp_num_summed_323, temp_num_summed) NE 1 THEN remove_diff, temp_num_summed, temp_num_summed_323
        ENDIF 
    ENDELSE 

    IF past_first EQ 0 THEN BEGIN ; on first file
        epoch5        = reform(temp_epoch5       )
        error5        = reform(temp_error5       )
        s_chan5       = reform(temp_s_chan5      )
        num_summed    = reform(temp_num_summed   )
        sw_pri        =        temp_sw_pri        
        wap_pri_ssd   =        temp_wap_pri_ssd   
        wap_pri_nossd =        temp_wap_pri_nossd 
    ENDIF ELSE BEGIN 
        old_size = size(epoch5)
        old_num  = old_size[1]
        epoch5        = [epoch5,     reform(temp_epoch5    )]
        error5        = [error5,     reform(temp_error5    )]
        s_chan5       = [s_chan5,    reform(temp_s_chan5   )]
        num_summed    = [  [num_summed    ],   [temp_num_summed    ]]
        wap_pri_ssd   = [ [[wap_pri_ssd  ]],  [[temp_wap_pri_ssd  ]]]
        wap_pri_nossd = [ [[wap_pri_nossd]],  [[temp_wap_pri_nossd]]]
        ; need diff method for 4-dim array
        old_sw_pri = sw_pri
        new_size   = size(epoch5)
        new_num    = new_size[1]
        sw_pri     = lonarr(128, 16, 4, new_num)
        sw_pri[*, *, *, 0      :old_num-1] =  old_sw_pri
        sw_pri[*, *, *, old_num:new_num-1] = temp_sw_pri
    ENDELSE 

ENDIF 

END 
