; Lorna Ellis
; 05/21/2007
; read_limits_pp.pro
; This reads in the limits for the bins for classification

; in : file_name: the name of the limit file
;     quad_style_boxes = 0 if old limits files (min and max mass and m/q), 1 if define 4 points for each box
; out: num_bins : an array with how many limits used for each category (eg PHA_pri_rates SSD) -- size 12 elements
;      limits   : 
;         for quad_style_boxes=0: an array for the limits [rate, bin_num(as index), (bin_num, m/q min, m/q max, mass min, mass max)]
;         for quad_style_boxes=1: an array for the limits [rate, bin_num(as index), (bin_num, mq1,mass1,mq2,mass2,mq3,mass3,mq4,mass4)]
;      labels   : an array of strings with the label for each [rate, bin], for 8 rates

; 02/22/2008 Now read labels 
; 04/15/2008 Change arbitrary limit on number of bins from 25 to 50
; 04/18/2008 If simulate_instr check num_bins
; 05/22/2008 Check for empty lines.
; 09/04/2008 Added quad_style_boxes.

PRO read_limits_pp, file_name, num_bins, limits, labels, simulate_instr, quad_style_boxes
compile_opt strictarrsubs

; read in bounds for bin_dat_word
openr, binfile_lun, file_name, /get_lun
line = " "
readf, binfile_lun, line   ; read past header and first line
readf, binfile_lun, line
readf, binfile_lun, line
IF quad_style_boxes EQ 1 THEN readf, binfile_lun, line

num_bins = intarr(12)
IF quad_style_boxes EQ 0 THEN BEGIN
    num_columns = 5
    start_index = 0 
    label_index = 5
ENDIF ELSE BEGIN 
    num_columns = 9
    start_index = 1
    label_index = 0
ENDELSE 
temp_limits = fltarr(12, 50, num_columns) ; 12 categories, 50 arbitrary max number of bins expected per category, index+ limits
temp_labels = strarr(12, 50) ; labels for each bin
ii = 0
jj = 0
WHILE eof(binfile_lun) EQ 0 DO BEGIN 
    readf, binfile_lun, line    
    parts = strsplit(line, /EXTRACT)
    IF parts[0] NE '' THEN BEGIN ; check for empty line
        IF (quad_style_boxes EQ 0 AND parts[0] LT 'A') OR (quad_style_boxes EQ 1 AND parts[1] LT 'A') THEN BEGIN 
            FOR kk = start_index, start_index+num_columns-1 DO BEGIN 
                temp_limits[ii, jj, kk-start_index] = float(parts[kk]) 
            ENDFOR 
            temp_labels[ii, jj] = parts[label_index]
            jj = jj+1
        ENDIF ELSE BEGIN        ; new category
            num_bins[ii] = jj
            IF simulate_instr EQ 1 THEN BEGIN ; check for bit limit in bindatword
                too_many_bins = 0
                IF (ii EQ 0 OR ii EQ 1 OR ii EQ 10) AND jj GT 4  THEN too_many_bins = 1
                IF (ii EQ 2 OR ii EQ 3)             AND jj GT 8  THEN too_many_bins = 1
                IF (ii EQ 4 OR ii EQ 6)             AND jj GT 16 THEN too_many_bins = 1
                IF (ii EQ 8)                        AND jj GT 2  THEN too_many_bins = 1
                IF too_many_bins EQ 1 THEN BEGIN
                    print, 'Error: read_limits_pp.pro: too many bins for field in bindatword'
                    stop
                ENDIF
            ENDIF 
            ii = ii + 1
            jj = 0
        ENDELSE
    ENDIF 
ENDWHILE 
num_bins[ii] = jj ; get last category
max_num_bins = max(num_bins)
limits = fltarr(12, max_num_bins, num_columns)
limits = temp_limits[*, 0:(max_num_bins-1), *]
temp2_labels = strarr(12, max_num_bins)
temp2_labels = temp_labels[*, 0:(max_num_bins-1)]
full_limit_index = [0, 0, 1, 2, 3, 4, 6, 10] ; index for these plots into full_limits array
labels = temp2_labels[full_limit_index, *]
print, 'Finished reading input files'
close, binfile_lun
free_lun, binfile_lun
END 
