; Lorna Ellis
; 03/25/2008
; read_andrew_constants.pro

; This file reads in the carbon foil loss corrections from Andrew.

PRO read_andrew_constants, h_plus_corr, he_plus_corr, o_plus_corr
compile_opt strictarrsubs

line = ''
andrew_file = 'ConstantsTableAndrew.txt'
openr, andrew_lun, andrew_file, /get_lun

h_plus_corr = fltarr(128)
he_plus_corr = fltarr(128)
o_plus_corr = fltarr(128)

; read header -- 2 lines
readf, andrew_lun, line
readf, andrew_lun, line

; read 128 esa steps
FOR ii = 0, 127 DO BEGIN
    parts = strsplit(line, /extract, count = count)
    h_plus_corr[ii] = float(parts[7])
    he_plus_corr[ii] = float(parts[8])
    o_plus_corr[ii] = float(parts[10])
ENDFOR 

close,  andrew_lun
free_lun, andrew_lun

END 
