; Lorna Ellis
; 05/21/2007
; plot_pha_pp.pro

; This is a rewrite of plot_pha.pro
; This is meant as part of the pha_play routine

; 08/04/2007 Added check for -2 in m/q limits
; 09/28/2007 Added choice for histogram coloring
; 10/01/2007 Added choice for section
; 10/15/2007 Added option for ascii output of normalized counts
; 10/16/2007 Changed d to d_nossd and d_ssd
; 12/04/2007 Changed so get ascii for requested plots
;            Fixed bug in hourly averages (missed first value)
; 12/07/2007 Added which_pha
; 12/11/2007 Maintain deflection until after convert to counts/sec
; 01/24/2008 Took out section subtitle in histograms.
; 01/25/2008 Add option for summing defl before or after normalization
; 02/13/2008 Fixed typo in esa_string. 
;            Changed from norm_cycles to  norm_cycles_time.
;            Adjust ascii for sum over 2 esas.
; 02/15/2008 Changed myyrange in plot_data for mass=0 hist so min is 10.
; 02/27/2008 Fixed if only one bin.
; 03/03/2008 Fixed so only divide norm_data by 2 in counts/sec
; 03/05/2008 Changed classpoints to contour plots.
; 03/11/2008 Added choice for dot formadt in classpoints
; 04/15/2008 Changed to fix() to get integer indices in plot_data_2.
;            Added want_raw_ascii
;            Changed possible number of bins to 50.
; 04/18/2008 Separated section 0 from section 1
; 05/12/2208 Added check for if only one time (5 minutes)
; 05/19/2008 Added valid_mass_mq
; 06/09/2008 Fixed bug in checking for only one time.
; 06/23/2008 Fixed bug in summing over defl after normalization.
; 06/30/2008 Added full_page plot options.
; 07/15/2008 Remove .ps files.
;            Return norm_ and summed_counts_time arrays.
; 07/16/2008 Differentiate between wanting ascii and wanting .tplot
; 08/28/2008 Fixed bug where include last hour in penultimate hour.
;            Added process_ave_end
; 09/08/2008 Added quad_style_boxes.
; 09/26/2008 Added cumulative plots.
; 10/08/2008 Fixed bug in summing over defl when no avg and sum after norm and c/s.
; 10/22/2008 Fixed bug in summing over time in norm (flexible num_bins)
; 11/04/2009 Fixed bug when missing more than an hour of data.
; 04/08/2011 Fixed bug when too few levels.
; 10/10/2011 Rewrite for efficiency, and for new accumulation times.
; 05/29/2012 Fixed bug when want "dots for single points" in classpoints.
; 02/18/2013 Fix algorithm with quad style boxes.

PRO plot_data, data, plot_name, num_bins, limit_array, x_left, x_right, y_bottom, y_top, combo_plot, x_title, ind_plot
; in : data        : the data array: priority, 1000x1000, numbins
;      plot_name   : the prefix of the plot being plotted
;      num_bins    : the number of bins
;      limit_array : the array of limits (16 x 4) or (16 x 9) for quad
;      pos_x_left  : used for setting the plot on the page
;      pos_x_right : used for setting the plot on the page
;      pos_y_bottom: used for setting the plot on the page
;      pos_y_top   : used for setting the plot on the page
;      combo_plot  : 0 if only plot hist for 0 mass, 1 if also have
;                    full plot, 2 if no mass=0 hist
;      x_title     : title for x axis for histogram
;      dot_format  : 0=small circles, 1=points
;      ind_plot    : 0=summary plot, 1=individual plot

compile_opt strictarrsubs
COMMON com_pha_play

myxrange = lonarr(2)
myxrange[0] = 1
myxrange[1] = 1000
myyrange = lonarr(2)
myyrange[0] = 1
myyrange[1] = 1000
IF ind_plot EQ 1 THEN BEGIN 
    myxrange = round(full_page_limits[0, *] * 10)
    myxscale = full_page_scale[0]
    myyscale = full_page_scale[1]
ENDIF ELSE BEGIN
    myxscale = 1 ; log for summary plots
    myyscale = 1
ENDELSE 

; get x ticks
temp_data = intarr(1000, 1000)
plot, temp_data, /nodata, xrange = myxrange, yrange = myyrange, xstyle = 5, ystyle = 5, ylog=myyscale, xlog=myxscale, xtick_get = temp_x_ticks
temp_x_ticks = temp_x_ticks/10
xtick_names = string(temp_x_ticks, format = '(F5.1)')


; mass=0 histograms
IF combo_plot LT 2 THEN BEGIN
    temp_data1 = reform(data[*, *, 1, *]) ; changed from 2 when changed fill_bins_pp.pro
    IF num_bins GT 1 THEN temp_data = total(temp_data1, 3, /nan) ELSE temp_data = temp_data1
    myyrange[1] = MAX(temp_data)
    IF myyrange[1] LE 10 THEN myyrange[1] = 10
    FOR i = 0, num_bins-1 DO BEGIN 
        IF quad_style_boxes EQ 0 THEN BEGIN 
            IF limit_array[i, 2] EQ -2 THEN limit_array[i, 2] = .2 ; check for -2 in mass
            IF limit_array[i, 2] EQ -1 THEN BEGIN ; check for -1 in mass
                IF limit_array[i, 3] NE -1 THEN BEGIN
                    print, "Error with limits"
                    stop
                ENDIF 
                limit_array[i, 2] = .2
            ENDIF
            IF limit_array[i, 0] EQ -2 THEN limit_array[i, 0] = .1 ; check for -2 in m/q
            IF limit_array[i, 0] EQ -1 THEN BEGIN ; check for -1 in m/q
                IF limit_array[i, 1] NE -1 THEN BEGIN
                    print, "Error with limits"
                    stop
                ENDIF 
                limit_array[i, 0] = .1 ; changed this to make plot go all the way to left
                limit_array[i, 1] = 99
            ENDIF
        ENDIF ELSE BEGIN 
            IF limit_array[i, 1] EQ -2 THEN limit_array[i, 1] = .2 ; check for -2 in mass
            IF limit_array[i, 3] EQ -2 THEN limit_array[i, 3] = .2 ; check for -2 in mass
            IF limit_array[i, 5] EQ -2 THEN limit_array[i, 5] = .2 ; check for -2 in mass
            IF limit_array[i, 7] EQ -2 THEN limit_array[i, 7] = .2 ; check for -2 in mass
            IF limit_array[i, 1] EQ -1 OR limit_array[i, 3] EQ -1 OR $
              limit_array[i, 5] EQ -1 OR limit_array[i, 7] EQ -1 THEN BEGIN ; check for -1 in mass
                IF limit_array[i, 1] NE -1 OR limit_array[i, 3] NE -1 OR limit_array[i, 5] NE -1 OR limit_array[i, 7] NE -1 THEN BEGIN 
                    print, "Error with limits"
                    stop
                ENDIF 
                limit_array[i, 1] = 99
                limit_array[i, 3] = 99
                limit_array[i, 5] = .2
                limit_array[i, 7] = .2
            ENDIF
            IF limit_array[i, 0] EQ -2 THEN limit_array[i, 0] = .1 ; check for -2 in m/q
            IF limit_array[i, 2] EQ -2 THEN limit_array[i, 2] = .1 ; check for -2 in m/q
            IF limit_array[i, 4] EQ -2 THEN limit_array[i, 4] = .1 ; check for -2 in m/q
            IF limit_array[i, 6] EQ -2 THEN limit_array[i, 6] = .1 ; check for -2 in m/q
            IF limit_array[i, 0] EQ -1 OR limit_array[i, 2] EQ -1 OR $
              limit_array[i, 4] EQ -1 OR limit_array[i, 6] EQ -1 THEN BEGIN ; check for -1 in m/q
                IF limit_array[i, 0] NE -1 OR limit_array[i, 2] NE -1 OR limit_array[i, 4] NE -1 OR limit_array[i, 6] NE -1 THEN BEGIN
                    print, "Error with limits"
                    stop
                ENDIF 
                limit_array[i, 0] = .1 ; changed this to make plot go all the way to left
                limit_array[i, 2] = 99 ; changed this to make plot go all the way to left
                limit_array[i, 4] = 99
                limit_array[i, 6] = .1
            ENDIF
        ENDELSE 
    ENDFOR 
    IF combo_plot EQ 0 THEN BEGIN
        temp_title = plot_name 
        temp_y_top = y_top
    ENDIF ELSE BEGIN 
        temp_title = '  '
        IF ind_plot EQ 1 THEN temp_y_top = y_top -.6 ELSE temp_y_top = y_top -.13
    ENDELSE 
    plot, temp_data, /nodata, xrange = myxrange, yrange = myyrange, xstyle = 5, ystyle = 4, $
          ylog = myyscale, xlog = myxscale, ytick_get = y_ticks
    y_ticklabels = strarr(n_elements(y_ticks))

    IF combo_plot EQ 1 THEN BEGIN 
        y_ticklabels[0] = string(y_ticks[0], format = '(E8.2)')
        FOR ii = 1, n_elements(y_ticks)-2 DO BEGIN 
            y_ticklabels[ii] = ' '
        ENDFOR
        y_ticklabels[n_elements(y_ticks)-1] = string(y_ticks[n_elements(y_ticks)-1], format = '(E8.2)')
    ENDIF ELSE BEGIN 
        FOR ii = 0, n_elements(y_ticks)-1 DO BEGIN 
            y_ticklabels[ii] = ''
        ENDFOR
    ENDELSE 
    PLOT, temp_data, /NODATA, TITLE = temp_title, XTITLE = x_title, YTITLE = 'Count', $
          XRANGE = myxrange, YRANGE = myyrange, xstyle = 1, $
          XTICKNAME = xtick_names, ytickname = y_ticklabels, BACKGROUND = 255, COLOR = 0, $
          POSITION = [x_left, y_bottom+.025, x_right, temp_y_top], xlog=myxscale, ylog=myyscale
    FOR j = 0, 3 DO BEGIN       ; priorities
        CASE j OF
            0: loadct, 7 ; Red-Purple
            1: loadct, 8 ; Green/White Linear 
            2: loadct, 3 ; Red Temperature
            3: loadct, 1 ; B-W linear
        ENDCASE 
        oplot, temp_data[j, *], color = 150 ; middle of color table?
    ENDFOR 
    FOR i = 0, num_bins-1 DO BEGIN
        IF quad_style_boxes EQ 0 THEN BEGIN 
            IF limit_array[i, 2] EQ .2 THEN BEGIN 
                OPLOT, [limit_array[i, 0]*10, limit_array[i, 0]*10], [1, myyrange[1]]
                OPLOT, [limit_array[i, 1]*10, limit_array[i, 1]*10], [1, myyrange[1]]
            ENDIF 
        ENDIF ELSE BEGIN
            IF limit_array[i, 5] EQ .2 AND limit_array[i, 7] EQ .2 THEN BEGIN 
                OPLOT, [limit_array[i, 4]*10, limit_array[i, 4]*10], [1, myyrange[1]]
                OPLOT, [limit_array[i, 6]*10, limit_array[i, 6]*10], [1, myyrange[1]]
            ENDIF 
        ENDELSE 
    ENDFOR 
ENDIF 

IF combo_plot GT 0 THEN BEGIN ; point plot
    temp_array = intarr(1000, 1000)
    IF ind_plot EQ 1 THEN BEGIN
        myyrange = round(full_page_limits[1, *] * 10)
        IF combo_plot EQ 1 THEN BEGIN
            temp_y_bottom = y_top - .5
            temp_x_style = 1 ; full axis
        ENDIF ELSE BEGIN 
            temp_y_bottom = y_bottom
            temp_x_style = 9 ; was 5
        ENDELSE 
    ENDIF ELSE BEGIN 
        myyrange = [1, 1000]
        IF combo_plot EQ 1 THEN BEGIN
            temp_y_bottom = y_top -.14 
            temp_x_style = 5 ; suppress axis
        ENDIF ELSE BEGIN
            temp_y_bottom = y_bottom + .025
            temp_x_style = 9 ; half-box axis
        ENDELSE 
    ENDELSE 
    contour, temp_array, /NODATA, XRANGE = myxrange, YRANGE = myyrange, XSTYLE = 5,  YSTYLE = 5, XLOG=MYXSCALE, YLOG=MYYSCALE, $
             ytick_get = temp_y_ticks
    temp_y_ticks = temp_y_ticks/10
    ytick_names = string(temp_y_ticks, format = '(F5.1)')
    IF ind_plot EQ 0 THEN ytick_names[0] = ' '
    contour, temp_array, /NODATA, TITLE = plot_name, XTITLE = ' ', YTITLE = 'Mass', $
             XRANGE = myxrange, YRANGE = myyrange, XSTYLE = temp_x_style,  YSTYLE = 1, XLOG=MYXSCALE, YLOG=MYYSCALE, $
             XTICKNAME = xtick_names, ytickname = ytick_names, BACKGROUND = 255, COLOR = 0, $
             POSITION = [x_left, temp_y_bottom, x_right, y_top]
    data[*, *, 1, *] = 0 ; get rid of counts with 0 mass -- this used to be 2
    data[*, 1, *, *] = data[*, 0, *, *] + data[*, 1, *, *] ; combine first two bins because don't plot 0 -- I think
    temp_array = 0

    ncontours = 256
    min = .1D
    IF dot_format EQ 0 THEN BEGIN 
        a = findgen(17)*(!PI*2/16.) ; create circle for plotting psym
        usersym, cos(a)/4, sin(a)/4, /fill
    ENDIF 
    FOR j = 0, 3 DO BEGIN       ; priorities
        pri_data = reform(data[j, *, *, *])
        IF size(data, /n_dimensions) GT 3 THEN pri_data = total(pri_data, 3, /nan) ; sum over bins
        max = double(max(pri_data))
        IF max GT 0 THEN BEGIN 
            IF ind_plot EQ 1 AND full_page_contours[0] NE -1 THEN levels = full_page_contours ELSE $
              levels = 10 ^ ((indgen(ncontours))*(alog10(max)-alog10(min))/(ncontours-1)+alog10(min))
            CASE j OF
                0: loadct, 7    ; Red-Purple
                1: loadct, 8    ; Green/White Linear 
                2: loadct, 3    ; Red Temperature
                3: loadct, 1    ; B-W linear
            ENDCASE 
            non_zero = WHERE(pri_data, num_non_zero)
            non_zero_i = array_indices(pri_data, non_zero)
            IF dot_format EQ 0 THEN oplot, reform(non_zero_i[0, *]), reform(non_zero_i[1, *]), psym = 8, color = 150 $
            ;  ELSE oplot, (non_zero_i[0, *]/10.0), (non_zero_i[1, *]/10.0), color = 150 
            ELSE BEGIN 
                FOR i = 0L, num_non_zero-1 DO BEGIN 
                    IF dot_format EQ 0 THEN OPLOT, [non_zero_i[0, i]], [non_zero_i[1, i]], PSYM = 8, COLOR = 150 $
                    ELSE OPLOT, [non_zero_i[0, i]], [non_zero_i[1, i]], COLOR = 150 
                ENDFOR 
            ENDELSE 
            contour, pri_data, /overplot, /fill, levels = levels
        ENDIF 
    ENDFOR 
    pri_data = 0 ; deallocate memory
    FOR i = 0, num_bins-1 DO BEGIN 
        IF quad_style_boxes EQ 0 THEN BEGIN 
            IF limit_array[i, 2] EQ -2 THEN limit_array[i, 2] = .2 ; check for -2 in mass
            IF limit_array[i, 3] EQ -2 THEN limit_array[i, 3] = .5
            IF limit_array[i, 2] EQ -1 THEN BEGIN ; check for -1 in mass
                IF limit_array[i, 3] NE -1 THEN BEGIN
                    print, "Error with limits"
                ENDIF 
                limit_array[i, 2] = .2
                limit_array[i, 3] = 99
            ENDIF
            IF limit_array[i, 0] EQ -2 THEN limit_array[i, 0] = .1 ; check for -2 in m/q
            IF limit_array[i, 0] EQ -1 THEN BEGIN ; check for -1 in m/q
                IF limit_array[i, 1] NE -1 THEN BEGIN
                    print, "Error with limits"
                ENDIF 
                limit_array[i, 0] = .1 ; changed to make plot go further left
                limit_array[i, 1] = 99
            ENDIF
            num_columns = 4
        ENDIF ELSE BEGIN 
            IF limit_array[i, 1] EQ -2 THEN limit_array[i, 1] = .2 ; check for -2 in mass
            IF limit_array[i, 3] EQ -2 THEN limit_array[i, 3] = .2 ; check for -2 in mass
            IF limit_array[i, 5] EQ -2 THEN limit_array[i, 5] = .2 ; check for -2 in mass
            IF limit_array[i, 7] EQ -2 THEN limit_array[i, 7] = .2 ; check for -2 in mass
            IF limit_array[i, 1] EQ -1 OR limit_array[i, 3] EQ -1 OR $
              limit_array[i, 5] EQ -1 OR limit_array[i, 7] EQ -1 THEN BEGIN ; check for -1 in mass
                IF limit_array[i, 1] NE -1 OR limit_array[i, 3] NE -1 OR limit_array[i, 5] NE -1 OR limit_array[i, 7] NE -1 THEN BEGIN 
                    print, "Error with limits"
                    stop
                ENDIF 
                limit_array[i, 1] = 99
                limit_array[i, 3] = 99
                limit_array[i, 5] = .2
                limit_array[i, 7] = .2
            ENDIF
            IF limit_array[i, 0] EQ -2 THEN limit_array[i, 0] = .1 ; check for -2 in m/q
            IF limit_array[i, 2] EQ -2 THEN limit_array[i, 2] = .1 ; check for -2 in m/q
            IF limit_array[i, 4] EQ -2 THEN limit_array[i, 4] = .1 ; check for -2 in m/q
            IF limit_array[i, 6] EQ -2 THEN limit_array[i, 6] = .1 ; check for -2 in m/q
            IF limit_array[i, 0] EQ -1 OR limit_array[i, 2] EQ -1 OR $
              limit_array[i, 4] EQ -1 OR limit_array[i, 6] EQ -1 THEN BEGIN ; check for -1 in m/q
                IF limit_array[i, 0] NE -1 OR limit_array[i, 2] NE -1 OR limit_array[i, 4] NE -1 OR limit_array[i, 6] NE -1 THEN BEGIN
                    print, "Error with limits"
                    stop
                ENDIF 
                limit_array[i, 0] = .1 ; changed this to make plot go all the way to left
                limit_array[i, 2] = 99 ; changed this to make plot go all the way to left
                limit_array[i, 4] = 99
                limit_array[i, 6] = .1
            ENDIF
            num_columns = 8
        ENDELSE 
        FOR j = 0, num_columns-1 DO BEGIN
            IF limit_array[i, j] EQ .1 THEN limit_array[i, j] = .11 ; so see limit on graph
            IF limit_array[i, j] EQ 100 THEN limit_array[i, j] = 99 ; so see limit on graph
        ENDFOR 
    ENDFOR 
    FOR i = 0, num_bins-1 DO BEGIN
        temp_limits = round(reform(limit_array[i, *])*10)
        IF ind_plot EQ 1 THEN BEGIN
            IF quad_style_boxes EQ 0 THEN BEGIN 
                IF (temp_limits[2] LT myyrange[0] AND temp_limits[3] LT myyrange[0]) OR $
                  (temp_limits[2] GT myyrange[1] AND temp_limits[3] GT myyrange[1]) OR $
                  (temp_limits[0] LT myyrange[0] AND temp_limits[1] LT myyrange[0]) OR $
                  (temp_limits[0] GT myyrange[1] AND temp_limits[1] GT myyrange[1]) THEN in_range = 0 ELSE BEGIN
                    IF temp_limits[0] LT myxrange[0] THEN temp_limits[0] = myxrange[0]
                    IF temp_limits[1] GT myxrange[1] THEN temp_limits[1] = myxrange[1]
                    IF temp_limits[2] LT myyrange[0] THEN temp_limits[2] = myyrange[0]
                    IF temp_limits[3] GT myyrange[1] THEN temp_limits[3] = myyrange[1]
                    in_range = 1
                ENDELSE 
            ENDIF ELSE BEGIN
                IF (temp_limits[0] LT myxrange[0] AND temp_limits[2] LT myxrange[0] AND $
                    temp_limits[4] LT myxrange[0] AND temp_limits[6] LT myxrange[0]) OR $
                  (temp_limits[0] GT myxrange[1] AND temp_limits[2] GT myxrange[1] AND $
                   temp_limits[4] GT myxrange[1] AND temp_limits[6] GT myxrange[1]) OR $
                  (temp_limits[1] LT myyrange[0] AND temp_limits[3] LT myyrange[0] AND $
                   temp_limits[5] LT myyrange[0] AND temp_limits[7] LT myyrange[0]) OR $
                  (temp_limits[1] GT myyrange[1] AND temp_limits[3] GT myyrange[1] AND $
                   temp_limits[5] GT myyrange[1] AND temp_limits[7] GT myyrange[1]) THEN in_range = 0 $
                     ELSE in_range = 1
            ENDELSE 
        ENDIF ELSE in_range = 1
        IF in_range EQ 1 THEN BEGIN 
            IF quad_style_boxes EQ 0 THEN BEGIN 
                OPLOT, [temp_limits[0], temp_limits[1]], [temp_limits[2], temp_limits[2]]
                OPLOT, [temp_limits[0], temp_limits[1]], [temp_limits[3], temp_limits[3]]
                OPLOT, [temp_limits[0], temp_limits[0]], [temp_limits[2], temp_limits[3]]
                OPLOT, [temp_limits[1], temp_limits[1]], [temp_limits[2], temp_limits[3]]
            ENDIF ELSE BEGIN
                OPLOT, [temp_limits[0], temp_limits[2]], [temp_limits[1], temp_limits[3]]
                OPLOT, [temp_limits[2], temp_limits[4]], [temp_limits[3], temp_limits[5]]
                OPLOT, [temp_limits[4], temp_limits[6]], [temp_limits[5], temp_limits[7]]
                OPLOT, [temp_limits[6], temp_limits[0]], [temp_limits[7], temp_limits[1]]
            ENDELSE 
        ENDIF 
    ENDFOR 
ENDIF 


END


PRO plot_data2, file_name, limits, limits_bins, counts, num_bins, pos_x_left, pos_x_right, pos_y_bottom, pos_y_top, quad_style_boxes
; in : file_name       : the prefix of the plot being plotted
;      limits          : the limits array    : for each bin, limits 
;      limits_bins     : same as limits, but in bin numbers not mass, m/q
;      counts          : array    : for each bin, the count
;      num_bins        : the number of bins
;      pos_x_left      : used for setting the plot on the page
;      pos_x_right     : used for setting the plot on the page
;      pos_y_bottom    : used for setting the plot on the page
;      pos_y_top       : used for setting the plot on the page
;      quad_style_boxes: 0=original box format, 1=4 points specified for each box

; change form of data
IF quad_style_boxes EQ 0 THEN BEGIN
    data2 = FLTARR(1001, 1001)
ENDIF ELSE BEGIN 
    data2 = FLTARR(256, 96)
    nm_i_array = intarr(256, 96)
    nq_i_array = intarr(256, 96)
    FOR ii = 0, 95 DO BEGIN
        nm_i_array[*, ii] = ii
    ENDFOR 
    FOR ii = 0, 255 DO BEGIN
        nq_i_array[ii, *] = ii
    ENDFOR 
    bin_index = lonarr(num_bins, 2) ; 0=index into full_index_arr, 1=num elements for this bin
ENDELSE 
FOR i = 0, num_bins-1 DO BEGIN
    IF quad_style_boxes EQ 0 THEN BEGIN 
        IF limits[i, 0] EQ -2 THEN limits[i, 0] = .1 ; check for -2 in m/q
        IF limits[i, 2] EQ -2 THEN limits[i, 2] = .2 ; check for -2 in mass
        IF limits[i, 3] EQ -2 THEN limits[i, 3] = .5
        IF limits[i, 2] EQ -1 THEN BEGIN ; check for -1 in mass
            IF limits[i, 3] NE -1 THEN BEGIN
                print, "Error with limits"
                stop
            ENDIF 
            limits[i, 2] = .2
            limits[i, 3] = 100
        ENDIF
        IF limits[i, 0] EQ -1 THEN BEGIN ; check for -1 in m/q
            IF limits[i, 1] NE -1 THEN BEGIN
                print, "Error with limits"
                stop
            ENDIF 
            limits[i, 0] = .1   ; changed this to make plot go further left
            limits[i, 1] = 100
        ENDIF
    ENDIF ELSE BEGIN 
        IF limits_bins[i, 1] EQ -1 THEN limits_bins[i, 1] = 0
        IF limits_bins[i, 2] EQ -1 THEN limits_bins[i, 2] = 95
        IF limits_bins[i, 3] EQ -1 THEN limits_bins[i, 3] = 255
        IF limits_bins[i, 4] EQ -1 THEN limits_bins[i, 4] = 95
        IF limits_bins[i, 5] EQ -1 THEN limits_bins[i, 5] = 255
        IF limits_bins[i, 6] EQ -1 THEN limits_bins[i, 6] = 0
        IF limits_bins[i, 7] EQ -1 THEN limits_bins[i, 7] = 0
        IF limits_bins[i, 8] EQ -1 THEN limits_bins[i, 8] = 0
    ENDELSE 
ENDFOR
FOR i = 1, num_bins DO BEGIN    ; fill each bin, in reverse order (num_bins-i)
    IF quad_style_boxes EQ 0 THEN BEGIN 
        m_q_min  = fix(limits[num_bins-i, 0] * 10)
        m_q_max  = fix(limits[num_bins-i, 1] * 10)
        mass_min = fix(limits[num_bins-i, 2] * 10)
        mass_max = fix(limits[num_bins-i, 3] * 10)
        FOR j = num_bins-i, num_bins-2 DO BEGIN ; empty any overlapping bins (j+i)
            j_m_q_min  = fix(limits[j, 0] * 10)
            j_m_q_max  = fix(limits[j, 1] * 10)
            j_mass_min = fix(limits[j, 2] * 10)
            j_mass_max = fix(limits[j, 3] * 10)
            FOR k = j_m_q_min, j_m_q_max DO BEGIN
                FOR l = j_mass_min, j_mass_max DO BEGIN
                    IF k GE m_q_min AND k LE m_q_max AND l GE mass_min AND l LE mass_max THEN data2[k, l] = 0
                ENDFOR
            ENDFOR
        ENDFOR
        data2[m_q_min:m_q_max, mass_min:mass_max] = counts[num_bins-i] ; fill full array
    ENDIF ELSE BEGIN 
        temp_limits = double(limits_bins)
        ; find the 4 boundary lines -- start with top left
        slope1 = (temp_limits[num_bins-i, 4] - temp_limits[num_bins-i, 2]) / (temp_limits[num_bins-i, 3] - temp_limits[num_bins-i, 1])   
        slope2 = (temp_limits[num_bins-i, 6] - temp_limits[num_bins-i, 4]) / (temp_limits[num_bins-i, 5] - temp_limits[num_bins-i, 3])   
        slope3 = (temp_limits[num_bins-i, 8] - temp_limits[num_bins-i, 6]) / (temp_limits[num_bins-i, 7] - temp_limits[num_bins-i, 5])   
        slope4 = (temp_limits[num_bins-i, 2] - temp_limits[num_bins-i, 8]) / (temp_limits[num_bins-i, 1] - temp_limits[num_bins-i, 7])   
        y_int1 = temp_limits[num_bins-i, 2] - (slope1 * temp_limits[num_bins-i, 1])
        y_int2 = temp_limits[num_bins-i, 4] - (slope2 * temp_limits[num_bins-i, 3])
        y_int3 = temp_limits[num_bins-i, 6] - (slope3 * temp_limits[num_bins-i, 5])
        y_int4 = temp_limits[num_bins-i, 8] - (slope4 * temp_limits[num_bins-i, 7])
        IF limits_bins[num_bins-i, 3] EQ limits_bins[num_bins-i, 5] AND limits_bins[num_bins-i, 1] EQ limits_bins[num_bins-i, 7] THEN BEGIN 
            temp_i = where( $   ; second and fourth lines are vertical
                     (nm_i_array LE ((slope1*nq_i_array)+y_int1))       AND $ ; top line
                     (nq_i_array LE limits_bins[num_bins-i, 3])         AND $ ; right side
                     (nm_i_array GE ((slope3*nq_i_array)+y_int3))       AND $ ; bottom
                     (nq_i_array GE limits_bins[num_bins-i, 1]), count) ; left side
        ENDIF ELSE IF limits_bins[num_bins-i, 1] EQ limits_bins[num_bins-i, 3] AND $
          limits_bins[num_bins-i, 5] EQ limits_bins[num_bins-i, 7] THEN BEGIN 
            temp_i = where( $ ; first and third lines are vertical 
                     (nq_i_array LE limits_bins[num_bins-i, 1])         AND $ ; right side
                     (nm_i_array GE ((slope2*nq_i_array)+y_int2))       AND $ ; bottom
                     (nq_i_array GE limits_bins[num_bins-i, 5])         AND $ ; left side
                     (nm_i_array LE ((slope4*nq_i_array)+y_int4)), count) ; top
        ENDIF ELSE IF limits_bins[num_bins-i, 3] EQ limits_bins[num_bins-i, 5] THEN BEGIN ; right side is vertical (and second)
            temp_i = where( $ 
                     (nm_i_array LE ((slope1*nq_i_array)+y_int1))       AND $ ; top line
                     (nq_i_array LE limits_bins[num_bins-i, 3])         AND $ ; right side
                     (nm_i_array GE ((slope3*nq_i_array)+y_int3))       AND $ ; bottom
                     (nq_i_array GE ((nm_i_array-y_int4)/slope4)), count) ; left side
        ENDIF ELSE IF limits_bins[num_bins-i, 1] EQ limits_bins[num_bins-i, 3] THEN BEGIN ; right side is vertical (and first)
            temp_i = where( $ 
                     (nq_i_array LE limits_bins[num_bins-i, 1])         AND $ ; right side
                     (nm_i_array GE ((slope2*nq_i_array)+y_int2))       AND $ ; bottom
                     (nq_i_array GE ((nm_i_array-y_int3)/slope3))       AND $ ; left side
                     (nm_i_array LE ((slope4*nq_i_array)+y_int4)), count) ; top line
        ENDIF ELSE IF limits_bins[num_bins-i, 1] EQ limits_bins[num_bins-i, 7] THEN BEGIN ; left side is vertical (and fourth)
            temp_i = where( $        ; overwrite
                     (nm_i_array LE ((slope1*nq_i_array)+y_int1))       AND $ ; top line
                     (nq_i_array LE ((nm_i_array-y_int2)/slope2))       AND $ ; right side
                     (nm_i_array GE ((slope3*nq_i_array)+y_int3))       AND $ ; bottom
                     (nq_i_array GE limits_bins[num_bins-i, 1]), count) ; left side
        ENDIF ELSE IF limits_bins[num_bins-i, 5] EQ limits_bins[num_bins-i, 7] THEN BEGIN ; left side is vertical (and third)
            temp_i = where( $        ; overwrite
                     (nq_i_array LE ((nm_i_array-y_int1)/slope1))       AND $ ; right side
                     (nm_i_array GE ((slope2*nq_i_array)+y_int2))       AND $ ; bottom
                     (nq_i_array GE limits_bins[num_bins-i, 5])         AND $ ; left side
                     (nm_i_array LE ((slope4*nq_i_array)+y_int4)), count) ; top line
        ENDIF ELSE BEGIN        ; no sides are vertical
            temp_i = where( $   ; overwrite
                     (nm_i_array LE ((slope1*nq_i_array)+y_int1)) AND $ ; top line
                     (nq_i_array LE ((nm_i_array-y_int2)/slope2)) AND $ ; right side
                     (nm_i_array GE ((slope3*nq_i_array)+y_int3)) AND $ ; bottom
                     (nq_i_array GE ((nm_i_array-y_int4)/slope4)), count) ; left side
        ENDELSE 
        IF count GT 0 THEN BEGIN 
            data2[temp_i] = counts[num_bins-i]
            bin_index[num_bins-i, 0] = n_elements(full_index_array)
            bin_index[num_bins-i, 1] = count
            IF n_elements(full_index_array) EQ 0 THEN BEGIN 
                full_index_array = temp_i
            ENDIF ELSE BEGIN
                full_index_array = [full_index_array, temp_i]
            ENDELSE 
        ENDIF 
    ENDELSE 
ENDFOR

; determine the number of levels
counts      = long(counts)
level_array = SORT(counts)   ; gives index that each element of counts would have in a sorted array
bin_level   = intarr(num_bins) ; use this as index into level_array to get sorted levels (i.e. level_array[bin_level[0]]) -- tells which level each element in counts should have
temp = -1
num_levels = 0
FOR i = 0, num_bins-1 DO BEGIN      
    IF (counts[level_array[i]] NE temp) AND (level_array[i] LT num_bins) THEN BEGIN
        num_levels = num_levels + 1
        temp = counts[level_array[i]]
    ENDIF
ENDFOR
mylevels = LONARR(num_levels) ; array of levels in order
level = 0
temp = -1
FOR i = 0, num_bins-1 DO BEGIN
    IF counts[level_array[i]] NE temp AND level_array[i] LT num_bins THEN BEGIN
        mylevels[level] = counts[level_array[i]]
        level = level + 1
        temp = counts[level_array[i]]
    ENDIF
ENDFOR
temp_num_bin = 0
bin_level[level_array[0]] = temp_num_bin
FOR i = 1, num_bins-1 DO BEGIN 
    IF temp_num_bin LT num_levels THEN $
      IF counts[level_array[i]] GE mylevels[temp_num_bin] THEN temp_num_bin = temp_num_bin + 1    
    bin_level[level_array[i]] = temp_num_bin
ENDFOR 
;IF file_name EQ 'WapPHA_SSD' THEN stop
bad_i = where(bin_level GE num_levels, bad_count)
IF bad_count GT 0 THEN bin_level[bad_i] = bin_level[bad_i]-1

; plot data
mytitle = file_name
myxrange = intarr(2)
myyrange = intarr(2)
IF quad_style_boxes EQ 0 THEN BEGIN 
    myxrange[0] = 1
    myxrange[1] = 1000
    myyrange[0] = 1
    myyrange[1] = 1000
ENDIF ELSE BEGIN 
    myxrange[0] = 0
    myxrange[1] = 255
    myyrange[0] = 0
    myyrange[1] = 95
ENDELSE 
mycolors = FLTARR(num_levels)
FOR i = 0, num_levels-1 DO BEGIN
    mycolors[i] = (i * 250/num_levels) + 10
ENDFOR

;plot axis and first bin
IF quad_style_boxes EQ 0 THEN BEGIN 
    CONTOUR, data2, /nodata, TITLE = mytitle, XTITLE = 'Mass/Charge [amu/q]', YTITLE = 'Mass', $
             XRANGE = myxrange, YRANGE = myyrange, XSTYLE = 1,  YSTYLE = 1, NLEVELS = 1, $
             C_COLORS = [mycolors[bin_level[0]]], LEVELS = [mylevels[bin_level[0]]], /XLOG, /YLOG, $
             XTICKNAME = ['0.1', '1.0', '10.0', '100.0'], $
             YTICKNAME = ['0.1', '1.0', '10.0', '100.0'], BACKGROUND = 255, COLOR = 0, $
             POSITION = [pos_x_left, pos_y_bottom+.06, pos_x_right, pos_y_top]
;plot the rest of the bins
    FOR jj = 1, num_bins DO BEGIN 
        kk = num_bins - jj
        xmin = fix(limits[kk, 0] * 10) ; get first min m/q
        xmax = fix(limits[kk, 1] * 10)
        ymin = fix(limits[kk, 2] * 10)
        ymax = fix(limits[kk, 3] * 10)
        IF xmin EQ xmax THEN BEGIN 
            IF ymin EQ ymax THEN BEGIN
                data3 = fltarr(2, 2)
                data3[0, 0] = data2[xmin, ymin]
            ENDIF ELSE BEGIN
                data3 = fltarr(2, ymax-ymin+1)
                data3[0, *] = data2[xmin, ymin:ymax]
            ENDELSE
        ENDIF ELSE BEGIN
            IF ymin EQ ymax THEN BEGIN
                data3 = fltarr(xmax-xmin+1, 2)
                data3[*, 0] = data2[xmin:xmax, ymin]
            ENDIF ELSE BEGIN    ; have a reasonable array
                data3 = data2[xmin:xmax, ymin:ymax]
            ENDELSE
        ENDELSE
        IF xmin EQ xmax THEN x = fltarr(2) ELSE x = FLTARR(xmax-xmin+1)
        FOR i = 0, xmax-xmin DO BEGIN
            x[i] = xmin + i
        ENDFOR
        IF ymin EQ ymax THEN y = fltarr(2) ELSE y = FLTARR(ymax-ymin+1)
        FOR i = 0, ymax-ymin DO BEGIN
            y[i] = ymin + i
        ENDFOR
        data3[*, *] = mylevels[bin_level[kk]]
        CONTOUR, data3, x, y, /FILL, /OVERPLOT, NLEVELS = 1, $
                 C_COLORS = [mycolors[bin_level[kk]]], LEVELS = [mylevels[bin_level[kk]]]
    ENDFOR
ENDIF ELSE BEGIN
    ; main plot
    CONTOUR, data2, /nodata, TITLE = mytitle, XTITLE = '', YTITLE = 'NM bin', $
             XRANGE = myxrange, YRANGE = myyrange, XSTYLE = 1,  YSTYLE = 1, NLEVELS = 1, $
             C_COLORS = [mycolors[bin_level[0]]], LEVELS = [mylevels[bin_level[0]]], $
             BACKGROUND = 255, COLOR = 0, $
             XTICKNAME = [' ', ' ', ' ', ' ', ' ', ' '], $
             POSITION = [pos_x_left, pos_y_bottom+.07, pos_x_right, pos_y_top]
    FOR jj = 1, num_bins DO BEGIN
        kk = num_bins-jj
        start_i = bin_index[kk, 0] ; index into full_index_array
        stop_i  = bin_index[kk, 0] + bin_index[kk, 1] - 1
        data3   = fltarr(256, 96)
        data3[*, *] = -1
        data3[full_index_array[start_i:stop_i]] = mylevels[bin_level[kk]]
        CONTOUR, data3, /fill, /overplot, NLEVELS = 1, $
                 C_COLORS = [mycolors[bin_level[kk]]], LEVELS = [mylevels[bin_level[kk]]]
    ENDFOR 
    ; mass = 0 plot
    CONTOUR, data2, /nodata, XTITLE = 'NQ bin', YTITLE = '', $
             XRANGE = myxrange, YRANGE = [0, 1], XSTYLE = 1,  YSTYLE = 4, NLEVELS = 1, $
             C_COLORS = [mycolors[bin_level[0]]], LEVELS = [mylevels[bin_level[0]]], $
             BACKGROUND = 255, COLOR = 0, $
             ytickname = [' ', ' '], $
             POSITION = [pos_x_left, pos_y_bottom+.06, pos_x_right, pos_y_bottom+.07]
    FOR jj = 1, num_bins DO BEGIN
        kk = num_bins-jj
        start_i = bin_index[kk, 0]  ; index into full_index_array
        stop_i = bin_index[kk, 0] + bin_index[kk, 1] - 1
        data3 = fltarr(256, 96)
        data3[*, *] = -1
        data3[full_index_array[start_i:stop_i]] = mylevels[bin_level[kk]]
        data4 = fltarr(256, 2)
        data4[*, 0] = data3[*, 0]
        data4[*, 1] = data3[*, 0]
        CONTOUR, data4, /fill, /overplot, NLEVELS = 1, $
                 C_COLORS = [mycolors[bin_level[kk]]], LEVELS = [mylevels[bin_level[kk]]]
    ENDFOR 
ENDELSE     

legend_data = intarr(num_levels+1, 2)
legend_levels = intarr(num_levels+1)
myticks = STRARR(num_levels+1)
IF mylevels[0] LE 9999 THEN myticks[0] = STRING(mylevels[0], FORMAT = '(F5.0)') ELSE myticks[0] = STRING(mylevels[0], FORMAT = '(E7.1)')
FOR k = 0, num_levels DO BEGIN
    legend_data[k, 0:1] = k
    legend_levels[k] = k
    IF k LT num_levels THEN BEGIN 
        IF mylevels[k] LE 9999 THEN myticks[k+1] = STRING(mylevels[k], FORMAT = '(F5.0)') ELSE $
          myticks[k+1] = STRING(mylevels[k], FORMAT = '(E7.1)')
        mylevels[k] = strcompress(mylevels[k], /remove_all)
    ENDIF 
ENDFOR
IF (num_levels GT 4) AND (num_levels LE 8) THEN BEGIN
    myticks[0] = ' '
    FOR k = 0, num_levels-1 DO BEGIN 
        IF (k MOD 2 EQ 1) AND (strlen(myticks[k+1]) GT 4) THEN myticks[k+1] = '  '
    ENDFOR
ENDIF 
IF (num_levels GT 8) THEN BEGIN
    myticks[0] = ' '
    FOR k = 0, num_levels-1 DO BEGIN 
        IF (k MOD 3 NE 0) THEN myticks[k+1] = '  '
    ENDFOR
ENDIF 

myxrange[0] = 0
myxrange[1] = num_levels
myyrange[0] = 0
myyrange[1] = 1
CONTOUR, legend_data, /FILL, TITLE = ' ', XTITLE = 'Number of Counts', COLOR = 0, $
         XRANGE = myxrange, YRANGE = myyrange, XSTYLE = 1,  YSTYLE = 1, NLEVELS = num_levels, $
         C_COLORS = mycolors, LEVELS = legend_levels, YTICKS = 1, YTICKINTERVAL = 5, $
         XTICKNAME = myticks, XTICKINTERVAL = 1, POSITION = [pos_x_left, pos_y_bottom, pos_x_right, pos_y_top-.135]
END


PRO plot_pha_pp, full_bins, hist_coloring, when_sum_defl, valid_pha, $
                 cdf_base_brief, swpha_counts, wappha_ssd_counts, wappha_nossd_counts, $
                 supranoe_ssd_counts, supranoe_nossd_counts, suprawide_counts, swz_counts, $
                 swhalpha_counts, plot_names, $
                 swpha_raw, wappha_ssd_raw, wappha_nossd_raw, $
                 supranoe_ssd_raw, supranoe_nossd_raw, suprawide_raw, swz_raw, $
                 swhalpha_raw, num_bins, limits, full_limit_index, $
                 temp_esa_start, temp_esa_stop, temp_esa_st, temp_energy_start, temp_energy_stop, $
                 swpha_norm, wappha_ssd_norm, wappha_nossd_norm, $
                 supranoe_ssd_norm, supranoe_nossd_norm, suprawide_norm, swz_norm, $
                 swhalpha_norm

; in:  full_bins        : array of limits as bins (12 x 16 x 5)
;      hist_coloring    : 0=by priority in pha word, 1=by assigned priority
;      want_ascii       : 0=no, 1=yes
;      ascii_ave_time   : number of hours over which to average ascii output (0 = don't average)
;      ascii_norm_format: 0=counts, 1=counts/sec
;      which_pha        : 1=just those that go in rates (for normalization)
;                         2=just those that don't go in rates (so we know what is missing)
;                         3=all (normalization won't make sense)
;      when_sum_defl    : 0=sum before normalization, 1=sum after normalization
;      want_raw_ascii   : 0=no, 1=yes (ascii of pha data plus nm, nq)
;      want_tplot       : 0=no, 1=yes
;      valid_pha        : array[16, num_valid_pha]

COMMON com_pha_play
compile_opt strictarrsubs

; plot individual data
    IF files_wanted[0] EQ 1 THEN BEGIN 
        ind_plot = 0
        mydevice = !D.NAME
        SET_PLOT, 'PS'
        outname = plot_dir+'/classpoints_'+cdf_base_brief
        IF esa_range_format EQ 1 THEN outname = outname+temp_esa_st
        outname = outname+'_'+suffix
        temp_outname = outname+'.ps'
        DEVICE, FILENAME = temp_outname, /COLOR, PORTRAIT = 1, /INCHES, xsize = 8.5, ysize = 10, XOFFSET = 0, YOFFSET = 0
        loadct, 39
        !NOERAS = 1
        xyouts, .15, .96, 'ST'+sat+' '+time_st, /NORMAL, size = 1.5
        esa_string = STRING(temp_esa_start, FORMAT = '(I3)')+'-'+string(temp_esa_stop, format = '(I3)')
        IF temp_esa_start EQ -1 THEN subtitle = "ESA:"+esa_string ELSE $
          subtitle = "ESA:"+esa_string+","+string(temp_energy_start, format = '(F5.2)')+$
                     ' -'+string(temp_energy_stop, format = '(F5.2)')+" keV"
        subtitle = subtitle+', '+limit_filename
        xyouts, .05, .94, subtitle, /NORMAL, size = 1.2
        mycolors = FLTARR(4)
        FOR i = 0, 3 DO BEGIN
            mycolors[i] = (i * 250/4) + 10
        ENDFOR
        x_left   = [.1,    .1,     .1,   .1,    .55,   .55,   .55,   .55  ] ; coordinate for left x position
        x_right  = [.45,   .45,   .45,   .45,   .9,    .9,    .9,    .9   ]
        y_bottom = [.6975, .485,  .2725, .06,   .6975, .485,  .2725, .06  ]
        y_top    = [.89,   .6775, .465,  .2525, .89,   .6775, .465,  .2525]
        n = N_ELEMENTS(plot_names)
        FOR i = 0, n-1 DO BEGIN 
            print, "starting classpoints part ", i
            IF plots_wanted[i] EQ 1 THEN BEGIN 
                CASE i OF 
                    0: data = swpha_raw
                    1: data = wappha_ssd_raw
                    2: data = wappha_nossd_raw
                    3: data = supranoe_ssd_raw
                    4: data = supranoe_nossd_raw
                    5: data = suprawide_raw
                    6: data = swz_raw
                    7: data = swhalpha_raw
                ENDCASE 
                CASE i OF 
                    0: combo_plot = 1
                    1: combo_plot = 1
                    2: combo_plot = 0
                    3: combo_plot = 0
                    4: combo_plot = 0
                    5: combo_plot = 2
                    6: combo_plot = 1
                    7: combo_plot = 1
                ENDCASE 
                CASE i OF 
                    0: x_title = ' '
                    1: x_title = ' '
                    2: x_title = ' '
                    3: x_title = 'Mass/Charge [amu/q]'
                    4: x_title = ' '
                    5: x_title = ' '
                    6: x_title = ' '
                    7: x_title = 'Mass/Charge [amu/q]'
                ENDCASE 
                IF esa_range_format EQ 1 THEN BEGIN 
                    data = total(data[temp_esa_start-esa_start:temp_esa_stop-esa_start, *, *, *, *], 1, /nan) 
                ENDIF 
                plot_data, data, plot_names[i], num_bins[i], REFORM(limits[i, *, *]), $
                           x_left[i], x_right[i], y_bottom[i], y_top[i], combo_plot, x_title, ind_plot
            ENDIF 
        ENDFOR 
        FOR jj = 0, 3 DO BEGIN
            CASE jj OF 
                0: loadct, 7    ; Red-Purple
                1: loadct, 8    ; Green/White Linear 
                2: loadct, 3    ; Red Temperature
                3: loadct, 1    ; B-W linear
            ENDCASE 
            xyouts, .05+(jj*.05), .02, "+", COLOR = 150, /NORMAL
            temp_string = STRING(jj)
            xyouts, .015+(jj*.05), .02, temp_string, /NORMAL
        ENDFOR
        temp_string = "Color indicates priority"
        xyouts, .015+(5*.05), .02, temp_string, /NORMAL
        plot_stamp
        DEVICE, /CLOSE
        SET_PLOT, mydevice
        !NOERAS = 0
        command_string = 'convert -density 288 -geometry 25% -sharpen 3 ' + outname + '.ps ' + outname + '.png'
        spawn, command_string
        command_string = 'rm '+outname+'.ps'
        spawn, command_string

        ; full page plots
        IF want_full_page EQ 1 THEN BEGIN 
            ind_plot = 1
            FOR ii = 0, n-1 DO BEGIN 
                print, "starting individual classpoints part ", ii
                IF plots_wanted[ii] EQ 1 THEN BEGIN 
                    mydevice = !D.NAME
                    SET_PLOT, 'PS'
                    CASE ii OF 
                        0: data = swpha_raw
                        1: data = wappha_ssd_raw
                        2: data = wappha_nossd_raw
                        3: data = supranoe_ssd_raw
                        4: data = supranoe_nossd_raw
                        5: data = suprawide_raw
                        6: data = swz_raw
                        7: data = swhalpha_raw
                    ENDCASE 
                    CASE ii OF 
                        0: combo_plot = 1
                        1: combo_plot = 1
                        2: combo_plot = 0
                        3: combo_plot = 0
                        4: combo_plot = 0
                        5: combo_plot = 2
                        6: combo_plot = 1
                        7: combo_plot = 1
                    ENDCASE 
                    CASE ii OF 
                        0: x_title = ' '
                        1: x_title = ' '
                        2: x_title = ' '
                        3: x_title = 'Mass/Charge [amu/q]'
                        4: x_title = ' '
                        5: x_title = ' '
                        6: x_title = ' '
                        7: x_title = 'Mass/Charge [amu/q]'
                    ENDCASE 
                    IF esa_range_format EQ 1 THEN BEGIN 
                        data = total(data[temp_esa_start-esa_start:temp_esa_stop-esa_start, *, *, *, *], 1, /nan) 
                    ENDIF 
                    outname = plot_dir+'/ind_classpoints_'+cdf_base_brief+'_'+plot_names[ii]
                    IF esa_range_format EQ 1 THEN outname = outname+temp_esa_st
                    outname = outname+'_'+suffix
                    temp_outname = outname+'.ps'
                    DEVICE, FILENAME = temp_outname, /COLOR, PORTRAIT = 1, /INCHES, xsize = 8.5, ysize = 10, XOFFSET = 0, YOFFSET = 0
                    loadct, 39
                    !NOERAS = 1
                    xyouts, .15, .96, 'ST'+sat+' '+time_st, /NORMAL, size = 1.5
                    esa_string = STRING(temp_esa_start, FORMAT = '(I3)')+'-'+string(temp_esa_stop, format = '(I3)')
                    IF temp_esa_start EQ -1 THEN subtitle = "ESA:"+esa_string ELSE $
                      subtitle = "ESA:"+esa_string+","+string(temp_energy_start, format = '(F5.2)')+$
                                 ' -'+string(temp_energy_stop, format = '(F5.2)')+" keV"
                    subtitle = subtitle+', '+limit_filename
                    xyouts, .05, .94, subtitle, /NORMAL, size = 1.2
                    plot_data, data, plot_names[ii], num_bins[ii], REFORM(limits[ii, *, *]), $
                               .1, .9, .06, .89, combo_plot, x_title, ind_plot
                    FOR jj = 0, 3 DO BEGIN ; priorities
                        CASE jj OF 
                            0: loadct, 7 ; Red-Purple
                            1: loadct, 8 ; Green/White Linear 
                            2: loadct, 3 ; Red Temperature
                            3: loadct, 1 ; B-W linear
                        ENDCASE 
                        xyouts, .05+(jj*.05), .02, "+", COLOR = 150, /NORMAL
                        temp_string = STRING(jj)
                        xyouts, .015+(jj*.05), .02, temp_string, /NORMAL
                    ENDFOR 
                    temp_string = "Color indicates priority" 
                    xyouts, .015+(5*.05), .02, temp_string, /NORMAL
                    plot_stamp
                    DEVICE, /CLOSE
                    SET_PLOT, mydevice
                    !NOERAS = 0
                    command_string = 'convert -density 288 -geometry 25% -sharpen 3 ' + outname + '.ps ' + outname + '.png'
                    spawn, command_string
                    command_string = 'rm '+outname+'.ps'
                    spawn, command_string
                ENDIF 
            ENDFOR 
        ENDIF 
    ENDIF 

; plot aggregated data
    IF files_wanted[1] EQ 1 THEN BEGIN 
        mydevice = !D.NAME
        SET_PLOT, 'PS'
        outname = plot_dir+'/classbins_'+cdf_base_brief
        IF esa_range_format EQ 1 THEN outname = outname+temp_esa_st
        outname = outname+'_'+suffix
        temp_outname = outname+'.ps'
        DEVICE, FILENAME = temp_outname, /COLOR, PORTRAIT = 1, /INCHES, xsize = 8.5, ysize = 10, XOFFSET = 0, YOFFSET = 0
        loadct, 39
        !NOERAS = 1
        xyouts, .15, .96, 'ST'+sat+' '+time_st, /NORMAL, size = 1.5
        esa_string = STRING(temp_esa_start, FORMAT = '(I3)')+'-'+string(temp_esa_stop, format = '(I3)')
        IF temp_esa_start EQ -1 THEN subtitle = "ESA:"+esa_string ELSE $
          subtitle = "ESA:"+esa_string+","+string(temp_energy_start, format = '(F6.2)')+$
          ' -'+string(temp_energy_stop, format = '(F6.2)')+" keV"
        IF section_wanted EQ -2 THEN subtitle = subtitle+', All sections' $
        ELSE IF section_wanted EQ -1 THEN subtitle = subtitle+', Sections 0/1' $
             ELSE subtitle = subtitle+', Section '+string(section_wanted, format = '(I1.1)')
        subtitle = subtitle+', '+limit_filename
        xyouts, .05, .94, subtitle, /NORMAL, size = 1.2
        file_array = ['SwPha', 'WapPHA_SSD', 'Wap_PHA_noSSD', 'SupraNoE_SSD', 'SupraNoE_noSSD', 'SupraWide', 'Swz2', 'Sw_H_alpha']
        x_left     = [.10, .10, .10, .10, .55, .55, .55, .55] ; coordinate for left x position
        x_right    = [.45, .45, .45, .45, .90, .90, .90, .90]
        y_bottom   = [.75, .53, .31, .09, .75, .53, .31, .09]
        y_top      = [.90, .68, .46, .24, .90, .68, .46, .24]
        n = N_ELEMENTS(file_array)
        FOR i = 0, n-1 DO BEGIN
            IF plots_wanted[i] EQ 1 THEN BEGIN
                CASE i OF 
                    0: data = swpha_counts
                    1: data = wappha_ssd_counts
                    2: data = wappha_nossd_counts
                    3: data = supranoe_ssd_counts
                    4: data = supranoe_nossd_counts
                    5: data = suprawide_counts
                    6: data = swz_counts
                    7: data = swhalpha_counts
                ENDCASE 
                IF esa_range_format EQ 1 THEN BEGIN 
                    temp_data = total(data[temp_esa_start-esa_start:temp_esa_stop-esa_start, *, *, *, *], 1, /nan) 
                ENDIF ELSE temp_data = total(data,      1, /nan) ; sum over esa
                temp_data = total(temp_data, 1, /nan) ; sum over defl
                temp_data = total(temp_data, 1, /nan) ; sum over priority
                temp_data = total(temp_data, 2, /nan) ; sum over time
                plot_data2, file_array[i], REFORM(limits[i, *, *]), reform(full_bins[full_limit_index[i], *, *]), $
                            temp_data, num_bins[i], $
                            x_left[i], x_right[i], y_bottom[i], y_top[i], quad_style_boxes
            ENDIF 
        ENDFOR
        plot_stamp
        DEVICE, /CLOSE
        SET_PLOT, mydevice
        !NOERAS = 0
        command_string = 'convert -density 288 -geometry 25% -sharpen 3 ' +outname + '.ps ' + outname + '.png'
        spawn, command_string
        command_string = 'rm '+outname+'.ps'
        spawn, command_string
    ENDIF 

; plot normalized data
    IF files_wanted[2] EQ 1 THEN BEGIN 
        num_esa = temp_esa_stop-temp_esa_start+1
        mydevice = !D.NAME
        SET_PLOT, 'PS'
        outname = plot_dir+'/normbins_'+cdf_base_brief
        IF esa_range_format EQ 1 THEN outname = outname+temp_esa_st
        outname = outname+'_'+suffix
        temp_outname = outname+'.ps'
        DEVICE, FILENAME = temp_outname, /COLOR, PORTRAIT = 1, /INCHES, xsize = 8.5, ysize = 10, XOFFSET = 0, YOFFSET = 0
        loadct, 39
        !NOERAS = 1
        xyouts, .15, .96, 'ST'+sat+' '+time_st, /NORMAL, size = 1.5
        esa_string = STRING(temp_esa_start, FORMAT = '(I3)')+'-'+string(temp_esa_stop, format = '(I3)')
        IF temp_esa_start EQ -1 THEN subtitle = "ESA:"+esa_string ELSE $
          subtitle = "ESA:"+esa_string+","+string(temp_energy_start, format = '(F6.2)')+$
                     ' -'+string(temp_energy_stop, format = '(F6.2)')+" keV"
        IF section_wanted EQ -2 THEN subtitle = subtitle+', All sections' $
        ELSE IF section_wanted EQ -1 THEN subtitle = subtitle+', Sections 0/1' $
             ELSE subtitle = subtitle+', Section '+string(section_wanted, format = '(I1.1)')
        subtitle = subtitle+', norm:'+string(norm_interval, format = '(I3)')+' '+limit_filename
        xyouts, .05, .94, subtitle, /NORMAL, size = 1.2
        file_array = ['SwPha', 'WapPHA_SSD', 'Wap_PHA_noSSD', 'SupraNoE_SSD', 'SupraNoE_noSSD', $
                      'SupraWide', 'Swz2', 'Sw_H_alpha']
        x_left   = [.10, .10, .10, .10, .55, .55, .55, .55] ; coordinate for left x position
        x_right  = [.45, .45, .45, .45, .90, .90, .90, .90]
        y_bottom = [.75, .53, .31, .09, .75, .53, .31, .09]
        y_top    = [.90, .68, .46, .24, .90, .68, .46, .24]
        n = N_ELEMENTS(file_array)
        FOR i = 0, n-1 DO BEGIN
            IF plots_wanted[i] EQ 1 THEN BEGIN
                CASE i OF 
                    0: data = swpha_norm
                    1: data = wappha_ssd_norm
                    2: data = wappha_nossd_norm
                    3: data = supranoe_ssd_norm
                    4: data = supranoe_nossd_norm
                    5: data = suprawide_norm
                    6: data = swz_norm
                    7: data = swhalpha_norm
                ENDCASE 
                ; reduce ESA if necessary
                IF esa_range_format EQ 1 THEN BEGIN 
                    data = data[temp_esa_start-esa_start:temp_esa_stop-esa_start, *, *, *, *]
                ENDIF 
                ; sum over time
                SWITCH i OF 
                    0:
                    6:
                    7: BEGIN
                        IF when_sum_defl EQ 0 THEN BEGIN
                            IF n_elements(data) GT (num_esa      * num_bins[i]) THEN data = total(data, 3, /nan) 
                        ENDIF ELSE BEGIN
                            IF n_elements(data) GT (num_esa * 16 * num_bins[i]) THEN data = total(data, 4, /nan)
                        ENDELSE 
                        BREAK
                    END
                    1: 
                    2:
                    3:
                    4:
                    5: IF n_elements(data) GT (num_esa * num_bins[i]) THEN data = total(data, 3, /nan) ; sum over time
                ENDSWITCH 
                data = total(data, 1, /nan) ; sum over esa
                IF when_sum_defl EQ 1 AND (i EQ 0 OR i EQ 6 OR i EQ 7) THEN data = total(data, 1, /nan) ; sum over defl
                plot_data2, file_array[i], REFORM(limits[i, *, *]), reform(full_bins[full_limit_index[i], *, *]), data, num_bins[i], $
                            x_left[i], x_right[i], y_bottom[i], y_top[i], quad_style_boxes
            ENDIF 
        ENDFOR
        plot_stamp
        DEVICE, /CLOSE
        SET_PLOT, mydevice
        !NOERAS = 0
        command_string = 'convert -density 288 -geometry 25% -sharpen 3 ' + outname + '.ps ' + outname + '.png'
        spawn, command_string
        command_string = 'rm '+outname+'.ps'
        spawn, command_string
    ENDIF 

; plot histograms
    IF files_wanted[3] EQ 1 THEN BEGIN 
        wanted_i = where(valid_pha[0, *] GE temp_esa_start AND valid_pha[0, *] LE temp_esa_stop, count)
        IF count GT 0 THEN BEGIN 
            temp_valid_pha = valid_pha[*, wanted_i]
        ENDIF            
        FOR i = 0, 4 DO BEGIN   ; 5 hist_ files
            IF (section_wanted EQ -2) OR $
              (section_wanted  EQ -1 AND (i EQ 0  OR i EQ 1 OR i EQ 2)) OR $
              (section_wanted  EQ  0 AND (i EQ 0  OR i EQ 1 OR i EQ 2)) OR $
              (section_wanted  EQ  1 AND (i EQ 0  OR i EQ 1 OR i EQ 2)) OR $
              (section_wanted  EQ  2 AND  i EQ 3) OR $
              (section_wanted  EQ  3 AND  i EQ 4) THEN BEGIN 
                CASE i OF 
                    0: outname = plot_dir+'/hist_0-1_'   +cdf_base_brief
                    1: outname = plot_dir+'/hist_0-1_y0_'+cdf_base_brief
                    2: outname = plot_dir+'/hist_0-1_n0_'+cdf_base_brief
                    ELSE: outname = plot_dir+'/hist_'+string(i-1, format = '(Z1)')+'_'+cdf_base_brief
                ENDCASE 
                IF esa_range_format EQ 1 THEN outname = outname+temp_esa_st
                outname = outname+'_'+suffix
                temp_outname = outname+'.ps' 
                mydevice = !D.NAME
                SET_PLOT, 'PS'
                DEVICE, FILENAME = temp_outname, /COLOR, PORTRAIT = 1, /INCHES, xsize = 8.5, ysize = 10, XOFFSET = 0, YOFFSET = 0
                loadct, 39
                !NOERAS = 1
                IF i LE 2 THEN BEGIN
                    IF section_wanted LT 0 THEN file_string = 'ST'+sat+' '+time_st+' Sections 0/1' ELSE $
                      file_string = 'ST'+sat+' '+time_st+' Section '+string(section_wanted, format = '(Z1)')
                ENDIF ELSE file_string = 'ST'+sat+' '+time_st+' Section '+string(i-1, format = '(Z1)')
                xyouts, .1, .96, file_string, /NORMAL, size = 1.5
                esa_string = STRING(temp_esa_start, FORMAT = '(I3)')+'-'+string(temp_esa_stop, format = '(I3)')
                IF temp_esa_start EQ -1 THEN subtitle = "ESA:"+esa_string ELSE $
                  subtitle = "ESA:"+esa_string+","+string(temp_energy_start, format = '(F5.2)')+$
                             ' -'+string(temp_energy_stop, format = '(F5.2)')+" keV"
                IF i EQ 1 THEN subtitle = subtitle+", pos=0"
                IF i EQ 2 THEN subtitle = subtitle+", pos>0"
                xyouts, .25, .94, subtitle, /NORMAL, size = 1.2
                
    ; find right section
                CASE i OF 
                    0: index_wanted = where((  reform(temp_valid_pha[7, *]) EQ 0) OR (reform(temp_valid_pha[7, *]) EQ 1), count_wanted) 
                    1: index_wanted = where((( reform(temp_valid_pha[7, *]) EQ 0) OR (reform(temp_valid_pha[7, *]) EQ 1)) AND $
                                            (  reform(temp_valid_pha[6, *]  EQ 0)), count_wanted) ; sec 0/1, pos == 0
                    2: index_wanted = where((( reform(temp_valid_pha[7, *]) EQ 0) OR (reform(temp_valid_pha[7, *]) EQ 1)) AND $
                                            (  reform(temp_valid_pha[6, *]  NE 0)), count_wanted) ; sec 0/1, pos != 0
                    ELSE: index_wanted = where(reform(temp_valid_pha[7, *]) EQ i-1, count_wanted)
                ENDCASE 
            
                                ; tof
                myxrange    = intarr(2)
                myxrange[0] = 0
                myxrange[1] = 1025
                myyrange    = fltarr(2)
                myyrange[0] = .1
                data = fltarr(4, 1024)      
                FOR jj = 0L, count_wanted-1 DO BEGIN 
                    IF hist_coloring EQ 0 THEN temp_pri = temp_valid_pha[8, index_wanted[jj]] $ ; color by pha priority
                    ELSE temp_pri = temp_valid_pha[9, index_wanted[jj]] ; color by new priority
                    temp_tof = temp_valid_pha[5, index_wanted[jj]]
                    data[temp_pri, temp_tof] = data[temp_pri, temp_tof] + 1
                ENDFOR 
                temp_index = where(data EQ 0, count)
                IF count GT 0 THEN data[temp_index] = .1
                myyrange[1] = MAX(data)
                PLOT, data, /nodata, TITLE = 'tof Histogram', XTITLE = 'tof', YTITLE = 'Count', XRANGE = myxrange, $
                      YRANGE = myyrange, BACKGROUND = 255, COLOR = 0, POSITION = [.1, .55, .45, .9], /YLOG
                FOR j = 0, 3 DO BEGIN 
                    oplot, data[j, *], color = (j * 250/4)+25
                ENDFOR 
    
                                ; tof vs. ssde
                myyrange[0] = 10
                myyrange[1] = 1200
                data = fltarr(4, 1024, 1024) ; priority, tof, ssde
                FOR jj = 0L, count_wanted-1 DO BEGIN 
                    IF hist_coloring EQ 0 THEN temp_pri = temp_valid_pha[8, index_wanted[jj]] $ ; color by pha priority
                    ELSE temp_pri = temp_valid_pha[9, index_wanted[jj]] ; color by new priority
                    temp_tof  = temp_valid_pha[5, index_wanted[jj]]
                    temp_ssde = temp_valid_pha[4, index_wanted[jj]]
                    data[temp_pri, temp_tof, temp_ssde] = data[temp_pri, temp_tof, temp_ssde] + 1
                ENDFOR 
    ; plot top
                dummy = replicate(' ', 7)
                PLOT, data, /NODATA, TITLE = 'tof vs. ssde', YTITLE = 'ssde', XRANGE = myxrange, ystyle = 1, xtickname = dummy, $
                      YRANGE = myyrange, BACKGROUND = 255, COLOR = 0, POSITION = [.55, .61, .9, .9], /YLOG
                FOR ii = 0, 3 DO BEGIN ; color by priority
                    temp_data = reform(data[ii, *, *])
                    non_zero = WHERE(temp_data NE 0, num_non_zero)
                    FOR j = 0L, num_non_zero-1 DO BEGIN
                        temp_index = non_zero[j]
                        temp_y = (temp_index / 1024)
                        temp_x = temp_index MOD 1024
                        IF temp_y EQ 0 THEN temp_y = .1
                        OPLOT, [temp_x], [temp_y], PSYM = 1, color = (ii * 250/4)+25
                    ENDFOR 
                ENDFOR 
    ; plot bottom, which is hist for when ssde=0
                no_energy = reform(data[*, *, 0]) ; want ssde=0
                temp_index = where(no_energy EQ 0, count)
                IF count GT 0 THEN no_energy[temp_index] = .1
                myyrange[0] = .1
                myyrange[1] = max(no_energy) 
                PLOT, no_energy, /NODATA, XTITLE = 'tof', YTITLE = 'count', yticks = 2, XRANGE = myxrange, $
                      YRANGE = myyrange, BACKGROUND = 255, COLOR = 0, POSITION = [.55, .55, .9, .6], /YLOG
                FOR j = 0, 3 DO BEGIN ; color by priority
                    oplot, no_energy[j, *], color = (j * 250/4)+25
                ENDFOR 

        ; pos
                myxrange[1] = 64
                myyrange[0] = .1
                data = fltarr(4, 64)
                FOR jj = 0L, count_wanted-1 DO BEGIN 
                    IF hist_coloring EQ 0 THEN temp_pri = temp_valid_pha[8, index_wanted[jj]] $ ; color by pha priority
                    ELSE temp_pri = temp_valid_pha[9, index_wanted[jj]] ; color by new priority
                    temp_pos = temp_valid_pha[6, index_wanted[jj]]
                    data[temp_pri, temp_pos] = data[temp_pri, temp_pos] + 1
                ENDFOR 
                temp_index = where(data EQ 0, count)
                IF count GT 0 THEN data[temp_index] = .1
                myyrange[1] = MAX(data)
                PLOT, data, /nodata, TITLE = 'Position Histogram', XTITLE = 'Position', YTITLE = 'Count', XRANGE = myxrange, $
                      YRANGE = myyrange, BACKGROUND = 255, COLOR = 0, POSITION = [.55, .1, .9, .45], /YLOG 
                FOR j = 0, 3 DO BEGIN ; color by priority
                    oplot, data[j, *], color = (j * 250/4)+25
                    xyouts, .25+(j*.1), .02, "+", COLOR = (j * 250/4)+25, /NORMAL
                    temp_string = STRING(j)
                    xyouts, .215+(j*.1), .02, temp_string, /NORMAL
                ENDFOR
                IF hist_coloring EQ 0 THEN xyouts, .6, .02, 'pha priority', /normal $ 
                ELSE xyouts, .6, .02, 'simulated bin', /normal
            
        ; ssde
                mycolors = FLTARR(16) ; 16 ssd_id values
                FOR j = 0, 15 DO BEGIN
                    mycolors[j] = (j * 250/16) + 15
                ENDFOR
                myxrange[0] = 0
                myxrange[1] = 1024 ; was 13250
                myyrange[0] = 0.1
                data = fltarr(16, 1024) ; ssd_id, ssde
                FOR jj = 0L, count_wanted-1 DO BEGIN 
                    temp_ssd_id = temp_valid_pha[3, index_wanted[jj]]
                    temp_ssde = temp_valid_pha[4, index_wanted[jj]]
                    data[temp_ssd_id, temp_ssde] = data[temp_ssd_id, temp_ssde] + 1
                ENDFOR 
                temp_index = where(data EQ 0, count)
                IF count GT 0 THEN data[temp_index] = .1
                myyrange[1] = MAX(data)
                PLOT, data, /NODATA, TITLE = 'ssde Histogram', XTITLE = 'ssde', YTITLE = 'Count', XRANGE = myxrange, $
                      YRANGE = myyrange, BACKGROUND = 255, COLOR = 0, POSITION = [.1, .1, .45, .45], /YLOG
                FOR j = 0, 15 DO BEGIN ; color by priority
                    oplot, data[j, *], color = (j * 250/16)+15
                    xyouts, .05+(j*.05), .05, "+", COLOR = (j * 250/16)+15, /NORMAL
                    temp_string = STRING(j)
                    xyouts, .015+(j*.05), .05, temp_string, /NORMAL
                ENDFOR
                xyouts, .85, .05, 'ssdid', /normal
                plot_stamp
                DEVICE, /CLOSE
                SET_PLOT, mydevice
                !NOERAS = 0
                command_string = 'convert -density 288 -geometry 25% -sharpen 3 ' + outname + '.ps ' + outname + '.png'
                spawn, command_string
                command_string = 'rm '+outname+'.ps'
                spawn, command_string
            ENDIF 
        ENDFOR 
        print, "finished histograms"
        data = 0
    ENDIF 
END 
