; Lorna Ellis
; 10/28/2011
; plot_cum_pha.pro

; This was separated from plot_pha_pp.pro so that it can include all
; ESAs

PRO plot_cum_pha, valid_pha, cdf_base_brief
                   
COMMON com_pha_play
compile_opt strictarrsubs

; plot cumulative plots (tof vs. ESA, m/q vs. ESA)
outname = plot_dir+'/cum_'+cdf_base_brief
outname = outname+'_'+suffix
temp_outname = outname+'.ps' 
mydevice = !D.NAME
SET_PLOT, 'PS'
DEVICE, FILENAME = temp_outname, /COLOR, PORTRAIT = 1, /INCHES, xsize = 8.5, ysize = 10, XOFFSET = 0, YOFFSET = 0
loadct, 39
!NOERAS = 1
xyouts, .15, .96, 'ST'+sat+' '+time_st, /NORMAL, size = 1.5
esa_string = STRING(esa_start, FORMAT = '(I3)')+'-'+string(esa_stop, format = '(I3)')
IF esa_start EQ -1 THEN subtitle = "ESA:"+esa_string ELSE $
  subtitle = "ESA:"+esa_string+","+string(energy_start, format = '(F6.2)')+$
             ' -'+string(energy_stop, format = '(F6.2)')+" keV"
IF section_wanted EQ -2 THEN subtitle = subtitle+', All sections' $
ELSE IF section_wanted EQ -1 THEN subtitle = subtitle+', Sections 0/1' $
     ELSE subtitle = subtitle+', Section '+string(section_wanted, format = '(I1.1)')
xyouts, .25, .94, subtitle, /NORMAL, size = 1.2

x_left   = [.10, .10]           ; coordinate for left x position
x_right  = [.90, .90]
y_bottom = [.53, .09]
y_top    = [.90, .46]

                                ; tof vs. ESA
myxrange    = intarr(2)
myxrange[0] = 0
myxrange[1] = 127
myyrange    = fltarr(2)
myyrange[0] = 0
myyrange[1] = 1024
data = lonarr(128, 1024)        ; ESA, tof
FOR ii = esa_start, esa_stop DO BEGIN
    FOR jj = 0, 1023 DO BEGIN 
        temp_i = where(valid_pha[0, *] EQ ii AND valid_pha[5, *] EQ jj, count)
        data[ii, jj] = count
    ENDFOR
ENDFOR 
max_data  = max(data)
min_data  = .1D
ncontours = 100
levels = 10 ^ ((indgen(ncontours))*(alog10(max_data)-alog10(min_data))/(ncontours-1)+alog10(min_data))
CONTOUR, data, /nodata, xtickname = [' ', ' ', ' ', ' '], YTITLE = 'TOF bin', $
         XRANGE = myxrange, YRANGE = myyrange, POSITION = [.1, .53, .8, .9]
non_zero   = WHERE(data, num_non_zero)
non_zero_i = array_indices(data, non_zero)
FOR i = 0L, num_non_zero-1 DO BEGIN 
    temp_level = where(data[non_zero[i]] GT levels, temp_count)
    IF temp_count GT 0 THEN temp_color = temp_level[0] ELSE temp_color = (ncountours-1)
    OPLOT, [non_zero_i[0, i]], [non_zero_i[1, i]], COLOR = (double(temp_color)*(255/99))
ENDFOR 
CONTOUR, data, /fill, /overplot, levels = levels

        ; color bar
data   = dblarr(3, 11)
top    = .9
bottom = .53
left   = .8
right  = .85
data[*, 0] = levels[0]
FOR ii = 1, 10 DO BEGIN
    data[*, ii] = levels[(ncontours * ii / 10)-1] 
ENDFOR 
CONTOUR, data, /fill, xticks = 1, xtickname = [' ', ' '], yticks = 1, ytickname = [' ', ' '], $
         POSITION = [left, bottom, right, top], levels = levels
FOR ii = 1, 10 DO BEGIN
    data[*, ii] = levels[(ncontours * ii / 10)-1] 
    xyouts, (right+.01), (bottom+(ii*(top-bottom)/10)-.01), string(data[0, ii], format = '(E8.2)'), /normal
ENDFOR 

                                ; NQ vs. ESA
myxrange    = intarr(2)
myxrange[0] = 0
myxrange[1] = 127
myyrange    = fltarr(2)
myyrange[0] = 0
myyrange[1] = 256
data        = lonarr(128, 256)  ; ESA, nq
FOR ii = 0, 127 DO BEGIN
    FOR jj = 0, 255 DO BEGIN 
        IF which_mass_mq_algorithm EQ 1 THEN temp_i = where(valid_pha[0, *] EQ ii AND valid_pha[13, *] EQ jj, count) $
        ELSE temp_i = where(valid_pha[0, *] EQ ii AND valid_pha[11, *] EQ jj, count) 
        data[ii, jj] = count
    ENDFOR
ENDFOR
max_data = max(data)
min_data = .1D
ncontours = 100
levels = 10 ^ ((indgen(ncontours))*(alog10(max_data)-alog10(min_data))/(ncontours-1)+alog10(min_data))
CONTOUR, data, /nodata, xtickname = [' ', ' ', ' ', ' '], YTITLE = 'NQ bin', $
         XRANGE = myxrange, YRANGE = myyrange, POSITION = [.1, .16, .8, .53], levels = levels
non_zero = WHERE(data, num_non_zero)
non_zero_i = array_indices(data, non_zero)
FOR i = 0L, num_non_zero-1 DO BEGIN 
    temp_level = where(data[non_zero[i]] GT levels, temp_count)
    IF temp_count GT 0 THEN temp_color = temp_level[0] ELSE temp_color = (ncountours-1)
    OPLOT, [non_zero_i[0, i]], [non_zero_i[1, i]], COLOR = (double(temp_color)*(255/99))
ENDFOR 
CONTOUR, data, /fill, /overplot, levels = levels
        ; colorbar
data = dblarr(3, 11)
top    = .53
bottom = .16
left   = .8
right  = .85
data[*, 0] = levels[0]
FOR ii = 1, 10 DO BEGIN
    data[*, ii] = levels[(ncontours * ii / 10)-1] 
ENDFOR 
CONTOUR, data, /fill, xticks = 1, xtickname = [' ', ' '], yticks = 1, ytickname = [' ', ' '], $
         POSITION = [left, bottom, right, top], levels = levels
xyouts, (right+.01), (bottom-.01), string(data[0, 0], format = '(E8.2)'), /normal
FOR ii = 1, 10 DO BEGIN
    data[*, ii] = levels[(ncontours * ii / 10)-1] 
    xyouts, (right+.01), (bottom+(ii*(top-bottom)/10)-.01), string(data[0, ii], format = '(E8.2)'), /normal
ENDFOR 

myxrange    = intarr(2)
myxrange[0] = 0
myxrange[1] = 127
myyrange    = fltarr(2)
myyrange[0] = 0
data        = lonarr(128)       ; ESA
FOR ii = 0, 127 DO BEGIN
    temp_i = where(valid_pha[0, *] EQ ii, count) 
    data[ii] = count
ENDFOR 
myyrange[1] = max(data)
plot, data, xtitle = 'ESA step', ytitle = 'Counts', $
      xrange = myxrange, yrange = myyrange, position = [.1, .09, .8, .16]
    
plot_stamp
DEVICE, /CLOSE
SET_PLOT, mydevice
!NOERAS = 0
command_string = 'convert -density 288 -geometry 25% -sharpen 3 ' + outname + '.ps ' + outname + '.png'
spawn, command_string
command_string = 'rm '+outname+'.ps'
spawn, command_string
print, "finished cumulative"

END 
