; Lorna Ellis
; 11/02/2012
; pha_play_read_proton_data.pro

; This procedure reads in the proton bulk speed and thermal speed from
; our Level 2 data.

; output:
;   proton_from_valid: 1=from valid data, 0=from non_valid
;   pr_error, pr_caution, pr_speed, pr_therm: These all are arrays the
;   same size as the number of pha events. Error values include:
;     !values.f_nan = no data found for that time period
;     -1 (for pr_error and pr_caution) = older cdf, no valid entry
;     -1e31 = no valid entry in cdf

; 01/09/2013 Fix when have more than one matching time.
; 01/14/2013 Fix for when there are errors in more than one matching time.
; 03/27/2014 Make it look for OBMom when no RA data.
; 04/01/2014 Changer version to temp_version so don't interfere with common block.

PRO pha_play_read_proton_data, proton_from_valid, pr_error, pr_caution, pr_speed, pr_therm
compile_opt strictarrsubs  
COMMON com_pha_play

year  = strmid(cdf_base, 11, 4)
month = strmid(cdf_base, 15, 2)
date  = strmid(cdf_base, 17, 2)

temp_i     = strpos(cdf_dir, 'Level')
dir_prefix = strmid(cdf_dir, 0, temp_i-1)
valid_dir  = dir_prefix+'/Level2/CDFs/1DMax/Valid/1min/'+year+'/'
pr_file    = 'ST'+sat+'_L2_PLA_1DMax_1min_'+year+month+date+'_V'
pr_prefix  = valid_dir+pr_file

; check for valid file
more = 1 
temp_version = 99                    ; largest expected version number
file_found = 0
WHILE (more EQ 1) AND (temp_version GT 0) DO BEGIN ; stop looking if there isn't a version 1 file
    file_string = pr_prefix+string(temp_version, format = '(I2.2)')+'.cdf'
    file_found = file_test(file_string, /read) ; returns 1 if file exists
    IF file_found EQ 1 THEN BEGIN
        more = 0                ; the most recent version has been found, stop looking for lower version numbers
    ENDIF ELSE BEGIN
        temp_version = temp_version - 1   ; try the next lower version number
    ENDELSE 
ENDWHILE
IF file_found EQ 0 THEN BEGIN ; check for non_valid
    non_valid_dir = dir_prefix+'/Level2/CDFs/1DMax/Non_valid/1min/'+year+'/'
    pr_prefix = non_valid_dir+pr_file
    more = 1 
    temp_version = 99                ; largest expected version number
    file_found = 0
    WHILE (more EQ 1) AND (temp_version GT 0) DO BEGIN ; stop looking if there isn't a version 1 file
        file_string = pr_prefix+string(temp_version, format = '(I2.2)')+'.cdf'
        file_found = file_test(file_string, /read) ; returns 1 if file exists
        IF file_found EQ 1 THEN BEGIN
            more = 0            ; the most recent version has been found, stop looking for lower version numbers
        ENDIF ELSE BEGIN
            temp_version = temp_version - 1 ; try the next lower version number
        ENDELSE 
    ENDWHILE
    IF file_found EQ 1 THEN BEGIN 
        proton_from_valid = 0
        pr_path = file_string
    ENDIF ELSE BEGIN            ; no file found -- check OBMom
        ob_dir = dir_prefix+'/Level2/CDFs/OBMoments/Valid/1min/'+year+'/'
        ob_file    = 'ST'+sat+'_L2_PLA_OBMom_1min_valid_'+year+month+date+'_V'
        pr_prefix = ob_dir+ob_file
        more = 1 
        temp_version = 99            ; largest expected version number
        file_found = 0
        WHILE (more EQ 1) AND (temp_version GT 0) DO BEGIN ; stop looking if there isn't a version 1 file
            file_string = pr_prefix+string(temp_version, format = '(I2.2)')+'.cdf'
            file_found = file_test(file_string, /read) ; returns 1 if file exists
            IF file_found EQ 1 THEN BEGIN
                more = 0        ; the most recent version has been found, stop looking for lower version numbers
            ENDIF ELSE BEGIN
                temp_version = temp_version - 1 ; try the next lower version number
            ENDELSE 
        ENDWHILE
        IF file_found EQ 1 THEN BEGIN 
            proton_from_valid = -1
            pr_path = file_string
        ENDIF ELSE BEGIN 
            print, 'no file found for proton data'
            stop
        ENDELSE  
    ENDELSE 
ENDIF ELSE BEGIN
    proton_from_valid = 1
    pr_path = file_string
ENDELSE 
    
pr_id = cdf_open(pr_path)
cdf_control, pr_id, get_var_info = pr_epoch_info, var = 'epoch', /zvariable
IF pr_epoch_info.maxrec GE 0 THEN BEGIN
    cdf_varget, pr_id, 'epoch',                cdf_pr_epoch,   rec_count = pr_epoch_info.maxrec+1, /zvariable
    cdf_varget, pr_id, 'proton_bulk_speed',    cdf_pr_speed,   rec_count = pr_epoch_info.maxrec+1, /zvariable
    cdf_varget, pr_id, 'proton_thermal_speed', cdf_pr_therm,   rec_count = pr_epoch_info.maxrec+1, /zvariable
    IF proton_from_valid GE 0 THEN $
      cdf_varget, pr_id, 'error',              cdf_pr_error,   rec_count = pr_epoch_info.maxrec+1, /zvariable ELSE $
      cdf_varget, pr_id, 'error_poor_stats',   cdf_pr_error,   rec_count = pr_epoch_info.maxrec+1, /zvariable 
    IF proton_from_valid GE 0 THEN $
      cdf_varget, pr_id, 'caution',            cdf_pr_caution, rec_count = pr_epoch_info.maxrec+1, /zvariable
ENDIF 

cdf_pr_epoch   = reform(cdf_pr_epoch)
cdf_pr_error   = reform(cdf_pr_error)
cdf_pr_speed   = reform(cdf_pr_speed)
cdf_pr_therm   = reform(cdf_pr_therm)
IF proton_from_valid GE 0 THEN cdf_pr_caution = reform(cdf_pr_caution) ELSE BEGIN
    cdf_pr_caution    = fltarr(n_elements(cdf_pr_epoch))
    cdf_pr_caution[*] = !values.f_nan
ENDELSE 

num_pha    = n_elements(valid_pha_epoch1)
pr_error   = fltarr(num_pha)
pr_caution = fltarr(num_pha)
pr_speed   = dblarr(num_pha)
pr_therm   = dblarr(num_pha)

pr_error  [*] = !values.f_nan
pr_caution[*] = !values.f_nan
pr_speed  [*] = !values.f_nan
pr_therm  [*] = !values.f_nan

FOR ii = 0L, n_elements(valid_epoch1)-1 DO BEGIN 
    time_i = where(abs(valid_epoch1[ii] - cdf_pr_epoch) LT 5, time_count)
    IF time_count GT 1 THEN BEGIN
        good_i = where(cdf_pr_error[time_i] EQ 0, good_count)
        IF good_count GT 1 THEN stop ; Lorna fix this
        IF good_count EQ 1 THEN time_i = time_i[good_i]
        time_count = 1
    ENDIF 
    IF time_count EQ 1 THEN BEGIN 
        wanted_i = where(time_i[0] EQ valid_pha_epoch1, wanted_count) ; valid_pha_epoch1 is index into valid_epoch1
        IF wanted_count GT 0 THEN BEGIN 
            pr_error  [wanted_i] = cdf_pr_error  [time_i]
            pr_caution[wanted_i] = cdf_pr_caution[time_i]
            pr_speed  [wanted_i] = cdf_pr_speed  [time_i]
            pr_therm  [wanted_i] = cdf_pr_therm  [time_i]
        ENDIF 
    ENDIF
ENDFOR 

END 
