; Lorna Ellis
; 5/12/2007
; pha_play.pro

; This is an adaptation of science_overview that allows more user
; input. Also, I took out SolarSoft routines.

; 09/21/2007 Now read section from settings file.
; 09/28/2007 Added option for coloring histograms.
; 10/15/2007 Added option for ascii output of normalized counts.
; 10/16/2007 Changed d to d_nossd and d_ssd
; 12/04/2007 Added norm_cycles
; 12/07/2007 Added selection by which pha (for normalization)
; 01/24/2008 Changed format of start and stop time
; 01/25/2008 Add option for summing defl before or after normalization
; 02/13/2008 Added norm_cycles_time (important for averaging ascii)
; 02/15/2008 If norm_esa_sum=2 and esas=-2, then do esas by 2s
; 02/20/2008 Add option for esa ranges, and for .tplot files
; 03/11/2008 Added option for small circles or dots in classpoints
; 03/26/2008 Added sat to common block
; 04/15/2008 Added want_raw_ascii
; 04/17/2008 Added simulate_instr
; 04/18/2008 Pass simulate_instr to read_limits_pp.
;            Separate section 0 and section 1.
;            Automatically copy settings file.
; 05/01/2008 Fix bug in create_tplot (remove sat argument).
; 06/30/2008 Added full-page classpoints plots.
; 07/15/2008 Create tplot from data arrays rather than ascii.
; 07/16/2008 Adjusted for altered settings file.
; 07/18/2008 Added have_norm.
; 09/04/2008 Added quad style boxes.
; 09/26/2008 Added cum_file.
; 10/03/2008 Added want_ascii check on call to combine_ascii.
; 10/06/2008 Added valid_pha_buffer (0=primary, 1=secondary)
; 10/08/2008 Added want_buffer_info
; 10/16/2008 Added abg code:
; 05/22/2008 add abg m, mq option
; 03/25/2009 Added kiel algorithm
; 06/29/2011 Added version to common block.
; 10/10/2011 Rewrite for efficiency, and for new accumulation times.
; 02/03/2012 Fix bug when running files with different versions.
; 02/28/2012 Added option for printing all num_cycles info.
; 02/25/2013 Added plot_bins keyword.
; 06/01/2013 Can go across days (and years). Settings file changed.
; 04/03/2014 Fix bug when multiple runs.

PRO pha_play, plot_bins = plot_bins
COMMON com_pha_play, read_whole_file, start_time, stop_time, time_st, plot_dir, esa_start, esa_stop, energy_start, energy_stop, ind_pha, cdf_base, cdf_id, epoch1_info, epoch1, error1, valid_epoch1, converted_valid_epoch1, converted_valid_epoch5, valid_epoch5_st, valid_pha_epoch1, s_chan1, s_chan5, esa_st, files_wanted, plots_wanted, section_wanted, norm_interval, norm_esa_sum, norm_times, suffix, limit_filename, norm_cycles, log_lun, norm_cycles_time, esa_range_format, labels, dot_format, sat, which_mass_mq_algorithm, simulate_instr, want_full_page, full_page_scale, full_page_limits, full_page_contours, have_norm, quad_style_boxes, valid_pha_buffer, want_buffer_info, version, want_num_cycles, cdf_dir, base_intervals

; want_full_page    : 0=no, 1=yes
; full_page_scale   : [x_scale,yscale], 0=linear, 1=log
; full_page_limits  : [2,2] = [x/y,min/max]
; full_page_contours: intarray (unknown size) with levels for contour plots
; have_norm         : set to 1 if have norm data, set to 0 if not because no 5 min data 
; quad_style_boxes  : set to 1 if want to define boxes by 4 corners rather than high and low mass and m/q

compile_opt strictarrsubs
cmd = 'echo '+systime()
spawn, cmd

openr, settings_lun, "pha_play.settings", /GET_LUN

line = " "
readf, settings_lun, line       ; read past first line

; read if simulate instrument (constraints in bindatword)
readf, settings_lun, line
simulate_instr = fix(line)
IF simulate_instr NE 0 AND simulate_instr NE 1 THEN BEGIN
    print, 'Error: Invalid choice simulating instrument'
    stop
ENDIF 

; check if using quadrilateral boxes 
FOR ii = 0, 2 DO BEGIN 
    readf, settings_lun, line 
ENDFOR 
quad_style_boxes = fix(line)
IF quad_style_boxes NE 0 AND quad_style_boxes NE 1 THEN BEGIN
    print, "ERROR: Invalid value for if you want quadrilateral boxes."
    stop
ENDIF 

; read bin limits and find bins
FOR ii = 0, 2 DO BEGIN 
    readf, settings_lun, line 
ENDFOR 
limit_filename = line 
read_limits_pp, limit_filename, full_num_bins, full_limits, labels, simulate_instr, quad_style_boxes

; read classification constants
readf, settings_lun, line
readf, settings_lun, line
readf, settings_lun, line
constants_filename = line
read_constants_pp, constants_filename, a1, a2, a3, a4, a5, a6, a_e, a_t, b_e, b_t, c2, d_nossd, d_ssd, d1, d2, e_max, e_min, $
                mass_max, mass_min, mq_max, mq_min, n_max, nq_max, t_max, t_min
find_bins_pp, full_limits, full_num_bins, mass_max, mass_min, mq_max, mq_min, n_max, nq_max, d_nossd, d_ssd, quad_style_boxes, $
           bins, mass_low_bound, mq_low_bound

; get file for energy lookup 
readf, settings_lun, line 
readf, settings_lun, line 
readf, settings_lun, line 
energy_file = line

; get PAC
readf, settings_lun, line 
readf, settings_lun, line 
pac = 0
readf, settings_lun, PAC 

; get plot directory
readf, settings_lun, line 
readf, settings_lun, line 
plot_dir = ' '
readf, settings_lun, plot_dir

; get whether to read from maui
readf, settings_lun, line 
readf, settings_lun, line 
read_from_maui = -1
readf, settings_lun, read_from_maui
IF read_from_maui NE 0 AND read_from_maui NE 1 THEN print, "ERROR: Invalid value for whether to read from maui."

; find out if need to add year to dir
readf, settings_lun, line 
readf, settings_lun, line 
add_year_to_dir = -1
readf, settings_lun, add_year_to_dir
IF add_year_to_dir NE 0 AND add_year_to_dir NE 1 THEN print, "ERROR: Invalid value for whether to add year to cdf dir."

; if not reading from maui, get cdf dir
readf, settings_lun, line 
readf, settings_lun, line 
cdf_dir = ' '
readf, settings_lun, cdf_dir

; get which files wanted
FOR ii = 0, 8 DO BEGIN 
    readf, settings_lun, line
ENDFOR 
classpoints_file = 0
classbins_file = 1
normbins_file = 2
hist_file = 3
cum_file = 4
files_wanted = intarr(5)
parts = strsplit(line, /extract, count = count)
FOR ii = 0, count-1 DO BEGIN
    temp = fix(parts[ii])
    IF temp GE 0 AND temp LE 4 THEN files_wanted[fix(parts[ii])] = 1
ENDFOR 

; get format for dots in classpoints
FOR ii = 0, 4 DO BEGIN 
    readf, settings_lun, line 
ENDFOR 
dot_format = fix(line)
IF dot_format NE 0 AND dot_format NE 1 THEN BEGIN
    print, 'Error: Invalid choice for histogram coloring'
    stop
ENDIF 

; get which plots wanted
FOR ii = 0, 11 DO BEGIN 
    readf, settings_lun, line
ENDFOR 
sw_pha_plot          = 0
wap_pha_ssd_plot     = 1
wap_pha_nossd_plot   = 2
supra_noe_ssd_plot   = 3
supra_noe_nossd_plot = 4
supra_wide_plot      = 5
swz2_plot            = 6
sw_h_alpha_plot      = 7
plots_wanted = intarr(8)
parts = strsplit(line, /extract, count = count)
FOR ii = 0, count-1 DO BEGIN
    plots_wanted[fix(parts[ii])] = 1
ENDFOR 

; read if want full-page class-points plots
FOR ii = 0, 3 DO BEGIN 
    readf, settings_lun, line 
ENDFOR 
want_full_page = fix(line)
IF want_full_page NE 0 AND want_full_page NE 1 THEN BEGIN
    print, 'Error: Invalid choice for if you want full-page classpoints plots'
    stop
ENDIF 

; read x scale for full-page plots
FOR ii = 0, 2 DO BEGIN 
    readf, settings_lun, line 
ENDFOR 
full_page_scale = intarr(2)
full_page_scale[0] = fix(line)
IF full_page_scale[0] NE 0 AND full_page_scale[0] NE 1 THEN BEGIN
    print, 'Error: Invalid choice for x-scale of full-page plots'
    stop
ENDIF 

; read y scale for full-page plots
FOR ii = 0, 2 DO BEGIN 
    readf, settings_lun, line 
ENDFOR 
full_page_scale[1] = fix(line)
IF full_page_scale[1] NE 0 AND full_page_scale[1] NE 1 THEN BEGIN
    print, 'Error: Invalid choice for y-scale of full-page plots'
    stop
ENDIF 

; read x limits for full-page plots
FOR ii = 0, 2 DO BEGIN 
    readf, settings_lun, line 
ENDFOR 
parts = strsplit(line, /extract, count = count)
IF count NE 2 THEN BEGIN 
    print, 'Error: Invalid choice for x limits of full-page plots'
    stop
ENDIF 
full_page_limits = fltarr(2, 2)
full_page_limits[0, 0] = float(parts[0])
full_page_limits[0, 1] = float(parts[1])
IF full_page_limits[0, 1] LT .1 THEN full_page_limits[0, 1] = .1 ; lower limit for plotting
IF full_page_limits[0, 1] GT 100 THEN full_page_limits[0, 1] = 100 ; upper limit for plotting

; read y limits for full-page plots
FOR ii = 0, 2 DO BEGIN 
    readf, settings_lun, line 
ENDFOR 
parts = strsplit(line, /extract, count = count)
IF count NE 2 THEN BEGIN 
    print, 'Error: Invalid choice for y limits of full-page plots'
    stop
ENDIF 
full_page_limits[1, 0] = float(parts[0])
full_page_limits[1, 1] = float(parts[1])
IF full_page_limits[1, 1] LT  .1 THEN full_page_limits[1, 1] =  .1 ; lower limit for plotting
IF full_page_limits[1, 1] GT 100 THEN full_page_limits[1, 1] = 100 ; upper limit for plotting

; read contour levels for full-page plots
FOR ii = 0, 2 DO BEGIN 
    readf, settings_lun, line 
ENDFOR 
parts = strsplit(line, /extract, count = count)
full_page_contours = fix(parts)

; get how the histograms should be colored
FOR ii = 0, 4 DO BEGIN 
    readf, settings_lun, line 
ENDFOR 
hist_coloring = fix(line)
IF hist_coloring NE 0 AND hist_coloring NE 1 THEN BEGIN
    print, 'Error: Invalid choice for histogram coloring'
    stop
ENDIF 

; read if ascii output of raw pha (and nm, nq)
FOR ii = 0, 2 DO BEGIN 
    readf, settings_lun, line 
ENDFOR 
want_raw_ascii = fix(line)
IF want_raw_ascii NE 0 AND want_raw_ascii NE 1 THEN BEGIN
    print, 'Error: Invalid choice for ascii output of raw pha'
    stop
ENDIF 

; read if ascii output of normalized counts is wanted
FOR ii = 0, 2 DO BEGIN 
    readf, settings_lun, line 
ENDFOR 
want_ascii = fix(line)
IF want_ascii NE 0 AND want_ascii NE 1 THEN BEGIN
    print, 'Error: Invalid choice for ascii output of normalized data'
    stop
ENDIF 

; read averaging time for ascii output
FOR ii = 0, 2 DO BEGIN 
    readf, settings_lun, line 
ENDFOR 
ascii_ave_time = fix(line)
IF ascii_ave_time LT 0 THEN BEGIN
    print, 'Error: Invalid choice for ascii averaging time'
    stop
ENDIF 

; read format for norm ascii output (counts vs. counts/sec)
FOR ii = 0, 2 DO BEGIN 
    readf, settings_lun, line 
ENDFOR 
ascii_norm_format = fix(line)
IF ascii_norm_format NE 0 AND ascii_norm_format NE 1 THEN BEGIN
    print, 'Error: Invalid choice for ascii_norm_format (counts vs. counts/sec)'
    stop
ENDIF 

; read when you want deflection summed in normalization
FOR ii = 0, 2 DO BEGIN 
    readf, settings_lun, line 
ENDFOR 
when_sum_defl = fix(line)
IF when_sum_defl NE 0 AND when_sum_defl NE 1 THEN BEGIN
    print, 'Error: Invalid choice for when to sum deflection in normalization'
    stop
ENDIF 

; read if you want primary/secondary buffer info
FOR ii = 0, 3 DO BEGIN 
    readf, settings_lun, line 
ENDFOR 
want_buffer_info = fix(line)
IF want_buffer_info NE 0 AND want_buffer_info NE 1 THEN BEGIN
    print, 'Error: Invalid choice for if you want primary/secondary buffer information.'
    stop
ENDIF 

; read if want esa steps one-by-one or all together
FOR ii = 0, 3 DO BEGIN 
    readf, settings_lun, line 
ENDFOR 
esa_range_format = fix(line)
IF esa_range_format NE 0 AND esa_range_format NE 1 THEN BEGIN
    print, 'Error: Invalid choice for whether to do esas separately'
    stop
ENDIF
IF esa_range_format EQ 1 THEN BEGIN
    wanted_i = where(files_wanted EQ 1,  count)
    IF count EQ 0 THEN BEGIN 
        print, 'Better to have ESA steps combined if do not want plots.'
        print, 'Press .c to continue as is (may run out of memory).'
        stop
    ENDIF
ENDIF 

; read if want .tplot files
FOR ii = 0, 2 DO BEGIN 
    readf, settings_lun, line 
ENDFOR 
want_tplot = fix(line)
IF want_tplot NE 0 AND want_tplot NE 1 THEN BEGIN
    print, 'Error: Invalid choice for whether to generate .tplot variables'
    stop
ENDIF 

; read tplot_dir
FOR ii = 0, 2 DO BEGIN 
    readf, settings_lun, line 
ENDFOR 
tplot_dir = line

; read which algorithm to use
FOR ii = 0, 2 DO BEGIN 
    readf, settings_lun, line 
ENDFOR 
which_mass_mq_algorithm = fix(line)
IF which_mass_mq_algorithm LT 0 OR which_mass_mq_algorithm GT 3 THEN BEGIN ; 2 is for abg
    print, 'Error: Invalid choice for which mass m/q algorithm'
    stop
ENDIF 

; read if want num_cycles info printed
FOR ii = 0, 2 DO BEGIN 
    readf, settings_lun, line 
ENDFOR 
want_num_cycles = fix(line)
IF want_num_cycles LT 0 OR want_num_cycles GT 1 THEN BEGIN 
    print, 'Error: Invalid choice for printing num_cycles'
    stop
ENDIF 

; read individual file data
FOR ii = 0, 18 DO BEGIN 
    readf, settings_lun, line 
ENDFOR 
parts = strsplit(line, /extract, count = count)
WHILE count GT 0 DO BEGIN 
    IF n_elements(full_lines) EQ 0 THEN full_lines = [line] ELSE full_lines = [full_lines, line]
    IF eof(settings_lun) EQ 0 THEN BEGIN 
        readf, settings_lun, line 
        parts = strsplit(line, /extract, count = count)    
    ENDIF ELSE count = 0
ENDWHILE
; parse them
num_runs = 0
IF n_elements(full_lines) GT 0 THEN BEGIN
    num_runs         = n_elements(full_lines)
    cdfs             = strarr(num_runs, 400) ; 400 arbitrary large number (more than a year)
    esas             = intarr(2, num_runs)
    sections         = intarr(num_runs)
    read_whole_files = intarr(num_runs)
    start_times      = dblarr(num_runs, 400)
    stop_times       = dblarr(num_runs, 400)
    time_sts         = strarr(num_runs)
    norm_intervals   = intarr(num_runs)
    norm_esa_sums    = intarr(num_runs)
    which_phas       = intarr(num_runs)
    suffixes         = strarr(num_runs)
    versions         = intarr(num_runs)
    num_days         = intarr(num_runs)
ENDIF 
FOR ii = 0, num_runs-1 DO BEGIN 
    line = full_lines[ii]
    parts = strsplit(line, /extract, count = count)
    IF count NE 13 AND count NE 12 THEN BEGIN 
        print, 'Error: invalid num arguments in line: ', line
        stop
    ENDIF 
    sat           =     parts[0]
    start_year    = fix(parts[1])
    start_doy     = fix(parts[2])
    start_time_st =     parts[3]
    stop_year     = fix(parts[4])
    stop_doy      = fix(parts[5])
    stop_time_st  =     parts[6]
    temp_esa      = strsplit(parts[7], '/', /extract, count = count)
    esas[0, ii]   = fix(temp_esa[0])
    IF count GT 1 THEN esas[1, ii] = fix(temp_esa[1]) ELSE esas[1, ii] = esas[0, ii]
    sections[ii]  = fix(parts[8])
    IF sections[ii] LT -2 OR sections[ii] GT 3 THEN BEGIN
        print, 'Error: Invalid section (must be -2, -1, 0, 1, 2, or 3): ', parts[8]
        stop
    ENDIF 
    norm_intervals[ii] = fix(parts[9])
    IF norm_intervals[ii] NE -1 AND norm_intervals[ii] MOD 5 NE 0 THEN BEGIN
        print, 'Invalid normalization interval'
        stop
    END 
    norm_esa_sums[ii] = fix(parts[10])
    IF norm_esa_sums[ii] NE 1 AND norm_esa_sums[ii] NE 2 THEN print, 'Expect 1 or 2 for number of esas to normalize over'
    ; if sum over 2 esas and normalization wanted, then need to go from even to odd esa
    IF norm_esa_sums[ii] EQ 2 AND [files_wanted[2] EQ 1 OR want_ascii EQ 1] THEN BEGIN
        IF esas[0, ii] MOD 2 EQ 1 THEN esas[0, ii] = esas[0, ii]-1
        IF esas[1, ii] MOD 2 EQ 0 THEN esas[1, ii] = esas[1, ii]+1
    ENDIF 
    which_phas[ii] = fix(parts[11])
    IF which_phas[ii] LT 1 OR which_phas[ii] GT 3 THEN BEGIN 
        print, 'Expect 1, 2 or 3 for which pha'
        stop
    ENDIF 
    IF which_phas[ii] NE 1 AND (files_wanted[2] EQ 1 OR want_ascii EQ 1 OR want_tplot EQ 1) THEN BEGIN
        print, 'Cannot normalize with this setting for which PHA to include: ', which_phas[ii]
        stop
    ENDIF 
    IF n_elements(parts) EQ 13 THEN suffixes[ii] = strcompress(parts[12], /remove_all) ELSE suffixes[ii] = ''

    doy2date, start_doy, start_year, start_month, start_day
    doy2date,  stop_doy,  stop_year,  stop_month,  stop_day
    start_prefix = string(start_year, format = '(I4.4)')+'-'+string(start_month, format = '(I2.2)')+'-'+string(start_day,  format = '(I2.2)')+'/'
    stop_prefix  = string( stop_year, format = '(I4.4)')+'-'+string( stop_month, format = '(I2.2)')+'-'+string( stop_day,  format = '(I2.2)')+'/'

    ; figure out cdfs needed
    doy_i  = start_doy
    year_i = start_year
    cdf_i  = 0
    temp_cdf_dir = cdf_dir
    WHILE (year_i LT stop_year) OR ((year_i EQ stop_year) AND (doy_i LE stop_doy)) DO BEGIN 
        doy2date, doy_i, year_i, month, day
        IF read_from_maui  EQ 1 THEN cdf_dir = '/guamdata1/Spacecraft_'+sat+'/Level1/CDFs/'+string(year_i, format = '(I4.4)')
        IF add_year_to_dir EQ 1 THEN cdf_dir = temp_cdf_dir+'/'+string(year_i, format = '(I4.4)')
        cdf_prefix = cdf_dir+'/ST'+sat+'_L1_PLA_'+string(year_i, format = '(I4.4)')+string(month, format = '(I2.2)')+$
                     string(day, format = '(I2.2)')+'_'+string(doy_i, format = '(I3.3)')+'_V'
        more = 1 
        version = 99            ; largest expected version number
        file_found = 0
        WHILE (more EQ 1) AND (version GT 0) DO BEGIN ; stop looking if there isn't a version 1 file
            file_string = cdf_prefix+string(version, format = '(I2.2)')+'.cdf'
            file_found = file_test(file_string, /read) ; returns 1 if file exists
            IF file_found EQ 1 THEN BEGIN
                more = 0        ; the most recent version has been found, stop looking for lower version numbers
            ENDIF ELSE BEGIN
                version = version - 1 ; try the next lower version number
            ENDELSE 
        ENDWHILE
        versions[ii] = version
        IF file_found EQ 0 THEN print, 'Missing file ', file_string ELSE cdfs[ii, cdf_i] = file_string

        doy2date, doy_i, year_i, month, day
        prefix = string(year_i, format = '(I4.4)')+'-'+string(month, format = '(I2.2)')+'-'+string(day,  format = '(I2.2)')+'/'
        IF start_time_st EQ '-1' THEN BEGIN 
            IF cdf_i EQ 0 THEN BEGIN ; only have to do once
                read_whole_files[ii] = 1 
                start_times[ii, cdf_i] = time_double(start_prefix+'00:00:00', /epoch)
                stop_times [ii, cdf_i] = time_double( stop_prefix+'24:00:00', /epoch)
                time_sts   [ii] = start_prefix+'00:00:00 '+stop_prefix+'24:00:00'
            ENDIF 
        ENDIF ELSE BEGIN
            IF (cdf_i EQ 0) THEN BEGIN 
                start_times       [ii, cdf_i] = time_double(start_prefix+start_time_st, /epoch) 
                time_sts          [ii]        = start_prefix+start_time_st+' '+stop_prefix+parts[6]
            ENDIF ELSE start_times[ii, cdf_i] = time_double(prefix+'00:00:00', /epoch)
            stop_times            [ii, cdf_i] = time_double(prefix+'24:00:00', /epoch) ; will be overwritten for last day            
        ENDELSE 

        cdf_i = cdf_i + 1
        IF ((doy_i EQ 365) AND (year_i MOD 4 NE 0)) OR ((doy_i EQ 366) AND (year_i MOD 4 EQ 0)) THEN BEGIN 
            doy_i  = 1 
            year_i = year_i + 1
        ENDIF ELSE doy_i = doy_i+1
    ENDWHILE 
    num_days[ii] = cdf_i
    IF stop_time_st  NE '-1' THEN stop_times [ii, cdf_i-1] = time_double(stop_prefix+parts[6], /epoch) ELSE $
      stop_times[ii, cdf_i-1] = time_double(stop_prefix+'24:00:00', /epoch)
    IF start_time_st EQ '-1' THEN BEGIN 
        read_whole_files[ii] = 1 
        time_sts   [ii] = start_prefix+'00:00:00 '+stop_prefix+'24:00:00'
    ENDIF ELSE BEGIN
        time_sts   [ii] = start_prefix+start_time_st+' '+stop_prefix+parts[6]
    ENDELSE 
ENDFOR 

; close settings file
close, settings_lun
free_lun, settings_lun

; set up plots
plot_names = ['SwPha', 'WapPha_ssd', 'WapPha_nossd', 'SupraNoE_ssd', 'SupraNoE_nossd', 'SupraWide', 'Swz2', 'Sw_H_alpha']
full_limit_index = [0, 0, 1, 2, 3, 4, 6, 10] ; index for these plots into full_limits array
num_bins = full_num_bins[full_limit_index]
n = N_ELEMENTS(plot_names)
IF quad_style_boxes EQ 0 THEN num_columns = 4 ELSE num_columns = 8
limits = FLTARR(n, 50, num_columns) ; each plot, for each bin level: m/q min, m/q max, mass min, mass max
; find limits for these plots
FOR i = 0, n-1 DO BEGIN 
    FOR j = 0, num_bins[i]-1 DO BEGIN ; for each bin
        FOR k = 0, num_columns-1 DO BEGIN ; min, max, min, max
            limits[i, j, k] = full_limits[full_limit_index[i], j, k+1] ; k+1 because full_limits also has bin label
        ENDFOR
    ENDFOR
ENDFOR 

; loop through runs
FOR ii = 0, num_runs-1 DO BEGIN
    esa_start      = esas      [0, ii]
    esa_stop       = esas      [1, ii]
    section_wanted = sections     [ii]
    which_pha      = which_phas   [ii]
    norm_esa_sum   = norm_esa_sums[ii]
    version        = versions     [ii]
    num_esa        = 1
    have_norm      = 0
    IF esa_range_format EQ 1 THEN BEGIN ; want each esa separately
        IF norm_esa_sum EQ 1 THEN num_esa = esa_stop-esa_start+1 ELSE num_esa = (esa_stop-esa_start+1)/2
    ENDIF 
    esa_st = '_'+string(esa_start, format = '(I3.3)')+'_'+string(esa_stop, format = '(I3.3)')
    find_energy_pp, esa_start, energy_file, energy_start
    find_energy_pp, esa_stop,  energy_file, energy_stop
    read_whole_file = read_whole_files[ii]
    start_time      = start_times     [ii, 0]
    stop_time       = stop_times      [ii, num_days[ii]-1]
    time_st         = time_sts        [ii]
    epoch1          = 0D
    FOR day_i = 0, num_days[ii]-1 DO BEGIN ; loop through days
        cdf         = cdfs         [ii, day_i]
        cdf_base    = file_basename(cdf, '.cdf')
        file_found  = file_test    (cdf, /read) ; returns 1 if file exists
        IF file_found EQ 1 THEN BEGIN 
            command_string = 'cp pha_play.settings '+plot_dir+'/'+cdf_base+'_'+suffixes[ii]+'.settings'
            spawn, command_string
            cdf_id = cdf_open(cdf)
            cdf_control, cdf_id, get_var_info = epoch1_info, var = 'epoch1', /zvariable
            IF epoch1_info.maxrec GE 0 THEN BEGIN 
                cdf_varget,  cdf_id, 'epoch1',   temp_epoch1, rec_count = epoch1_info.maxrec+1, /zvariable
                cdf_control, cdf_id, get_var_info = error1_info, var = 'error1', /zvariable
                cdf_varget,  cdf_id, 'error1',   temp_error1, rec_count = epoch1_info.maxrec+1, /zvariable
                cdf_varget,  cdf_id, 's_chan1', temp_s_chan1, rec_count = epoch1_info.maxrec+1, /zvariable
                norm_interval = norm_intervals[ii]
                suffix        = suffixes      [ii]
                
                IF n_elements(epoch1) LE 1 THEN BEGIN ; first data
                    epoch1  = reform(temp_epoch1)
                    error1  = reform(temp_error1)
                    s_chan1 = reform(temp_s_chan1)
                ENDIF ELSE BEGIN 
                    epoch1  = [epoch1,  reform(temp_epoch1)]
                    error1  = [error1,  reform(temp_error1)]
                    s_chan1 = [s_chan1, reform(temp_s_chan1)]
                ENDELSE 
                
                                ; read and limit pha data
                read_pha_data_pp, which_pha, day_i, pha, sw_pri, wap_pri_ssd, wap_pri_nossd, have_data, epoch5, error5, num_summed
            ENDIF 
            IF day_i EQ            0 THEN start_cdf_base = cdf_base
            IF day_i EQ (num_days[ii]-1) THEN  stop_cdf_base = cdf_base
        ENDIF ELSE print, "File not found. ", cdf
        cdf_close, cdf_id
    ENDFOR 
    IF have_data EQ 0 THEN valid_pha = [-1] ELSE limit_pha_data, pha, which_pha, epoch5, error5, num_summed, $
      sw_pri, wap_pri_ssd, wap_pri_nossd, valid_pha

    IF valid_pha[0] EQ -1 THEN print, 'No Valid Pha!!!!'  ELSE BEGIN 
                ; read individual data
        fill_bins_new, valid_pha, full_limits, bins, full_num_bins, full_limit_index, $
                       a1, a2, a3, a4, a5, a6, a_e, a_t, b_e, b_t, c2, d_nossd, d_ssd, d1, d2, $
                       e_max, e_min, mass_max, mass_min, t_max, t_min, $
                       pac, mass_low_bound, mq_low_bound, $
                       swpha_raw, wappha_ssd_raw, wappha_nossd_raw, supranoe_ssd_raw, supranoe_nossd_raw, $
                       suprawide_raw, swz_raw, swhalpha_raw, $
                       swpha_counts, wappha_ssd_counts, wappha_nossd_counts, $
                       supranoe_ssd_counts, supranoe_nossd_counts, suprawide_counts, $
                       swz_counts, swhalpha_counts, $
                       swpha_pri_counts, wappha_ssd_pri_counts, wappha_nossd_pri_counts, valid_mass_mq, $
                       plot_bins = plot_bins

        cdf_base_brief = strmid(cdf_base, 0, 4)+strmid(start_cdf_base, 11, 8)+'_'+strmid(stop_cdf_base, 11, 8)
                ; ascii output of raw data
        IF want_raw_ascii EQ 1 THEN BEGIN
            FOR jj = 0, n-1 DO BEGIN 
                CASE jj OF 
                    0: bit = 1
                    1: bit = 2
                    2: bit = 4
                    3: bit = 8
                    4: bit = 16
                    5: bit = 32
                    6: bit = 64
                    7: bit = 128
                ENDCASE 
                IF plots_wanted[jj] EQ 1 THEN write_raw_ascii, valid_pha, valid_mass_mq, plot_names[jj], bit, cdf_base_brief
            ENDFOR 
        ENDIF 
                ; get normalized data
        IF files_wanted[2] EQ 1 OR want_ascii EQ 1 OR want_tplot EQ 1 THEN BEGIN 
            find_norm_data, num_bins, swpha_counts, wappha_ssd_counts, wappha_nossd_counts, $
                            supranoe_ssd_counts, supranoe_nossd_counts, $
                            suprawide_counts, swz_counts, swhalpha_counts, $
                            swpha_pri_counts, wappha_ssd_pri_counts, wappha_nossd_pri_counts, $
                            when_sum_defl, temp_file_start, temp_file_end, $
                            swpha_norm, wappha_ssd_norm, wappha_nossd_norm, supranoe_ssd_norm, $
                            supranoe_nossd_norm, suprawide_norm, swz_norm, swhalpha_norm, $
                            summed_swpha_counts_time, summed_wappha_ssd_counts_time, $
                            summed_wappha_nossd_counts_time, summed_supranoe_ssd_counts_time, $
                            summed_supranoe_nossd_counts_time, summed_suprawide_counts_time, $
                            summed_swz_counts_time, summed_swhalpha_counts_time, $
                            num_intervals, sw_pri, wap_pri_ssd, wap_pri_nossd, cdf_base_brief
            have_norm = 1
        ENDIF 

        IF want_ascii EQ 1 OR want_tplot EQ 1 THEN BEGIN 
            write_norm_ascii, want_ascii, ascii_ave_time, ascii_norm_format, when_sum_defl, want_tplot, $
                              swpha_newnorm, wappha_ssd_newnorm, wappha_nossd_newnorm, supranoe_ssd_newnorm, $
                              supranoe_nossd_newnorm, suprawide_newnorm, swz_newnorm, swhalpha_newnorm, $
                              swpha_newraw, wappha_ssd_newraw, wappha_nossd_newraw, supranoe_ssd_newraw, $
                              supranoe_nossd_newraw, suprawide_newraw, swz_newraw, swhalpha_newraw, $
                              cdf_base_brief, num_bins, $
                              swpha_norm, wappha_ssd_norm, wappha_nossd_norm, supranoe_ssd_norm, $
                              supranoe_nossd_norm, suprawide_norm, swz_norm, swhalpha_norm, $
                              summed_swpha_counts_time, summed_wappha_ssd_counts_time, $
                              summed_wappha_nossd_counts_time, summed_supranoe_ssd_counts_time, $
                              summed_supranoe_nossd_counts_time, summed_suprawide_counts_time, $
                              summed_swz_counts_time, summed_swhalpha_counts_time, tplot_times
            write_schan_info, cdf_base_brief
        ENDIF 

        IF files_wanted[4] EQ 1 THEN plot_cum_pha, valid_pha, cdf_base_brief                   
        
        FOR jj = 0, num_esa-1 DO BEGIN
            IF esa_range_format EQ 1 THEN BEGIN 
                IF norm_esa_sum EQ 1 THEN temp_esa_start = jj+esas[0, ii] ELSE temp_esa_start = (jj*2)+esas[0, ii]
                IF norm_esa_sum EQ 1 THEN temp_esa_stop  = jj+esas[0, ii] ELSE temp_esa_stop  = (jj*2)+esas[0, ii]+1
            ENDIF ELSE BEGIN
                temp_esa_start = esa_start
                temp_esa_stop  = esa_stop
            ENDELSE 
            temp_esa_st = '_'+string(temp_esa_start, format = '(I3.3)')+'_'+string(temp_esa_stop, format = '(I3.3)')
            find_energy_pp, temp_esa_start, energy_file, temp_energy_start
            find_energy_pp, temp_esa_stop,  energy_file, temp_energy_stop
            plot_pha_pp, bins, hist_coloring, when_sum_defl, valid_pha, $
                         cdf_base_brief, swpha_counts, wappha_ssd_counts, wappha_nossd_counts, $
                         supranoe_ssd_counts, supranoe_nossd_counts, suprawide_counts, swz_counts, $
                         swhalpha_counts, plot_names, $
                         swpha_raw, wappha_ssd_raw, wappha_nossd_raw, $
                         supranoe_ssd_raw, supranoe_nossd_raw, suprawide_raw, swz_raw, $
                         swhalpha_raw, num_bins, limits, full_limit_index, $
                         temp_esa_start, temp_esa_stop, temp_esa_st, temp_energy_start, temp_energy_stop, $
                         swpha_norm, wappha_ssd_norm, wappha_nossd_norm, $
                         supranoe_ssd_norm, supranoe_nossd_norm, suprawide_norm, swz_norm, $
                         swhalpha_norm
            print, 'finished ', temp_esa_st
        ENDFOR 
        print, "finished plot_pha"
    ENDELSE 
    temp_string = 'finished '+full_lines[ii]+' '+string(esa_start) 
    print, temp_string

    IF want_tplot EQ 1 AND have_norm EQ 1 THEN create_tplot_new, tplot_dir, esas[0, ii], esas[1, ii], full_num_bins, $
      ascii_norm_format, $
      swpha_newnorm, wappha_ssd_newnorm, wappha_nossd_newnorm, supranoe_ssd_newnorm, $
      supranoe_nossd_newnorm, suprawide_newnorm, swz_newnorm, swhalpha_newnorm, $
      swpha_newraw, wappha_ssd_newraw, $
      wappha_nossd_newraw, supranoe_ssd_newraw, $
      supranoe_nossd_newraw, suprawide_newraw, $
      swz_newraw, swhalpha_newraw, tplot_times

ENDFOR 
cmd = 'echo '+systime()
spawn, cmd

END
