; Lorna Ellis
; 06/04/2013
; limit_pha_data.pro

; This procedure limits the pha data that we want (by error, time,
; etc.) It is taken out of the read_pha_data_pp procedure.

; in : pha        : array[768, 9, time] -- [768 is possible # of events]
; pha indices are : 0: swpe
;                   1: swpd
;                   2: quadrant
;                   3: ssd_id
;                   4: ssde
;                   5: tof
;                   6: pos
;                   7: section
;                   8: priority
;                   9: blank -- for new bin
;      which_pha  : 1: just those that go in rates (for normalization)
;                   2: just those that don't go in rates (so we know what is missing)
;                   3: all (normalization won't make sense)
;      epoch5     : double array
;      error5     : flag (array)
;      num_summed : [128,time] -- [esa,time]
;
; out: valid_pha : array[16, num_valid_pha] -- 10th-15th index are blank, 16 is schan switch for that minute
; pha indices are: 0: swpe
;                  1: swpd
;                  2: quadrant
;                  3: ssd_id
;                  4: ssde
;                  5: tof
;                  6: pos
;                  7: section
;                  8: priority
;                  9: blank -- for new bin

; 01/23/2014 Change to allow base rate greater than 5.

PRO limit_pha_data, pha, which_pha, epoch5, error5, num_summed, sw_pri, wap_pri_ssd, wap_pri_nossd, valid_pha
COMMON com_pha_play
compile_opt strictarrsubs

have_data = 1
; remove by time
valid_epoch1 = epoch1
converted_valid_epoch1 = time_double(valid_epoch1, /epoch) ; put in double form sec. since 1970
time_found = where(converted_valid_epoch1 GE start_time AND converted_valid_epoch1 LT stop_time, count)
IF count GT 0 THEN BEGIN 
    valid_epoch1           = valid_epoch1          [time_found]
    converted_valid_epoch1 = converted_valid_epoch1[time_found]
    pha                    = pha             [*, *, time_found]
    error1                 = error1                [time_found]
    s_chan1                = s_chan1               [time_found]
    none_left              = 0
ENDIF ELSE none_left = 1

; find which buffer while still have all esa steps
pha_buffer = intarr(768, count)
IF want_buffer_info EQ 1 THEN BEGIN ; otherwise, put all as primary buffer
    FOR ii = 0, count-1 DO BEGIN 
        buffer = 0
        pha_buffer[0, ii] = 0
        FOR jj = 1, 767 DO BEGIN 
            IF pha[jj, 0, ii] EQ -1 THEN buffer = -1 ELSE $
              IF buffer EQ 0 AND pha[jj-1, 0, ii] GT pha[jj, 0, ii] THEN buffer = 1
            pha_buffer[jj, ii] = buffer
        ENDFOR 
    ENDFOR 
ENDIF 

; limit by esa
IF esa_start NE -1 THEN BEGIN 
    unwanted_index = where(pha[*, 0, *] LT esa_start OR pha[*, 0, *] GT esa_stop, count)
    IF count GT 0 THEN BEGIN 
        unwanted2 = array_indices(pha[*, 0, *], unwanted_index)
        FOR ii = 0L, count-1 DO BEGIN 
            pha[unwanted2[0, ii], *, unwanted2[2, ii]] = -1 
        ENDFOR 
        pha_buffer[unwanted_index] = -1
    ENDIF 
ENDIF 

; limit by section
IF section_wanted NE -2 THEN BEGIN 
    IF section_wanted EQ -1 THEN unwanted_index = where(pha[*, 7, *] NE 0 AND pha[*, 7, *] NE 1, count) $ ; want both 0 and 1 for SW
      ELSE unwanted_index = where(pha[*, 7, *] NE section_wanted, count)
    IF count GT 0 THEN BEGIN 
        unwanted2 = array_indices(pha[*, 7, *], unwanted_index)
        FOR ii = 0L, count-1 DO BEGIN 
            pha[unwanted2[0, ii], *, unwanted2[2, ii]] = -1 
        ENDFOR 
        pha_buffer[unwanted_index] = -1
    ENDIF 
ENDIF 

; remove error cases
valid_index = where(error1 EQ 0, count) 
IF count GT 0 THEN BEGIN 
    valid_epoch1           = valid_epoch1          [valid_index]
    converted_valid_epoch1 = converted_valid_epoch1[valid_index]
    pha                    = pha             [*, *, valid_index]
    pha_buffer             = pha_buffer         [*, valid_index]
    s_chan1                = s_chan1               [valid_index]
    none_left              = 0
ENDIF ELSE none_left = 1

; remove when schan_1 eq -1
valid_index = where(s_chan1 GE 0, count) 
IF count GT 0 THEN BEGIN 
    valid_epoch1           = valid_epoch1          [valid_index]
    converted_valid_epoch1 = converted_valid_epoch1[valid_index]
    pha                    = pha             [*, *, valid_index]
    pha_buffer             = pha_buffer         [*, valid_index]
    s_chan1                = s_chan1               [valid_index]
    none_left              = 0
ENDIF ELSE none_left = 1

; check for no switch
wanted_i = where(s_chan1 EQ 0, count)
IF count GT 0 THEN BEGIN 
    s_chan1[wanted_i] = 128

    temp_i = where(reform(pha[*, 7, wanted_i]) EQ 1, temp_count)
    IF temp_count GT 0 THEN BEGIN
        new_i = array_indices(reform(pha[*, 7, wanted_i]), temp_i)
        pha[new_i[0], 7, wanted_i[new_i[1]]] = 0
    ENDIF 
ENDIF 

; check against schan in 5-min data 
IF which_pha NE 3 THEN BEGIN ; don't want all pha
    IF have_data EQ 1 THEN BEGIN 
       ; remove error cases
        none_left = 0
        valid_index = where(error5 EQ 0, count)
        valid_epoch5 = epoch5
        IF count GT 0 THEN BEGIN
            valid_epoch5  = valid_epoch5       [valid_index]
            s_chan5       = s_chan5            [valid_index] 
            num_summed    = num_summed      [*, valid_index] 
            sw_pri        = sw_pri    [*, *, *, valid_index]
            wap_pri_ssd   = wap_pri_ssd  [*, *, valid_index]
            wap_pri_nossd = wap_pri_nossd[*, *, valid_index]
       ENDIF ELSE none_left = 1

       ; remove times when schan = -1 because can't normalize
       valid_index = where(s_chan5 NE -1, count)
        IF count GT 0 THEN BEGIN
            valid_epoch5  = valid_epoch5       [valid_index]
            s_chan5       = s_chan5            [valid_index]
            num_summed    = num_summed      [*, valid_index] 
            sw_pri        = sw_pri    [*, *, *, valid_index]
            wap_pri_ssd   = wap_pri_ssd  [*, *, valid_index]
            wap_pri_nossd = wap_pri_nossd[*, *, valid_index]
        ENDIF ELSE none_left = 1            

       ; remove times when num_summed = -1 because can't normalize
        good_i1 = where(num_summed GT -1, count)
        IF count GT 0 THEN BEGIN
            good_i2       = array_indices(num_summed, good_i1)
            good_i3       = uniq(good_i2[1, *])
            valid_index   = reform(good_i2[1, good_i3])
            valid_epoch5  = valid_epoch5       [valid_index]
            s_chan5       = s_chan5            [valid_index]
            num_summed    = num_summed      [*, valid_index] 
            sw_pri        = sw_pri    [*, *, *, valid_index]
            wap_pri_ssd   = wap_pri_ssd  [*, *, valid_index]
            wap_pri_nossd = wap_pri_nossd[*, *, valid_index]
        ENDIF ELSE none_left = 1            

        ; check for no switch
        wanted_i = where(s_chan5 EQ 0, count)
        IF count GT 0 THEN s_chan5[wanted_i] = 128

       ; remove by time
        converted_valid_epoch5 = time_double(valid_epoch5, /epoch) ; put in double form sec. since 1970
        time_found = where(converted_valid_epoch5 GE start_time AND converted_valid_epoch5 LE stop_time, count)
        IF count GT 0 THEN BEGIN 
            valid_epoch5           = valid_epoch5          [time_found]
            converted_valid_epoch5 = converted_valid_epoch5[time_found]
            s_chan5                = s_chan5               [time_found]
            num_summed             = num_summed         [*, time_found] 
            sw_pri                 = sw_pri       [*, *, *, time_found]
            wap_pri_ssd            = wap_pri_ssd     [*, *, time_found]
            wap_pri_nossd          = wap_pri_nossd   [*, *, time_found]
        ENDIF ELSE none_left = 1

        ; line up epoch1 with epoch5 -- no longer assumes 5 minute accumulation
        base_intervals = reform(num_summed[0, *]) ; first ESA will have full counts
        mods = norm_interval MOD base_intervals 
        IF array_equal(mods, 0) NE 1 THEN BEGIN 
            print, "ERROR: limit_pha_data.pro: Normalization interval is not multiple of base interval!"
            stop
        ENDIF 
        found_epoch1 = intarr(n_elements(converted_valid_epoch1)) ; use this to check for times not in 5 min data - set to 1 when found
        temp_arr     = intarr(128) ; used for checking num_summed
        FOR jj = 0, n_elements(converted_valid_epoch5)-1 DO BEGIN 
            temp_arr[*]  = base_intervals[jj]
            IF which_pha EQ 1 THEN BEGIN ; don't have 5min -- need for normalization
                bad_i    = where((converted_valid_epoch1 LT (converted_valid_epoch5[jj]-10)) AND (found_epoch1 EQ 0), count)
                IF count GT 0 THEN BEGIN
                    pha    [*, *, bad_i] = -1
                    pha_buffer[*, bad_i] = -1
                    found_epoch1[ bad_i] = 1
                ENDIF 
            ENDIF 
            wanted_i = where(converted_valid_epoch1 GE (converted_valid_epoch5[jj]-10) AND $
                             converted_valid_epoch1 LT (converted_valid_epoch5[jj]+(base_intervals[jj]*60)-10), count)
            IF count GT 0 THEN BEGIN 
                found_epoch1[wanted_i] = 1
                IF which_pha EQ 2 THEN BEGIN ; want only pha not in normalization
                    pha    [*, *, wanted_i] = -1
                    pha_buffer[*, wanted_i] = -1
                ENDIF                     
                IF jj EQ n_elements(converted_valid_epoch5)-1 AND count LT base_intervals[jj] THEN BEGIN ; end of time span
                    IF which_pha EQ 1 THEN BEGIN ; skip these minutes
                        pha    [*, *, wanted_i] = -1
                        pha_buffer[*, wanted_i] = -1
                    ENDIF                     
                ENDIF ELSE BEGIN 
                    temp_schan5 = s_chan5[jj]
                    IF temp_schan5 EQ 0 THEN temp_schan5 = 128
                    temp_num_summed = intarr(128) ; double_check num_summed
                    FOR ii = 0, count-1 DO BEGIN ; check each 1-min record
                        index1 = wanted_i[ii]
                        temp_schan1 = s_chan1[wanted_i[ii]]
                        IF temp_schan1 EQ 0 THEN temp_schan1 = 128
                        IF (converted_valid_epoch5[jj] EQ converted_valid_epoch1[index1]) AND $
                          (temp_schan1 NE temp_schan5) THEN stop ; schan should match
                        IF array_equal(num_summed[*, jj], temp_arr) EQ 1 THEN BEGIN ; all esa steps of all cycles included
                            temp_num_summed = temp_num_summed + 1
                            IF which_pha EQ 2 THEN BEGIN
                                pha    [*, *, index1] = -1 ; empty records for unwanted pha
                                pha_buffer[*, index1] = -1
                            ENDIF 
                        ENDIF ELSE IF temp_schan1 EQ -1 THEN BEGIN ; can't use data
                            pha    [*, *, index1] = -1 
                            pha_buffer[*, index1] = -1
                        ENDIF ELSE IF temp_schan1 EQ temp_schan5 THEN BEGIN ; include all
                            temp_num_summed = temp_num_summed + 1
                            IF which_pha EQ 2 THEN BEGIN
                                pha    [*, *, index1] = -1 ; empty records for unwanted pha
                                pha_buffer[*, index1] = -1
                            ENDIF 
                        ENDIF ELSE IF temp_schan1 GT temp_schan5 THEN BEGIN 
                            IF which_pha EQ 2 THEN BEGIN ; take out ends of unwanted
                                temp_i = where(pha[*, 0, index1] LT temp_schan5, temp_count)
                                IF temp_count GT 0 THEN BEGIN
                                    pha       [temp_i, *, index1] = -1
                                    pha_buffer[temp_i,    index1] = -1
                                ENDIF 
                                temp_i = where(pha[*, 0, index1] GT temp_schan1, temp_count)
                                IF temp_count GT 0 THEN BEGIN
                                    pha[temp_i, *, index1] = -1
                                    pha[temp_i,    index1] = -1
                                ENDIF 
                            ENDIF 
                            FOR ll = temp_schan5, temp_schan1-1 DO BEGIN ; in between schan
                                IF which_pha EQ 1 THEN BEGIN ; take out middle from wanted
                                    temp_i = where(pha[*, 0, index1] EQ ll, temp_count)
                                    IF temp_count GT 0 THEN BEGIN
                                        pha       [temp_i, *, index1] = -1
                                        pha_buffer[temp_i,    index1] = -1
                                    ENDIF 
                                ENDIF 
                            ENDFOR
                            temp_num_summed[0:temp_schan5-1] = temp_num_summed[0:temp_schan5-1]+1
                            IF temp_schan1 LT 128 THEN temp_num_summed[temp_schan1:127] = temp_num_summed[temp_schan1:127]+1
                        ENDIF ELSE BEGIN ; temp_schan1 LT temp_schan5
                            IF which_pha EQ 2 THEN BEGIN ; take out ends of unwanted
                                temp_i = where(pha[*, 0, index1] LT temp_schan1, temp_count)
                                IF temp_count GT 0 THEN BEGIN
                                    pha       [temp_i, *, index1] = -1
                                    pha_buffer[temp_i,    index1] = -1
                                ENDIF 
                                temp_i = where(pha[*, 0, index1] GT temp_schan5, temp_count)
                                IF temp_count GT 0 THEN BEGIN
                                    pha       [temp_i, *, index1] = -1
                                    pha_buffer[temp_i,    index1] = -1
                                ENDIF 
                            ENDIF 
                            FOR ll = temp_schan1, temp_schan5-1 DO BEGIN ; in between schan
                                IF which_pha EQ 1 THEN BEGIN ; take out middle from wanted
                                    temp_i = where(pha[*, 0, index1] EQ ll, temp_count)
                                    IF temp_count GT 0 THEN BEGIN
                                        pha       [temp_i, *, index1] = -1
                                        pha_buffer[temp_i,    index1] = -1
                                    ENDIF 
                                ENDIF 
                            ENDFOR
                            temp_num_summed[0:temp_schan1-1] = temp_num_summed[0:temp_schan1-1]+1
                            IF temp_schan5 LT 128 THEN temp_num_summed[temp_schan5:127] = temp_num_summed[temp_schan5:127]+1
                        ENDELSE 
                    ENDFOR 
                    IF array_equal(temp_num_summed, num_summed[*, jj]) NE 1 THEN BEGIN
                        print, 'read_pha_data_pp: num_summed does not match ', cdf_base, jj
                        pha       [*, *, wanted_i] = -1
                        pha_buffer[*,    wanted_i] = -1
                        s_chan1   [      wanted_i] = -1 ; so remove this data
                    ENDIF
                ENDELSE 
            ENDIF ; if there were any epoch1 times
        ENDFOR 
    ENDIF 
; remove unwanted ESAs
    num_summed             = num_summed    [esa_start:esa_stop,       *] 
    sw_pri                 = sw_pri        [esa_start:esa_stop, *, *, *]
    wap_pri_ssd            = wap_pri_ssd   [esa_start:esa_stop, *,    *]
    wap_pri_nossd          = wap_pri_nossd [esa_start:esa_stop, *,    *]
ENDIF 

; if normalizing, remove places where we miss the schan switch
IF which_pha EQ 1 THEN BEGIN
    valid_index = where(s_chan1 NE -1, count) 
    IF count GT 0 THEN BEGIN 
        valid_epoch1           = valid_epoch1          [valid_index]
        converted_valid_epoch1 = converted_valid_epoch1[valid_index]
        pha                    = pha             [*, *, valid_index]
        pha_buffer             = pha_buffer         [*, valid_index]
        s_chan1                = s_chan1               [valid_index]
        none_left              = 0
    ENDIF ELSE none_left = 1
ENDIF 

; remove fill
temp_data = reform(pha[*, 0, *])
valid = where(temp_data NE -1, valid_count)
IF valid_count GT 0 AND none_left EQ 0 THEN BEGIN 
    valid_2          = array_indices(temp_data, valid)
    valid_pha        = intarr(16, valid_count)
    valid_pha_buffer = intarr(    valid_count)
    valid_pha_epoch1 = intarr(    valid_count) ; this will be filled with the index into valid_epoch1 
    FOR ii = 0L, valid_count-1 DO BEGIN 
        valid_pha  [0:8, ii] = pha[valid_2[0, ii], *, valid_2[1, ii]]
        valid_pha_buffer     = pha_buffer[valid]
        valid_pha_epoch1[ii] = valid_2[1, ii]
        valid_pha  [15,  ii] = s_chan1[valid_2[1, ii]]
    ENDFOR 
ENDIF ELSE valid_pha = -1

END 
