; Lorna Ellis
; 05/22/2007
; find_energy_pp.pro

; This find the energy corresponding to a desired esa step
; This file is assumed to go from high energy to low energy

; in : esa      : the target esa
;      filename : the file in which to search
; out: energy   : the corresponding esa step

PRO find_energy_pp, esa, filename, energy
compile_opt strictarrsubs

openr, in_lun, filename, /GET_LUN
line = ' '

FOR i = 0, 19 DO BEGIN          ; read past header
    readf, in_lun, line 
ENDFOR 
    
FOR i = 0, esa DO BEGIN 
    readf, in_lun, line 
ENDFOR 
parts = strsplit(line, /EXTRACT)
temp_esa = fix(parts[0])
IF temp_esa NE esa THEN print, "Error in find_energy"
energy = double(parts[2])

close, in_lun
free_lun, in_lun

END 
