; Lorna Ellis
; 07/10/2008
; find_bindatword_new.pro

; This is a rewrite of find_bindatword_pp.
; All input and output are arrays, one index per pha event.

; 09/04/2008 Added quad_style_boxes.
; 02/15/2013 Fix bug in set_bin_quad. Now set from top left.
; 02/25/2013 Added plot_bins keyword.
; 03/07/2013 Adjusted colors for plot_bins.
; 03/08/2013 Adjusted colors some more.
; 05/21/2013 Fixed another bug in set_bin_quad! (When vertical lines are 1st or 3rd).
; 05/22/2013 Take into account bin 0 that is not mass 0.


; in: half             = 0 if ssd; 1 if no ssd
;     nm               = mass
;     nq               = mass per charge
;     full_limits      = array for limits (physical units): 12 categories, up to 50 bins (not all used), mass and m/q limits
;        quad_style_boxes=0:(bin_number, mq min, mq max, mass min, mass max)
;        quad_style_boxes=1:(bin_number, mq1,mass1,mq2,mass2,mq3,mass3,mq4,mass4)
;     limits           = array for limits as bins: 12 categories, up to 50 bins (not all used), mass and m/q limits
;        quad_style_boxes=0:(bin_number, mq min, mq max, mass min, mass max)
;        quad_style_boxes=1:(bin_number, mq1,mass1,mq2,mass2,mq3,mass3,mq4,mass4)
;     num_bins         = array (12) with number of bins for each category
;     quad_style_boxes = 0 if old limits files (min and max mass and m/q), 1 if define 4 points for each box
; out: pha_pri      = value for pha_pri bits
;      supra_no_e   = value for supra_no_e bits
;      supra_wide   = value for supra_wide bits
;      swz2         = value for the swz2 bits
;      sw_all       = value for the sw_all bits
;      sw_H_alpha   = value for the sw_h_alpha bits
;      bin_dat_word = the full bins_dat_word

PRO set_bin_orig, half, nm, nq, limits, num_bins, which_half_i, which_half, category_i, output
compile_opt strictarrsubs
k = num_bins[category_i] - 1
FOR i = 0, k DO BEGIN
    j = k - i                   ; go backward
    IF limits[category_i, j, 1] EQ -1 THEN output[which_half_i] = long(limits[category_i, j, 0]) $ ; set all
    ELSE BEGIN 
        temp_i = where((half EQ which_half) AND $ ; overwrite
                       (nq GE limits[category_i, j, 1]) AND $
                       (nq LE limits[category_i, j, 2]) AND $
                       (nm GE limits[category_i, j, 3]) AND $
                       (nm LE limits[category_i, j, 4]), count)
        IF count GT 0 THEN output[temp_i] = long(limits[category_i, j, 0])
    ENDELSE 
ENDFOR 
END 

PRO set_bin_quad, half, nm, nq, limits, num_bins, which_half_i, which_half, category_i, output
compile_opt strictarrsubs
k = num_bins[category_i] - 1
FOR ii = 0, k DO BEGIN
    jj = k-ii ; go backward
    IF limits[category_i, jj, 1] EQ -1 THEN output[which_half_i] = long(limits[category_i, jj, 0]) $ ; set all
    ELSE BEGIN 
        ; find the 4 boundary lines -- start with top left
        slope1 = (double(limits[category_i, jj, 4]) - limits[category_i, jj, 2]) / (limits[category_i, jj, 3] - limits[category_i, jj, 1])   
        slope2 = (double(limits[category_i, jj, 6]) - limits[category_i, jj, 4]) / (limits[category_i, jj, 5] - limits[category_i, jj, 3])   
        slope3 = (double(limits[category_i, jj, 8]) - limits[category_i, jj, 6]) / (limits[category_i, jj, 7] - limits[category_i, jj, 5])   
        slope4 = (double(limits[category_i, jj, 2]) - limits[category_i, jj, 8]) / (limits[category_i, jj, 1] - limits[category_i, jj, 7])   
        y_int1 = limits[category_i, jj, 2] - (slope1 * limits[category_i, jj, 1])
        y_int2 = limits[category_i, jj, 4] - (slope2 * limits[category_i, jj, 3])
        y_int3 = limits[category_i, jj, 6] - (slope3 * limits[category_i, jj, 5])
        y_int4 = limits[category_i, jj, 8] - (slope4 * limits[category_i, jj, 7])
        IF limits[category_i, jj, 3] EQ limits[category_i, jj, 5] AND limits[category_i, jj, 1] EQ limits[category_i, jj, 7] THEN BEGIN 
            temp_i = where((half EQ which_half) AND $ ; second and fourth lines are vertical
                           (nm LE ((slope1*nq)+y_int1))      AND $ ; top line
                           (nq LE limits[category_i, jj, 3]) AND $ ; right side
                           (nm GE ((slope3*nq)+y_int3))      AND $ ; bottom
                           (nq GE limits[category_i, jj, 1]), count) ; left side
            IF (finite(slope2) EQ 1) OR (finite(slope4) EQ 1) THEN BEGIN
                print, 'Problem1 with quad algorithm. Send settings file and rate box file to Lorna.'
                stop
            ENDIF 
        ENDIF ELSE IF limits[category_i, jj, 1] EQ limits[category_i, jj, 3] AND $
          limits[category_i, jj, 5] EQ limits[category_i, jj, 7] THEN BEGIN 
            temp_i = where((half EQ which_half) AND $ ; first and third lines are vertical
                           (nq LE limits[category_i, jj, 1]) AND $ ; right side
                           (nm GE ((slope2*nq)+y_int2))      AND $ ; bottom
                           (nq GE limits[category_i, jj, 5]) AND $ ; left side
                           (nm LE ((slope4*nq)+y_int4)), count)    ; top line
            IF (finite(slope1) EQ 1) OR (finite(slope3) EQ 1) THEN BEGIN
                print, 'Problem2 with quad algorithm. Send settings file and rate box file to Lorna.'
                stop
            ENDIF 
        ENDIF ELSE IF limits[category_i, jj, 1] EQ limits[category_i, jj, 3] THEN BEGIN ; right side is vertical (first line)
            temp_i = where((half EQ which_half)              AND $ 
                           (nq LE limits[category_i, jj, 1]) AND $ ; right side
                           (nm GE ((slope2*nq)+y_int2))      AND $ ; bottom
                           (nq GE ((nm-y_int3)/slope3))      AND $ ; left side
                           (nm LE ((slope4*nq)+y_int4)), count)    ; top line
            IF finite(slope1) EQ 1 THEN BEGIN
                print, 'Problem3 with quad algorithm. Send settings file and rate box file to Lorna.'
                stop
            ENDIF 
        ENDIF ELSE IF limits[category_i, jj, 3] EQ limits[category_i, jj, 5] THEN BEGIN ; right side is vertical (second line)
            temp_i = where((half EQ which_half)              AND $ 
                           (nm LE ((slope1*nq)+y_int1))      AND $ ; top line
                           (nq LE limits[category_i, jj, 3]) AND $ ; right side
                           (nm GE ((slope3*nq)+y_int3))      AND $ ; bottom
                           (nq GE ((nm-y_int4)/slope4)), count)    ; left side
            IF finite(slope2) EQ 1 THEN BEGIN
                print, 'Problem4 with quad algorithm. Send settings file and rate box file to Lorna.'
                stop
            ENDIF 
        ENDIF ELSE IF limits[category_i, jj, 5] EQ limits[category_i, jj, 7] THEN BEGIN ; left side is vertical (third line)
            temp_i = where((half EQ which_half) AND              $ ; overwrite
                           (nq LE ((nm-y_int1)/slope1))      AND $ ; right side
                           (nm GE ((slope2*nq)+y_int2))      AND $ ; bottom
                           (nq GE limits[category_i, jj, 5]) AND $ ; left side
                           (nm LE ((slope4*nq)+y_int4)), count)    ; top line
            IF finite(slope3) EQ 1 THEN BEGIN
                print, 'Problem5 with quad algorithm. Send settings file and rate box file to Lorna.'
                stop
            ENDIF 
        ENDIF ELSE IF limits[category_i, jj, 1] EQ limits[category_i, jj, 7] THEN BEGIN ; left side is vertical (fourth line)
            temp_i = where((half EQ which_half) AND         $        ; overwrite
                           (nm LE ((slope1*nq)+y_int1)) AND $        ; top line
                           (nq LE ((nm-y_int2)/slope2)) AND $        ; right side
                           (nm GE ((slope3*nq)+y_int3)) AND $        ; bottom
                           (nq GE limits[category_i, jj, 1]), count) ; left side
            IF finite(slope4) EQ 1 THEN BEGIN
                print, 'Problem6 with quad algorithm. Send settings file and rate box file to Lorna.'
                stop
            ENDIF 
        ENDIF ELSE BEGIN        ; no sides are vertical
            temp_i = where((half EQ which_half)         AND $   ; overwrite
                           (nm LE ((slope1*nq)+y_int1)) AND $   ; top line
                           (nq LE ((nm-y_int2)/slope2)) AND $   ; right side
                           (nm GE ((slope3*nq)+y_int3)) AND $   ; bottom
                           (nq GE ((nm-y_int4)/slope4)), count) ; left side
        ENDELSE 
        IF count GT 0 THEN BEGIN
            output[temp_i] = long(limits[category_i, jj, 0])
            min_nq = 0.
            max_nq = 0.
            min_nm = 0.
            max_nm = 0.
            IF limits[category_i, jj, 1] GE 0 THEN min_nq = limits[category_i, jj, 1]
            IF limits[category_i, jj, 3] GE 0 AND limits[category_i, jj, 3] LT min_nq THEN min_nq = limits[category_i, jj, 3]
            IF limits[category_i, jj, 5] GE 0 AND limits[category_i, jj, 5] LT min_nq THEN min_nq = limits[category_i, jj, 5]
            IF limits[category_i, jj, 7] GE 0 AND limits[category_i, jj, 7] LT min_nq THEN min_nq = limits[category_i, jj, 7]
            IF limits[category_i, jj, 1] GE 0 THEN max_nq = limits[category_i, jj, 1]
            IF limits[category_i, jj, 3] GE 0 AND limits[category_i, jj, 3] GT max_nq THEN max_nq = limits[category_i, jj, 3]
            IF limits[category_i, jj, 5] GE 0 AND limits[category_i, jj, 5] GT max_nq THEN max_nq = limits[category_i, jj, 5]
            IF limits[category_i, jj, 7] GE 0 AND limits[category_i, jj, 7] GT max_nq THEN max_nq = limits[category_i, jj, 7]
            IF limits[category_i, jj, 2] GE 0 THEN min_nm = limits[category_i, jj, 2]
            IF limits[category_i, jj, 4] GE 0 AND limits[category_i, jj, 4] LT min_nm THEN min_nm = limits[category_i, jj, 4]
            IF limits[category_i, jj, 6] GE 0 AND limits[category_i, jj, 6] LT min_nm THEN min_nm = limits[category_i, jj, 6]
            IF limits[category_i, jj, 8] GE 0 AND limits[category_i, jj, 8] LT min_nm THEN min_nm = limits[category_i, jj, 8]
            IF limits[category_i, jj, 2] GE 0 THEN max_nm = limits[category_i, jj, 2]
            IF limits[category_i, jj, 4] GE 0 AND limits[category_i, jj, 4] GT max_nm THEN max_nm = limits[category_i, jj, 4]
            IF limits[category_i, jj, 6] GE 0 AND limits[category_i, jj, 6] GT max_nm THEN max_nm = limits[category_i, jj, 6]
            IF limits[category_i, jj, 8] GE 0 AND limits[category_i, jj, 8] GT max_nm THEN max_nm = limits[category_i, jj, 8]
            bad_i = where((nq[temp_i] LT min_nq) OR (nq[temp_i] GT max_nq) OR $
                          (nm[temp_i] LT min_nm) OR (nm[temp_i] GT max_nm), bad_count)
            IF bad_count GT 0 THEN BEGIN
                print, 'Problem7 with quad algorithm. Send settings file and rate box file to Lorna.'
                stop
            ENDIF 
        ENDIF 
    ENDELSE 
ENDFOR 
END 

PRO find_bindatword_new, half, nm, nq, limits, num_bins, quad_style_boxes, pha_pri, supra_no_e, supra_wide, swz2, sw_all, sw_h_alpha, $
  bin_dat_word, plots_wanted, full_limit_index, full_limits, plot_bins = plot_bins
compile_opt strictarrsubs

num_pha          = n_elements(half)
bin_dat_word     = lonarr(num_pha)
pha_pri_index    = intarr(num_pha)
supra_no_e_index = intarr(num_pha)
supra_wide_index = intarr(num_pha)
swz2_index       = intarr(num_pha)
sw_all_index     = intarr(num_pha)
sw_h_alpha_index = intarr(num_pha)
pha_pri          = lonarr(num_pha)
supra_no_e       = lonarr(num_pha)
supra_wide       = lonarr(num_pha)
swz2             = lonarr(num_pha)
sw_all           = lonarr(num_pha)
sw_h_alpha       = lonarr(num_pha)

half0_i = where(half EQ 0, half0_count, complement = half1_i, ncomplement = half1_count)

;set pha bits
IF half0_count GT 0 THEN BEGIN  ; SSD
    IF quad_style_boxes EQ 0 THEN set_bin_orig, half, nm, nq, limits, num_bins, half0_i, 0, 0, pha_pri $
    ELSE set_bin_quad, half, nm, nq, limits, num_bins, half0_i, 0, 0, pha_pri
ENDIF 
IF half1_count GT 0 THEN BEGIN ; no-SSD
    IF quad_style_boxes EQ 0 THEN set_bin_orig, half, nm, nq, limits, num_bins, half1_i, 1, 1, pha_pri $
    ELSE set_bin_quad, half, nm, nq, limits, num_bins, half1_i, 1, 1, pha_pri
ENDIF
bin_dat_word = bin_dat_word or (ishft(pha_pri, 14))

;set supra no E
IF half0_count GT 0 THEN BEGIN  ; SSD
    IF quad_style_boxes EQ 0 THEN set_bin_orig, half, nm, nq, limits, num_bins, half0_i, 0, 2, supra_no_e $
    ELSE set_bin_quad, half, nm, nq, limits, num_bins, half0_i, 0, 2, supra_no_e
ENDIF 
IF half1_count GT 0 THEN BEGIN ; no-SSD
    IF quad_style_boxes EQ 0 THEN set_bin_orig, half, nm, nq, limits, num_bins, half1_i, 1, 3, supra_no_e $
    ELSE set_bin_quad, half, nm, nq, limits, num_bins, half1_i, 1, 3, supra_no_e
ENDIF  
bin_dat_word = bin_dat_word OR (ishft(supra_no_e, 11))

;set supra_wide bits
IF half0_count GT 0 THEN BEGIN  ; SSD
    IF quad_style_boxes EQ 0 THEN set_bin_orig, half, nm, nq, limits, num_bins, half0_i, 0, 4, supra_wide $
    ELSE set_bin_quad, half, nm, nq, limits, num_bins, half0_i, 0, 4, supra_wide
ENDIF 
IF half1_count GT 0 THEN BEGIN ; no-SSD
    IF quad_style_boxes EQ 0 THEN set_bin_orig, half, nm, nq, limits, num_bins, half1_i, 1, 5, supra_wide $
    ELSE set_bin_quad, half, nm, nq, limits, num_bins, half1_i, 1, 5, supra_wide
ENDIF  
bin_dat_word = bin_dat_word OR (ishft(supra_wide, 7))

;set swz2 bits
IF half0_count GT 0 THEN BEGIN  ; SSD
    IF quad_style_boxes EQ 0 THEN set_bin_orig, half, nm, nq, limits, num_bins, half0_i, 0, 6, swz2 $
    ELSE set_bin_quad, half, nm, nq, limits, num_bins, half0_i, 0, 6, swz2
ENDIF 
IF half1_count GT 0 THEN BEGIN ; no-SSD
    IF quad_style_boxes EQ 0 THEN set_bin_orig, half, nm, nq, limits, num_bins, half1_i, 1, 7, swz2 $
    ELSE set_bin_quad, half, nm, nq, limits, num_bins, half1_i, 1, 7, swz2
ENDIF  
bin_dat_word = bin_dat_word OR (ishft(swz2, 3))

;set sw_all bits
IF half0_count GT 0 THEN BEGIN  ; SSD
    IF quad_style_boxes EQ 0 THEN set_bin_orig, half, nm, nq, limits, num_bins, half0_i, 0, 8, sw_all $
    ELSE set_bin_quad, half, nm, nq, limits, num_bins, half0_i, 0, 8, sw_all
ENDIF 
IF half1_count GT 0 THEN BEGIN ; no-SSD
    IF quad_style_boxes EQ 0 THEN set_bin_orig, half, nm, nq, limits, num_bins, half1_i, 1, 9, sw_all $
    ELSE set_bin_quad, half, nm, nq, limits, num_bins, half1_i, 1, 9, sw_all
ENDIF  
bin_dat_word = bin_dat_word OR (ishft(sw_all, 3))

;set sw_h_alpha bits
tab = string(9B)
IF half0_count GT 0 THEN BEGIN  ; SSD
    IF quad_style_boxes EQ 0 THEN set_bin_orig, half, nm, nq, limits, num_bins, half0_i, 0, 10, sw_h_alpha $
    ELSE set_bin_quad, half, nm, nq, limits, num_bins, half0_i, 0, 10, sw_h_alpha
ENDIF 
IF half1_count GT 0 THEN BEGIN ; no-SSD
    IF quad_style_boxes EQ 0 THEN set_bin_orig, half, nm, nq, limits, num_bins, half1_i, 1, 11, sw_h_alpha $
    ELSE set_bin_quad, half, nm, nq, limits, num_bins, half1_i, 1, 11, sw_h_alpha
ENDIF  
bin_dat_word = bin_dat_word OR sw_h_alpha

IF keyword_set(plot_bins) THEN BEGIN
    device, decomposed = 0
    ;loadct, 39
    FOR ii = 0, 7 DO BEGIN ; 8 Plots
        IF plots_wanted[ii] EQ 1 THEN BEGIN 
            IF ii EQ 1 AND plots_wanted[0] EQ 1 THEN dummy = dummy ELSE BEGIN ; combine plots 0&1
                CASE ii OF      ; index into limits
                    0: BEGIN
                        temp_data = pha_pri ; SwPha half=0
                        temp_half = 0
                        title     = 'PhaPri_SSD'
                    END 
                    1: BEGIN
                        temp_data = pha_pri ; Wap PHA SSD (same box as above) half=0
                        temp_half = 0
                        title     = 'PhaPri_SSD'
                    END 
                    2: BEGIN
                        temp_data = pha_pri ; Wap PHA noSSD half=1
                        temp_half = 1
                        title     = 'PhaPri_noSSD'
                    END 
                    3: BEGIN
                        temp_data = supra_no_e ; supra noe ssd half=0
                        temp_half = 0
                        title     = 'SupraNoE_SSD'
                    END
                    4: BEGIN
                        temp_data = supra_no_e ; supra noe no-ssd half=1
                        temp_half = 1
                        title     = 'SupraNoE_noSSD'
                    END 
                    5: BEGIN
                        temp_data = supra_wide ; supra wide both halves
                        temp_half = -1
                        title     = 'SupraWide'
                    END 
                    6: BEGIN
                        temp_data = swz2 ; swz both halves
                        temp_half = -1
                        title     = 'Swz2'
                    END 
                    7: BEGIN
                        temp_data = sw_h_alpha ; h_alpha both halves
                        temp_half = -1
                        title     = 'Sw_H_alpha'
                    END 
                ENDCASE
                temp_bin_index    = full_limit_index[ii]
                temp_num_bins     = num_bins[temp_bin_index]
                temp_nq_corners   = intarr(temp_num_bins, 4)
                temp_nm_corners   = intarr(temp_num_bins, 4)
                temp_nq_corn_phys = fltarr(temp_num_bins, 4)
                temp_nm_corn_phys = fltarr(temp_num_bins, 4)
                IF quad_style_boxes EQ 0 THEN BEGIN
                    temp_nq_corners  [*, 0] = reform(     limits[temp_bin_index, 0:(temp_num_bins-1), 1])
                    temp_nq_corners  [*, 1] = reform(     limits[temp_bin_index, 0:(temp_num_bins-1), 2])
                    temp_nq_corners  [*, 2] = reform(     limits[temp_bin_index, 0:(temp_num_bins-1), 2])
                    temp_nq_corners  [*, 3] = reform(     limits[temp_bin_index, 0:(temp_num_bins-1), 1])
                    temp_nm_corners  [*, 0] = reform(     limits[temp_bin_index, 0:(temp_num_bins-1), 4])
                    temp_nm_corners  [*, 1] = reform(     limits[temp_bin_index, 0:(temp_num_bins-1), 4])
                    temp_nm_corners  [*, 2] = reform(     limits[temp_bin_index, 0:(temp_num_bins-1), 3])
                    temp_nm_corners  [*, 3] = reform(     limits[temp_bin_index, 0:(temp_num_bins-1), 3])
                    temp_nq_corn_phys[*, 0] = reform(full_limits[temp_bin_index, 0:(temp_num_bins-1), 1])
                    temp_nq_corn_phys[*, 1] = reform(full_limits[temp_bin_index, 0:(temp_num_bins-1), 2])
                    temp_nq_corn_phys[*, 2] = reform(full_limits[temp_bin_index, 0:(temp_num_bins-1), 2])
                    temp_nq_corn_phys[*, 3] = reform(full_limits[temp_bin_index, 0:(temp_num_bins-1), 1])
                    temp_nm_corn_phys[*, 0] = reform(full_limits[temp_bin_index, 0:(temp_num_bins-1), 4])
                    temp_nm_corn_phys[*, 1] = reform(full_limits[temp_bin_index, 0:(temp_num_bins-1), 4])
                    temp_nm_corn_phys[*, 2] = reform(full_limits[temp_bin_index, 0:(temp_num_bins-1), 3])
                    temp_nm_corn_phys[*, 3] = reform(full_limits[temp_bin_index, 0:(temp_num_bins-1), 3])
                ENDIF ELSE BEGIN 
                    temp_nq_corners  [*, 0] = reform(     limits[temp_bin_index, 0:(temp_num_bins-1), 1])
                    temp_nq_corners  [*, 1] = reform(     limits[temp_bin_index, 0:(temp_num_bins-1), 3])
                    temp_nq_corners  [*, 2] = reform(     limits[temp_bin_index, 0:(temp_num_bins-1), 5])
                    temp_nq_corners  [*, 3] = reform(     limits[temp_bin_index, 0:(temp_num_bins-1), 7])
                    temp_nm_corners  [*, 0] = reform(     limits[temp_bin_index, 0:(temp_num_bins-1), 2])
                    temp_nm_corners  [*, 1] = reform(     limits[temp_bin_index, 0:(temp_num_bins-1), 4])
                    temp_nm_corners  [*, 2] = reform(     limits[temp_bin_index, 0:(temp_num_bins-1), 6])
                    temp_nm_corners  [*, 3] = reform(     limits[temp_bin_index, 0:(temp_num_bins-1), 8])
                    temp_nq_corn_phys[*, 0] = reform(full_limits[temp_bin_index, 0:(temp_num_bins-1), 1])
                    temp_nq_corn_phys[*, 1] = reform(full_limits[temp_bin_index, 0:(temp_num_bins-1), 3])
                    temp_nq_corn_phys[*, 2] = reform(full_limits[temp_bin_index, 0:(temp_num_bins-1), 5])
                    temp_nq_corn_phys[*, 3] = reform(full_limits[temp_bin_index, 0:(temp_num_bins-1), 7])
                    temp_nm_corn_phys[*, 0] = reform(full_limits[temp_bin_index, 0:(temp_num_bins-1), 2])
                    temp_nm_corn_phys[*, 1] = reform(full_limits[temp_bin_index, 0:(temp_num_bins-1), 4])
                    temp_nm_corn_phys[*, 2] = reform(full_limits[temp_bin_index, 0:(temp_num_bins-1), 6])
                    temp_nm_corn_phys[*, 3] = reform(full_limits[temp_bin_index, 0:(temp_num_bins-1), 8])
                ENDELSE 
                                ;IF ii EQ 3 THEN stop
                temp_i = where(temp_nm_corn_phys[*, 0] EQ -2, count) ; top of no mass
                IF count GT 0 THEN temp_nm_corners[temp_i, 0] =  05
                temp_i = where(temp_nm_corn_phys[*, 1] EQ -2, count) ; right of no mass
                IF count GT 0 THEN BEGIN
                    temp_i2 = where(temp_nm_corn_phys[temp_i, 0] EQ -2, count2, complement = temp_i3, ncomplement = count3)
                    IF count2 GT 0 THEN temp_nm_corners[temp_i[temp_i2], 1] =  05
                    IF count3 GT 0 THEN temp_nm_corners[temp_i[temp_i3], 1] = -05
                ENDIF 
                temp_i = where(temp_nm_corn_phys[*, 2] EQ -2, count) ; bottom of no mass
                IF count GT 0 THEN temp_nm_corners[temp_i, 2] = -05
                temp_i = where(temp_nm_corn_phys[*, 3] EQ -2, count) ; left of no mass
                IF count GT 0 THEN BEGIN
                    temp_i2 = where(temp_nm_corn_phys[temp_i, 2] EQ -2, count2, complement = temp_i3, ncomplement = count3)
                    IF count2 GT 0 THEN temp_nm_corners[temp_i[temp_i2], 3] = -05
                    IF count3 GT 0 THEN temp_nm_corners[temp_i[temp_i3], 3] = 05
                ENDIF 
                temp_i = where(temp_nq_corners[*, 0] EQ -1, count) ; left bin all
                IF count GT 0 THEN temp_nq_corners[temp_i, 0] = -20
                temp_i = where(temp_nq_corners[*, 3] EQ -1, count) ; left bin all
                IF count GT 0 THEN temp_nq_corners[temp_i, 3] = -20
                temp_i = where(temp_nq_corners[*, 1] EQ -1, count) ; right bin all
                IF count GT 0 THEN temp_nq_corners[temp_i, 1] = 300
                temp_i = where(temp_nq_corners[*, 2] EQ -1, count) ; right bin all
                IF count GT 0 THEN temp_nq_corners[temp_i, 2] = 300
                temp_i = where(temp_nm_corners[*, 0] EQ -1, count) ; top bin all
                IF count GT 0 THEN temp_nm_corners[temp_i, 0] = -20
                temp_i = where(temp_nm_corners[*, 1] EQ -1, count) ; top bin all
                IF count GT 0 THEN temp_nm_corners[temp_i, 1] = -20
                temp_i = where(temp_nm_corners[*, 2] EQ -1, count) ; bottom bin all
                IF count GT 0 THEN temp_nm_corners[temp_i, 2] = 100
                temp_i = where(temp_nm_corners[*, 3] EQ -1, count) ; bottom bin all
                IF count GT 0 THEN temp_nm_corners[temp_i, 3] = 100
                loadct, 39
                plot, [-20], [-20], /nodata, yrange = [-20, 100], xrange = [-20, 300], $
                      xstyle = 1, ystyle = 1, title = title, background = 255, color = 0
                loadct, 12
                FOR jj = 0, temp_num_bins-1 DO BEGIN ; plot boxes
                    my_color = (jj * 200./temp_num_bins)
                    oplot, [temp_nq_corners[jj, 0], temp_nq_corners[jj, 1]], [temp_nm_corners[jj, 0], temp_nm_corners[jj, 1]], color = my_color
                    oplot, [temp_nq_corners[jj, 1], temp_nq_corners[jj, 2]], [temp_nm_corners[jj, 1], temp_nm_corners[jj, 2]], color = my_color
                    oplot, [temp_nq_corners[jj, 2], temp_nq_corners[jj, 3]], [temp_nm_corners[jj, 2], temp_nm_corners[jj, 3]], color = my_color
                    oplot, [temp_nq_corners[jj, 3], temp_nq_corners[jj, 0]], [temp_nm_corners[jj, 3], temp_nm_corners[jj, 0]], color = my_color
                    xyouts, temp_nq_corners[jj, 3], temp_nm_corners[jj, 3], string(jj, format = '(I2.2)'), color = my_color
                    xyouts, temp_nq_corners[jj, 0]-10, -15, string(temp_nq_corn_phys[jj, 0], format = '(F6.1)'), color = my_color
                    xyouts, temp_nq_corners[jj, 1]-10, -15, string(temp_nq_corn_phys[jj, 1], format = '(F6.1)'), color = my_color
                    xyouts, temp_nq_corners[jj, 2]-10, -15, string(temp_nq_corn_phys[jj, 2], format = '(F6.1)'), color = my_color
                    xyouts, temp_nq_corners[jj, 3]-10, -15, string(temp_nq_corn_phys[jj, 3], format = '(F6.1)'), color = my_color
                    xyouts, -20, temp_nm_corners[jj, 0]-02, string(temp_nm_corn_phys[jj, 0], format = '(F6.1)'), color = my_color
                    xyouts, -20, temp_nm_corners[jj, 1]-02, string(temp_nm_corn_phys[jj, 1], format = '(F6.1)'), color = my_color
                    xyouts, -20, temp_nm_corners[jj, 2]-02, string(temp_nm_corn_phys[jj, 2], format = '(F6.1)'), color = my_color
                    xyouts, -20, temp_nm_corners[jj, 3]-02, string(temp_nm_corn_phys[jj, 3], format = '(F6.1)'), color = my_color
                ENDFOR 
                FOR kk = 0, temp_num_bins-1 DO BEGIN ; plot_data
                    jj = temp_num_bins - 1 - kk
                    my_color = (jj * 200./temp_num_bins)
                    IF temp_half EQ 0 THEN temp_i = where((temp_data EQ jj) AND (half EQ 0), count) $
                    ELSE IF temp_half EQ 1 THEN temp_i = where((temp_data EQ jj) AND (half EQ 1), count) $
                         ELSE temp_i = where((temp_data EQ jj), count) 
                    IF count GT 0 THEN BEGIN
                        oplot, nq[temp_i], nm[temp_i], psym = 1, color = my_color
                    ENDIF 
                ENDFOR 
                stop
            ENDELSE 
        ENDIF 
    ENDFOR 
    device, decomposed = 1
ENDIF 

END 
