; Lorna Ellis
; 07/09/2008
; fill_bins_new.pro

; This is a modification of fill_bins_pp.pro. This version works with
; the entire array of pha events at once rather than looping.

; 08/08/2008 Changed check on plot_m_q to GE from GT.
; 09/04/2008 Added quad_style_boxes as argument in find_bindatword.
; 10/03/2008 Checked for 1 pha event only.
; 10/07/2008 Added buffer to pri_counts arrays
; 10/16/2008 Added abg code:
; 05/22/2008 Added abg algorithm m, mq option (abg)
; 05/24/2008 Added new elements to valid_mass_mq array (abg)
; 06/20/2008 Changed criteria under "; collect data for plotting" from "plot mass lt zero" 
;            to "plot mass le zero" (abg)
; 03/25/2010 Added kiel algorithm option.
; 10/26/2011 Add ESA to raw so only run this once.
;            Change so only use ESAs we want (not 128)
; 10/28/2011 Fix bug with strictarray_sub.
; 01/24/2012 Removed print statement.
; 12/01/2012 Change arguments to calculate_mass_mq_abg_new.
; 02/25/2013 Add argument in find_bindatword_new.pro
; 02/25/2013 Add plot_bins keyword
; 03/12/2014 Removed unnecessary arguments

PRO fill_bins_new, valid_pha, full_limits, full_bins, full_num_bins, full_limit_index, $
                   a1, a2, a3, a4, a5, a6, a_e, a_t, b_e, b_t, c2, d_nossd, d_ssd, d1, d2, e_max, e_min, mass_max, mass_min, $
                   t_max, t_min, $
                   pac, mass_low_bound, mq_low_bound, $
                   swpha_raw, wappha_ssd_raw, wappha_nossd_raw, supranoe_ssd_raw, supranoe_nossd_raw, $
                   suprawide_raw, swz_raw, swhalpha_raw, $
                   swpha_counts, wappha_ssd_counts, wappha_nossd_counts, supranoe_ssd_counts, supranoe_nossd_counts, $
                   suprawide_counts, $
                   swz_counts, swhalpha_counts, swpha_pri_counts, wappha_ssd_pri_counts, wappha_nossd_pri_counts, valid_mass_mq, $
                   plot_bins = plot_bins
compile_opt strictarrsubs
; in:  valid_pha       : array (16 x num valid events) (16 is the 9 pha fields, plus new bin,nm_orig,nq_orig,nm_new,nq_new,which_products,schan)
;      full_limits     : array of limits (12 x 16 x 5) or (12 x 16 x 9)
;      full_bins       : array of limits as bins (12 x 16 x 5) or (12 x 16 x 9)
;      full_num_bins   : array (size 12) of num bins per category
;      full_limit_index: for each plot, index into full array
;      a1              : constant from file
;      a2              : constant from file
;      a3              : constant from file
;      a4              : constant from file
;      a5              : constant from file
;      a6              : constant from file
;      a_e             : constant from file
;      a_t             : constant from file
;      b_e             : constant from file
;      b_t             : constant from file
;      c2              : constant from file
;      d_nossd         : constant from file
;      d_ssd           : constant from file
;      d1              : constant from file
;      d2              : constant from file
;      e_max           : constant from file
;      e_min           : constant from file
;      mass_max        : constant from file
;      mass_min        : constant from file
;      t_max           : constant from file
;      t_min           : constant from file
;      pac             : from settings file
;      mass_low_bound  : from find_bins
;      mq_low_bound    : from find_bins
;      n               : num graphs
; out: 
;      valid_pha              : see above (add new bins) -- the products in the last index are done by
;                               bitwise addition with the following bits set:
;                               1=swpha
;                               2=wappha_ssd
;                               4=wappha_nossd
;                               8=supranoe_ssd
;                               16=supranoe_nossd
;                               32=suprawide
;                               64=swz
;                               128=swhalpha
;      swpha_counts           : [num_esa, 16, 4, x, epoch] each plot, esa, defl, priority, counts per bin (not all used)
;      wappha_ssd_counts      : [num_esa, 16, 4, x, epoch]
;      wappha_nossd_counts    : [num_esa, 16, 4, x, epoch]
;      supranoe_ssd_counts    : [num_esa, 16, 4, x, epoch]
;      supranoe_nossd_counts  : [num_esa, 16, 4, x, epoch]
;      suprawide_counts       : [num_esa, 16, 4, x, epoch]
;      swz_counts             : [num_esa, 16, 4, x, epoch]
;      swhalpha_counts        : [num_esa, 16, 4, x, epoch]
;      swpha_raw              : (num_esa, 4, 1000, 1000, x) esa, priority, 1000 x 1000, each bin (not all used)
;      wappha_ssd_raw         : (num_esa, 4, 1000, 1000, x)
;      wappha_nossd_raw       : (num_esa, 4, 1000, 1000, x)
;      supranoe_ssd_raw       : (num_esa, 4, 1000, 1000, x)
;      supranoe_nossd_raw     : (num_esa, 4, 1000, 1000, x)
;      suprawide_raw          : (num_esa, 4, 1000, 1000, x)
;      swz_raw                : (num_esa, 4, 1000, 1000, x)
;      swhalpha_raw           : (num_esa, 4, 1000, 1000, x)
;      swpha_pri_counts       : (num_esa, 16, 4, 2, x) esa, defl, priority, buffer, epoch
;      wappha_ssd_pri_counts  : (num_esa, 16, 2, 2, x) esa, defl, priority, buffer, epoch
;      wappha_nossd_pri_counts: (num_esa, 16, 2, 2, x) esa, defl, priority, buffer, epoch
;      valid_mass_mq          : (4, num_valid_pha) mass(orig), m/q(orig), mass(new), mq(new) for each valid pha
;      valid_mass_mq          : (8, num_valid_pha) mass(orig), m/q(orig), mass(new), mq(new), e_per_q, e_per_q+PAC, $
;                               e_meas (keV), time_meas (ns) for each valid pha (abg)
COMMON com_pha_play
compile_opt strictarrsubs

num_esa = esa_stop-esa_start+1
swpha_pri_counts        = lonarr(num_esa, 16, 4, 2, n_elements(valid_epoch1))
wappha_ssd_pri_counts   = lonarr(num_esa, 16, 2, 2, n_elements(valid_epoch1))
wappha_nossd_pri_counts = lonarr(num_esa, 16, 2, 2, n_elements(valid_epoch1))
IF plots_wanted[0] EQ 1 OR files_wanted[2] EQ 1 THEN BEGIN 
    IF esa_range_format EQ 1 THEN $
      swpha_raw           = fltarr(num_esa, 4, 1000, 1000, full_num_bins[full_limit_index[0]]) ELSE $
      swpha_raw           = fltarr(         4, 1000, 1000, full_num_bins[full_limit_index[0]])
    swpha_counts          = fltarr(num_esa,      16,    4, full_num_bins[full_limit_index[0]], n_elements(valid_epoch1))
ENDIF 
IF plots_wanted[1] EQ 1 OR files_wanted[2] EQ 1 THEN BEGIN 
    IF esa_range_format EQ 1 THEN $
      wappha_ssd_raw      = fltarr(num_esa, 4, 1000, 1000, full_num_bins[full_limit_index[1]]) ELSE $
      wappha_ssd_raw      = fltarr(         4, 1000, 1000, full_num_bins[full_limit_index[1]])
    wappha_ssd_counts     = fltarr(num_esa,      16,    4, full_num_bins[full_limit_index[1]], n_elements(valid_epoch1))
ENDIF 
IF plots_wanted[2] EQ 1 OR files_wanted[2] EQ 1 THEN BEGIN 
    IF esa_range_format EQ 1 THEN $
      wappha_nossd_raw    = fltarr(num_esa, 4, 1000, 1000, full_num_bins[full_limit_index[2]]) ELSE $
      wappha_nossd_raw    = fltarr(         4, 1000, 1000, full_num_bins[full_limit_index[2]])
    wappha_nossd_counts   = fltarr(num_esa,      16,    4, full_num_bins[full_limit_index[2]], n_elements(valid_epoch1))
ENDIF 
IF plots_wanted[3] EQ 1 THEN BEGIN 
    IF esa_range_format EQ 1 THEN $
      supranoe_ssd_raw    = fltarr(num_esa, 4, 1000, 1000, full_num_bins[full_limit_index[3]]) ELSE $
      supranoe_ssd_raw    = fltarr(         4, 1000, 1000, full_num_bins[full_limit_index[3]])
    supranoe_ssd_counts   = fltarr(num_esa,      16,    4, full_num_bins[full_limit_index[3]], n_elements(valid_epoch1))
ENDIF 
IF plots_wanted[4] EQ 1 THEN BEGIN 
    IF esa_range_format EQ 1 THEN $
      supranoe_nossd_raw  = fltarr(num_esa, 4, 1000, 1000, full_num_bins[full_limit_index[4]]) ELSE $
      supranoe_nossd_raw  = fltarr(         4, 1000, 1000, full_num_bins[full_limit_index[4]])
    supranoe_nossd_counts = fltarr(num_esa,      16,    4, full_num_bins[full_limit_index[4]], n_elements(valid_epoch1))
ENDIF 
IF plots_wanted[5] EQ 1 THEN BEGIN 
    IF esa_range_format EQ 1 THEN $
      suprawide_raw       = fltarr(num_esa, 4, 1000, 1000, full_num_bins[full_limit_index[5]]) ELSE $
      suprawide_raw       = fltarr(         4, 1000, 1000, full_num_bins[full_limit_index[5]])
    suprawide_counts      = fltarr(num_esa,      16,    4, full_num_bins[full_limit_index[5]], n_elements(valid_epoch1))
ENDIF 
IF plots_wanted[6] EQ 1 THEN BEGIN 
    IF esa_range_format EQ 1 THEN $
      swz_raw             = fltarr(num_esa, 4, 1000, 1000, full_num_bins[full_limit_index[6]]) ELSE $
      swz_raw             = fltarr(         4, 1000, 1000, full_num_bins[full_limit_index[6]])
    swz_counts            = fltarr(num_esa,      16,    4, full_num_bins[full_limit_index[6]], n_elements(valid_epoch1))
ENDIF 
IF plots_wanted[7] EQ 1 THEN BEGIN 
    IF esa_range_format EQ 1 THEN $
      swhalpha_raw        = fltarr(num_esa, 4, 1000, 1000, full_num_bins[full_limit_index[7]]) ELSE $
      swhalpha_raw        = fltarr(         4, 1000, 1000, full_num_bins[full_limit_index[7]]) 
    swhalpha_counts       = fltarr(num_esa,      16,    4, full_num_bins[full_limit_index[7]], n_elements(valid_epoch1))
ENDIF 

IF which_mass_mq_algorithm EQ 1 THEN read_andrew_constants, h_plus_corr, he_plus_corr, o_plus_corr
valid_mass_mq = fltarr(8, n_elements(valid_pha[0, *])) ; changed to 8 from 4 for abg code

; Calculate mass and mass per charge
    ; do the original algorithm regardless
calculate_mass_mq_new, valid_pha, 1, a1, a2, a3, a4, a5, a6, a_e, a_t, b_e, b_t, c2, d_nossd, d_ssd, d1, d2, e_max, e_min, $
  mass_max, mass_min, t_max, pac, mass_low_bound, mq_low_bound, $
  swpe, swpd, quadrant, position, section, priority, half, mass, nm, m_per_q, nq, e_per_q 
valid_pha[10, *] = nm
valid_pha[11, *] = nq
valid_mass_mq[0, *] = mass
valid_mass_mq[1, *] = m_per_q
IF which_mass_mq_algorithm EQ 1 THEN BEGIN ; data from above is overwritten if want different algorithm
    calculate_mass_mq_andrew_new, valid_pha, 1, a1, a2, a3, a4, a5, a6, d_nossd, d_ssd, d1, d2, e_max, e_min, $
      mass_max, mass_min, t_max, pac, mass_low_bound, mq_low_bound, h_plus_corr, he_plus_corr, o_plus_corr, sat, $
      swpe, swpd, quadrant, position, section, priority, half, mass, nm, m_per_q, nq, e_per_q
    valid_pha    [12, *] = nm
    valid_pha    [13, *] = nq
    valid_mass_mq[ 2, *] = mass
    valid_mass_mq[ 3, *] = m_per_q
ENDIF 
; abg code
IF which_mass_mq_algorithm EQ 2 THEN BEGIN ; data from above is overwritten - want different algorithm
    calculate_mass_mq_abg_new, which_mass_mq_algorithm, section_wanted, valid_pha, 1, a1, a2, a3, a4, a5, a6, a_e, a_t, b_e, b_t, c2, $
      d_nossd, d_ssd, dq, d2, e_max, e_min, mass_max, mass_min, t_max, t_min, pac, mass_low_bound, mq_low_bound, $
      swpe, swpd, quadrant, position, section, priority, half, $
      mass, nm, m_per_q, nq, e_per_q, e_meas, tns
    valid_pha    [12, *] = nm ; values with new algorithm
    valid_pha    [13, *] = nq
    valid_mass_mq[ 2, *] = mass
    valid_mass_mq[ 3, *] = m_per_q
    valid_mass_mq[ 4, *] = e_per_q
    valid_mass_mq[ 5, *] = e_per_q + PAC
    valid_mass_mq[ 6, *] = e_meas
    valid_mass_mq[ 7, *] = tns
    valid_pha_size = size(valid_pha)
    ;FOR ii = 0L, valid_pha_size[2]-1 DO BEGIN 
    ;    print, 'fill_bins_pp valid mass ', valid_mass_mq[2, ii], ' valid mass_per_charge ', valid_mass_mq[3, ii]
    ;ENDFOR
ENDIF 
; end abg code

; kiel code
IF which_mass_mq_algorithm EQ 3 THEN BEGIN ; data from above is overwritten - want different algorithm
    calculate_mass_mq_kiel, valid_pha, 1, c2, d_nossd, d_ssd, d1, mass_max, mass_min, t_max, mass_low_bound, mq_low_bound, $
      swpe, swpd, quadrant, position, section, priority, half, mass, nm, m_per_q, nq, e_per_q
    valid_pha    [12, *] = nm ; values with new algorithm
    valid_pha    [13, *] = nq
    valid_mass_mq[ 2, *] = mass
    valid_mass_mq[ 3, *] = m_per_q
    valid_pha_size = size(valid_pha)
ENDIF 
; end kiel code

; Calculate the bin_dat_word
; Create bin_dat_words
find_bindatword_new, half, nm, nq, full_bins, full_num_bins, quad_style_boxes, pha_pri, supra_no_e, supra_wide, swz2, sw_all, $
                    sw_h_alpha, bin_dat_word, plots_wanted, full_limit_index, full_limits, plot_bins = plot_bins

temp = size(valid_pha, /dimensions)
IF n_elements(valid_pha) GT 15 THEN num_pha = temp[1] ELSE num_pha = 1
pha_pri_addr    = lonarr(num_pha)
supra_no_e_addr = lonarr(num_pha)
supra_wide_addr = lonarr(num_pha)
swz2_addr       = lonarr(num_pha)
sw_all_addr     = lonarr(num_pha)
sw_h_alpha_addr = lonarr(num_pha)
IF simulate_instr EQ 1 THEN BEGIN 
; find address that will be incremented.
; If no address, then bin won't be incremented.
; Addresses end in 0, but the corresponding address that ends in 1
; also needs to be checked.
; First find POS (*not* position)
    POS = lonarr(num_pha)
    temp_i = where(section EQ 0 OR section EQ 1, count)
    IF count  GT 0 THEN POS[temp_i] = position[temp_i] - 16
    temp_i = where(section NE 0 AND section NE 1 AND quadrant EQ 0, count)
    IF count  GT 0 THEN POS[temp_i] = (ishft(position[temp_i], -3) AND '3'X) 
    temp_i = where(section NE 0 AND section NE 1 AND quadrant NE 0, count)
    IF count  GT 0 THEN POS[temp_i] = (ishft((quadrant[temp_i] AND '1'X), 2) OR (ishft(position[temp_i], -4) AND '3'X))
; pha_pri_addr
    temp_i = where((section AND '2'X) EQ 0, count, complement = ntemp_i, ncomplement = ncount)
    IF count  GT 0 THEN pha_pri_addr[temp_i ] = ('2F00'X OR (ishft((pha_pri[temp_i] AND '3'X), 6)) OR $
                                               (ishft((swpd[temp_i] AND '1F'X), 1))) 
    IF ncount GT 0 THEN pha_pri_addr[ntemp_i] = ('3200'X OR (ishft((pha_pri[ntemp_i] AND '1'X), 2)) OR $
                                                 (ishft((section[ntemp_i] AND '1'X), 1)))
; supra_no_e_addr
    temp_i = where(((section AND '2'X) EQ 0) OR (supra_no_e EQ '7'X), count, complement = ntemp_i, ncomplement = ncount)
    IF count  GT 0 THEN supra_no_e_addr[temp_i ] = 0
    IF ncount GT 0 THEN supra_no_e_addr[ntemp_i] = ('3100'X OR (ishft((supra_no_e[ntemp_i] AND '7'X), 5)) OR $
                                                    (ishft((POS[ntemp_i] AND '7'X), 2)) $
                                OR (ishft((section[ntemp_i] AND '1'), 1)))
; supra_wide_addr
    temp_i = where((section NE 2) OR (supra_wide EQ 'F'X), count, complement = ntemp_i, ncomplement = ncount)
    IF count  GT 0 THEN supra_wide_addr[temp_i ] = 0
    IF ncount GT 0 THEN supra_wide_addr[ntemp_i] = ('3000'X OR (ishft((supra_wide[ntemp_i] AND 'F'X), 4)) OR $
                                                    (ishft((POS[ntemp_i] AND '7'X), 1)))

; swz2_addr
    temp_i = where(((section AND '2'X) EQ 2) OR (swz2 EQ 'F'X), count, complement = ntemp_i, ncomplement = ncount)
    IF count  GT 0 THEN swz2_addr[temp_i ] = 0
    IF ncount GT 0 THEN swz2_addr[ntemp_i] = ('2000'X OR (ishft((swz2[ntemp_i] AND 'F'X), 8)) OR (ishft((POS[ntemp_i] AND '1E'X), 3)) $
                                              OR (ishft((swpd[ntemp_i] AND '1C'X), -1)))
; sw_all_addr
    temp_i = where(((section AND '2'X) EQ 2) OR (sw_all EQ 1), count, complement = ntemp_i, ncomplement = ncount)
    IF count  GT 0 THEN sw_all_addr[temp_i ] = 0
    IF ncount GT 0 THEN sw_all_addr[ntemp_i] = ('1800'X OR (ishft((POS[ntemp_i] AND '1F'X), 6)) OR (ishft((swpd[ntemp_i] AND '1F'X), 1)))
; sw_h_alpha_addr
    temp_i = where(((section AND '2'X) EQ 2) OR (sw_h_alpha EQ 3), count, complement = ntemp_i, ncomplement = ncount)
    IF count  GT 0 THEN sw_h_alpha_addr[temp_i ] = 0
    IF ncount GT 0 THEN sw_h_alpha_addr[ntemp_i] = ((ishft((sw_h_alpha[ntemp_i] AND '3'X), 11)) OR (ishft((POS[ntemp_i] AND '1F'X), 6)) $
                                                    OR (ishft((swpd[ntemp_i] AND '1F'X), 1)))
ENDIF ELSE BEGIN                ; set to 1 so won't constrain below
    pha_pri_addr   [*] = 1
    supra_no_e_addr[*] = 1
    supra_wide_addr[*] = 1
    swz2_addr      [*] = 1
    sw_all_addr    [*] = 1
    sw_h_alpha_addr[*] = 1
ENDELSE 

; collect data for plotting
half0_i = where(half EQ 0, half0_count, complement = half1_i, ncomplement = half1_count)
plot_mass = round(mass*10)
temp_i = where(plot_mass LE 0, count)
IF count GT 0 THEN plot_mass[temp_i] = 1 ; 2
temp_i = where(plot_mass GE 1000, count)
IF count GT 0 THEN plot_mass[temp_i] = 999
plot_m_q = round(m_per_q*10)
temp_i = where(plot_m_q GE 1000, count)
IF count GT 0 THEN plot_m_q[temp_i] = 999

IF half0_count GT 0 THEN BEGIN ; SSD
    temp_i = where(half EQ 0 AND section EQ 2, count)
    IF count GT 0 THEN BEGIN
        pha_pri_msb  = intarr(count)
        priority_msb = intarr(count)
        pha_pri_msb  = ISHFT(pha_pri [temp_i], -1) ; get MSB of pha_pri
        priority_msb = ISHFT(priority[temp_i], -1)
        valid_pha[9, temp_i] = pha_pri_msb
        FOR ii = 0L, count-1 DO BEGIN 
            wappha_ssd_pri_counts[swpe[temp_i[ii]]-esa_start, (swpd[temp_i[ii]]/2), priority_msb[ii], $
                                  valid_pha_buffer[temp_i[ii]], valid_pha_epoch1[temp_i[ii]]] = $
              wappha_ssd_pri_counts[swpe[temp_i[ii]]-esa_start, (swpd[temp_i[ii]]/2), priority_msb[ii], $
                                    valid_pha_buffer[temp_i[ii]], valid_pha_epoch1[temp_i[ii]]] + 1
        ENDFOR 
        IF plots_wanted[1] EQ 1 OR files_wanted[2] EQ 1 THEN BEGIN 
            temp_i = where(half EQ 0 AND section EQ 2 AND pha_pri_addr NE 0, count)
            FOR ii = 0L, count-1 DO BEGIN ; index 0&1 for bin 0, 2&3 for bin 1
                IF esa_range_format EQ 1 THEN BEGIN 
                    wappha_ssd_raw  [swpe[temp_i[ii]]-esa_start, priority[temp_i[ii]], plot_m_q[temp_i[ii]], $
                                                                plot_mass[temp_i[ii]], (pha_pri_msb[ii]*2)] = $ 
                      wappha_ssd_raw[swpe[temp_i[ii]]-esa_start, priority[temp_i[ii]], plot_m_q[temp_i[ii]], $
                                                            plot_mass[temp_i[ii]], (pha_pri_msb[ii]*2)] + 1
                    wappha_ssd_raw  [swpe[temp_i[ii]]-esa_start, priority[temp_i[ii]], plot_m_q[temp_i[ii]], $
                                                            plot_mass[temp_i[ii]], (pha_pri_msb[ii]*2)+1] =  $
                      wappha_ssd_raw[swpe[temp_i[ii]]-esa_start, priority[temp_i[ii]], plot_m_q[temp_i[ii]], $
                                                            plot_mass[temp_i[ii]], (pha_pri_msb[ii]*2)+1] + 1
                ENDIF ELSE BEGIN 
                    wappha_ssd_raw  [                            priority[temp_i[ii]], plot_m_q[temp_i[ii]], $
                                                                plot_mass[temp_i[ii]], (pha_pri_msb[ii]*2)] = $ 
                      wappha_ssd_raw[                            priority[temp_i[ii]], plot_m_q[temp_i[ii]], $
                                                            plot_mass[temp_i[ii]], (pha_pri_msb[ii]*2)] + 1
                    wappha_ssd_raw  [                            priority[temp_i[ii]], plot_m_q[temp_i[ii]], $
                                                            plot_mass[temp_i[ii]], (pha_pri_msb[ii]*2)+1] =  $
                      wappha_ssd_raw[                            priority[temp_i[ii]], plot_m_q[temp_i[ii]], $
                                                               plot_mass[temp_i[ii]], (pha_pri_msb[ii]*2)+1] + 1
                ENDELSE 
                wappha_ssd_counts   [swpe[temp_i[ii]]-esa_start, (swpd[temp_i[ii]]/2), priority[temp_i[ii]], (pha_pri_msb[ii]*2), $
                                                      valid_pha_epoch1[temp_i[ii]]] = $
                  wappha_ssd_counts [swpe[temp_i[ii]]-esa_start, (swpd[temp_i[ii]]/2), priority[temp_i[ii]], (pha_pri_msb[ii]*2), $
                                                      valid_pha_epoch1[temp_i[ii]]] + 1
                wappha_ssd_counts   [swpe[temp_i[ii]]-esa_start, (swpd[temp_i[ii]]/2), priority[temp_i[ii]], (pha_pri_msb[ii]*2)+1, $
                                                      valid_pha_epoch1[temp_i[ii]]] = $
                  wappha_ssd_counts [swpe[temp_i[ii]]-esa_start, (swpd[temp_i[ii]]/2), priority[temp_i[ii]], (pha_pri_msb[ii]*2)+1, $
                                                      valid_pha_epoch1[temp_i[ii]]] + 1
                valid_pha[14, temp_i[ii]] = valid_pha[14, temp_i[ii]]+2
            ENDFOR 
        ENDIF
    ENDIF 
    temp_i = where(half EQ 0 AND section NE 2, count)
    IF count GT 0 THEN BEGIN
        valid_pha[9, temp_i] = pha_pri[temp_i]
        FOR ii = 0L, count-1 DO BEGIN 
            swpha_pri_counts   [swpe[temp_i[ii]]-esa_start, (swpd[temp_i[ii]]/2), priority[temp_i[ii]], $
                                                 valid_pha_buffer[temp_i[ii]], valid_pha_epoch1[temp_i[ii]]] = $
              swpha_pri_counts [swpe[temp_i[ii]]-esa_start, (swpd[temp_i[ii]]/2), priority[temp_i[ii]], $
                                                 valid_pha_buffer[temp_i[ii]], valid_pha_epoch1[temp_i[ii]]] + 1
        ENDFOR 
        IF plots_wanted[0] EQ 1 OR files_wanted[2] EQ 1 THEN BEGIN 
            temp_i = where(half EQ 0 AND section NE 2 AND pha_pri_addr NE 0, count)
            FOR ii = 0L, count-1 DO BEGIN 
                IF esa_range_format EQ 1 THEN BEGIN 
                    swpha_raw  [swpe[temp_i[ii]]-esa_start, priority[temp_i[ii]], plot_m_q[temp_i[ii]], $
                                                           plot_mass[temp_i[ii]], pha_pri[temp_i[ii]]] = $
                      swpha_raw[swpe[temp_i[ii]]-esa_start, priority[temp_i[ii]], plot_m_q[temp_i[ii]], $
                                                           plot_mass[temp_i[ii]], pha_pri[temp_i[ii]]] + 1
                ENDIF ELSE BEGIN 
                    swpha_raw  [                            priority[temp_i[ii]], plot_m_q[temp_i[ii]], $
                                                           plot_mass[temp_i[ii]], pha_pri[temp_i[ii]]] = $
                      swpha_raw[                            priority[temp_i[ii]], plot_m_q[temp_i[ii]], $
                                                           plot_mass[temp_i[ii]], pha_pri[temp_i[ii]]] + 1
                ENDELSE 
                swpha_counts   [swpe[temp_i[ii]]-esa_start, (swpd[temp_i[ii]]/2), priority[temp_i[ii]], pha_pri[temp_i[ii]], $
                                                 valid_pha_epoch1[temp_i[ii]]] = $
                  swpha_counts [swpe[temp_i[ii]]-esa_start, (swpd[temp_i[ii]]/2), priority[temp_i[ii]], pha_pri[temp_i[ii]], $
                                                 valid_pha_epoch1[temp_i[ii]]] + 1
                valid_pha[14, temp_i[ii]] = valid_pha[14, temp_i[ii]]+1
            ENDFOR  
        ENDIF 
    ENDIF 
    IF plots_wanted[3] EQ 1 THEN BEGIN 
        temp_i = where(half EQ 0 AND supra_no_e_addr NE 0, count)
        FOR ii = 0L, count-1 DO BEGIN 
            IF esa_range_format EQ 1 THEN BEGIN 
                supranoe_ssd_raw  [swpe[temp_i[ii]]-esa_start, priority[temp_i[ii]], plot_m_q[temp_i[ii]], $
                                                              plot_mass[temp_i[ii]], supra_no_e[temp_i[ii]]] = $
                  supranoe_ssd_raw[swpe[temp_i[ii]]-esa_start, priority[temp_i[ii]], plot_m_q[temp_i[ii]], $
                                                              plot_mass[temp_i[ii]], supra_no_e[temp_i[ii]]] + 1
            ENDIF ELSE BEGIN 
                supranoe_ssd_raw  [                            priority[temp_i[ii]], plot_m_q[temp_i[ii]], $
                                                              plot_mass[temp_i[ii]], supra_no_e[temp_i[ii]]] = $
                  supranoe_ssd_raw[                            priority[temp_i[ii]], plot_m_q[temp_i[ii]], $
                                                              plot_mass[temp_i[ii]], supra_no_e[temp_i[ii]]] + 1
            ENDELSE 
            supranoe_ssd_counts   [swpe[temp_i[ii]]-esa_start, (swpd[temp_i[ii]]/2), priority[temp_i[ii]], supra_no_e[temp_i[ii]], $
                                                    valid_pha_epoch1[temp_i[ii]]] = $
              supranoe_ssd_counts [swpe[temp_i[ii]]-esa_start, (swpd[temp_i[ii]]/2), priority[temp_i[ii]], supra_no_e[temp_i[ii]], $
                                                    valid_pha_epoch1[temp_i[ii]]] + 1
            valid_pha[14, temp_i[ii]] = valid_pha[14, temp_i[ii]]+8
        ENDFOR 
    ENDIF 
    IF plots_wanted[5] EQ 1 THEN BEGIN 
        temp_i = where(half EQ 0 AND supra_wide_addr NE 0, count)
        FOR ii = 0L, count-1 DO BEGIN 
            IF esa_range_format EQ 1 THEN BEGIN 
                suprawide_raw  [swpe[temp_i[ii]]-esa_start, priority[temp_i[ii]], plot_m_q[temp_i[ii]], $
                                                           plot_mass[temp_i[ii]], supra_wide[temp_i[ii]]] = $
                  suprawide_raw[swpe[temp_i[ii]]-esa_start, priority[temp_i[ii]], plot_m_q[temp_i[ii]], $
                                                           plot_mass[temp_i[ii]], supra_wide[temp_i[ii]]] + 1
            ENDIF ELSE BEGIN 
                suprawide_raw  [                            priority[temp_i[ii]], plot_m_q[temp_i[ii]], $
                                                           plot_mass[temp_i[ii]], supra_wide[temp_i[ii]]] = $
                  suprawide_raw[                            priority[temp_i[ii]], plot_m_q[temp_i[ii]], $
                                                           plot_mass[temp_i[ii]], supra_wide[temp_i[ii]]] + 1
            ENDELSE 
            suprawide_counts   [swpe[temp_i[ii]]-esa_start, (swpd[temp_i[ii]]/2), priority[temp_i[ii]], supra_wide[temp_i[ii]], $
                                                 valid_pha_epoch1[temp_i[ii]]] = $
              suprawide_counts [swpe[temp_i[ii]]-esa_start, (swpd[temp_i[ii]]/2), priority[temp_i[ii]], supra_wide[temp_i[ii]], $
                                                 valid_pha_epoch1[temp_i[ii]]] + 1
            valid_pha[14, temp_i[ii]] = valid_pha[14, temp_i[ii]]+32
        ENDFOR 
    ENDIF 
    IF plots_wanted[6] EQ 1 THEN BEGIN 
        temp_i = where(half EQ 0 AND swz2_addr NE 0, count)
        FOR ii = 0L, count-1 DO BEGIN 
            IF esa_range_format EQ 1 THEN BEGIN 
                swz_raw  [swpe[temp_i[ii]]-esa_start, priority[temp_i[ii]], plot_m_q[temp_i[ii]], $
                                                     plot_mass[temp_i[ii]], swz2[temp_i[ii]]] = $
                  swz_raw[swpe[temp_i[ii]]-esa_start, priority[temp_i[ii]], plot_m_q[temp_i[ii]], $
                                                     plot_mass[temp_i[ii]], swz2[temp_i[ii]]] + 1
            ENDIF ELSE BEGIN 
                swz_raw  [                            priority[temp_i[ii]], plot_m_q[temp_i[ii]], $
                                                     plot_mass[temp_i[ii]], swz2[temp_i[ii]]] = $
                  swz_raw[                            priority[temp_i[ii]], plot_m_q[temp_i[ii]], $
                                                     plot_mass[temp_i[ii]], swz2[temp_i[ii]]] + 1
            ENDELSE 
            swz_counts   [swpe[temp_i[ii]]-esa_start, (swpd[temp_i[ii]]/2), priority[temp_i[ii]], swz2[temp_i[ii]], $
                                           valid_pha_epoch1[temp_i[ii]]] = $
              swz_counts [swpe[temp_i[ii]]-esa_start, (swpd[temp_i[ii]]/2), priority[temp_i[ii]], swz2[temp_i[ii]], $
                                                  valid_pha_epoch1[temp_i[ii]]] + 1
            valid_pha[14, temp_i[ii]] = valid_pha[14, temp_i[ii]]+64
        ENDFOR 
    ENDIF 
    IF plots_wanted[7] EQ 1 THEN BEGIN 
        temp_i = where(half EQ 0 AND sw_h_alpha_addr NE 0, count)
        FOR ii = 0L, count-1 DO BEGIN 
            IF esa_range_format EQ 1 THEN BEGIN 
                swhalpha_raw  [swpe[temp_i[ii]]-esa_start, priority[temp_i[ii]], plot_m_q[temp_i[ii]], $
                                                          plot_mass[temp_i[ii]], sw_h_alpha[temp_i[ii]]] = $
                  swhalpha_raw[swpe[temp_i[ii]]-esa_start, priority[temp_i[ii]], plot_m_q[temp_i[ii]], $
                                                          plot_mass[temp_i[ii]], sw_h_alpha[temp_i[ii]]] + 1
            ENDIF ELSE BEGIN 
                swhalpha_raw  [                            priority[temp_i[ii]], plot_m_q[temp_i[ii]], $
                                                          plot_mass[temp_i[ii]], sw_h_alpha[temp_i[ii]]] = $
                  swhalpha_raw[                            priority[temp_i[ii]], plot_m_q[temp_i[ii]], $
                                                          plot_mass[temp_i[ii]], sw_h_alpha[temp_i[ii]]] + 1
            ENDELSE 
            swhalpha_counts   [swpe[temp_i[ii]]-esa_start, (swpd[temp_i[ii]]/2), priority[temp_i[ii]], sw_h_alpha[temp_i[ii]], $
                                                valid_pha_epoch1[temp_i[ii]]] = $
              swhalpha_counts [swpe[temp_i[ii]]-esa_start, (swpd[temp_i[ii]]/2), priority[temp_i[ii]], sw_h_alpha[temp_i[ii]], $
                                                valid_pha_epoch1[temp_i[ii]]] + 1
            valid_pha[14, temp_i[ii]] = valid_pha[14, temp_i[ii]]+128
        ENDFOR 
    ENDIF
ENDIF 
IF half1_count GT 0 THEN BEGIN   ; non-SSD
    temp_i = where(half EQ 1 AND section EQ 3, count)
    IF count GT 0 THEN BEGIN
        pha_pri_msb  = intarr(count)
        priority_msb = intarr(count)
        pha_pri_msb  = ISHFT(pha_pri [temp_i], -1) ; get MSB of pha_pri
        priority_msb = ISHFT(priority[temp_i], -1)
        valid_pha[9, temp_i] = pha_pri_msb
        FOR ii = 0L, count-1 DO BEGIN 
            wappha_nossd_pri_counts  [swpe[temp_i[ii]]-esa_start, (swpd[temp_i[ii]]/2), priority_msb[ii], $
                                                       valid_pha_buffer[temp_i[ii]], valid_pha_epoch1[temp_i[ii]]] = $
              wappha_nossd_pri_counts[swpe[temp_i[ii]]-esa_start, (swpd[temp_i[ii]]/2), priority_msb[ii], $
                                                       valid_pha_buffer[temp_i[ii]], valid_pha_epoch1[temp_i[ii]]] + 1
        ENDFOR 
        IF plots_wanted[2] EQ 1 OR files_wanted[2] EQ 1 THEN BEGIN 
            temp_i = where(half EQ 1 AND section EQ 3 AND pha_pri_addr NE 0, count)
            FOR ii = 0L, count-1 DO BEGIN 
                IF esa_range_format EQ 1 THEN BEGIN 
                    wappha_nossd_raw  [swpe[temp_i[ii]]-esa_start, priority[temp_i[ii]], plot_m_q[temp_i[ii]], $
                                                                  plot_mass[temp_i[ii]], pha_pri_msb[ii]] = $
                      wappha_nossd_raw[swpe[temp_i[ii]]-esa_start, priority[temp_i[ii]], plot_m_q[temp_i[ii]], $
                                                                  plot_mass[temp_i[ii]], pha_pri_msb[ii]] + 1
                ENDIF ELSE BEGIN 
                    wappha_nossd_raw  [                            priority[temp_i[ii]], plot_m_q[temp_i[ii]], $
                                                                  plot_mass[temp_i[ii]], pha_pri_msb[ii]] = $
                      wappha_nossd_raw[                            priority[temp_i[ii]], plot_m_q[temp_i[ii]], $
                                                                  plot_mass[temp_i[ii]], pha_pri_msb[ii]] + 1
                ENDELSE 
                wappha_nossd_counts   [swpe[temp_i[ii]]-esa_start, (swpd[temp_i[ii]]/2), priority[temp_i[ii]], pha_pri_msb[ii], $
                                                        valid_pha_epoch1[temp_i[ii]]] = $
                  wappha_nossd_counts [swpe[temp_i[ii]]-esa_start, (swpd[temp_i[ii]]/2), priority[temp_i[ii]], pha_pri_msb[ii], $
                                                        valid_pha_epoch1[temp_i[ii]]] + 1
                valid_pha[14, temp_i[ii]] = valid_pha[14, temp_i[ii]]+4
            ENDFOR 
        ENDIF 
        temp_i = where(half EQ 1 AND section NE 3, count)
        IF count GT 0 THEN BEGIN  ; Wait! -- I don't think we should ever get here!
            print, 'Does it make sense to have half=0 and section!=3?'
            stop
            valid_pha[9, temp_i[ii]] = pha_pri[temp_i[ii]]
            IF plots_wanted[2] EQ 1 OR files_wanted[2] EQ 1 THEN BEGIN 
                temp_i = where(half EQ 1 AND section NE 3 AND pha_pri_addr NE 0, count)
                FOR ii = 0L, count-1 DO BEGIN 
                    IF esa_range_format EQ 1 THEN BEGIN 
                        wappha_nossd_raw  [swpe[temp_i[ii]]-esa_start, priority[temp_i[ii]], plot_m_q[temp_i[ii]], $
                                                                      plot_mass[temp_i[ii]], pha_pri[temp_i[ii]]] = $
                          wappha_nossd_raw[swpe[temp_i[ii]]-esa_start, priority[temp_i[ii]], plot_m_q[temp_i[ii]], $
                                                                      plot_mass[temp_i[ii]], pha_pri[temp_i[ii]]] + 1
                    ENDIF ELSE BEGIN 
                        wappha_nossd_raw  [                            priority[temp_i[ii]], plot_m_q[temp_i[ii]], $
                                                                      plot_mass[temp_i[ii]], pha_pri[temp_i[ii]]] = $
                          wappha_nossd_raw[                            priority[temp_i[ii]], plot_m_q[temp_i[ii]], $
                                                                      plot_mass[temp_i[ii]], pha_pri[temp_i[ii]]] + 1
                    ENDELSE 
                    wappha_nossd_counts   [swpe[temp_i[ii]]-esa_start, (swpd[temp_i[ii]]/2), priority[temp_i[ii]], pha_pri[temp_i[ii]], $
                                                            valid_pha_epoch1[temp_i[ii]]] = $
                      wappha_nossd_counts [swpe[temp_i[ii]]-esa_start, (swpd[temp_i[ii]]/2), priority[temp_i[ii]], pha_pri[temp_i[ii]], $
                                                            valid_pha_epoch1[temp_i[ii]]] + 1
                    valid_pha[14, temp_i[ii]] = valid_pha[14, temp_i[ii]]+4
                ENDFOR
            ENDIF 
        ENDIF 
        IF plots_wanted[4] EQ 1 THEN BEGIN 
            temp_i = where(half EQ 1 AND supra_no_e_addr NE 0, count)
            FOR ii = 0L, count-1 DO BEGIN 
                IF esa_range_format EQ 1 THEN BEGIN 
                    supranoe_nossd_raw  [swpe[temp_i[ii]]-esa_start, priority[temp_i[ii]], plot_m_q[temp_i[ii]], $
                                                                    plot_mass[temp_i[ii]], supra_no_e[temp_i[ii]]] = $
                      supranoe_nossd_raw[swpe[temp_i[ii]]-esa_start, priority[temp_i[ii]], plot_m_q[temp_i[ii]], $
                                                                    plot_mass[temp_i[ii]], supra_no_e[temp_i[ii]]] + 1
                ENDIF ELSE BEGIN 
                    supranoe_nossd_raw  [                            priority[temp_i[ii]], plot_m_q[temp_i[ii]], $
                                                                    plot_mass[temp_i[ii]], supra_no_e[temp_i[ii]]] = $
                      supranoe_nossd_raw[                            priority[temp_i[ii]], plot_m_q[temp_i[ii]], $
                                                                    plot_mass[temp_i[ii]], supra_no_e[temp_i[ii]]] + 1
                ENDELSE 
                supranoe_nossd_counts   [swpe[temp_i[ii]]-esa_start, (swpd[temp_i[ii]]/2), priority[temp_i[ii]], supra_no_e[temp_i[ii]], $
                                                          valid_pha_epoch1[temp_i[ii]]] = $
                  supranoe_nossd_counts [swpe[temp_i[ii]]-esa_start, (swpd[temp_i[ii]]/2), priority[temp_i[ii]], supra_no_e[temp_i[ii]], $
                                                          valid_pha_epoch1[temp_i[ii]]] + 1
                valid_pha[14, temp_i[ii]] = valid_pha[14, temp_i[ii]]+16
            ENDFOR
        ENDIF 
    ENDIF 
ENDIF 

print, "finished reading individual pha"
END 
