; Lorna Ellis
; 07/15/2008
; create_tplot_new.pro

; This creates .tplot files for each product.
; This is part of the PhaPlay program.
; This version does not read from ascii, but takes from data arrays.

; input: tplot_dir        : directory in which to put .tplot files
;        temp_start_esa   : esa at which files start
;        temp_stop_esa    : end of esa range
;        ascii_norm_format: 0=counts, 1=counts/sec
;        full_num_bins    : array with number of bins for each product (size 12)
;        _newnorm -- [esa, num_bins, num_epoch]
;        _newraw [esa, defl (summed), priority, num_bins, num_epoch]
;        tplot_times      : dblarr

; 07/21/2011 Fix bug when only have one time.
; 10/21/2011 Change for new version
; 07/18/2013 Removed '+temp_start_esa' when setting up esa_indices

PRO create_tplot_new, tplot_dir, temp_start_esa, temp_stop_esa, full_num_bins, ascii_norm_format, $
  swpha_newnorm, wappha_ssd_newnorm, wappha_nossd_newnorm, supranoe_ssd_newnorm, $
  supranoe_nossd_newnorm, suprawide_newnorm, swz_newnorm, swhalpha_newnorm, $
  swpha_newraw, wappha_ssd_newraw, wappha_nossd_newraw, supranoe_ssd_newraw, $
  supranoe_nossd_newraw, suprawide_newraw, swz_newraw, swhalpha_newraw, tplot_times
compile_opt strictarrsubs

COMMON com_pha_play

cdf_base_brief = strmid(cdf_base, 0, 4)+strmid(cdf_base, 11, 8)
line = ' '
tab = STRING(9B)

full_limit_index = [0, 0, 1, 2, 3, 4, 6, 10] ; index for these plots into full_limits array
num_bins = full_num_bins[full_limit_index]

num_esa = temp_stop_esa-temp_start_esa+1
IF norm_esa_sum EQ 1 THEN BEGIN
    esa_indices = indgen(num_esa) ;+temp_start_esa
ENDIF ELSE BEGIN 
    esa_indices = indgen(num_esa/2)*2 ;+temp_start_esa ; indices we want in 128 esa array
ENDELSE 

gotten_esa = 0
FOR ii = 0, 7 DO BEGIN ; product
    IF plots_wanted[ii] EQ 1 THEN BEGIN 
        CASE ii OF 
            0: BEGIN
                prod_name = 'swpha'
                norm_data = swpha_newnorm
                raw_data  = swpha_newraw
            END 
            1: BEGIN
                prod_name = 'wappha_ssd'
                norm_data = wappha_ssd_newnorm
                raw_data  = wappha_ssd_newraw
            END 
            2: BEGIN
                prod_name = 'wappha_nossd'
                norm_data = wappha_nossd_newnorm
                raw_data  = wappha_nossd_newraw
            END 
            3: BEGIN
                prod_name = 'supranoe_ssd'
                norm_data = supranoe_ssd_newnorm
                raw_data  = supranoe_ssd_newraw
            END 
            4: BEGIN
                prod_name = 'supranoe_nossd'
                norm_data = supranoe_nossd_newnorm
                raw_data  = supranoe_nossd_newraw
            END 
            5: BEGIN
                prod_name = 'suprawide'
                norm_data = suprawide_newnorm
                raw_data  = suprawide_newraw
            END 
            6: BEGIN
                prod_name = 'swz'
                norm_data = swz_newnorm
                raw_data  = swz_newraw
            END 
            7: BEGIN
                prod_name = 'swhalpha'
                norm_data = swhalpha_newnorm
                raw_data  = swhalpha_newraw
            END 
        ENDCASE 

        ; set up energy range
        IF gotten_esa EQ 0 THEN BEGIN 
            size = size(norm_data, /dimensions)
            IF n_elements(size) LT 3 THEN num_tplot_times = 1 ELSE BEGIN 
                IF size[2] NE n_elements(tplot_times) THEN BEGIN
                    print, 'error with tplot times'
                    stop
                ENDIF 
                num_tplot_times = size[2]
            ENDELSE 
            get_pla_energies, sat, esa_step
            esa_step  =  esa_step * 1e3
            esa_range = fltarr(num_esa)
            FOR jj = 0, num_esa-1 DO BEGIN 
                esa_range[jj] = esa_step[temp_start_esa+jj]
            ENDFOR 
            esa_array = fltarr(num_tplot_times, num_esa)
            FOR jj = 0, num_tplot_times-1 DO BEGIN
                esa_array[jj, *] = esa_range/1000 
            ENDFOR 
            IF ascii_norm_format EQ 0 THEN ztitle = 'Counts' ELSE ztitle = 'Counts/Sec.'
            gotten_esa = 1
        ENDIF 

        ; data
        temp_num_bins = num_bins[ii]
        FOR jj = 0, temp_num_bins-1 DO BEGIN
            temp_norm_data = reform(norm_data[*, jj, *]) ; just take this bin
            temp_raw_data  = reform(raw_data [*, jj, *]) ; just take this bin
            IF norm_esa_sum EQ 1 THEN BEGIN 
                new_norm_data = transpose(temp_norm_data[esa_indices, *])
                new_raw_data  = transpose(temp_raw_data [esa_indices, *])
            ENDIF ELSE BEGIN
                new_norm_data = dblarr(num_esa, num_tplot_times)
                temp_i = indgen(num_esa/2)*2
                new_norm_data[temp_i, *] = temp_norm_data[esa_indices, *]
                temp_i = indgen(num_esa/2)*2+1
                new_norm_data[temp_i, *] = temp_norm_data[esa_indices, *]
                new_norm_data = new_norm_data/2
                new_norm_data = transpose(new_norm_data)
                new_raw_data = dblarr(num_esa, num_tplot_times)
                temp_i = indgen(num_esa/2)*2
                new_raw_data[temp_i, *] = temp_raw_data[esa_indices, *]
                temp_i = indgen(num_esa/2)*2+1
                new_raw_data[temp_i, *] = temp_raw_data[esa_indices, *]
                new_raw_data = new_raw_data/2
                new_raw_data = transpose(new_raw_data)
            ENDELSE 

            ; normalized data
            temp_prod_name = sat+'_norm_'+prod_name+'_'+labels[ii, jj]+'_'+suffix
            ytitle = sat+'_norm!C!C'+prod_name+'_'+labels[ii, jj]+'!C!C E/q (keV/q)'
            good_i = where(new_norm_data NE 0, count)
            IF count GT 0 THEN min = min(new_norm_data[good_i], max = max) ELSE BEGIN
                min = .1
                max = 10
            ENDELSE 
            IF min EQ max THEN max = max * 10
            dat = {x:tplot_times, y:new_norm_data, v:esa_array}
            store_data, temp_prod_name, data = dat, $
            dlim = {panel_size:1, $
                    spec:1, $
                    x_no_interp:1, $
                    y_no_interp:1, $
                    ylog:0, $
                    zlog:1, $
                    zrange:[min, max], $
                    ytitle:ytitle, $
                    ztitle:ztitle $
                   }

            temp_prod_name = sat+'_raw_'+prod_name+'_'+labels[ii, jj]+'_'+suffix
            ytitle = sat+'_raw!C!C'+prod_name+'_'+labels[ii, jj]+'!C!C E/q (keV/q)'
            good_i = where(new_raw_data NE 0, count)
            IF count GT 0 THEN min = min(new_raw_data[good_i], max = max) ELSE BEGIN 
                min = .1
                max = 10
            ENDELSE 
            IF min EQ max THEN max = max * 10
            dat = {x:tplot_times, y:new_raw_data, v:esa_array}
            store_data, temp_prod_name, data = dat, $
            dlim = {panel_size:1, $
                    spec:1, $
                    x_no_interp:1, $
                    y_no_interp:1, $
                    ylog:0, $
                    zlog:1, $
                    zrange:[min, max], $
                    ytitle:ytitle, $
                    ztitle:'Counts' $
                   }
        ENDFOR 
    ENDIF 
ENDFOR 
temp_filename = tplot_dir+'/'+cdf_base_brief+'_'+suffix
tplot_save, filename = temp_filename
END 
