; Lorna Ellis
; July 10, 2008
; calculate_mass_mq_andrew_new.pro

; This program takes an array of PHA words and calculates mass, mass per
; charge and e/q. It is intended as part of the pha_play program.
; This version uses Andrew's algorith, as put forward in 080304_agustafson.ppt.

; Input: pha           : 9 element array [swpe, swpd, quad, ssd_id, ssde, tof, position, section, priority]
;        want_bins     : flag for if want bin number returned
;        a1            : constant from file
;        a2            : constant from file
;        a3            : constant from file
;        a4            : constant from file
;        a5            : constant from file
;        a6            : constant from file
;        d_nossd       : constant from file
;        d_ssd         : constant from file
;        d1            : constant from file
;        d2            : constant from file
;        e_max         : constant from file
;        e_min         : constant from file
;        mass_max      : constant from file
;        mass_min      : constant from file
;        t_max         : constant from file
;        pac           : constant 
;        mass_low_bound: from find_bins [92] -- only needed if want bins
;        mq_low_bound  : from find_bins [2,256] -- only needed if want bins
;        h_plus_corr   : from ConstantsTableAndrew.txt, 128 array of carbon foil loss correction
;        he_plus_corr  : from ConstantsTableAndrew.txt, 128 array of carbon foil loss correction
;        o_plus_corr   : from ConstantsTableAndrew.txt, 128 array of carbon foil loss correction
;        sat           : 'A' or 'B'
;
; Output: swpe    : from pha
;         swpd    : from pha
;         quadrant: from pha
;         position: from pha
;         section : from pha
;         priority: from pha
;         half    : based on section
;         mass    : mass in keV -- returns NaN when ssde_un eq 0
;         nm      : mass bin
;         m_per_q : mass per charge
;         nq      : mass per charge bin
;         e_per_q : energy per charge in keV

;  07/18/2008 If tof=0 then tns=0. If ssde=0 then mass=0.
;  08/06/2008 Changed a_t to a_t_andrew (etc) so can loop files.
;  01/23/2012 Fix line with mass calculation so constants are treated right.
;  03/12/2014 Removed arguments that aren't used.

PRO calculate_mass_mq_andrew_new, pha, want_bins, a1, a2, a3, a4, a5, a6, d_nossd, d_ssd, d1, d2, e_max, e_min, mass_max, mass_min, t_max, pac, mass_low_bound, mq_low_bound, h_plus_corr, he_plus_corr, o_plus_corr, sat, swpe, swpd, quadrant, position, section, priority, half, mass, nm, m_per_q, nq, e_per_q

compile_opt strictarrsubs
temp = size(pha, /dimensions)
num_pha = temp[1]
swpe     = reform(long(pha[0, *]))         ; convert to a long
swpd     = reform(long(pha[1, *]))
temp_i = where(swpe MOD 2 EQ 1, count)
IF count GT 0 THEN swpd[temp_i] = 31-swpd[temp_i] ; reverse deflection on odd esas
quadrant = reform(long(pha[2, *]))         ; no-SSD half has PHA quadrants 3 & 4
ssd_id   = reform(long(pha[3, *]))
ssde_un  = reform(long(pha[4, *]))
tof      = reform(long(pha[5, *]))
position = reform(long(pha[6, *]))
section  = reform(long(pha[7, *]))
priority = reform(long(pha[8, *]))
yes_i = where(section EQ 3, yes_count, complement = no_i, ncomplement = no_count)
half = lonarr(num_pha)
IF yes_count GT 0 THEN half[yes_i] = 1L
IF no_count GT 0 THEN half[no_i] = 0L

; Calculate NQ table
; Convert time channels (Tch) to nanoseconds (Tns)
a_t_andrew = fltarr(num_pha)
b_t_andrew = fltarr(num_pha)
sec3_i = where(section EQ 3, sec3_count, complement = sec_not3_i, ncomplement = sec_not3_count)
IF sat EQ 'A' THEN BEGIN
    IF sec3_count GT 0 THEN BEGIN
        a_t_andrew[sec3_i] = 0.250
        b_t_andrew[sec3_i] = 4.7
    ENDIF 
    IF sec_not3_count GT 0 THEN BEGIN 
        a_t_andrew[sec_not3_i] = 0.252
        b_t_andrew[sec_not3_i] = 4.8
    ENDIF 
ENDIF ELSE BEGIN
    IF sec3_count GT 0 THEN BEGIN
        a_t_andrew[sec3_i] = 0.240
        b_t_andrew[sec3_i] = 3.5
    ENDIF 
    IF sec_not3_count GT 0 THEN BEGIN 
        a_t_andrew[sec_not3_i] = 0.250
        b_t_andrew[sec_not3_i] = 4.3
    ENDIF 
ENDELSE 
tns = dblarr(num_pha)
tof0_i = where(tof EQ 0, tof0_count, complement = ntof0_i, ncomplement = ntof0_count)
IF tof0_count GT 0 THEN tns[tof0_i] = 0
IF ntof0_count GT 0 THEN tns[ntof0_i] =  tof[ntof0_i] * a_t_andrew[ntof0_i] + b_t_andrew[ntof0_i]          ; Tch is TOF
; Convert E/Q steps to keV
s = 127 - swpe
e_per_q =  d1 * d2^s
; Calculate Mass per charge for each T -- E/Q pair
c1 = (4.38E7)^2/(1E9)^2/(d_nossd)^2
m_per_q_init = c1 * (pac + e_per_q ) * (tns)^2
half0_i = where(half EQ 0, half0_count, complement = half1_i, ncomplement = half1_count)
IF half0_count GT 0 THEN m_per_q_init[half0_i] = m_per_q_init[half0_i] * (d_nossd)^2 / (d_ssd)^2
new_c2 = fltarr(num_pha)
temp_i = where(m_per_q_init LT 2.25, temp_count)
IF temp_count GT 0 THEN new_c2[temp_i] = h_plus_corr[swpe[temp_i]]
temp_i = where(m_per_q_init GT 2.25 AND m_per_q_init LT 11, temp_count)
IF temp_count GT 0 THEN new_c2[temp_i] = he_plus_corr[swpe[temp_i]]
temp_i = where(m_per_q_init GE 11, temp_count)
IF temp_count GT 0 THEN new_c2[temp_i] = o_plus_corr[swpe[temp_i]]
m_per_q = c1 * (pac + e_per_q - new_c2 ) * (tns)^2
IF half0_count GT 0 THEN m_per_q[half0_i] = m_per_q[half0_i] * (d_nossd)^2 / (d_ssd)^2

; get bin 
IF want_bins EQ 1 THEN BEGIN 
    nq = intarr(num_pha)
    nq[*] = 255 ; if not found elsewhere, it will be here
    IF half0_count GT 0 THEN BEGIN
        ;mq_index[half0_i] = 1
        temp_m_q = m_per_q[half0_i]
        temp_nq = nq[half0_i]
        FOR ii = 0, 254 DO BEGIN ; 256 limit bins -- this loop is small compared with num_pha
            temp_i = where(mq_low_bound[1, ii] LE temp_m_q AND mq_low_bound[1, ii+1] GT temp_m_q, temp_count)
            IF temp_count GT 0 THEN temp_nq[temp_i] = ii
        ENDFOR 
        nq[half0_i] = temp_nq
    ENDIF 
    IF half1_count GT 0 THEN BEGIN
        ;mq_index[half1_i] = 0
        temp_m_q = m_per_q[half1_i]
        temp_nq = nq[half1_i]
        FOR ii = 0, 254 DO BEGIN ; 256 limit bins -- this loop is small compared with num_pha
            temp_i = where(mq_low_bound[0, ii] LE temp_m_q AND mq_low_bound[0, ii+1] GT temp_m_q, temp_count)
            IF temp_count GT 0 THEN temp_nq[temp_i] = ii
        ENDFOR 
        nq[half1_i] = temp_nq
    ENDIF 
ENDIF 
; Calculate NM 
; Convert uncompressed energy channel to keV
ssd_offset = intarr(num_pha)
a_e_andrew = fltarr(num_pha)
b_e_andrew = fltarr(num_pha)
IF sat EQ 'A' THEN BEGIN
    temp_i = where(ssd_id EQ 0, temp_count)
    IF temp_count GT 0 THEN BEGIN
        ssd_offset[temp_i] = 1
        a_e_andrew[temp_i] = 2.276
        b_e_andrew[temp_i] = -0.838
    ENDIF 
    temp_i = where(ssd_id EQ 1, temp_count)
    IF temp_count GT 0 THEN BEGIN
        ssd_offset[temp_i] = 5
        a_e_andrew[temp_i] = 2.302
        b_e_andrew[temp_i] = 8.09
    ENDIF 
    temp_i = where(ssd_id EQ 2, temp_count)
    IF temp_count GT 0 THEN BEGIN
        ssd_offset[temp_i] = 2
        a_e_andrew[temp_i] = 2.291
        b_e_andrew[temp_i] = 1.429
    ENDIF 
    temp_i = where(ssd_id EQ 3, temp_count)
    IF temp_count GT 0 THEN BEGIN
        ssd_offset[temp_i] = 3
        a_e_andrew[temp_i] = 2.263
        b_e_andrew[temp_i] = 3.738
    ENDIF 
    temp_i = where(ssd_id EQ 4, temp_count)
    IF temp_count GT 0 THEN BEGIN
        ssd_offset[temp_i] = 5
        a_e_andrew[temp_i] = 2.235
        b_e_andrew[temp_i] = 7.495
    ENDIF 
    temp_i = where(ssd_id EQ 5, temp_count)
    IF temp_count GT 0 THEN BEGIN
        ssd_offset[temp_i] = 7
        a_e_andrew[temp_i] = 2.227
        b_e_andrew[temp_i] = 12.909
    ENDIF 
    temp_i = where(ssd_id EQ 6, temp_count)
    IF temp_count GT 0 THEN BEGIN
        ssd_offset[temp_i] = 4
        a_e_andrew[temp_i] = 2.225
        b_e_andrew[temp_i] = 5.283
        ENDIF 
    temp_i = where(ssd_id EQ 7, temp_count)
    IF temp_count GT 0 THEN BEGIN
        ssd_offset[temp_i] = 3
        a_e_andrew[temp_i] = 2.214
        b_e_andrew[temp_i] = 4.03
    ENDIF 
    temp_i = where(ssd_id EQ 8, temp_count)
    IF temp_count GT 0 THEN BEGIN
        ssd_offset[temp_i] = 8
        a_e_andrew[temp_i] = 2.211
        b_e_andrew[temp_i] = 14.252
    ENDIF 
    temp_i = where(ssd_id EQ 9, temp_count)
    IF temp_count GT 0 THEN BEGIN
        ssd_offset[temp_i] = 4
        a_e_andrew[temp_i] = 2.16
        b_e_andrew[temp_i] = 6.74
    ENDIF 
    temp_i = where(ssd_id EQ 10, temp_count)
    IF temp_count GT 0 THEN BEGIN
        ssd_offset[temp_i] = 2
        a_e_andrew[temp_i] = 2.219
        b_e_andrew[temp_i] = 0.977
    ENDIF 
    temp_i = where(ssd_id EQ 11, temp_count)
    IF temp_count GT 0 THEN BEGIN
        ssd_offset[temp_i] = 6
        a_e_andrew[temp_i] = 2.22
        b_e_andrew[temp_i] = 10.795
    ENDIF 
    temp_i = where(ssd_id EQ 12, temp_count)
    IF temp_count GT 0 THEN BEGIN
        ssd_offset[temp_i] = 4
        a_e_andrew[temp_i] = 2.223
        b_e_andrew[temp_i] = 5.155
    ENDIF 
    temp_i = where(ssd_id EQ 13, temp_count)
    IF temp_count GT 0 THEN BEGIN
        ssd_offset[temp_i] = 4
        a_e_andrew[temp_i] = 2.223
        b_e_andrew[temp_i] = 5.014
    ENDIF 
    temp_i = where(ssd_id EQ 14, temp_count)
    IF temp_count GT 0 THEN BEGIN
        ssd_offset[temp_i] = 0
        a_e_andrew[temp_i] = 2.269
        b_e_andrew[temp_i] = -3.128
    ENDIF 
    temp_i = where(ssd_id EQ 15, temp_count)
    IF temp_count GT 0 THEN BEGIN
        ssd_offset[temp_i] = 0
        a_e_andrew[temp_i] = 2.357
        b_e_andrew[temp_i] = -2.912
    ENDIF 
ENDIF ELSE BEGIN
    temp_i = where(ssd_id EQ 0, temp_count)
    IF temp_count GT 0 THEN BEGIN
        ssd_offset[temp_i] = 2
        a_e_andrew[temp_i] = 2.16
        b_e_andrew[temp_i] = -21.06
    ENDIF 
    temp_i = where(ssd_id EQ 1, temp_count)
    IF temp_count GT 0 THEN BEGIN
        ssd_offset[temp_i] = 1
        a_e_andrew[temp_i] = 2.13
        b_e_andrew[temp_i] = -23.2
    ENDIF 
    temp_i = where(ssd_id EQ 2, temp_count)
    IF temp_count GT 0 THEN BEGIN
        ssd_offset[temp_i] = 0
        a_e_andrew[temp_i] = 2.24
        b_e_andrew[temp_i] = -26.29
    ENDIF 
    temp_i = where(ssd_id EQ 3, temp_count)
    IF temp_count GT 0 THEN BEGIN
        ssd_offset[temp_i] = 0
        a_e_andrew[temp_i] = 2.09
        b_e_andrew[temp_i] = -24.
    ENDIF 
    temp_i = where(ssd_id EQ 4, temp_count)
    IF temp_count GT 0 THEN BEGIN
        ssd_offset[temp_i] = 2
        a_e_andrew[temp_i] = 2.19
        b_e_andrew[temp_i] = -20.27
    ENDIF 
    temp_i = where(ssd_id EQ 5, temp_count)
    IF temp_count GT 0 THEN BEGIN
        ssd_offset[temp_i] = 4
        a_e_andrew[temp_i] = 2.16
        b_e_andrew[temp_i] = -17.49
    ENDIF 
    temp_i = where(ssd_id EQ 6, temp_count)
    IF temp_count GT 0 THEN BEGIN
        ssd_offset[temp_i] = 2
        a_e_andrew[temp_i] = 2.13
        b_e_andrew[temp_i] = -20.46
    ENDIF 
    temp_i = where(ssd_id EQ 7, temp_count)
    IF temp_count GT 0 THEN BEGIN
        ssd_offset[temp_i] = 2
        a_e_andrew[temp_i] = 2.14
        b_e_andrew[temp_i] = -19.95
    ENDIF 
    temp_i = where(ssd_id EQ 8, temp_count)
    IF temp_count GT 0 THEN BEGIN
        ssd_offset[temp_i] = 7
        a_e_andrew[temp_i] = 2.09
        b_e_andrew[temp_i] = -10.66
    ENDIF 
    temp_i = where(ssd_id EQ 9, temp_count)
    IF temp_count GT 0 THEN BEGIN
        ssd_offset[temp_i] = 6
        a_e_andrew[temp_i] = 2.1
        b_e_andrew[temp_i] = -12.87
    ENDIF 
    temp_i = where(ssd_id EQ 10, temp_count)
    IF temp_count GT 0 THEN BEGIN
        ssd_offset[temp_i] = 4
        a_e_andrew[temp_i] = 2.01
        b_e_andrew[temp_i] = -14.73
    ENDIF 
    temp_i = where(ssd_id EQ 11, temp_count)
    IF temp_count GT 0 THEN BEGIN
        ssd_offset[temp_i] = 3
        a_e_andrew[temp_i] = 2.11
        b_e_andrew[temp_i] = -19.02
    ENDIF 
    temp_i = where(ssd_id EQ 12, temp_count)
    IF temp_count GT 0 THEN BEGIN
        ssd_offset[temp_i] = 1
        a_e_andrew[temp_i] = 2.18
        b_e_andrew[temp_i] = -23.17
    ENDIF 
    temp_i = where(ssd_id EQ 13, temp_count)
    IF temp_count GT 0 THEN BEGIN
        ssd_offset[temp_i] = 5
        a_e_andrew[temp_i] = 2.09
        b_e_andrew[temp_i] = -15.13
    ENDIF 
    temp_i = where(ssd_id EQ 14, temp_count)
    IF temp_count GT 0 THEN BEGIN
        ssd_offset[temp_i] = 4
        a_e_andrew[temp_i] = 2.24
        b_e_andrew[temp_i] = -18.14
    ENDIF 
    temp_i = where(ssd_id EQ 15, temp_count)
    IF temp_count GT 0 THEN BEGIN
        ssd_offset[temp_i] = 0
        a_e_andrew[temp_i] = 2.24
        b_e_andrew[temp_i] = -25.56
    ENDIF 
ENDELSE 
e_meas = (ssde_un-ssd_offset)*a_e_andrew + b_e_andrew
; Calculate mass
x = alog(e_meas)
y = alog(tns)
mass = dblarr(num_pha)
mass0_i = where(ssde_un EQ 0, mass0_count, complement = nmass0_i, ncomplement = nmass0_count)
IF mass0_count  GT 0 THEN mass[ mass0_i] = 0
IF nmass0_count GT 0 THEN mass[nmass0_i] = $
  EXP(a1 + a2*x[nmass0_i] + a3*y[nmass0_i] + a4*x[nmass0_i]*y[nmass0_i] + $
      a5*x[nmass0_i]^2 + a6*y[nmass0_i]^3)
; Convert to a bin number
IF want_bins EQ 1 THEN BEGIN 
    nm = intarr(num_pha)
    nm[*] = 91
    FOR ii = 0, 90 DO BEGIN    ; 92 limit bins -- this loop is small compared with num_pha
        temp_i = where(mass_low_bound[ii] LE mass AND mass_low_bound[ii+1] GT mass, temp_count)
        IF temp_count GT 0 THEN nm[temp_i] = ii
    ENDFOR 
    ; now overwrite with error cases
    temp_i = where(mass LE mass_min, temp_count)
    IF temp_count GT 0 THEN nm[temp_i] = 92
    temp_i = where(mass GE mass_max, temp_count)
    IF temp_count GT 0 THEN nm[temp_i] = 91
    temp_i = where(tns GE t_max, temp_count)
    IF temp_count GT 0 THEN nm[temp_i] = 95
    temp_i = where(finite(tns) NE 1, temp_count)
    IF temp_count GT 0 THEN nm[temp_i] = 94
    temp_i = where(e_meas GE e_max, temp_count)
    IF temp_count GT 0 THEN nm[temp_i] = 93
    temp_i = where(e_meas LE e_min, temp_count)
    IF temp_count GT 0 THEN nm[temp_i] = 0
ENDIF 
END 
