; Lorna Ellis
; 01/09/2013
; time_shift_intra_stereo.pro

; This is based on time_shift_wind_to_stereo.pro. 

; input : start_sat   : 'A' or 'B'
;         stop_sat    : 'A' or 'B'
;         time_range  : array of doubles with tplot times
; output: shifted_time: array of doubles with shifted tplot times

; 04/08/2014 Divide by 60 for timespan
; 07/08/2019 Coming back closer together; so reverse delta_lon

PRO time_shift_intra_stereo, start_sat, stop_sat, time_range, shifted_time
compile_opt strictarrsubs
tplot_names, names = names
saved_vars = 0
IF keyword_set(names) THEN BEGIN 
    saved_vars = 1
    tplot_save, filename = 'temp_time_shift_intra_stereo' ; save existing tplot variable so can restore later
    tplot_names, '*', names = names
    store_data, names, /DEL
ENDIF 

good_i = where(finite(time_range) EQ 1)

temp_time_range = time_range[good_i]
start_t         = temp_time_range[0]
stop_t          = temp_time_range[n_elements(temp_time_range)-1]
start_t_struct  = time_struct(start_t)
stop_t_struct   = time_struct(stop_t)
start_year      = start_t_struct.year
start_doy       = start_t_struct.doy
stop_year       = stop_t_struct.year
stop_doy        = stop_t_struct.doy
num_records     = n_elements(temp_time_range)

; load data
timespan, start_t, (stop_t-start_t+5)/60, /minutes
get_pla_l2_1dmax, start_sat, order = 2 ; valid first, then prelim
speed = start_sat+'_l2_1dmax_proton_bulk_speed'
get_data, speed, speed_t, speed_d
new_speed_t = dblarr(num_records)
new_speed_d = dblarr(num_records)

; remove times with no valid speed
problem_case = 0
temp_good_i = where(finite(speed_d) EQ 1, good_count)
IF good_count GT 0 THEN BEGIN
    speed_t = speed_t[temp_good_i]
    speed_d = speed_d[temp_good_i]
ENDIF ELSE BEGIN ; need to expand time range to get some valid time
    temp_start_t = start_t
    temp_stop_t  = stop_t 
    WHILE good_count EQ 0 DO BEGIN 
        temp_start_t = temp_start_t - 300 ; go back 5 minutes
        temp_stop_t  = temp_stop_t  + 300
        timespan, temp_start_t, (stop_t-start_t+1), /minutes
        get_pla_l2_1dmax, start_sat, order = 2 ; valid first, then prelim
        speed = start_sat+'_l2_1dmax_proton_bulk_speed'
        get_data, speed, speed_t, speed_d
        temp_good_i = where(finite(speed_d) EQ 1, good_count)
        IF good_count GT 0 THEN BEGIN
            speed_t = speed_t[temp_good_i]
            speed_d = speed_d[temp_good_i]
        ENDIF 
        IF num_records EQ 1 THEN BEGIN ; find closest value if only want one
            min = min(abs(speed_t - temp_time_range[0]), min_i, /nan)
            new_speed_t[0] = speed_t[min_i]
            new_speed_d[0] = speed_d[min_i]
        ENDIF 
        problem_case = 1
    ENDWHILE 
ENDELSE 

IF problem_case EQ 0 THEN BEGIN 
    FOR ii = 0L, num_records-1 DO BEGIN
        IF ii MOD 10000 EQ 0 THEN print, 'time ', ii, ' ', num_records
        min = min(abs(speed_t - temp_time_range[ii]), min_i, /nan)
        IF min LT 120 THEN BEGIN ; two minutes
            new_speed_t[ii] = speed_t[min_i]
            new_speed_d[ii] = speed_d[min_i]
        ENDIF ELSE BEGIN
            new_speed_t[ii] = !values.f_nan
            new_speed_d[ii] = !values.f_nan
        ENDELSE 
    ENDFOR
ENDIF 

; GET LOCATION OF BOTH SPACECRAFT
now_time_pla       = TIME_STRING(temp_time_range)
now_time_formatted = strmid(now_time_pla, 0, 10)+'T'+strmid(now_time_pla, 11, 8)

location_start_sat = GET_STEREO_LONLAT(now_time_formatted, start_sat) ; longtidue and latitude in radians
rad_start_sat      = location_start_sat[0, *] ; km
lon_start_sat      = location_start_sat[1, *]
location_stop_sat  = GET_STEREO_LONLAT(now_time_formatted, stop_sat ) ; longtidue and latitude in radians
rad_stop_sat       = location_stop_sat[0, *] ; km
lon_stop_sat       = location_stop_sat[1, *]

IF (start_sat EQ 'A' AND (start_t LT time_double('2011-04-01') OR  (start_t GE time_double('2019-06-01')))) OR $
   (start_sat EQ 'B' AND (start_t GE time_double('2011-04-01') AND (start_t LT time_double('2019-06-01')))) THEN BEGIN
    delta_lon = lon_start_sat - lon_stop_sat ; radians
ENDIF ELSE IF (start_sat EQ 'B' AND (start_t LT time_double('2011-04-01') OR  (start_t GE time_double('2019-06-01')))) OR $
              (start_sat EQ 'A' AND (start_t GE time_double('2011-04-01') AND (start_t LT time_double('2019-06-01')))) THEN BEGIN 
    delta_lon = lon_stop_sat - lon_start_sat
ENDIF ELSE stop ; shouldn't get here

temp_i = where(delta_lon LT 0, temp_count)
IF temp_count GT 0 THEN delta_lon[temp_i] = delta_lon[temp_i]+DOUBLE(2.0*!PI)
delta_rad = rad_stop_sat - rad_start_sat ; km 

IF (start_sat EQ 'A' AND start_t LT time_double('2011-04-01')) OR $
   (start_sat EQ 'B' AND start_t GE time_double('2011-04-01')) THEN BEGIN
    temp_shifted_time = temp_time_range - (delta_lon/(2.905E-6)) + (delta_rad/new_speed_d) 
ENDIF ELSE IF (start_sat EQ 'B' AND start_t LT time_double('2011-04-01')) OR $
              (start_sat EQ 'A' AND start_t GE time_double('2011-04-01')) THEN BEGIN 
    temp_shifted_time = temp_time_range + (delta_lon/(2.905E-6)) + (delta_rad/new_speed_d)
ENDIF ELSE stop ; shouldn't get here

shifted_time = dblarr(n_elements(time_range))
shifted_time[*] = !values.f_nan
shifted_time[good_i] = temp_shifted_time

tplot_names, '*', names = names
store_data, names, /DEL
IF saved_vars EQ 1 THEN BEGIN 
    tplot_restore, filename = 'temp_time_shift_intra_stereo.tplot' ; restore old tplot variables
    cmd = 'rm temp_time_shift_intra_stereo.tplot'
    spawn, cmd
ENDIF 

END 
