; Lorna Ellis
; 03/18/2015
; convert_ace_swics_v2_2hr.pro

; This creates an ascii file for the ace swics 2 hr data which
; time-shifts the data and adjusts for radial distance.

PRO convert_ace_swics_v2_2hr, year, sat, num_days = num_days
compile_opt strictarrsubs

out_dir = '~/TempPlots2/'
out_file = 'ACE_SWICS_Data_'+string(year, format = '(I4.4)')+'_v2_2hr_adj_'+sat+'.txt'
out_path = out_dir+out_file

start = string(year, format = '(I4.4)')+'-01-01/00:00:00'
ts = time_double(start)
IF keyword_set(num_days) EQ 0 THEN $
  IF year MOD 4 EQ 0 THEN num_days = 366 ELSE num_days = 365
timespan, ts, num_days

get_ace_swics_v2_2hr
he_vel   = 'ace_swics_alpha_velocity_v2_2hr'
he_vth   = 'ace_swics_alpha_v_therm_v2_2hr'
c_6_5    = 'ace_swics_c_6_5_v2_2hr'
o_7_6    = 'ace_swics_o_7_6_v2_2hr'
o_8_6    = 'ace_swics_o_8_6_v2_2hr'
fe_av_q  = 'ace_swics_fe_av_q_v2_2hr'
fe_o     = 'ace_swics_fe_o_v2_2hr'
he_vel_no_err   = 'ace_swics_alpha_velocity_v2_2hr_no_err'
he_vth_no_err   = 'ace_swics_alpha_v_therm_v2_2hr_no_err'
c_6_5_no_err    = 'ace_swics_c_6_5_v2_2hr_no_err'
o_7_6_no_err    = 'ace_swics_o_7_6_v2_2hr_no_err'
o_8_6_no_err    = 'ace_swics_o_8_6_v2_2hr_no_err'
fe_av_q_no_err  = 'ace_swics_fe_av_q_v2_2hr_no_err'
fe_o_no_err     = 'ace_swics_fe_o_v2_2hr_no_err'

get_data, he_vel,           he_vel_t,           he_vel_d    
get_data, he_vth,           he_vth_t,           he_vth_d    
get_data, c_6_5,            c_6_5_t,            c_6_5_d     
get_data, o_7_6,            o_7_6_t,            o_7_6_d     
get_data, o_8_6,            o_8_6_t,            o_8_6_d     
get_data, fe_av_q,          fe_av_q_t,          fe_av_q_d   
get_data, fe_o,             fe_o_t,             fe_o_d      
get_data, he_vel_no_err,    he_vel_no_err_t,    he_vel_no_err_d    
get_data, he_vth_no_err,    he_vth_no_err_t,    he_vth_no_err_d    
get_data, c_6_5_no_err,     c_6_5_no_err_t,     c_6_5_no_err_d     
get_data, o_7_6_no_err,     o_7_6_no_err_t,     o_7_6_no_err_d     
get_data, o_8_6_no_err,     o_8_6_no_err_t,     o_8_6_no_err_d     
get_data, fe_av_q_no_err,   fe_av_q_no_err_t,   fe_av_q_no_err_d   
get_data, fe_o_no_err,      fe_o_no_err_t,      fe_o_no_err_d      

IF array_equal(he_vth_t,          he_vel_t) NE 1 THEN stop    
IF array_equal(c_6_5_t,           he_vel_t) NE 1 THEN stop     
IF array_equal(o_7_6_t,           he_vel_t) NE 1 THEN stop     
IF array_equal(o_8_6_t,           he_vel_t) NE 1 THEN stop     
IF array_equal(fe_av_q_t,         he_vel_t) NE 1 THEN stop   
IF array_equal(fe_o_t,            he_vel_t) NE 1 THEN stop      
IF array_equal(he_vel_no_err_t,   he_vel_t) NE 1 THEN stop    
IF array_equal(he_vth_no_err_t,   he_vel_t) NE 1 THEN stop    
IF array_equal(c_6_5_no_err_t,    he_vel_t) NE 1 THEN stop     
IF array_equal(o_7_6_no_err_t,    he_vel_t) NE 1 THEN stop     
IF array_equal(o_8_6_no_err_t,    he_vel_t) NE 1 THEN stop     
IF array_equal(fe_av_q_no_err_t,  he_vel_t) NE 1 THEN stop   
IF array_equal(fe_o_no_err_t,     he_vel_t) NE 1 THEN stop      

time_shift_aceswics_v2_2hr_to_stereo, sat, he_vel_t, new_ace_t

; ace radial distance
get_ace_ancillary
get_data, 'ace_sp_d_hs', ace_rad_t, ace_rad_d
;time_shift_ace_to_stereo, sat, ace_rad_t, new_ace_rad_t, /ancillary
time_shift_aceswics_v2_2hr_to_stereo, sat, ace_rad_t, new_ace_rad_t

bad_i = where(finite(new_ace_rad_t) EQ 0, bad_count, complement = good_i, ncomplement = good_count)
WHILE bad_count GT 0 DO BEGIN 
    temp_time = new_ace_rad_t[good_i]
    temp_i    = 0
    wanted_i  = bad_i[temp_i]
    temp_i    = temp_i + 1
    WHILE temp_i LT bad_count DO BEGIN 
        IF bad_i[temp_i] EQ wanted_i[n_elements(wanted_i)-1]+1 THEN BEGIN 
            wanted_i = [wanted_i, bad_i[temp_i]] 
            temp_i   = temp_i + 1
        ENDIF ELSE temp_i = bad_count
    ENDWHILE 
    temp_count = n_elements(wanted_i)
    step1 = indgen(temp_count)+1
    step2 = step1*(1.0/(temp_count+1))
    step3 = bad_i[0]-1+step2
    new_times = interpolate(temp_time, step3)
    new_ace_rad_t[wanted_i] = new_times
    bad_i = where(finite(new_ace_rad_t) EQ 0, bad_count, complement = good_i, ncomplement = good_count)
ENDWHILE 
store_data, 'ace_sp_d_hs', data = {x:new_ace_rad_t, y:ace_rad_d}

; stereo radial distance
temp_time = time_string(new_ace_rad_t)
strput, temp_time, 'T', 10      ; change time string format for SolarSoft
IF sat EQ 'A' THEN state = get_stereo_coord(temp_time, 'A', system = 'HERTN', target = 'STEREO Ahead') ELSE $
  state = get_stereo_coord(temp_time, 'B', system = 'HERTN', target = 'STEREO Behind')
stereo_rad_d = reform(state[0, *])

; adjust by radial distance
FOR doy = 1, num_days DO BEGIN 
    wanted_i = where(new_ace_t GE new_ace_rad_t[doy-1] AND new_ace_t LT (new_ace_rad_t[doy-1] + 86400), count)
    IF count GT 0 THEN BEGIN 
        he_vth_d         [wanted_i] = he_vth_d         [wanted_i] * sqrt((ace_rad_d[doy-1]/stereo_rad_d[doy-1]))
        he_vth_no_err_d  [wanted_i] = he_vth_no_err_d  [wanted_i] * sqrt((ace_rad_d[doy-1]/stereo_rad_d[doy-1]))
    ENDIF 
ENDFOR 

; create strings
he_vel_d_st          = string(           he_vel_d) 
he_vth_d_st          = string(           he_vth_d) 
c_6_5_d_st           = string(            c_6_5_d)            
o_7_6_d_st           = string(            o_7_6_d)            
o_8_6_d_st           = string(            o_8_6_d)            
fe_av_q_d_st         = string(          fe_av_q_d)          
fe_o_d_st            = string(             fe_o_d)             
he_vel_no_err_d_st   = string(    he_vel_no_err_d)    
he_vth_no_err_d_st   = string(    he_vth_no_err_d)    
c_6_5_no_err_d_st    = string(     c_6_5_no_err_d)     
o_7_6_no_err_d_st    = string(     o_7_6_no_err_d)     
o_8_6_no_err_d_st    = string(     o_8_6_no_err_d)     
fe_av_q_no_err_d_st  = string(   fe_av_q_no_err_d)   
fe_o_no_err_d_st     = string(      fe_o_no_err_d)      
bad_he_vel_i          = where(finite(           he_vel_d) EQ 0,           he_vel_count)    
bad_he_vth_i          = where(finite(           he_vth_d) EQ 0,           he_vth_count)    
bad_c_6_5_i           = where(finite(            c_6_5_d) EQ 0,            c_6_5_count)     
bad_o_7_6_i           = where(finite(            o_7_6_d) EQ 0,            o_7_6_count)     
bad_o_8_6_i           = where(finite(            o_8_6_d) EQ 0,            o_8_6_count)     
bad_fe_av_q_i         = where(finite(          fe_av_q_d) EQ 0,          fe_av_q_count)   
bad_fe_o_i            = where(finite(             fe_o_d) EQ 0,             fe_o_count)      
bad_he_vel_no_err_i   = where(finite(    he_vel_no_err_d) EQ 0,    he_vel_no_err_count)    
bad_he_vth_no_err_i   = where(finite(    he_vth_no_err_d) EQ 0,    he_vth_no_err_count)    
bad_c_6_5_no_err_i    = where(finite(     c_6_5_no_err_d) EQ 0,     c_6_5_no_err_count)     
bad_o_7_6_no_err_i    = where(finite(     o_7_6_no_err_d) EQ 0,     o_7_6_no_err_count)     
bad_o_8_6_no_err_i    = where(finite(     o_8_6_no_err_d) EQ 0,     o_8_6_no_err_count)     
bad_fe_av_q_no_err_i  = where(finite(   fe_av_q_no_err_d) EQ 0,   fe_av_q_no_err_count)   
bad_fe_o_no_err_i     = where(finite(      fe_o_no_err_d) EQ 0,      fe_o_no_err_count)      
IF he_vel_count          GT 0 THEN            he_vel_d_st[bad_he_vel_i         ] = '-1.00E+31'    
IF he_vth_count          GT 0 THEN            he_vth_d_st[bad_he_vth_i         ] = '-1.00E+31'    
IF c_6_5_count           GT 0 THEN             c_6_5_d_st[bad_c_6_5_i          ] = '-1.00E+31'     
IF o_7_6_count           GT 0 THEN             o_7_6_d_st[bad_o_7_6_i          ] = '-1.00E+31'     
IF o_8_6_count           GT 0 THEN             o_8_6_d_st[bad_o_8_6_i          ] = '-1.00E+31'     
IF fe_av_q_count         GT 0 THEN           fe_av_q_d_st[bad_fe_av_q_i        ] = '-1.00E+31'   
IF fe_o_count            GT 0 THEN              fe_o_d_st[bad_fe_o_i           ] = '-1.00E+31'      
IF he_vel_no_err_count   GT 0 THEN     he_vel_no_err_d_st[bad_he_vel_no_err_i  ] = '-1.00E+31'    
IF he_vth_no_err_count   GT 0 THEN     he_vth_no_err_d_st[bad_he_vth_no_err_i  ] = '-1.00E+31'    
IF c_6_5_no_err_count    GT 0 THEN      c_6_5_no_err_d_st[bad_c_6_5_no_err_i   ] = '-1.00E+31'     
IF o_7_6_no_err_count    GT 0 THEN      o_7_6_no_err_d_st[bad_o_7_6_no_err_i   ] = '-1.00E+31'     
IF o_8_6_no_err_count    GT 0 THEN      o_8_6_no_err_d_st[bad_o_8_6_no_err_i   ] = '-1.00E+31'     
IF fe_av_q_no_err_count  GT 0 THEN    fe_av_q_no_err_d_st[bad_fe_av_q_no_err_i ] = '-1.00E+31'   
IF fe_o_no_err_count     GT 0 THEN       fe_o_no_err_d_st[bad_fe_o_no_err_i    ] = '-1.00E+31'            

; write out data
openw, out_lun, out_path, /get_lun
printf, out_lun, out_file
header = 'Adjusted by time and radial distance'
printf, out_lun, header
tab = string(9B)
header = 'ACE Time'+tab+'ST'+sat+' Adj. Time'+tab+$
         he_vel   +tab+$ 
         he_vth   +tab+$ 
         c_6_5    +tab+$ 
         o_7_6    +tab+$ 
         o_8_6    +tab+$ 
         fe_av_q  +tab+$ 
         fe_o     +tab+$ 
         he_vel_no_err   +tab+$ 
         he_vth_no_err   +tab+$ 
         c_6_5_no_err    +tab+$ 
         o_7_6_no_err    +tab+$ 
         o_8_6_no_err    +tab+$ 
         fe_av_q_no_err  +tab+$ 
         fe_o_no_err     
printf, out_lun, header
FOR ii = 0, n_elements(new_ace_t)-1 DO BEGIN
    temp_string = time_string(he_vel_t [ii])+tab+$
                  time_string(new_ace_t[ii])+tab+$
                  he_vel_d_st          [ii]+tab+$ 
                  he_vth_d_st          [ii]+tab+$ 
                  c_6_5_d_st           [ii]+tab+$ 
                  o_7_6_d_st           [ii]+tab+$ 
                  o_8_6_d_st           [ii]+tab+$ 
                  fe_av_q_d_st         [ii]+tab+$ 
                  fe_o_d_st            [ii]+tab+$ 
                  he_vel_no_err_d_st   [ii]+tab+$ 
                  he_vth_no_err_d_st   [ii]+tab+$ 
                  c_6_5_no_err_d_st    [ii]+tab+$ 
                  o_7_6_no_err_d_st    [ii]+tab+$ 
                  o_8_6_no_err_d_st    [ii]+tab+$ 
                  fe_av_q_no_err_d_st  [ii]+tab+$ 
                  fe_o_no_err_d_st     [ii]
    printf, out_lun, temp_string
ENDFOR 
close, out_lun
free_lun, out_lun

END

